unit uGeneral;

interface
uses
  sysutils
  ,Classes
  ,JanXMLParser2      // Part of EasyXML 2.1
  ;
Const
  RootIdent = '$ROOT$';
  VirtualDisplayTag = '$DISPNAME$\';

  FileTypeTag = '$FILETYPE:';
  FileTypeEndTag = ':$\';

  ListTag = '$LISTTAG:';
  ListEndTag = ':$';

  ISOMEDIA = 'ISO';
  XISOMEDIA = 'XISO';
  ZIPMEDIA = 'ZIP';


  Function GetNodeByName(aName:String;aNodeList:TJanXMLNodeList2):TjanXMLNode2;
  Function GetOrCreateNodeByName(aName:String;aNodeList:TJanXMLNodeList2;aDefaultValue:String = ''):TjanXMLNode2;
  function GetNextParam(var param:String):String;
  Function MAX(s:String;L:integer):String;
  function GetParam(paramnum:Integer;param:String):String;
  function isIpAllowed(aIpAdress:String;aIpList:String):Boolean;
  Function ReplaceExtention(aFilename:String;NewExtention:String):String;

Type
  tempconfigobject = Class
    subson    : Boolean;
    Framerate : Real;
    Shutdown  : Boolean;
  public
    constructor create;
  end;

implementation

// function to see if a ipadres is in the iplist ..
// with wildcard support * .. currently...
// and if list is empty then it will be automaticly allowed
function isIpAllowed(aIpAdress:String;aIpList:String):Boolean;
var
  sl : TStringlist;
  x  : Longint;
  CurrentIP : String;
begin
  if aIpList='' then
    Begin
      Result:=True;
      Exit;
    End;
  Result := False;
  sl:=TStringlist.Create;
  aIpAdress := StringReplace(aIpAdress,'.',',',[rfReplaceAll]);
  sl.text := aIpList;
  For X:=0 to sl.Count-1 do
    Begin
      CurrentIP := sl.Strings[x];
      CurrentIP := StringReplace(CurrentIP,'.',',',[rfReplaceAll]);
      if    ((GetParam(1,CurrentIP) = GetParam(1,aIPAdress)) or (GetParam(1,CurrentIP)='*'))
        and ((GetParam(2,CurrentIP) = GetParam(2,aIPAdress)) or (GetParam(2,CurrentIP)='*'))
        and ((GetParam(3,CurrentIP) = GetParam(3,aIPAdress)) or (GetParam(3,CurrentIP)='*'))
        and ((GetParam(4,CurrentIP) = GetParam(4,aIPAdress)) or (GetParam(4,CurrentIP)='*'))
      then
        begin
          Result := True;
          Exit;
        end;

    End;
end;

// function to maximize a string to a certain length
Function MAX(s:String;L:integer):String;
Begin
  Result := s;
  while length(result)<l do result := result + ' ';
End;

// strip the next parameter from a string till a ',' comes along
function GetNextParam(var param:String):String;
var
  tmp : String;
Begin
  tmp := '';
  While (length(param)>0) and (param[1]<>',') do
    Begin
      tmp := tmp + param[1];
      delete(param,1,1);
    End;
  delete(param,1,1);
  Result := tmp;
End;

function GetParam(paramnum:Integer;param:String):String;
var
  tmp : String;
  curpar : Integer;
Begin
  tmp := '';
  Curpar := 1;
  if (length(param)>0) and (param[1]=',') then
    delete(param,1,1);

  While (length(param)>0) and (curpar<=paramnum) do
    Begin
      if param[1]=',' then
        inc(curpar)
      else
        if curpar=paramnum then
          tmp := tmp + param[1];
      delete(param,1,1);
    End;
  Result := tmp;
  if pos(VirtualDisplayTag,result)>0 then
    Result := copy(Result,1,pos(VirtualDisplayTag,result)-1);
End;


Function GetNodeByName(aName:String;aNodeList:TJanXMLNodeList2):TjanXMLNode2;
var
  x:Longint;
Begin
  Result := Nil;
  for x:=0 to aNodeList.Count-1 do
    Begin
      if Uppercase(aName) = Uppercase(TjanXMLNode2(aNodeList.Items[x]).name) then
        Begin
          Result := TjanXMLNode2(aNodeList.Items[x]);
          Exit;
        end;
    End;
End;

Function GetOrCreateNodeByName(aName:String;aNodeList:TJanXMLNodeList2;aDefaultValue:String = ''):TjanXMLNode2;
Begin
//
  Result := GetNodeByName(aName,aNodeList);
  if Result=nil then
    begin
      Result := TjanXMLNode2.create;
      Result.name := aName;
      Result.text := aDefaultValue;
      aNodeList.Add(Result)
    end;

End;

Function ReplaceExtention(aFilename:String;NewExtention:String):String;
Begin
  Result := aFilename;
  if (length(result)>0) and (pos('.',result)>0) then
    begin
      while (length(result)>0) and (result[length(result)]<>'.') do
        delete(result,length(result),1);
      Result := Result + NewExtention;
    end
  else
    Result := Result + '.' + NewExtention;
End;

{ tempconfigobject }

constructor tempconfigobject.create;
begin
  subson := True;
  Framerate := 0;
  Shutdown := False;
end;

end.
