unit uDisplayObject;

interface
uses
  downloadframe,controls,Main,Sysutils;

Type // object to synchronise display events with main thread
  TDisplayObject=Class(Tobject)
  Public
    dlstatus : Tdlstatus;
    Parent : TWinControl;
    Filename : String;
    Progress : Integer;
    MaxValue : Integer;
    MinValue : Integer;
    RemoteIP : String;
    Procedure Start;
    Procedure Update;
    Procedure Stop;
    Function ForceStop:Boolean;
  End;

implementation

{ TDisplayObject }
  procedure TDisplayObject.Stop;
  begin
    if not assigned(frmMain) then exit;
    FreeAndNil(dlstatus);
  end;

  procedure TDisplayObject.Start;
  begin
    if not assigned(frmMain) then exit;
    dlstatus := tdlstatus.Create(Nil);
    dlstatus.Align:= alTop;
    dlstatus.Parent := Parent;
    dlstatus.lblFilename.Caption := Filename;
    dlstatus.PbarPosition.MaxValue := MaxValue;
    dlstatus.PbarPosition.Progress := Progress;
    dlstatus.PbarPosition.MinValue := MinValue;
    dlstatus.lblRemoteIP.Caption := RemoteIP;
  end;

  function TDisplayObject.ForceStop: Boolean;
  begin
    Result := dlstatus.Stop;
  end;

  procedure TDisplayObject.Update;
  begin
    if not assigned(frmMain) then exit;
    dlstatus.lblFilename.Caption := Filename;
    dlstatus.PbarPosition.MaxValue := MaxValue;
    dlstatus.PbarPosition.Progress := Progress;
    dlstatus.PbarPosition.MinValue := MinValue;
    dlstatus.lblRemoteIP.Caption := RemoteIP;
  end;


end.
