unit uDeflog;

interface

uses
  SysUtils,    // Delphi VCL
  Forms,       // Delphi VCL
  IdHTTP,      // Part of Indy Delphi Components Suite
  ExtCtrls,    // Delphi VCL
  Controls,    // Delphi VCL
  Classes,     // Delphi VCL
  StdCtrls;    // Delphi VCL

type
  TfrmDefLog = class(TForm)
    memolog: TMemo;
    btnClose: TButton;
    Label1: TLabel;
    lblStatus: TLabel;
    btnUpdate: TButton;
    Timer1: TTimer;
    Timer2: TTimer;
    procedure btnUpdateClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnCloseClick(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
  private
  public
    procedure updatelog;
  end;

Type // object to synchronise display events with main thread
  TLogUpdate = Class
  Public
    Line:String;
    Memo:TMemo;
    Procedure DoAddLog;
  End;


implementation

uses main,windows;

{$R *.dfm}

Procedure TLogUpdate.DoAddLog;
Begin
  LockWindowUpdate(memo.Handle);
  while Memo.Lines.Count >200 do
    Memo.lines.Delete(0);
  Memo.Lines.Add(Line);
  LockWindowUpdate(0);
End;

procedure TfrmDefLog.updatelog;
var
  s:String;
  IdHTTP1 : TIdHTTP;
begin
  lblStatus.Caption := 'Checking Developers log';
  Application.ProcessMessages;

  IdHTTP1 := TIdHTTP.Create(Self);
  idHTTP1.Request.UserAgent := 'Relax '+Main.Version;

  s:='';
  Try
    s := IdHTTP1.Get('http://updates.raforce.nl:8080/RelaX.Def');
  Except
    on e:Exception do
      Begin
        lblStatus.Caption := 'Checking for updates Failed -'+e.Message;
        s:='';
      End;
  End;
  Try
    IdHTTP1.Disconnect;
  Except
    on exception do ;
  End;
  FreeAndNil(IdHTTP1);

  if (s<>'') then
    Begin
      lblStatus.caption := 'Developers log found';
      memolog.Text := s;
    End;

  btnUpdate.Enabled := False;
  Timer1.Enabled := True;
end;

procedure TfrmDefLog.btnUpdateClick(Sender: TObject);
begin
  updatelog;
end;

procedure TfrmDefLog.Timer1Timer(Sender: TObject);
begin
  // Floodprotection!
  timer1.Enabled := False;
  btnUpdate.Enabled := True;
end;

procedure TfrmDefLog.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  action := CaFree;
end;

procedure TfrmDefLog.btnCloseClick(Sender: TObject);
begin
  close;
end;

procedure TfrmDefLog.Timer2Timer(Sender: TObject);
begin
  timer2.enabled := False;
  updatelog;
end;

end.
