unit main;
// (c) 2002 by Remco Sonnema
// Part of RelaX
// released under GNU General Public License
// coded in Delphi 6 pro (www.borland.com)
interface

uses
  windows            // Delphi VCL
 ,StdCtrls           // Delphi VCL
 ,Controls           // Delphi VCL
 ,ExtCtrls           // Delphi VCL
 ,ImgList            // Delphi VCL
 ,ComCtrls           // Delphi VCL
 ,Menus              // Delphi VCL
 ,Forms              // Delphi VCL
 ,Classes            // Delphi VCL
 ,Sysutils           // Delphi VCL
 ,ValEdit            // Delphi VCL
 ,Dialogs            // Delphi VCL
 ,JanXMLParser2      // Part of EasyXML 2.1
 ,ToolWin            // Delphi VCL
 ,Spin               // Delphi VCL
 ,ActnList           // Delphi VCL
 ,udmListener        // Part if RelaX
 ,IdHTTP             // Part of Indy Delphi Components Suite
 ,IdTCPConnection    // Part of Indy Delphi Components Suite
 ,IdTCPClient        // Part of Indy Delphi Components Suite
 ,IdBaseComponent    // Part of Indy Delphi Components Suite
 ,IdComponent        // Part of Indy Delphi Components Suite
 ,MFileExplorer      // File Explorer
 ,CoolTrayIcon       // Tray icon!
 ,Buttons
 {$IFDEF MSWINDOWS}
 , XPMan
 {$ENDIF}{Remove this stuff for Linux support}
 ;

resourcestring
  rsConnections  = 'Connections: ';
Const
  {$I Compiledate.inc}
  Version = '0.71';//Pre - '+CompileDate;
  CheckVersion = '0.71';
  OldConfigFileName = 'Config.XML';
  ConfigFileName = 'RelaX_Config.XML';
type
  TfrmMain = class(TForm)
    PageControl1: TPageControl;
    tsShares: TTabSheet;
    tsConfig: TTabSheet;
    tsDebug: TTabSheet;
    Memo1: TMemo;
    StatusBar1: TStatusBar;
    tsConnections: TTabSheet;
    ScrollBox1: TScrollBox;
    ImageList1: TImageList;
    Panel2: TPanel;
    Panel3: TPanel;
    pnlEdit: TPanel;
    TreeView1: TTreeView;
    PopupMenu1: TPopupMenu;
    Insert1: TMenuItem;
    Add1: TMenuItem;
    ActionList1: TActionList;
    Label1: TLabel;
    sePort: TSpinEdit;
    seDebugLevel: TSpinEdit;
    Label2: TLabel;
    actDelete: TAction;
    actAdd: TAction;
    lblAttribute: TLabel;
    lblPath: TLabel;
    Panel7: TPanel;
    actMoveUp: TAction;
    actMoveDown: TAction;
    Movedown1: TMenuItem;
    Moveup1: TMenuItem;
    Timer1: TTimer;
    actRename: TAction;
    Rename1: TMenuItem;
    actSaveConfig: TAction;
    N2: TMenuItem;
    SaveConfig1: TMenuItem;
    CoolTrayIcon1: TCoolTrayIcon;
    PopupMenu2: TPopupMenu;
    acte: TMenuItem;
    actExit: TAction;
    MFileExplorer1: TMFileExplorer;
    ViewMenu: TPopupMenu;
    pmLarge: TMenuItem;
    pmSmall: TMenuItem;
    pmList: TMenuItem;
    pmDetail: TMenuItem;
    editDir: TEdit;
    btnGoto: TButton;
    Splitter1: TSplitter;
    Panel8: TPanel;
    ToolBar: TToolBar;
    Panel1: TPanel;
    sbUp: TToolButton;
    ToolButton6: TToolButton;
    sbView: TToolButton;
    OpenDialog1: TOpenDialog;
    btnbrowse: TButton;
    Label9: TLabel;
    edtSubtitledirectory: TEdit;
    Button1: TButton;
    Button2: TButton;
    actStopServer: TAction;
    actStartServer: TAction;
    Memo2: TMemo;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    edtRecursive: TComboBox;
    lblRecursive: TLabel;
    lblDisplayname: TLabel;
    edtDisplayname: TEdit;
    lblHidden: TLabel;
    edtHidden: TComboBox;
    Label5: TLabel;
    edtPath: TEdit;
    edtAttribute: TComboBox;
    edtAdd: TButton;
    btnDelete: TButton;
    EdtIps: TListBox;
    edtAddIp: TEdit;
    edtFlatten: TComboBox;
    edtIntergrate: TComboBox;
    lblFlatten: TLabel;
    lblIntergrate: TLabel;
    lblExtentions: TLabel;
    edtExtentions: TEdit;
    edtAllExtentions: TEdit;
    Label17: TLabel;
    actFile: TAction;
    actHelp: TAction;
    actAbout: TAction;
    actCheckForUpdate: TAction;
    actViewDeflog: TAction;
    actViewFAQ: TAction;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    Help2: TMenuItem;
    Viewdeveloperslog1: TMenuItem;
    ViewonlineFAQ1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    About1: TMenuItem;
    Panel4: TPanel;
    Label3: TLabel;
    edtAddIpExtra: TEdit;
    edtIpsExtra: TListBox;
    btnDeleteExtra: TButton;
    btnAddExtra: TButton;
    actShowDocumentation: TAction;
    Documentation1: TMenuItem;
    ComboBox1: TComboBox;
    Label4: TLabel;
    Label6: TLabel;
    ToolBar2: TToolBar;
    ToolButton2: TToolButton;
    edtTBNdirectory: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure TreeView1DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure TreeView1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Editing(Sender: TObject; Node: TTreeNode; var AllowEdit: Boolean);
    procedure TreeView1Collapsing(Sender: TObject; Node: TTreeNode; var AllowCollapse: Boolean);
    procedure TreeView1Edited(Sender: TObject; Node: TTreeNode; var S: String);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure actAddExecute(Sender: TObject);
    procedure actDeleteUpdate(Sender: TObject);
    procedure actInsertUpdate(Sender: TObject);
    procedure actAddUpdate(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure actMoveUpExecute(Sender: TObject);
    procedure actMoveDownExecute(Sender: TObject);
    procedure actMoveUpUpdate(Sender: TObject);
    procedure actMoveDownUpdate(Sender: TObject);
    procedure Checkforupdates(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure actRenameUpdate(Sender: TObject);
    procedure actRenameExecute(Sender: TObject);
    procedure actSaveConfigExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CoolTrayIcon1DblClick(Sender: TObject);
    procedure actExitExecute(Sender: TObject);
    procedure actExitUpdate(Sender: TObject);
    procedure MFileExplorer1StartDrag(Sender: TObject; var DragObject: TDragObject);
    procedure Changestyle(Sender: TObject);
    procedure sbUpClick(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure MFileExplorer1Editing(Sender: TObject; Item: TListItem; var AllowEdit: Boolean);
    procedure btnGotoClick(Sender: TObject);
    procedure MFileExplorer1Change(Sender: TObject; Item: TListItem; Change: TItemChange);
    procedure editDirKeyPress(Sender: TObject; var Key: Char);
    procedure btnbrowseClick(Sender: TObject);
    procedure actStartServerUpdate(Sender: TObject);
    procedure actStopServerUpdate(Sender: TObject);
    procedure actStopServerExecute(Sender: TObject);
    procedure actStartServerExecute(Sender: TObject);
    procedure edtSubtitledirectoryChange(Sender: TObject);
    procedure seDebugLevelChange(Sender: TObject);
    procedure sePortChange(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure edtAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure edtDisplaynameChange(Sender: TObject);
    procedure edtPathChange(Sender: TObject);
    procedure edtRecursiveChange(Sender: TObject);
    procedure edtHiddenChange(Sender: TObject);
    procedure edtFlattenChange(Sender: TObject);
    procedure edtIntergrateChange(Sender: TObject);
    procedure edtExtentionsChange(Sender: TObject);
    procedure actHelpExecute(Sender: TObject);
    procedure actCheckForUpdatesExecute(Sender: TObject);
    procedure actViewDevelopersLogExecute(Sender: TObject);
    procedure actViewOnlineFAQExecute(Sender: TObject);
    procedure actMenuHelpExecute(Sender: TObject);
    procedure edtAllExtentionsChange(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure actFileExecute(Sender: TObject);
    procedure btnAddExtraClick(Sender: TObject);
    procedure btnDeleteExtraClick(Sender: TObject);
    procedure actShowDocumentationExecute(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure edtTBNdirectoryChange(Sender: TObject);
  private
    Listener : TDmListener;

    CurrentNode : TTreeNode;
    CurrentXML,
    CurrentAttribute,
    CurrentPath,
    CurrentIpList,
    CurrentHidden,
    CurrentFlatten,
    CurrentIntergrate,
    CurrentDisplayName,
    CurrentExtentions,
    CurrentRecursive : TjanXMLNode2;

    procedure NodesToTree(aNode: TJanXMLNode2; aTreeNode: TTreeNode);
    Function ProcessITEM(ITEM: TJanXMLNode2; aTreeNode: TTreeNode):Boolean;
    procedure Exceptionhandler(Sender: TObject; E: Exception);
    procedure HideMainForm;
    procedure ShowMainForm;
  public
    config        : TjanXMLParser2;
    shares        : TJanXMLNode2;
    settings      : TJanXMLNode2;

    ListenPort    : TJanXMLNode2;
    DebugLevel    : TJanXMLNode2;
    SubsDirectory : TJanXMLNode2;
    TBNDirectory  : TJanXMLNode2;

    Extentions          : TJanXMLNode2;
    SecurityIpList      : TJanXMLNode2;

    service:Boolean;
    connections : Longint;
    Class function done : Boolean;
    procedure addConnection;
    Procedure DeleteConnection;
  end;

var
  frmMain: TfrmMain;

implementation

uses
   About               // old unit by me
  ,updated             // Part of RelaX
  ,uGeneral            // Part of RelaX
  ,uDeflog
  ,uFAQonline             // Part of RelaX
  ,Math
  ,ufDocumentation, DateUtils;

{$R *.dfm}

var
  fDone : Boolean;

Function TfrmMain.ProcessITEM(ITEM:TJanXMLNode2;aTreeNode:TTreeNode):Boolean;
var
  attribute : TJanXMLNode2;
  Path : TJanXMLNode2;
  tmpTreeNode : TTreeNode;
Begin
  Result := True;
  if uppercase(item.name)='ITEM' then
    begin
      attribute := GetNodeByName('ATTRIBUTE',item.nodes);
      if attribute.text = '1' then
        begin
          ITEM.parentNode.deleteNode(ITEM);
          Result := False;
          Exit;
        End;
      Path := GetNodeByName('path',item.nodes);
      tmpTreeNode := nil;
      if assigned(path) and assigned(attribute) then
        tmpTreeNode := aTreeNode.Owner.AddChildObject(aTreeNode,path.text,item);
      if assigned(tmpTreeNode) then
        Begin
          case StrToInt(attribute.text) of
            0   : begin
                    tmpTreeNode.ImageIndex := 0;
                    NodesToTree(item,tmptreeNode);
                  End;
            1   : tmpTreeNode.ImageIndex := 6; // Configuration tag
            16  : tmpTreeNode.ImageIndex := 2; // path
            128 : tmpTreeNode.ImageIndex := 1; // file
          End;
         tmpTreeNode.SelectedIndex := tmpTreeNode.ImageIndex;
        End;
    End;
End;

Procedure TfrmMain.NodesToTree(aNode:TJanXMLNode2;aTreeNode:TTreeNode);
var
  x: Longint;
  cnt : Longint;
Begin
  cnt := aNode.nodes.Count-1;
  x:= 0;
  While X <= cnt do
    begin
      if ProcessITEM(TJanXMLNode2(aNode.nodes.Items[x]),aTreeNode) then
        inc(x)
      else
        dec(cnt);
    end;
End;


procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Self.Caption := 'RelaX v'+Version+' XNS server build on '+Compiledate;
  StatusBar1.Panels[0].Text := rsConnections + '0';
  {$IFDEF WIN32}
//  if Win32Platform = VER_PLATFORM_WIN32_NT then
//    if Win32MajorVersion = 5 then
//      if Win32MinorVersion = 1 then
//        PageControl1.Style := tsTabs;
  {$ENDIF}
//  setpriorityclass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);

  Connections := 0;
  FDone := False;
  Application.OnException := Self.Exceptionhandler;



  Config := TjanXMLParser2.create;
  if    not FileExists(extractfilepath(paramstr(0))+ConfigFileName)
    and not FileExists(extractfilepath(paramstr(0))+OldConfigFileName)
  then
    Begin
      Config.name := 'CONFIG';
    End
  else
    Begin
      if FileExists(extractfilepath(paramstr(0))+ConfigFileName) then
        config.LoadXML(extractfilepath(paramstr(0))+ConfigFileName)
      else
        config.LoadXML(extractfilepath(paramstr(0))+OldConfigFileName)
    End;


  shares        := GetOrCreateNodeByName('SHARES',Config.nodes);
  settings      := GetOrCreateNodeByName('SETTINGS',Config.nodes);

  SecurityIpList:= GetOrCreateNodeByName('SECURITYIPLIST',Settings.nodes);
  edtIpsExtra.Items.Text      := SecurityIpList.text;

  ListenPort    := GetOrCreateNodeByName('LISTENPORT',Settings.nodes,'1400');
  sePort.Value := StrToInt(ListenPort.text);

  DebugLevel    := GetOrCreateNodeByName('DEBUGLEVEL',Settings.nodes,'0');
  seDebugLevel.Value := StrToInt(DebugLevel.text);

  SubsDirectory := GetOrCreateNodeByName('SUBTITLEDIR',Settings.nodes);
  edtSubtitledirectory.Text := SubsDirectory.text;

  TBNDirectory := GetOrCreateNodeByName('TBNDIR',Settings.nodes);
  edtTBNdirectory.Text := TBNDirectory.text;

  Extentions          := GetOrCreateNodeByName('EXTENTIONS'      ,Settings.nodes,'*');
  edtAllExtentions.Text:=Extentions.text;

  Treeview1.Items.Clear;
  NodesToTree(shares,TreeView1.Items.AddObjectFirst(Nil,'SHARES',shares));

  TReeView1.Items[0].ImageIndex := 3;
  TReeView1.Items[0].SelectedIndex := 3;
  Treeview1.FullExpand;
  timer1.enabled := True;

  Self.actStartServerExecute(Self);

  SetWindowLong( Application.Handle, GWL_EXSTYLE,
                 GetWindowLong(Application.Handle, GWL_EXSTYLE) or
                 WS_EX_TOOLWINDOW and not WS_EX_APPWINDOW);

  setpriorityclass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);

end;

type TMyDragObject = class ( TDragObject )
       Filename : String;
     end;

procedure TfrmMain.TreeView1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  accept := assigned(TreeView1.GetNodeAt(x,y)) and (TreeView1.GetNodeAt(x,y).ImageIndex in[0,3]);
end;

function MakeXMLNode(aTagName:STring;aValue:String):TjanXMLNode2;
Begin
  Result := TJanXMLNode2.create;
  Result.name := aTagName;
  Result.text := aValue;
End;

Function FileToType(F:String):String;
var
  diri:TSearchrec;
  res:Integer;
Begin
  res := FindFirst(f,faanyfile,diri);
  if res=0 then
    Begin
      Result := '128'; //always a file;
      if diri.Attr and faDirectory = faDirectory then
        Result := '16';
    End
  else
    begin
      // drive detection!!
      if (length(F)=3) and (pos(':\',f)=2) then
        Result := '16'
      else
        Result := '0';
    End;
  FindClose(Diri);
End;

procedure TfrmMain.TreeView1DragDrop(Sender, Source: TObject; X, Y: Integer);
var
  XMLNode : TjanXMLNode2;
  TargetXML : TJanXMLNode2;
  TargetTree : TTreeNode;
  sl:TStringlist;
  z:Longint;
begin
  if assigned(TreeView1.GetNodeAt(x,y)) then
    Begin
      sl:=TStringlist.Create;
      TargetTree := TreeView1.GetNodeAt(x,y);
      TargetXML := TjanXMLNode2(TargetTree.Data);
      sl.Text :=(Source as TMyDragOBject).Filename;

      for z:=0 to sl.Count-1 do
        Begin
          XMLNode := MakeXMLNode('ITEM','');
          GetOrCreateNodeByName('ATTRIBUTE',XMLNode.nodes,FileToType(sl.Strings[z]));
          GetOrCreateNodeByName('PATH',XMLNode.nodes,sl.Strings[z]);

          TargetXML.addNode(XMLNode);
          ProcessITEM(XMLNode,TargetTree );
        end;
      TargetTree.Expand(True);

      FreeAndNil(sl);
      FreeAndNil(Source);
    End;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  config.SaveXML(extractfilepath(paramstr(0))+ConfigFileName);
  FreeAndNil(Listener);
  FreeAndNil(Config);
  FDone := True;
end;

procedure TfrmMain.TreeView1Change(Sender: TObject; Node: TTreeNode);
begin
  if Node.Data = Shares then
    begin
      pnlEdit.Visible := False;
      Exit;
    end
  else
    pnlEdit.Visible := True;
  CurrentXML := TjanXMLNode2(Node.Data);
  CurrentNode := Node;


  CurrentAttribute   := GetOrCreateNodeByName('ATTRIBUTE'  ,CurrentXML.nodes,'0');
  CurrentPath        := GetOrCreateNodeByName('PATH'       ,CurrentXML.nodes,'');
  CurrentRecursive   := GetOrCreateNodeByName('RECURSIVE'  ,CurrentXML.nodes,'Y');
  CurrentIpList      := GetOrCreateNodeByName('ALLOWEDIP'  ,CurrentXML.nodes,'');
  CurrentHidden      := GetOrCreateNodeByName('HIDDEN'     ,CurrentXML.nodes,'N');
  CurrentDisplayName := GetOrCreateNodeByName('DISPLAYNAME',CurrentXML.nodes,'');
  CurrentFlatten     := GetOrCreateNodeByName('FLATTEN'    ,CurrentXML.nodes,'N');
  CurrentIntergrate  := GetOrCreateNodeByName('INTERGRATE' ,CurrentXML.nodes,'N');
  CurrentExtentions  := GetOrCreateNodeByName('EXTENTIONS' ,CurrentXML.nodes,'');

  edtExtentions.Enabled := (CurrentAttribute.text<>'128') and (CurrentAttribute.text<>'1');
  lblExtentions.Enabled := edtExtentions.Enabled;
  edtExtentions.Text := CurrentExtentions.text;




  edtAttribute.ItemIndex := 3;
  if CurrentAttribute.text = '0'   then edtAttribute.ItemIndex := 0; // virtual directory
  if CurrentAttribute.text = '16'  then edtAttribute.ItemIndex := 1; // path
  if CurrentAttribute.text = '128' then edtAttribute.ItemIndex := 2; // file
  if CurrentAttribute.text = '1'   then edtAttribute.ItemIndex := 3; // Configuration tag
//  edtAttribute.Enabled:=True;


  edtPath.Text           := CurrentPath.text;
  edtPath.Enabled        := CurrentAttribute.text='0';
  lblPath.Enabled        := edtPath.Enabled;

  edtDisplayname.Text    := CurrentDisplayName.text;
  edtDisplayName.Enabled := CurrentAttribute.text<>'0';
  lblDisplayname.Enabled := edtDisplayname.Enabled;

  edtIps.Items.Text      := CurrentIpList.text;
  edtIps.Enabled         := True;
//  edtIps.Enabled         := CurrentAttribute.text<>'128';

  if CurrentHidden.text     = 'N' then edtHidden.ItemIndex := 0
                                  else edtHidden.ItemIndex := 1;
  edtHidden.Enabled        := True;
  lblHidden.Enabled        := edtHidden.Enabled;

  if CurrentRecursive.text  = 'N' then edtRecursive.ItemIndex := 0
                                  else edtRecursive.ItemIndex := 1;
  edtRecursive.Enabled     := CurrentAttribute.text='16';
  lblRecursive.Enabled     := edtRecursive.Enabled;

  if CurrentFlatten.text    = 'N' then edtFlatten.ItemIndex := 0
                                  else edtFlatten.itemIndex := 1;
  edtFlatten.enabled       := CurrentAttribute.text='16';
  lblFlatten.Enabled       := edtFlatten.Enabled;

  if CurrentIntergrate.text = 'N' then edtIntergrate.ItemIndex := 0
                                  else edtIntergrate.ItemIndex := 1;
  EdtIntergrate.enabled    := CurrentAttribute.text='16';
  lblIntergrate.Enabled    := edtIntergrate.Enabled;

  edtExtentions.visible := CurrentIntergrate.text ='N';
  lblExtentions.enabled := edtExtentions.visible and edtExtentions.enabled;

end;

procedure TfrmMain.TreeView1Editing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
  AllowEdit := Node.ImageIndex=0;
end;

procedure TfrmMain.TreeView1Collapsing(Sender: TObject; Node: TTreeNode;
  var AllowCollapse: Boolean);
begin
  AllowCollapse := False;
end;

procedure TfrmMain.TreeView1Edited(Sender: TObject; Node: TTreeNode;
  var S: String);
begin
  if s='' then abort;
  GetNodeByName('PATH',TJanXMLNode2(Node.Data).nodes).text := s;
end;

procedure TfrmMain.PopupMenu1Popup(Sender: TObject);
begin
  if not assigned(TreeView1.Selected) then
    Abort;
end;

procedure TfrmMain.Exit1Click(Sender: TObject);
begin
  Self.Close;
end;

procedure TfrmMain.actDeleteExecute(Sender: TObject);
begin
  TjanXMLNode2(TreeView1.Selected.Parent.data).deleteNode(TjanXMLNode2(TreeView1.Selected.data));
  TreeView1.Selected.Delete;
end;

procedure TfrmMain.actAddExecute(Sender: TObject);
var
  XMLNode : TjanXMLNode2;
begin
  XMLNode := MakeXMLNode('ITEM','');
  XMLNode.nodes.Add(MakeXMLNode('ATTRIBUTE','0'));
  XMLNode.nodes.Add(MakeXMLNode('PATH','Rename Please'));

  TjanXMLNode2(TreeView1.Selected.Data).addNode(XMLNode);
  ProcessITEM(XMLNode,TreeView1.Selected);
  TreeView1.Selected.Expand(True);
end;

procedure TfrmMain.actDeleteUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled := assigned(treeview1) and assigned(treeview1.selected) and
    (TreeView1.Selected.ImageIndex<>3);
end;

procedure TfrmMain.actInsertUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled := assigned(treeview1) and assigned(treeview1.selected) and
    (TreeView1.Selected.ImageIndex<>3);
end;

procedure TfrmMain.actAddUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled := assigned(treeview1) and assigned(treeview1.selected) and
    (TreeView1.Selected.ImageIndex in [3,0]);
end;

procedure TfrmMain.About1Click(Sender: TObject);
begin
  About.TfrmAbout.Create(self).Show;
end;

procedure TfrmMain.Exceptionhandler(Sender: TObject; E: Exception);
begin
  Listener.Log(5,e.Message,Nil);
end;



procedure TfrmMain.actMoveUpExecute(Sender: TObject);
var
  tmp:TTreenode;
  tmpXML : TjanXMLNode2;
  parentXML : TjanXMLNode2;
begin
  // moving in treeview
  tmp := TreeView1.Selected;
  tmp.MoveTo(tmp.Parent.Item[tmp.index-1],naInsert);
  tmp.Expand(True);

  // moving in xml
  tmpXML := TjanXMLNode2(tmp.data);
  parentXML := tmpXML.parentNode;
  ParentXML.nodes.Move(ParentXML.nodes.IndexOf(tmpXML),ParentXML.nodes.IndexOf(tmpXML)-1);
end;

procedure TfrmMain.actMoveDownExecute(Sender: TObject);
var
  tmp:TTreenode;
  tmpXML : TjanXMLNode2;
  parentXML : TjanXMLNode2;
begin
  // moving in treeview
  tmp := TreeView1.Selected;
  if tmp.index=tmp.parent.count-2 then
    tmp.MoveTo(tmp.Parent.Item[tmp.index+1],naAdd)
  else
    tmp.MoveTo(tmp.Parent.Item[tmp.index+2],naInsert);
  tmp.Expand(True);
  // moving in xml
  tmpXML := TjanXMLNode2(tmp.data);
  parentXML := tmpXML.parentNode;
  ParentXML.nodes.Move(ParentXML.nodes.IndexOf(tmpXML),ParentXML.nodes.IndexOf(tmpXML)+1);
end;

procedure TfrmMain.actMoveUpUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled := assigned(treeview1) and assigned(treeview1.selected) and
    (TreeView1.Selected.ImageIndex <> 3) and (TreeView1.Selected.index>0);

end;

procedure TfrmMain.actMoveDownUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled := assigned(treeview1) and assigned(treeview1.selected) and
    (TreeView1.Selected.ImageIndex <> 3) and assigned(treeview1.selected.parent) and (treeview1.selected.index < (treeview1.selected.Parent.Count-1));
end;

procedure TfrmMain.Checkforupdates(Sender: TObject);
var
  s:String;
  sl:TStringlist;
  Upd:TfrmUpdated;
  IdHTTP1 : TIdHTTP;
begin
  IdHTTP1 := TIdHTTP.Create(Self);
  idHTTP1.Request.UserAgent := 'Relax '+Version;
  statusbar1.Panels[1].Text := 'Checking for updates';
  Application.ProcessMessages;
  s:='';
  Try
    s := IdHTTP1.Get('http://updates.raforce.nl:8080/RelaX.Ver');
  Except
    on e:Exception do
      Begin
        StatusBar1.Panels[1].Text := 'Checking for updates Failed -'+e.Message;
        IdHTTP1.Disconnect;
        FreeAndNil(IdHTTP1);
        Exit;
      End;
  End;
  IdHTTP1.Disconnect;
  FreeAndNil(IdHTTP1);
  sl := TStringlist.Create;
  sl.text := s;
  if (sl.Count>1) and (CheckVersion <> sl.Strings[0]) then
    Begin
      statusbar1.Panels[1].Text := 'Update found on server to V'+sl.strings[0];
      Upd:=TfrmUpdated.Create(Nil);
      upd.lblversion.Caption := sl.strings[0];
      upd.downloadurl.Caption := sl.Strings[1];
      sl.Delete(0);
      sl.Delete(0);
      upd.memoinfo.Text := sl.Text;
      upd.Show;
    End
  Else
    begin
      statusbar1.Panels[1].Text := 'No update found - checked on ('+DateTimeToStr(now)+')';
      if Version <> CheckVersion then
        Showmessage('You are using a Preview Version of RelaX v'+Version);
    end;
  FreeAndNil(sl);
  //what about free'in upd ?? 
end;

procedure TfrmMain.Timer1Timer(Sender: TObject);
begin
  timer1.Enabled := False;
  Checkforupdates(sender);
end;

procedure TfrmMain.actRenameUpdate(Sender: TObject);
begin
  (sender as Taction).Enabled := assigned(treeview1) and assigned(treeview1.selected) and
    (TreeView1.Selected.ImageIndex in [0]);
end;

procedure TfrmMain.actRenameExecute(Sender: TObject);
begin
  TreeView1.Selected.EditText;
end;

procedure TfrmMain.actSaveConfigExecute(Sender: TObject);
begin
  StatusBar1.Panels[1].Text := 'Saving Config';
  config.SaveXML(extractfilepath(paramstr(0))+configfilename);
  StatusBar1.Panels[1].Text := 'Config Saved';
end;

Class function TfrmMain.done: Boolean;
begin
  if not FDone then
    begin
      application.handlemessage( ); // make program idle till next message
    End;
  Result := FDone;
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if service then
    abort;
  fDone := True;
end;

procedure TfrmMain.ShowMainForm;
begin
  if Application.MainForm <> nil then
    begin
      ShowWindow(Application.Handle, SW_RESTORE);
      Application.MainForm.Visible := True;
      if Application.MainForm.WindowState = wsMinimized then
        Application.MainForm.WindowState := wsNormal;
      SetForegroundWindow(Application.Handle);
    end;
end;


procedure TfrmMain.HideMainForm;
begin
  if Application.MainForm <> nil then
    begin
      Application.MainForm.Visible := False;
      ShowWindow(Application.Handle, SW_HIDE);
    end;
end;

procedure TfrmMain.CoolTrayIcon1DblClick(Sender: TObject);
begin
  if self.visible then
    HideMainForm
  else
    ShowMainForm;
end;

procedure TfrmMain.actExitExecute(Sender: TObject);
begin
  self.close;
end;

procedure TfrmMain.actExitUpdate(Sender: TObject);
begin
  (sender as TAction).Enabled := not Service;
end;

procedure TfrmMain.addConnection;
begin
  connections := Connections +1;
  StatusBar1.Panels[0].Text := rsConnections + Inttostr(Connections);
end;

procedure TfrmMain.DeleteConnection;
begin
  connections := Connections -1;
  StatusBar1.Panels[0].Text := rsConnections + Inttostr(Connections);
end;

procedure TfrmMain.MFileExplorer1StartDrag(Sender: TObject;
  var DragObject: TDragObject);
begin
  dragobject := TMyDragObject.Create;
  (dragObject as TMyDragObject).Filename:= MFileExplorer1.SelectedFilenames
end;

procedure TfrmMain.Changestyle(Sender: TObject);
begin
  with tmenuitem(sender) do begin
    mfileexplorer1.viewstyle:= tviewstyle(tag);
    //ShellListView1.ViewStyle:= TViewStyle(tag);
    Checked:= True;
  end;
end;

procedure TfrmMain.sbUpClick(Sender: TObject);
begin
  MFileExplorer1.OneLevelUp;
end;

procedure TfrmMain.ComboBox1Change(Sender: TObject);
begin
  MFileExplorer1.Mask := ComboBox1.Text;
end;

procedure TfrmMain.MFileExplorer1Editing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
  allowedit := False;
end;

procedure TfrmMain.btnGotoClick(Sender: TObject);
begin
  MFileExplorer1.Directory := Editdir.Text;
  MFileExplorer1.UpdateFileList;
end;

procedure TfrmMain.MFileExplorer1Change(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if MFileExplorer1.Visible and MFileExplorer1.Enabled and (not application.Terminated) then
    begin
      editDir.Text := MFileExplorer1.Directory;
      MFileExplorer1.SetFocus;
    end;
end;

procedure TfrmMain.editDirKeyPress(Sender: TObject; var Key: Char);
begin
  if key=#13 then
    begin
      btnGotoClick(SendeR);
    End;
end;

procedure TfrmMain.btnbrowseClick(Sender: TObject);
begin
  if opendialog1.Execute then
    begin
      editDir.Text := ExtractFilePath(OpenDialog1.FileName);
    end;
end;

procedure TfrmMain.actStartServerUpdate(Sender: TObject);
begin
  (Sender as Taction).Enabled := not assigned(Listener);
end;

procedure TfrmMain.actStopServerUpdate(Sender: TObject);
begin
  (Sender as Taction).Enabled := assigned(Listener);
end;

procedure TfrmMain.actStopServerExecute(Sender: TObject);
begin
  FreeAndNil(Listener);
end;

procedure TfrmMain.actStartServerExecute(Sender: TObject);
begin
  Listener := TDmListener.Create(self);
  Listener.shares := Shares;
end;

procedure TfrmMain.edtSubtitledirectoryChange(Sender: TObject);
begin
  SubsDirectory.text := edtSubtitledirectory.Text;
end;

procedure TfrmMain.seDebugLevelChange(Sender: TObject);
var
  i : TTabsheet;
  x : Longint;
begin
  DebugLevel.text := Inttostr(seDebugLevel.Value);

  LockWindowUpdate(PageControl1.Handle);

  if seDebugLevel.Value <> 9 then
    Begin
      if tsDebug.PageControl <> PageControl1 then
        Begin
          x:=PageControl1.ActivePageIndex;
          tsDebug.PageControl := PageControl1;
          if x=0 then
            Begin
              PageControl1.SelectNextPage(false);
              PageControl1.SelectNextPage(True);
            end
          else
            begin
              PageControl1.SelectNextPage(True);
              PageControl1.SelectNextPage(false);
            end;
        end;
    End
  else
    Begin
      i := PageControl1.ActivePage;
      tsDebug.PageControl := Nil;
      PageControl1.ActivePage := i;
    End;

  LockWindowUpdate(0);
end;

procedure TfrmMain.sePortChange(Sender: TObject);
begin
  ListenPort.text := Inttostr(sePort.Value);
end;

procedure TfrmMain.ToolButton1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    Begin
      edtSubtitledirectory.Text := ExtractFilePath(OpenDialog1.FileName);
      edtSubtitledirectoryChange(edtSubtitledirectory);
    End;
end;

procedure TfrmMain.edtAddClick(Sender: TObject);
begin
  EdtIps.Items.Add(edtAddIp.text);
  CurrentIpList.text := EdtIps.Items.Text;
end;

procedure TfrmMain.btnDeleteClick(Sender: TObject);
begin
  EdtIps.Items.Delete(EdtIps.ItemIndex);
  CurrentIpList.text := EdtIps.Items.Text;
end;

procedure TfrmMain.edtDisplaynameChange(Sender: TObject);
begin
  CurrentDisplayName.text := edtDisplayname.Text;
end;

procedure TfrmMain.edtPathChange(Sender: TObject);
begin
  CurrentPath.text := edtPath.Text;
  CurrentNode.Text := edtPath.Text;
end;

procedure TfrmMain.edtRecursiveChange(Sender: TObject);
begin
  case edtRecursive.ItemIndex of
     0   : CurrentRecursive.text := 'N';
     Else  CurrentRecursive.text := 'Y';
  End;

end;

procedure TfrmMain.edtHiddenChange(Sender: TObject);
begin
  case edtHidden.ItemIndex of
     0   : CurrentHidden.text := 'N';
     Else  CurrentHidden.text := 'Y';
  End;
end;

procedure TfrmMain.edtFlattenChange(Sender: TObject);
begin
  case edtFlatten.ItemIndex of
     0   : CurrentFlatten.text := 'N';
     Else  CurrentFlatten.text := 'Y';
  End;
end;

procedure TfrmMain.edtIntergrateChange(Sender: TObject);
begin
  case edtIntergrate.ItemIndex of
     0   : CurrentIntergrate.text := 'N';
     Else  CurrentIntergrate.text := 'Y';
  End;
  edtExtentions.visible := edtIntergrate.ItemIndex=0;
  lblExtentions.enabled := edtExtentions.visible;
end;

procedure TfrmMain.edtExtentionsChange(Sender: TObject);
begin
  CurrentExtentions.text := edtExtentions.Text;
end;

procedure TfrmMain.actHelpExecute(Sender: TObject);
begin
  About.TfrmAbout.Create(self).Show;
end;

procedure TfrmMain.actCheckForUpdatesExecute(Sender: TObject);
begin
  Checkforupdates(Sender);
end;

procedure TfrmMain.actViewDevelopersLogExecute(Sender: TObject);
var
  mydeflog : TfrmDeflog;
begin
  mydeflog := TfrmDefLog.Create(Self);
  MyDefLog.Show;
end;

procedure TfrmMain.actViewOnlineFAQExecute(Sender: TObject);
var
  MyFAQ : TfrmFaq;
begin
  MyFAQ := TfrmFaq.Create(Self);
  MyFAQ.Show;
end;

procedure TfrmMain.actMenuHelpExecute(Sender: TObject);
begin
//
end;

procedure TfrmMain.edtAllExtentionsChange(Sender: TObject);
begin
  Extentions.text := edtAllExtentions.text;
end;

procedure TfrmMain.File1Click(Sender: TObject);
begin
//
end;

procedure TfrmMain.actFileExecute(Sender: TObject);
begin
//
end;

procedure TfrmMain.btnAddExtraClick(Sender: TObject);
begin
  EdtIpsExtra.Items.Add(edtAddIpExtra.text);
  SecurityIpList.text := EdtIpsExtra.Items.Text;

end;

procedure TfrmMain.btnDeleteExtraClick(Sender: TObject);
begin
  EdtIpsExtra.Items.Delete(EdtIpsExtra.ItemIndex);
  SecurityIpList.text := EdtIpsExtra.Items.Text;
end;

procedure TfrmMain.actShowDocumentationExecute(Sender: TObject);
var
  frmDocumentation: TfrmDocumentation;
begin
  frmDocumentation := TfrmDocumentation.create(self);
  frmDocumentation.Show;
end;

procedure TfrmMain.ToolButton2Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    Begin
      edtTBNdirectory.Text := ExtractFilePath(OpenDialog1.FileName);
      edtTBNdirectoryChange(edtSubtitledirectory);
    End;

end;

procedure TfrmMain.edtTBNdirectoryChange(Sender: TObject);
begin
  TBNDirectory.text := edtTBNdirectory.Text;
end;

end.


