{******************************************************************************}
{                                                                              }
{ This unit contains initial routines for reading, searching and streaming the }
{ contents of an ISO file (Image) of a XBOX CD/DVD.                            }
{                                                                              }
{ Original unit name; UnXISOReader.pas                                         }
{                                                                              }
{ ToDo:                                                                        }
{   Verify the code. It's only tested on a limited number of XISO's            }
{   Merge with UnISOReader                                                     }
{ References                                                                   }
{                                                                              }
{******************************************************************************}
{                                                                              }
{ XISO Reading Routines Routines                                               }
{                                                                              }
{ Unit owner: Espen Schaathun  (espen_schaathun@hotmail.com)                   }
{ Last modified: December 02, 2002                                             }
{                                                                              }
{******************************************************************************}


unit UnXISOReader;

interface
uses
  Classes, SysUtils, Dialogs;

  Type
  TCustomXISODirectory = Class(TObject)
  private
    FLeftNode: SmallInt;
    FRightNode: SmallInt;
    FStartSector: LongInt;
    FFileSize: LongInt;
    FFlags: Byte;
    FIDentLength: Byte;
    FIDent: String;
    FPosition: LongInt;
    FDirList: TList;
    function GetIsDirectory: Boolean; virtual;
  public
    constructor Create;
    property IsDirectory: Boolean read GetIsDirectory;
    property DirList: TList read FDirList;
    property Ident: String read FIdent;
  end;

  TRootXISODirectory = class(TCustomXISODirectory)
  private
    function GetIsDirectory: Boolean; override;
  public
    constructor Create(aStartSector: Cardinal; aFileSize: Cardinal);
  end;

  TXISODirectory = class(TCustomXISODirectory)
  private
    function GetIsDirectory: Boolean; override;
  public
    constructor Create(P1: Pointer);
  end;

  TXISOFileSystem = class(TObject)
  private
    FMSName : String;
    FRootDirStartSector: Cardinal;
    FRootDirSize: Cardinal;
    FMSName2 : String;
    //FDirStruture: TList;
    FRootDir: TCustomXISODirectory;
    function CreateRootDir(AStartSector, ADirSize: Integer;AStream: TStream): TCustomXISODirectory;
    function CreateDirStruct(AParent: TCustomXISODirectory; AStream: TStream): TCustomXISODirectory;
  public
    constructor Create(AStream: TStream);
    property RootDir: TCustomXISODirectory read FRootDir;
  end;


  TXISOReader = class(TObject)
  private
    FFS: TStream;
    FFileSystem: TXISOFileSystem;
    FCurrentFile: TCustomXISODirectory;
  protected

  public

  published
    constructor Create(AISoFileName: String);
    procedure SetCurrentFile(aDirectory: TCustomXISODirectory);
    function Read(var Buffer; Count: Integer): Longint;
    property FileSystem: TXISOFileSystem read FFileSystem;
  end;

  TSearchableXISOReader = class(TXISOReader)
  private
    FWorkingDirectory: TCustomXISODirectory;
    FSearchDirectory: TCustomXISODirectory;
    FSearchString: String;
    function SetSearchDirectory(aPath: String): LongInt;
    function Search(aIndex: Integer; var aSearchRec: TSearchRec): LongInt;
  public
    constructor Create(AISoFileName: String);
    function SetWorkingDirectory(aPath: String): Longint;
    function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec):Longint;
    function FindNext(var aSearchRec: TSearchRec):Longint;
    procedure FindClose(var aSearchRec: TSearchRec);
    function FileExists(aFileName: String):Boolean;
  end;

  TXISOFileStream = Class(TStream)
  protected
    FISOFile: TSearchableXISOReader;
    procedure SetSize(NewSize: Longint); override;
    procedure SetSize(const NewSize: Int64); override;
  public
    constructor Create(AISOFileName: String; AFileName: String; AMode: Word; ARights: Cardinal);
    destructor Destroy; Override;
    function Read(var Buffer; Count: Longint): Longint; override;
    function Write(const Buffer; Count: Longint): Longint; override;
    function Seek(const Offset: Int64; Origin: TSeekOrigin): Int64; override;
  end;

implementation

{ TXISOFileStream }

constructor TXISOFileStream.Create(AISOFileName, AFileName: String;
  AMode: Word; ARights: Cardinal);
var
  SearchRec: TSearchRec;
begin
  //Create the searchable ISO reader
  FISOFile := TSearchableXISOReader.Create(AISOFileName);
  //Find the File
  //raise Exception if not found
  if FISOFile.FindFirst(AFileName,0 ,SearchRec) <> 0 then
    raise Exception.Create('File not found in ISO');
end;

destructor TXISOFileStream.Destroy;
begin
  //Free the XISOReader
  FISOFile.Free;
  inherited;
end;

function TXISOFileStream.Read(var Buffer; Count: Integer): Longint;
begin
  //Call the Read Method of the XISOReader
  Result := FISOFile.Read(Buffer, Count)
end;

function TXISOFileStream.Seek(const Offset: Int64;
  Origin: TSeekOrigin): Int64;
begin
  case Origin of
    soBeginning: FISOFile.FCurrentFile.FPosition := Offset; //Go offset bytes from the begining of File
    soCurrent  : FISOFile.FCurrentFile.FPosition := FISOFile.FCurrentFile.FPosition + Offset; //GO Offset bytes from current Posisition
    soEnd      : FISOFile.FCurrentFile.FPosition := FISOFile.FCurrentFile.FFileSize - Offset; //Go backwards from the end
  end;
{  if FISOFile.FCurrentFile.FPosition < 0 then
    FISOFile.FCurrentFile.FPosition := 0
  else} if FISOFile.FCurrentFile.FPosition > FISOFile.FCurrentFile.FFileSize then
    FISOFile.FCurrentFile.FPosition := FISOFile.FCurrentFile.FFileSize;
  Result := FISOFile.FCurrentFile.FPosition;
end;

procedure TXISOFileStream.SetSize(NewSize: Integer);
begin
  inherited;
  //Not implemented
end;

procedure TXISOFileStream.SetSize(const NewSize: Int64);
begin
  inherited;
  //Not implemented.
end;

function TXISOFileStream.Write(const Buffer; Count: Integer): Longint;
begin
  //Not implemented
    Result :=0;
end;


{ TXISOReader }

constructor TXISOReader.Create(AISoFileName: String);
begin
  inherited Create;
  FFS := TFileStream.Create(AIsoFileNAme, fmOpenRead+fmShareDenyNone);
  //Let's read the header
  FFileSystem := TXISOFileSystem.Create(FFS);
end;

function TXISOReader.Read(var Buffer; Count: Integer): LongInt;
begin
  //If we haven't got a file to read from what then ??
  if FCurrentFile = nil then
    raise Exception.Create('No file set');
  //Position the stream
  FFS.Position := 2048 * FCurrentFile.FStartSector + FCurrentFile.FPosition;
  //Do we pass file boundries ??
  if FCurrentFile.FFileSize < (FCurrentFile.FPosition - Count) then
    Count := FCurrentFile.FPosition - Count;
  //Read data
  Result := FFS.Read(Buffer, Count);
  //Update the posistion
  FCurrentFile.FPosition := FCurrentFile.FPosition + Result;
end;

procedure TXISOReader.SetCurrentFile(aDirectory: TCustomXISODirectory);
begin
  FCurrentFile:= aDirectory;
  FCurrentFile.FPosition:= 0;
end;

{ TXISODirectory }

constructor TXISODirectory.Create(P1: Pointer);
var
  P2: PChar;
  i: Integer;
begin
  inherited Create;
  P2:= PChar(P1);
  FLeftNode := PSmallInt(P2)^;
  FRightNode:= PSmallInt(P2+2)^;
  FStartSector:= PCardinal(P2+2+2)^;
  FFileSize:= PCardinal(P2+2+2+4)^;
  FFlags := PByte(P2+2+2+4+4)^;

  FIDentLength:= PByte(P2+2+2+4+4+1)^;
  for i := 0 to FIDentLength -1 do
  begin
    FIDent := FIDent + PChar(P2+2+2+4+4+1+1+i)^;
  end;
end;


function TXISODirectory.GetIsDirectory: Boolean;
begin
  Result := (FFlags and $10) <> 0;
end;

{ TXISOFileSystem }

constructor TXISOFileSystem.Create(AStream: TStream);
var
  I: Integer;
  P2: PChar;
  Sector: array [0..2047] of byte;
begin
  AStream.Position := $10000;
  AStream.ReadBuffer(Sector, 2048);

  P2:= @Sector[0];

  for I := 0 to $13 do    // Iterate
  begin
    FMsName:= FMsName + PChar(P2)^;
    P2:= P2 + 1;
  end;    // for

  FRootDirStartSector:= PCardinal(P2)^;
  FRootDirSize := PCardinal(P2+4)^;
  for I := 0 to $13 do    // Iterate
  begin
    FMsName2 := FMsName2 + PChar(P2 + 16 + 1992 + i)^;
  end;    // for
  //Loop until we have read ALL the Structs in RootDir
  FillChar(Sector, SizeOf(Sector), 0);
  AStream.Position:= FRootDirStartSector * 2048;
  CreateRootDir(FRootDirStartSector, FRootDirSize, AStream);
 end;

function TXISOFileSystem.CreateRootDir(AStartSector, ADirSize: Integer;
  AStream: TStream): TCustomXISODirectory;
var
  P1: Pointer;
begin
  Result := Nil;
  AStream.Position := AStartSector * 2048;
  //Read needed data
  GetMem(P1, ADirSize);

  AStream.ReadBuffer(P1^, ADirSize);
  FRootDir:= TRootXISODirectory.Create(aStartSector, aDirSize);
  CreateDirStruct(FRootDir, AStream);
end;

function TXISOFileSystem.CreateDirStruct(AParent: TCustomXISODirectory; AStream: TStream): TCustomXISODirectory;
var
  Buffer: PChar;
  ADir: TXISODirectory;
begin
  Result:= Nil;
  AStream.Position := AParent.FStartSector * 2048;
  //Read needed data
  GetMem(Buffer, AParent.FFileSize);

  AStream.ReadBuffer(Buffer^, AParent.FFileSize);
  //Create a entry
  ADir := TXISODirectory.Create(Buffer);
  while ADir.FRightNode <> 0 do
  begin
    if ADir.IsDirectory then
      CreateDirStruct(Adir, AStream);
    AParent.FDirList.add(ADir);
    //We need to progress the
    ADir := TXISODirectory.Create((PChar(Buffer) + ADir.FRightNode * 4));
  end;    // while
end;


{ TCustomXISODirectory }

constructor TCustomXISODirectory.Create;
begin
  inherited Create;
  FDirList := TList.Create;
  FPosition:= 0;
end;

function TCustomXISODirectory.GetIsDirectory: Boolean;
begin
  Result := True;
end;

{ TRootXISODirectory }

constructor TRootXISODirectory.Create(aStartSector: Cardinal; AFileSize: Cardinal);
begin
  inherited Create;
  FStartSector := aStartSector;
  FFileSize := AFileSize;
end;

function TRootXISODirectory.GetIsDirectory: Boolean;
begin
  Result := False;
end;

{ TSearchableXISOReader }

constructor TSearchableXISOReader.Create(AISoFileName: String);
begin
  Inherited;
  FSearchDirectory := FFileSystem.FRootDir;
  FWorkingDirectory:= FSearchDirectory;
end;

function TSearchableXISOReader.FileExists(aFileName: String): Boolean;
begin
  Result := False;
//  raise Exception.Create('FileExists not implemented');
end;

procedure TSearchableXISOReader.FindClose(var aSearchRec: TSearchRec);
begin

end;

function TSearchableXISOReader.Search(aIndex: Integer; var aSearchRec: TSearchRec): LongInt;
// aIndex is where in the current SearchPath we want to start searching.
//Normally findFirst wil call this procedure with aIndex := 0;
var
  i: Integer;
  procedure UpdateSearchRec();
  begin
    aSearchRec.FindHandle:= LongInt(FSearchDirectory.FDirList[aIndex]);
    aSearchRec.Name:= TCustomXISODirectory(FSearchDirectory.FDirList[aIndex]).Ident;
    aSearchRec.Attr := faReadOnly;

    if TCustomXISODirectory(FSearchDirectory.FDirList[aIndex]).IsDirectory then
      aSearchRec.Attr := aSearchRec.Attr + faDirectory;
  end;
begin
  Result := 1;  //ALways a pessimist;
  //If we try to find *.* then just return the Next occurence in the list.
  if ExtractFileName(FSearchString) = '*.*' then
  begin
    if FSearchDirectory.FDirList.Count -1 < (AIndex) then
    begin
      FCurrentFile := Nil;
      aSearchRec.FindHandle := 0;
      Exit;
    end
    else
    begin
      FCurrentFile := FSearchDirectory.FDirList[aIndex];
      //aSearchRec.FindHandle:= LongInt(FSearchDirectory.FDirList[aIndex]);
      //aSearchRec.Name:= TCustomXISODirectory(FSearchDirectory.FDirList[aIndex]).Ident;
      UpdateSearchRec;
      Result := 0;
      Exit;
    end;
  end
  else
  begin
    for i:= aIndex to FSearchDirectory.FDirList.Count -1 do
    begin
      //If we find a TXISODirectory Matching our aWildcard then Store it and Exit
      if TCustomXISODirectory(FSearchDirectory.FDirList[i]).Ident = ExtractFileName(FSearchString) then
      begin
        FCurrentFile:= TCustomXISODirectory(FSearchDirectory.FDirList[i]);
        UpdatesearchRec;
        Result:= 0; //Oh Yeah baby!! We found it..
        Break;
      end;
    end;
  end;
end;

function TSearchableXISOReader.FindFirst(aWildCard: String;
  FileMode: Integer; var aSearchRec: TSearchRec): Longint;
begin
  Result:= 1;
  //do we have a aWildcard??
  if aWildCard = '' then
    exit;
  //Store aWildCard for use in FindNext :-P
  FSearchString:= '*.*';//aWildCard;
  //go to correct path
  SetSearchDirectory(ExtractFilePath(aWildCard));
  //Itterate through the search path
  Result := Search(0, aSearchRec);
end;

function TSearchableXISOReader.FindNext(
  var aSearchRec: TSearchRec): Longint;
var
  Index: Integer;
begin
  Result := 1;
  //Do we have a wildcard?? Does it really mather here.... Don't think so.

  //No mather what we are gonna search from the current search directtory

  //Ok Find the Index of the last occurence we found
  Index:= FSearchDirectory.FDirList.IndexOf(Pointer(aSearchRec.FindHandle));
  Index:= Index + 1;
  if ((FSearchDirectory.FDirList.Count -1) <  (Index))then
    Exit;
  //Itterate through the search path
  Result := Search(Index, aSearchRec);
end;

function TSearchableXISOReader.SetSearchDirectory(aPath: String): LongInt;
var
  StrLst: TStringList;
  NewDirectory: TCustomXISODirectory;
  i: Integer;
  function FindDirectoryInt(aDirectory: TCustomXISODirectory; aDirectoryName: String): TCustomXISODirectory;
  var
    i: Integer;
  begin
    Result := Nil;
    for i:= 0 to ADirectory.FDirList.Count -1 do
    begin
      if TCustomXISODirectory(ADirectory.FDirList[i]).Ident = aDirectoryName then
      begin
        Result := TCustomXISODirectory(ADirectory.FDirList[i]);
        Break; //No need to itterate more :-)
      end;
    end;
  end;

begin
  Result:= 0;  //Always an optimist. I'm Okey, you're Okey :-P
  //if we have a blank here we are probably already in the right directory :-P
  if aPath = '' then
    exit;
  aPath := ExcludeTrailingPathDelimiter(aPath);

  //if we have a blank now we wanted to to to Root
  if aPath = '' then
  begin
    FSearchDirectory:= FFileSystem.RootDir;
    Exit;
  end;

  StrLst := TStringList.Create;
  StrLst.Delimiter := PathDelim;
  StrLst.DelimitedText := aPath;


  //Is it relative or absolute path?
  if StrLst[0] <> '' then
  begin
    //Relativ path
    //G0 from the current directory and find the next;
    NewDirectory := FWorkingDirectory;
  end
  else
  begin
    //It's absolut
    //Goto root
    NewDirectory := FFileSystem.FRootDir;
    //remove the first blank
    StrLst.Delete(0);
  end;

  //Go from start Directory and find the last Child
  for i:= 0 to StrLst.Count -1 do
  begin
    NewDirectory := FindDirectoryInt(NewDirectory, StrLst[i]);
    if NewDirectory = nil then
      Break; //Stop itterating!
  end;

  if NewDirectory <> nil then
    FSearchDirectory := NewDirectory
  else
    Result := 1;

  StrLst.Free;
end;

function TSearchableXISOReader.SetWorkingDirectory(aPath: String): Longint;
begin
  Result := 0;
  aPath := IncludeTrailingPathDelimiter(aPath);
  if SetSearchDirectory(aPath) = 0 then
    FWorkingDirectory := FSearchDirectory;
end;

end.
