{******************************************************************************}
{                                                                              }
{ This unit contains initial routines for reading, searching and streaming the }
{ contents of a CDImage files. Supported Images are Jeff Arnolds .Bin format   }
{ and ISO files from amongst others Nero Burning Rom. Rumours says that it also}
{ supports other ISO9660 compatible formats. Well what can I say.?. It might, I}
{ haven't tested it. Give me feedback on this.                                  }
{                                                                              }
{                                                                              }
{ Original unit name; UnXISOReader.pas                                         }
{                                                                              }
{ ToDo                                                                         }
{   Verify code                                                                }
{   Cleanup                                                                    }
{   Merge with UnXISOReader                                                    }
{                                                                              }
{ References                                                                   }
{******************************************************************************}
{                                                                              }
{ CDImage Reading Routines                                                     }
{                                                                              }
{ Unit owner: Espen Schaathun  (espen_schaathun@hotmail.com)                   }
{ Last modified: December 02, 2002                                             }
{                                                                              }
{******************************************************************************}
unit UnISOReader;

interface
uses Classes, Dialogs, Sysutils, Types;

{const
  DefaultSectorSize: Integer = 2048; //ISO = 2048, Bin Normally
  MinDirectorySize: Integer = 34;  //Mode1 = 34 ?? Mode2=48 ??
  FormatHeaderSize: Integer = 16;
  IdentifierPosition: Integer = 32;
  SectorHeaderSize: Integer = 0;
  UserDataSize: Integer= 2048; //ISO = 2048, BIN Mode 1 = 2048 Bin Mode 2 = 2324
  VDSTerminator = #255 + #67 + #68 + #48 + #48 + #49 +#1;
  }
type

  TSector = array [0..4096] of byte;
  TSectorArray = Array of Byte;

  TISOFileParams = Class(TObject)
  private
    FDefaultSectorSize:  Int64; //ISO = 2048, Bin Normally
    FMinDirectorySize:   Int64;  //Mode1 = 34 ?? Mode2=48 ??
    FFormatHeaderSize:   Int64;
    FIdentifierPosition: Int64;
    FSectorHeaderSize:   Int64;
    FUserDataSize:       Int64; //ISO = 2048, BIN Mode 1 = 2048 Bin Mode 2 = 2324
    FVDSTerminator:      String;
//    ISOMode:             Integer;
  public
    Constructor Create;
    property DefaultSectorSize: Int64 read FDefaultSectorSize write FDefaultSectorSize;
    property MinDirectorySize: Int64 read  FMinDirectorySize  write  FMinDirectorySize;
    property FormatHeaderSize: Int64 read  FFormatHeaderSize  write  FFormatHeaderSize;
    property IdentifierPosition: Int64 read  FIdentifierPosition write  FIdentifierPosition;
    property SectorHeaderSize: Int64 read  FSectorHeaderSize  write  FSectorHeaderSize;
    property UserDataSize: Int64 read  FUserDataSize write FUserDataSize;
    property VDSTerminator: String read  FVDSTerminator write  FVDSTerminator;
  end;

  TISOFileType = (ftUnknown, ftVCD);
  TDirectory = class(TObject)
  private
    FSize: Byte;
    FSectorCount: Byte;
    FFirstSector: DWord;
    FLength: DWord;
    FYear: Byte;
    FMonth: Byte;
    FDay: Byte;
    Fhour: Byte;
    Fminute: Byte;
    Fsecond: Byte;
    Foffset: Byte;
    Fflags: Byte;
    Ffileunitsize: Byte;
    Fgapsize: Byte;
    Fvolumeseqnum: word;
    FIdentLength: Byte;
    FIdent: String;
    FDirList: TList;
    FPosition: Int64;
    function GetIsFile: Boolean;
  public
    constructor Create(P1: Pointer; FileParams: TISOFileParams);
    property Ident: String read FIdent;
    property IsFile: Boolean read GetIsFile;
    property DirList: TList read FDirList;
    property Position: Int64 read FPosition write FPosition;  //Should be moved to a descendant clss
  end;


 TISOFileReader = Class(TObject)
  private
    //FFSectorSize: Integer;
//    FFileName: String;
    FS: TFileStream;
    FRootDirectory: TDirectory;
    FISOFileParams: TISOFileParams;
    FCurrentFile: TDirectory;
    procedure BuildDirectory(Parent: TDirectory; Stream: TStream);
    function BuildRoot(Stream: TStream): TDirectory;
    function GetFileType: TISOFileType;
  protected
  public
    Constructor Create(FileName: String);
    destructor Destroy; override;
    Function SetFile(aDirectory: TDirectory): Integer;
    property FileType: TISOFileType read GetFileType;
    property RootDirectory: TDirectory read FRootDirectory;
    function GetFileStream: TFileStream;
    function Read(var Buffer; Count: Integer): Longint;  //This is the only method that shouldn't be in here
    property CurrentFile: TDirectory read FCurrentFile;
  end;


  TSearchableISOFileReader = class (TISOFileReader)
  private
      FCurrentDirectory: TDirectory;
      FSearchDirectory: TDirectory;
      FSearchString: String;
      Function SetFile(aFileName: String): Integer; overload;
      Function SetPath(aPathName: String): Integer;
  protected
  public
    Constructor Create(FileName: String);
    Function SetCurrentDirectory(aPath: String): Integer;
    Function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec):Longint;
    Function FindNext(var aSearchRec: TSearchRec):Longint;
    Procedure FindClose(var aSearchRec: TSearchRec);
    Function FileExists(aFileName: String):Boolean;
    property CurrentDirectory: TDirectory read FCurrentDirectory;
  end;

  TISOFileStream = class(TStream)
  protected
    FISOFile: TSearchableISOFileReader;
    FDirectory: TDirectory;
    procedure SetSize(NewSize: Longint); override;
    procedure SetSize(const NewSize: Int64); override;
  public
    constructor Create(AISOFileName: String; AFileName: String; AMode: Word; ARights: Cardinal);
    destructor Destroy; Override;
    function Read(var Buffer; Count: Longint): Longint; override;
    function Write(const Buffer; Count: Longint): Longint; override;
    function Seek(const Offset: Int64; Origin: TSeekOrigin): Int64; override;
  end;

  function ByteCompare(P1: Pointer; P2: Pointer; Length: Integer): Boolean;

implementation

procedure TISOFileReader.BuildDirectory(Parent: TDirectory; Stream: TStream);
var
 Dir : TDirectory;
 Done: Boolean;
 SectorBuf: TSector;
 P1: Pointer;
begin
  Done:= False;
  Stream.Position := (Parent.FFirstSector * FISOFileParams.DefaultSectorSize) + FISOFileParams.FormatHeaderSize;
  Stream.Read(SectorBuf,FISOFileParams.DefaultSectorSize);
  P1 := @SectorBuf[2*FISOFileParams.MinDirectorySize];

  while not done do
  begin
    Dir := TDirectory.Create(P1, FISOFileParams);
    if Dir.FSize <> 0 then
    begin
      Parent.DirList.add(Dir);
      if not Dir.IsFile then
        BuildDirectory(Dir, Stream);
    end
    else
      Done := True;
    P1 := PCHAR(P1) + Dir.FSize;
  end;
end;


function TISOFileReader.BuildRoot(Stream: TStream): TDirectory;
var
  Buf: Array[0..47] of Byte;
begin
  Stream.Read(Buf,FISOFileParams.MinDirectorySize);
  Result := TDirectory.Create(@Buf[0], FISOFileParams);
  BuildDirectory(Result, Stream)
end;


function ByteCompare(P1: Pointer; P2: Pointer; Length: Integer): Boolean;
var
  i: Integer;
begin
  Result := True;
  for i := 0 to length -1 do
  begin
    if not ( (PChar(P1) + i)^ = (PChar(P2) +i)^)  then
    begin
      Result := False;
      Break;
    end;
  end;
end;

{ TISOFileParams }

constructor TISOFileParams.Create;
begin
  FDefaultSectorSize:= 2048; //ISO = 2048, Bin Normally
  FMinDirectorySize:= 34;  //Mode1 = 34 ?? Mode2=48 ??
  FFormatHeaderSize:= 16;
  FIdentifierPosition:= 32;
  FSectorHeaderSize:= 0;
  FUserDataSize:= 2048; //ISO = 2048, BIN Mode 1 = 2048 Bin Mode 2 = 2324
  FVDSTerminator:= #255 + #67 + #68 + #48 + #48 + #49 +#1;
end;

{ TISOFileReader }

constructor TISOFileReader.Create(FileName: String);
var
  SectorBuf: TSector;
begin
  inherited Create;
  {It's here that we set default sector size, headerSize and MODE. }
  FISOFileParams := TISOFileParams.Create;
  FS := TFileStream.Create(FileName, fmOpenRead+fmShareDenyNone);
//  if lowercase(ExtractFileExt(FileName)) = '.bin'  then
  begin
    FISOFileParams.DefaultSectorSize := 2352;
    FS.Read(SectorBuf,FISOFileParams.DefaultSectorSize);
    if SectorBuf[15] = 2 then
    begin
      FISOFileParams.MinDirectorySize:= 48;  //Mode1 = 34 ?? Mode2=48 ??
      FISOFileParams.FormatHeaderSize:= 24;
//      IdentifierPosition: Integer = 31;
//      SectorHeaderSize:= 16;
      FISOFileParams.UserDataSize:= 2324; //ISO = 2048, BIN Mode 1 = 2048 Bin Mode 2 = 2324
    end
    else if SectorBuf[15] = 1 then
    begin
      FISOFileParams.MinDirectorySize:= 34;  //Mode1 = 34 ?? Mode2=48 ??
      FISOFileParams.FormatHeaderSize:= 16;
//      IdentifierPosition: Integer = 31;
//      SectorHeaderSize:= 16;
      FISOFileParams.UserDataSize:= 2048; //ISO = 2048, BIN Mode 1 = 2048 Bin Mode 2 = 2324
    end
    else
     raise Exception.Create('Unkown .BIN mode');
  end;
{  else
  begin
    DefaultSectorSize := 2048;
    FFSectorSize:= DefaultSectorSize;
    FormatHeaderSize := 0;
//    IdentifierPosition := 31;
    MinDirectorySize := 34;
  end;}

  //First SKIP the first 16 sectors. They are just crap anyways
  FS.Position := FISOFileParams.DefaultSectorSize * 16 + FISOFileParams.FormatHeaderSize;
  //Find the Root directory:
{  if FS.Read(SectorBuf,FISOFileParams.DefaultSectorSize) <> FISOFileParams.DefaultSectorSize then
   Raise Exception.Create('Didn''t read correct BuFfer size');
}  //Starts at 157 in the Volume descriptor
  FS.Position := (16 * FISOFileParams.DefaultSectorSize) + 156 + FISOFileParams.FormatHeaderSize;
  FRootDirectory := BuildRoot(FS); //TDirectory.Create(Nil, @Sectorbuf[156]);
end;

destructor TISOFileReader.Destroy;
begin
  FS.Free;
  inherited;
end;


function TISOFileReader.GetFileStream: TFileStream;
begin
  Result := FS;
end;

function TISOFileReader.GetFileType: TISOFileType;
begin
  Result := ftUnknown;
end;

function TISOFileReader.Read(var Buffer; Count: Integer): Longint;
var
//  SectorArray: TSectorArray; //: Array [0..2047] of Byte;
  i: Integer;
  BytesLeftInSector: Integer;
  CountBytesInFirstSector: Integer;
  CountBytesToReadInLastSector: Integer;
  CountSectorsToRead: Integer;
  FirstByteInSectorToRead: Integer;
  FirstSector, Position : Integer;
  P1: PChar;
begin
  Firstsector := FCurrentFile.FFirstSector;
  Position := FCurrentFile.Position;
  //if we try to read more data than we have left, limit the read operation
  if Count > FCurrentFile.FLength - FCurrentFile.Position then
    Count := FCurrentFile.FLength - FCurrentFile.Position;
  //Convert to PChar so we can add to it.

  FirstByteInSectorToRead:= FCurrentFile.Position - ( (Position div FISOFileParams.UserDataSize) * FISOFileParams.UserDataSize);
  //How many bytes are left in the current sector
  BytesLeftInSector := FISOFileParams.UserDataSize- FirstByteInSectorToRead; //((Count div UserdataSize) * UserDataSize);

  //How Many bytes do we need to read from the first sector??
  if BytesLeftInSector >= Count then
    CountBytesInFirstSector:= Count
  else
    CountBytesInFirstSector:= BytesLeftInSector;

  //How many complete sectors do we need to read ??
  if Count <= BytesLeftInSector then
    CountSectorsToRead:= 0
  else
    CountSectorsToRead:= ((Count - BytesLeftInSector) div FISOFileParams.UserDataSize);
  //How many bytes do we need to read in the last sector ??
  CountBytesToReadInLastSector:= Count - CountBytesInFirstSector - (CountSectorsToRead*FISOFileParams.UserDataSize);
  if CountBytesToReadInLastSector <= 0 then
    CountBytesToReadInLastSector:= 0;

  FS.Position := ((FirstSector * FISOFileParams.DefaultSectorSize) + FISOFileParams.FormatHeaderSize) +  // Beginning of file
                 ((Position div FISOFileParams.UserDataSize) * FISOFileParams.DefaultSectorSize)//;        //Begning of the sector in question

                 + FirstByteInSectorToRead;//( Position - ((Position div UserDataSize) * UserDataSize));


  //Read the rest of the current sector
  P1:= PChar(@Buffer);
  FS.Read(P1^, CountBytesInFirstSector);

  //Position the Pointer
  P1 := P1 + CountBytesInFirstSector;

  //Read all the complete sectors
  for i :=0 to CountsectorsToRead-1 do
  begin
    FS.Position := ((FirstSector * FISOFileParams.DefaultSectorSize) + FISOFileParams.FormatHeaderSize) +  // Beginning of file
                   ((Position div FISOFileParams.UserDataSize) * FISOFileParams.DefaultSectorSize)//;        //Begning of the sector in question

                   + ((1+i) * FISOFileParams.DefaultSectorSize) ;//( Position - ((Position div UserDataSize) * UserDataSize));
    //Read a sector
    FS.Read(P1^, FISOFileParams.UserDataSize);
    P1:= P1 + FISOFileParams.UserDataSize;

  end;
  //Read the needed bytes from the last sector
  FS.Position := ((FirstSector * FISOFileParams.DefaultSectorSize) + FISOFileParams.FormatHeaderSize) +  // Beginning of file
                 ((Position div FISOFileParams.UserDataSize) * FISOFileParams.DefaultSectorSize)//;        //Begning of the sector in question

                 + ((1+CountSectorsToRead) * FISOFileParams.DefaultSectorSize) ;//( Position - ((Position div UserDataSize) * UserDataSize));
  FS.Read(P1^, CountBytesToReadInLastSector);
  //Set the position.
  FCurrentFile.Position := FCurrentFile.Position + Count;
  //Return what we have read!
  Result := Count;
end;

function TISOFileReader.SetFile(aDirectory: TDirectory): Integer;
begin
  Result := 0;
  FCurrentFile := aDirectory;
end;

{ TDirectory }

constructor TDirectory.Create(P1: Pointer; FileParams: TISOFileParams);
//******************************************************************************
//This moethod is supposed to read the Directory Structure. But since I only have
//the ISO9660 Dir structure, and not the structure from CDROM-XA etc it's not
//Completely correct. Most of the Important stuff are read out though.
// (FileSize startSector, Flags, and IDENT. That's all we need) :-)
//******************************************************************************

var
  P2: PChar;
  i: Integer;
//  PaddingByte: Byte;
  SkipInIdent: Integer;
begin
  FDirList:=  TList.Create;
  //Skip the Self and Parent directories
  //If the Size is 0 then we do NOT have a pointer to a directory Record
  FSize := 0;

  P2 := PChar(P1);
  if Byte(P2^) = 0 then exit;
  FSize := PByte(P2)^;
  FSectorCount := PByte(P2+1)^;
  FFirstSector := PLongWord(P2+1+1)^;
  FLength:=  PLongWord(P2+1+1+8)^;//Round(PLongWord(P2+1+1+8)^ / 2048) * 2352;
  FYear:= PByte(P2+1+1+8+8)^;
  FMonth:= PByte(P2+1+1+8+8+1)^;
  FDay:= PByte(P2+1+1+8+8+1+1)^;
  Fhour:= PByte(P2+1+1+8+8+1+1+1)^;
  Fminute:= PByte(P2+1+1+8+8+1+1+1+1)^;
  Fsecond:= PByte(P2+1+1+8+8+1+1+1+1+1)^;
  Foffset:= PByte(P2+1+1+8+8+1+1+1+1+1+1)^;
  Fflags:= PByte(P2 + FileParams.IdentifierPosition - 7)^;//PByte(P2+1+1+8+8+1+1+1+1+1+1)^;
  Ffileunitsize:= PByte(P2+1+1+8+8+1+1+1+1+1+1)^;
  Fgapsize:= PByte(P2+1+1+8+8+1+1+1+1+1+1)^;
  Fvolumeseqnum:= PLongWord(P2+1+1+8+8+1+1+1+1+1+1)^;
//  FIdentLength:= PLongWord(P2+1+1+8+8+1+1+1+1+1+1+8)^;
  FIdentLength:= PByte(P2+FileParams.IdentifierPosition)^;

  FIdent := '';
  //We do want to read the last 2 bytes (;1) if it's a file.
  if IsFile then
    SkipInIdent:= 2
  else
    SkipInIdent:=0;

  for i:= 0 to (FIdentLength - 1 - SkipInIdent) do //No need to use the 2 last chrs
  begin
    FIdent := FIdent + PChar(P2+FileParams.IdentifierPosition+i+1)^;
  end;

  if FileParams.DefaultSectorSize = 2352 then  // we have a MODE 2 file
    if ((FLength div 2048) * 2352) <> FLength then
      FLength := ((FLength div 2048) * 2352); //+ 44
      {for some uknown reason other ISO readers add 44 bytes to the file
       Daemon tools also adds an unknown header into .DAT files that is not
       found in the the ISO at all.
       };

  //But we want to progres those 2 bytes:
//  i:= i + SkipInIdent;
//  P2 :=P2+1+1+8+8+1+1+1+1+1+1+8+1+i;
//  PaddingByte := 0;
//  if odd(FIdentLength) then PaddingByte := 1;
//  P2 := P2 + 1;
//  P2 := PChar(P1) + FSize; //-33-FIdentLength-PaddingByte;
end;

function TDirectory.GetIsFile: Boolean;
begin
  Result := (FFlags and 2) = 0;
end;


{ TISOFileStream }

constructor TISOFileStream.Create(AISOFileName: String; AFileName: String; AMode: Word;
  ARights: Cardinal);
var
  FileFound: Boolean;
  SearchRec: TSearchRec;
begin
  //Create the ISOFileReader
  FIsoFile := TSearchableISOFileReader.Create(AISOFileName);
  //Set what file to Point at
  FileFound := FISOFile.FindFirst(AFileName, 0{Not used anyways}, SearchRec) = 0;
  FindClose(SearchRec);


  // this is the only place to add some stuff i guess before it all works :)
  if not FileFound then
      raise Exception.Create('Couldn''t find the file specified');

end;

destructor TISOFileStream.Destroy;
begin
  //Clean UP bitch.!
  FISOFile.Free;
  inherited;
end;

function TISOFileStream.Read(var Buffer; Count: Integer): Longint;
begin
  Result := FISOFile.Read(Buffer,  Count);
end;

function TISOFileStream.Seek(const Offset: Int64;
  Origin: TSeekOrigin): Int64;
begin
  case Origin of
    soBeginning: FISOFile.CurrentFile.Position := Offset;
    soCurrent: FISOFile.CurrentFile.Position := FISOFile.CurrentFile.Position + Offset;
    soEnd: FISOFile.CurrentFile.Position:= FISOFile.CurrentFile.FLength - Offset;
  end;
  Result:= FISOFile.CurrentFile.Position;
end;

procedure TISOFileStream.SetSize(NewSize: Integer);
begin
  inherited;
  raise Exception.Create('Ohh no. I didn''t implement that :-)  You can not set size');
end;

procedure TISOFileStream.SetSize(const NewSize: Int64);
begin
  //inherited;
  raise Exception.Create('Ohh no. I didn''t implement that :-)   You can not set size');
end;

function TISOFileStream.Write(const Buffer; Count: Integer): Longint;
begin
  raise Exception.Create('Ohh no. I didn''t implement that :-). You can not WRITE. This is  read only');
end;

{ TSearchableISOFileReader }

constructor TSearchableISOFileReader.Create(FileName: String);
begin
  Inherited;
  FCurrentDirectory := FRootDirectory;
  FSearchDirectory:= FRootDirectory;
end;

function TSearchableISOFileReader.FileExists(aFileName: String): Boolean;
var
  i: Integer;
  FileName: String;
begin
  Result := False;  //Always a Pessimist,
  //Get the path where we try to search
  if SetPath(ExtractFilePath(AFileName)) <> 0 then
    Exit; //We couldn't even find the path we tried to search in.
  FileName := ExtractFileName(aFileName);
  for i:= 0 to FSearchDirectory.FDirList.Count - 1 do
  begin
    if TDirectory(FSearchDirectory.FDirList[i]).Ident = FileName then
    begin
      Result := True;
      Break; //We got what we came for, so no need to itterate more.
    end;
  end;
end;

procedure TSearchableISOFileReader.FindClose(var aSearchRec: TSearchRec);
begin
  //What ever.
  FSearchDirectory := Nil;
end;

function TSearchableISOFileReader.FindFirst(aWildCard: String;
  FileMode: Integer; var aSearchRec: TSearchRec): Longint;
var
  i: Integer;
begin
  //Ok I hope we have *.*
  //And we just ignore FileMode :-P
  Result := -1; //Always the
  //If we have *.* then just return the first occurence in FDirList of the
  //current directory
  if FSearchDirectory = Nil then
    Exit;

  if SetPath(ExtractFilePath(aWildCard)) <> 0 then
    exit; //We couldn't even find the path we tried to search in.
  FSearchString:= ExtractFileName(aWildCard);
  //Here we can call FindNext instead, since it will do the work for us as long as the
  //Handle is < -1
  if FSearchString = '*.*' then
  begin
    if FSearchDirectory.FDirList.Count <= 0 then
      exit;
    //We are always ReadOnly and sometimes we are also a directory
    aSearchRec.Attr := faReadOnly;
    if not TDirectory(FSearchDirectory.FDirList[0]).IsFile then
    begin
      aSearchRec.Attr := aSearchRec.Attr +  faDirectory;
      FCurrentFile := Nil;
    end
    else
      SetFile(TDirectory(FSearchDirectory.FDirList[0]));
    //Store the Pointer to the first occurence.
    aSearchRec.FindHandle := LongInt(FSearchDirectory.FDirList[0]);
    ASearchRec.Name := TDirectory(FSearchDirectory.FDirList[0]).Ident;
    Result := 0;
  end
  else
  {implement *xxxx}
  {implement xxxx*}
  {implement *xxx*}
  {Never ever will we suppoer xx*xx*, or xxx??.exe. So :-P}
  begin
    for i:= 0 to FSearchDirectory.FDirList.Count -1 do
    begin
      if TDirectory(FSearchDirectory.FDirList[i]).Ident = FSearchString then
      begin
        FCurrentFile:= TDirectory(FSearchDirectory.FDirList[i]);
        Result := 0;
        Break;
      end;
    end;
  end;
end;

function TSearchableISOFileReader.FindNext(
  var aSearchRec: TSearchRec): Longint;
var
  IndexOf: Integer;
begin
  Result := -1;  //Always the pessimist :-(
  //Find the index of the TDirectory in Handle
  //
//  if aSearchRec.FindHandle >= 0 then
   IndexOf := FSearchDirectory.FDirList.IndexOf(Pointer(aSearchRec.FindHandle));
  //If we didn't find the file in question then just exit
  If IndexOf = -1  then
   exit;
  //If we are at the last TDirectory then exit
  if FSearchDirectory.FDirList.Count - IndexOf - 1  <= 0 then
   exit;
  if FSearchString = '*.*' then
  begin
   IndexOf := IndexOf + 1;
   Result := 0;
  end;
  {implement *xxxx}
  {implement xxxx*}
  {implement *xxx*}
  {Never ever will we suppoer xx*xx*, or xxx??.exe. So :-P}
  {And simply by the fact that a fullname can't exist 2 times in the same dir I
  really don't see a need to implement that either. (Okey what about 1 dir and 1
  file with the same name?)}
  aSearchRec.Attr := faReadOnly;
  if not TDirectory(FSearchDirectory.FDirList[IndexOf]).IsFile then
  begin
    aSearchRec.Attr := aSearchRec.Attr +  faDirectory;
    FCurrentFile := Nil;
  end
  else
    FCurrentFile:= TDirectory(FSearchDirectory.FDirList[IndexOf]);

  //Store the Pointer to the occurence.
  aSearchRec.FindHandle := LongInt(FSearchDirectory.FDirList[IndexOf]);
  ASearchRec.Name := TDirectory(FSearchDirectory.FDirList[IndexOf]).Ident;
end;

function TSearchableISOFileReader.SetCurrentDirectory(
  aPath: String): Integer;
var
  OldCurrentDirectory: TDirectory;
begin
  Result := 0;
  OldCurrentDirectory:= FCurrentDirectory;
  if SetPath(aPath) = 0 then
    FCurrentDirectory := FSearchDirectory
  else
    if OldCurrentDirectory = Nil then
      FCurrentDirectory := FRootDirectory;
end;

function TSearchableISOFileReader.SetFile(aFileName: String): Integer;
var
  i: Integer;
  FileName: String;
begin
  Result := -1;
  if SetPath(ExtractFilePath(aFileName)) <> 0 then
    exit;
  //The next portion of code should have been put in a new function
  //SetFileInCurrentDir!
  FileName := ExtractFileName(aFileName);
  for i:= 0 to FSearchDirectory.FDirList.Count -1 do
  begin
    if TDirectory(FSearchDirectory.FDirList[i]).Ident = FileName then
    begin
      SetFile(TDirectory(FSearchDirectory.FDirList[i]));
      Result := 0;
      Break;
    end;
  end;
end;


function TSearchableISOFileReader.SetPath(APathName: String): Integer;
var
  StrLst: TStringList;
  StartDirectory, NewDirectory: TDirectory;
  i: Integer;
  function FindDirectoryInt(aDirectory: TDirectory; aDirectoryName: String): TDirectory;
  var
    i: Integer;
  begin
    Result := Nil;
    for i:= 0 to ADirectory.FDirList.Count -1 do
    begin
      if TDirectory(ADirectory.FDirList[i]).Ident = aDirectoryName then
      begin
        Result := TDirectory(ADirectory.FDirList[i]);
        Break; //No need to itterate more :-)
      end;
    end;
  end;
begin
  Result := 0; //Always an optimist.. (For a change) :-)
  if aPathName = '' then
  begin
    //We're probably trying to search in the current directory..
    //But if we're not in a current directory we Return Root!
    if FCurrentDirectory <> nil  then
      FSearchDirectory := FCurrentDirectory;
    Exit;
  end;
  APathName := ExcludeTrailingPathDelimiter(aPathName);
  //if we only had a \ we will now have '', and we must take special care.
  //It means that we want to search on rootdir
  //I don't like having to next if statement since it messes up the code here.
  StrLst := TStringList.Create;
  if APathName <> '' then
  begin
    StrLst := TStringList.Create;
    StrLst.Delimiter:= PathDelim;
    StrLst.DelimitedText := aPathName;
  end
  else
    StrLst.add('');

  //Is it relative ???
  if StrLst[0] <> '' then
  begin
    //Relativ path
    //GO from the current directory and find the next;
    StartDirectory := FCurrentDirectory;
  end
  else
  begin
    //It's absolut
    //Goto root
    StartDirectory := FRootDirectory;
    //remove the first blank
    StrLst.Delete(0);
  end;
  //Go from start Directory and find the last Child
//  if StrLst.Count -1 > 0 then
  begin
    NewDirectory := StartDirectory;
    //This one could have been outside the if...
    for i:= 0 to StrLst.Count -1 do
    begin
      NewDirectory := FindDirectoryInt(NewDirectory, StrLst[i]);
      if NewDirectory = nil then
        Break; //Stop itterating!
    end;
  end;

  if NewDirectory <> nil then
  begin
    FSearchDirectory := NewDirectory;
  end
  else
    Result := 1;
  StrLst.Free;
end;


end.
