unit ufDocumentation;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, SHDocVw, StdCtrls, ExtCtrls ;

type
  TfrmDocumentation = class(TForm)
    Panel1: TPanel;
    WebBrowser1: TWebBrowser;
    Panel2: TPanel;
    Panel3: TPanel;
    btnSwitch: TButton;
    Label1: TLabel;
    lblLocal: TLabel;
    procedure btnSwitchClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  public
    Local:Boolean;
    Procedure NavLocal;
    Procedure NavOnline;
  end;


implementation

{$R *.dfm}

procedure TfrmDocumentation.NavLocal;
var
  LocalFile : String;
begin
  Local := True;
  LocalFile := ExtractFilePath(ParamStr(0))+'Documentation\relax_guide.htm';
  btnSwitch.Caption := 'Switch Online Documentation';
  lblLocal.caption := 'Browsing Local';
  if FileExists(LocalFile) then
    WebBrowser1.Navigate('file:'+LocalFile)
  else
    NavOnline;
end;

procedure TfrmDocumentation.NavOnline;
begin
  Local := False;
  btnSwitch.Caption := 'Switch Local Documentation';
  lblLocal.Caption := 'Browsing Online';
  WebBrowser1.Offline := False;
  WebBrowser1.Navigate('http://www.raforce.nl/relax/relax_guide.htm')
end;

procedure TfrmDocumentation.btnSwitchClick(Sender: TObject);
begin
  if local then
    NavOnline
  else
    NavLocal;
end;

procedure TfrmDocumentation.FormCreate(Sender: TObject);
begin
  NavLocal;
end;

procedure TfrmDocumentation.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  action := caFree;
end;

end.
