unit udmListener;

interface

uses
   windows            // Delphi VCL
  ,Graphics
  ,SysUtils           // Delphi VCL
  ,stdctrls           // Delphi VCL
  ,controls           // Delphi VCL
  ,forms              // Delphi VCL
  ,Classes            // Delphi VCL
  ,uGeneral           // RelaX general functions / procedures
  ,IdAntiFreezeBase   // Part of Indy Delphi Components Suite
  ,IdAntiFreeze       // Part of Indy Delphi Components Suite
  ,IdBaseComponent    // Part of Indy Delphi Components Suite
  ,IdComponent        // Delphi VCL
  ,JanXMLParser2      // Part of EasyXML 2.1
  ,IdStackConsts      // Part of Indy Delphi Components Suite
  ,IdIOHandlerSocket  // Part of Indy Delphi Components Suite
  ,IdTCPServer        // Part of Indy Delphi Components Suite
  ;

type
  TdmListener = class(TDataModule)
    IdTCPServer1: TIdTCPServer;
    IdAntiFreeze1: TIdAntiFreeze;
    procedure IdTCPServer1Disconnect(AThread: TIdPeerThread);
    procedure IdTCPServer1Connect(AThread: TIdPeerThread);
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    Fshares: TJanXMLNode2;
    IpCurrentPath : TStringlist;
//    ipConfigList : TStringlist;
//    Function DoConfig(aUserIP:String;aConfigOption:String):TempConfigObject;
  public
    property shares : TJanXMLNode2 read Fshares write FShares;
    Procedure Log(debuglevel:Integer;S:STring;AThread: TIdPeerThread;aIP:String = '000.000.000.000');
    Procedure LogFile(filename: String; S: STring);
    Function GetMediaFilesFromPath(aXMLNode:TJanXMLNode2;Path:String; RCAT : Boolean):String;
    function GetItemListFromXMLNode(XMLNode: TjanXMLNode2; UserIP: String; RCAT: Boolean): String;
    Function GetMediaFile(aMediaFileName:STring):TStream;
  end;

implementation

uses
  main                // RelaX Main unit
 ,downloadframe       // RelaX download information frame
 ,dialogs             // Delphi vcl
 ,uSRTMaker           // RelaX Srt File Maker (converter for sub files etc)
 ,IdIcmpClient        // Part of Indy Delphi Components Suite
 ,uRealDirectoryInfo  // Real directory lister
 ,uIDirectoryInfo     // Interface to directory lister
 ,uISODirectoryInfo   // iso lister by Espen Schaathun aka PulP
 ,uZipDirectoryInfo   // Zip lister
 ,uShoutcastDirectoryInfo // Shoutcast live directory info
 ,UnXISODirectoryInfo // iso lister by Espen Schaathun aka PulP
 ,uDefLog             // developers log!
 ,uDisplayObject      // Relax display object for information
 ,jpeg
 ;
{$R *.dfm}

procedure TdmListener.LogFile(filename: String; S: STring);
var
  sl:TStringlist;
begin
  sl := TStringlist.Create;
  sl.Text := s;
  sl.SaveToFile(filename);
  freeAndNil(sl);
end;

function getJpegFileStream(aJpegFile:TStream;MaxWidth:Integer):TStream;
var
  mypic,src : TJpegImage;
  bmsrc:TBitmap;
  w,h:Integer;
  Ratio:Real;
begin
  src := TJpegImage.Create;
  MyPic := TJpegImage.create;
  aJpegFile.Position := 0;
  src.LoadFromStream(aJpegFile);
//  if src.Width<=maxwidth then
//    begin // picture is smaller.. so passtrough!!
//      aJpegFile.Position := 0;
//      Result := aJpegFile;
//      FreeAndNil(src);
//      Exit;
//    end;
  FreeAndNil(aJpegFile);

  bmsrc := TBitmap.Create;
  bmSrc.PixelFormat := pf24bit;
  bmSrc.Assign(src);
  bmSrc.PixelFormat := pf24bit;

  SetStretchBltMode(bmsrc.Canvas.Handle, HALFTONE);
  Ratio := src.height / src.width;
  w:=MaxWidth;
  h := Round(w * Ratio);
  h := Round(h / 1.2);
  if bmsrc.width < w then
    bmsrc.Width := w;
  if bmsrc.Height < h then
    bmsrc.Height := h;
  StretchBlt(bmsrc.canvas.Handle, 0, 0, w, h, bmsrc.Canvas.Handle, 0, 0,
    src.Width, src.Height, SRCCOPy);
  bmsrc.Width := w;
  bmsrc.Height := h;

  mypic.Assign(bmsrc);

  mypic.CompressionQuality := 100;
  mypic.Modified := True;
  mypic.Compress;
  Result := TMemoryStream.Create;
  mypic.SaveToStream(Result);
  Result.Position := 0;

  FreeAndNil(mypic);
  FreeAndNil(src);
  FreeAndNil(bmsrc);
end;

function TdmListener.GetMediaFile(aMediaFileName: STring): TStream;
var
  MyDirectoryInfoIntf : IDirectoryInfo;
  MediaPath:String;
  Filename:String;
  MediaType:String;
  x:Integer;
begin
  Result := Nil;
  if aMediaFileName = '' then exit;
  MediaPath := '';
  FileName := aMediaFileName;
  MediaType:= '';
  x := Pos(FileTypeTag,FileName);
  if x>0 then
    begin
      Mediapath := Copy(FileName,1,x-1);
      Delete(Filename,1,(x+Length(FileTypeTag))-1);
      x:=Pos(FileTypeEndTag,FileName);
      MediaType := Copy(FileName,1,x-1);
      Delete(Filename,1,(Length(FileTypeEndTag)+x)-1);
    end;
  if MediaType = '' then
    MyDirectoryInfoIntf := TRealDirectoryInfo.Create;

  if MediaType = ISOMEDIA then
    MyDirectoryInfoIntf := TISODirectoryInfo.Create;

  if MediaType = ZIPMEDIA then
    MyDirectoryInfoIntf := TZIPDirectoryInfo.Create;

  if MediaType = XISOMEDIA then
    MyDirectoryInfoIntf := TXISODirectoryInfo.Create;

  if MediaType = SHOUTCASTMEDIA then
    MyDirectoryInfoIntf := TShoutcastDirectoryInfo.Create;

  Try
    Result := MyDirectoryInfoIntf.GetFileStream(MediaPath,FileName);
  Except
    on e:exception do
      begin
        Log(5,e.message,nil);
        Result := Nil;
      end;
  End;
  if assigned(Result) and (Uppercase(ExtractFileExt(FileName))='.JPG') then
    begin
//      Result := getJpegFileStream(Result,1600);
    end;
  MyDirectoryInfoIntf := Nil;
end;

// synchronized logger!
procedure TdmListener.Log(debuglevel: Integer; S: STring; AThread: TIdPeerThread;aIP:String = '000.000.000.000');
var
  Logger:TLogUpdate;
  f:textFile;
  LineToLog:String;
begin
  // no main form.. then nothing to log!
  if not assigned(frmMain) then
    exit;
  LineToLog := max(aIP,16)+'  '+DateTimeToStr(now)+'   '+inttostr(debuglevel)+' '+s;
  Try
    if main.frmMain.edtLogfile.Text<>'' then
      assignFile(f,main.frmMain.edtLogfile.Text);
    if fileexists(main.frmMain.edtLogfile.Text) then
      System.append(f)
    else
      System.rewrite(f);
    Writeln(f,LineToLog);
    closefile(f);
  Except
    On exception do ;
  End;

  // Only log when allowed within debug level
  if StrToInt(frmMain.DebugLevel.text)>Debuglevel then
    exit;
  Try
    Logger := TLogUpdate.Create;
    Logger.Line := LineToLog;
    Logger.Memo := frmMain.Memo1;
    if assigned(aThread) then
      aThread.Synchronize(Logger.DoAddLog)
    Else
      Logger.DoAddLog;
    FreeAndNil(Logger);
  except
    on e:exception do showmessage(e.message);
  End;
end;


{function TdmListener.DoConfig(aUserIP, aConfigOption: String):TempConfigObject;
var
  mytempconfigobject:TempConfigObject;
  x:Longint;
begin

  if not assigned(ipConfigList) then
    ipConfigList := TStringlist.Create;
  x := ipConfigList.indexof(aUserIP);
  if ipConfigList.indexof(aUserIP)>-1 then
    mytempconfigobject := TempConfigObject(ipConfiglist.objects[x])
  else
    begin
      mytempconfigobject := tempconfigobject.create;
      ipconfiglist.AddObject(aUserIP,mytempconfigobject)
    end;

  case StrToInt(aConfigOption) of
    0  : ; // just get the config object!
    1  : mytempconfigobject.subson := True;// subs on
    2  : mytempconfigobject.subson := False;// subs off
    3  : mytempconfigobject.FrameRate := 0;// sub convert auto
    4  : mytempconfigobject.FrameRate := 23.976;// sub convert 23.976
    5  : mytempconfigobject.FrameRate := 23.980;// sub convert 23.980
    6  : mytempconfigobject.FrameRate := 24.000;// sub convert 24.000
    7  : mytempconfigobject.FrameRate := 25.000;// sub convert 25.000
    8  : mytempconfigobject.FrameRate := 29.970;// sub convert 29.970
    9  : mytempconfigobject.FrameRate := 30.000;// sub convert 30.000
    10 : mytempconfigobject.Shutdown := true;// Shutdown on
    11 : mytempconfigobject.Shutdown := false;// Shutdown off
  end;
  result := mytempconfigobject;
end;}

Function TdmListener.GetMediaFilesFromPath(aXMLNode:TJanXMLNode2;Path:String; RCAT : Boolean):String;
var
  Diri:TSearchRec;
  res:Integer;
  Ext:String;
  RecursiveXML   : TJanXMLNode2;
  FlattenXML     : TJanXMLNode2;
  ExtentionsXML  : TJanXMLNode2;
  LoopXML        : TJanXMLNode2;
  Flatten:Boolean;
  doDirectories:Boolean;
  Exts:String;
  Tmp:STring;
  x:Integer;
  ExtsList:TStringlist;
  attrib : Integer;
  DispName : STring;
  MyDirectoryInfoIntf: IDirectoryInfo;
  MediaPath:String;
  Filename:String;
  MediaType:String;
begin
  MediaPath := '';
  FileName := Path;
  MediaType:= '';
  x := Pos(FileTypeTag,FileName);
  if x>0 then
    begin
      Mediapath := Copy(FileName,1,x-1);
      Delete(Filename,1,(x+Length(FileTypeTag))-1);
      x:=Pos(FileTypeEndTag,FileName);
      MediaType := Copy(FileName,1,x-1);
      Delete(Filename,1,(Length(FileTypeEndTag)+x)-1);
    end;

  if MediaType = '' then
    MyDirectoryInfoIntf := TRealDirectoryInfo.Create();

  if MediaType = ISOMEDIA then
    MyDirectoryInfoIntf := TISODirectoryInfo.Create;


  if MediaType = SHOUTCASTMEDIA then
    MyDirectoryInfoIntf := TShoutCastDirectoryInfo.Create;

  if MediaType = XISOMEDIA then
    MyDirectoryInfoIntf := TXISODirectoryInfo.Create;

  if MediaType = ZIPMEDIA then
    MyDirectoryInfoIntf := TZIPDirectoryInfo.Create;

  MyDirectoryInfoIntf.Init(MediaPath,FileName);
  if filename ='' then
    filename := '\';

  FlattenXML     := GetNodeByName('FLATTEN'    ,aXMLNode.nodes);
  if assigned(FlattenXML) then Flatten := FlattenXML.text = 'Y'
                          else Flatten := False;

  RecursiveXML   := GetNodeByName('RECURSIVE'  ,aXMLNode.nodes);
  if assigned(RecursiveXML) then doDirectories := RecursiveXML.text = 'Y'
                            else doDirectories := True;

  exts := '';
  LoopXML := aXMLNode;
  ExtentionsXML  := GetNodeByName('EXTENTIONS' ,LoopXML.nodes);
  if assigned(extentionsXML) then
    exts := extentionsXML.text;
  while (exts = '') and assigned(LoopXML.parentNode) do
    begin
      LoopXML := LoopXML.parentNode;
      ExtentionsXML  := GetNodeByName('EXTENTIONS' ,LoopXML.nodes);
      if assigned(extentionsXML) then
        exts := extentionsXML.text;
    end;
  if exts = '' then
    exts := frmMain.Extentions.text;
  if exts = '' then
    exts := '*';
  Exts := Exts + ';';

  ExtsList := TStringList.Create;
  tmp:='';
  While length(exts)>0 do
    Begin
      case exts[1] of
        ';' : begin
                if tmp<>'' then
                  extsList.Add(uppercase(tmp));
                tmp:='';
              end;
         else begin
                tmp := tmp + exts[1];
              end;
      end;
      delete(exts,1,1);
    end;
  ExtsList.Sort;
  ExtsList.Sorted:=True;

  Result := '';
  if (length(path)>0) and (path[length(path)]<>'\') then
    path:=path+'\';
//  Log(0,'Path : '+path,nil);
  Res := MyDirectoryInfoIntf.Findfirst('*.*',faanyfile,diri);
  While Res=0 do
    Begin
      if diri.Attr and faDirectory = faDirectory then
        Begin
          if (diri.Name <>'.') and (diri.name<>'..') then
            begin
              if Flatten then
                Result := Result + GetMediaFilesFromPath(aXMLNode,Path+diri.Name,RCAT)
              else
                if doDirectories then
                  begin
                    attrib := 16;
                    if MyDirectoryInfoIntf.FileExists(path+ReplaceExtention(diri.name,'TBN')) then
                      attrib := attrib or 4;
                    Result := Result + '<ITEM><ATTRIB>'+Inttostr(attrib)+'</ATTRIB><PATH>'+path+diri.name+'</PATH></ITEM>'+#13#10;
                    if RCAT then
                      Result := Result + GetMediaFilesFromPath(aXMLNode,Path+diri.Name,RCAT)
                  end;
            end;
        End
      Else
        Begin
          Ext := Uppercase(ExtractFileExt(Diri.name));
          if (length(ext)>0) and (Ext[1]='.') then
            Begin
              delete(ext,1,1);
            End;
          if ExtsList.find(ext,x) or ( (ExtsList.count>0) and (ExtsList.Strings[0]='*' ))
          then
            Begin
              attrib := 128;
              DispName := path+diri.name;
              if ext='PLS' then
                begin
                  DispName := Path+Diri.Name+VirtualDisplayTag+Diri.Name+'.mp3';
                end;
              if ((ext='BIN') or (ext='ISO') or (ext='IMG')) and (mediatype = '') and (main._isodisabled=false) then
                begin
                  attrib := 16;
                  DispName := Path+Diri.Name+FileTypeTag+ISOMEDIA+FileTypeEndTag+VirtualDisplayTag+Diri.Name;
                end;
              if (ext='ZIP') and (mediatype = '') then
                begin
                  attrib := 16;
                  DispName := Path+Diri.Name+FileTypeTag+ZIPMEDIA+FileTypeEndTag+VirtualDisplayTag+Diri.Name;
                end;
              if (ext='XISO')and (mediatype = '') then
                begin
                  attrib := 16;
                  DispName := Path+Diri.Name+FileTypeTag+XISOMEDIA+FileTypeEndTag+VirtualDisplayTag+Diri.Name;
                end;
              if (ext='SC-LIVE')and (mediatype = '') then
                begin
                  attrib := 16;
                  DispName := Path+Diri.Name+FileTypeTag+SHOUTCASTMEDIA+FileTypeEndTag+VirtualDisplayTag+Diri.Name;
                end;
//              if attrib = 128 then
//                Dispname := Dispname+VirtualDisplayTag+Lowercase(diri.name);
              if MyDirectoryInfoIntf.FileExists(path+ReplaceExtention(diri.name,'TBN')) then
                attrib := attrib or 4;

              if (frmMain.TBNDirectory.text<>'') and (FileExists(frmMain.TBNDirectory.text+ReplaceExtention(diri.name,'TBN'))) then
                  attrib := attrib or 4;

//              if MyDirectoryInfoIntf.FileExists(path+ReplaceExtention(diri.name,'SRT')) then
//                attrib := attrib or 8;

//              if SRTFileExists(path+ReplaceExtention(diri.name,'SRT'),frmMain.SubsDirectory.text) then
//                attrib := attrib or 8;

              Result := Result + '<ITEM><ATTRIB>'+Inttostr(attrib)+'</ATTRIB><PATH>'+DispName+'</PATH></ITEM>'+#13#10;
            End;
        End;
      Res := MyDirectoryInfoIntf.Findnext(diri);
    End;
  MyDirectoryInfoIntf.FindClose(diri);
  FreeAndNil(ExtsList);

  MyDirectoryInfoIntf := Nil; // refference counting should do its work here..:)
End;

function TdmListener.GetItemListFromXMLNode(XMLNode:TjanXMLNode2;UserIP:String;RCAT:Boolean):String;
var
  x: Longint;

  attribute : TJanXMLNode2;
  Path,item : TJanXMLNode2;

  IpList    : TJanXMLNode2;
  Hidden    : TJanXMLNode2;
  DisplayName : TJanXMLNode2;
  Intergrated : TJanXMLNode2;

  Skip : Boolean;

  isIntergrated : Boolean;
  attrib : Integer;

  DispName : String;
Begin
  Result := '';

  For x:=0 to XMLNode.nodes.Count-1 do
    Begin
      item :=TjanXMLNode2(XMLNode.nodes.Items[x]);
      if uppercase(item.name)='ITEM' then
        Begin


          Attribute   := GetNodeByName('ATTRIBUTE'  ,item.nodes);
          Path        := GetNodeByName('PATH'       ,item.nodes);

          IpList      := GetNodeByName('ALLOWEDIP'  ,item.nodes); // done;
          Hidden      := GetNodeByName('HIDDEN'     ,item.nodes); // done;

          DisplayName := GetNodeByName('DISPLAYNAME',item.nodes);
          Intergrated := GetNodeByName('INTERGRATE' ,item.nodes);

          Skip := False;

          if assigned(Hidden) and (Hidden.text='Y') then Skip := True;

          if assigned(IpList) and (skip=false)then // skip current tag if not allowed!
              Skip := not isIpAllowed(UserIP,IpList.text);

          if assigned(Intergrated) then isIntergrated := Intergrated.text='Y'
                                   else isIntergrated := False;

          DispName := Path.text;
          if assigned(DisplayName) and (displayname.text<>'') then
            DispName := DispName+VirtualDisplayTag+DisplayName.text;
          if not skip then
            case StrToInt(attribute.text) of
              128 : Begin // file
                      attrib := 128;
                      if FileExists(ReplaceExtention(path.text,'TBN')) then
                        attrib := attrib or 4;
//                      if SRTFileExists(ReplaceExtention(path.text,'SRT'),frmMain.SubsDirectory.text) then
//                        attrib := attrib or 8;
                      Result := Result + '<ITEM><ATTRIB>'+Inttostr(Attrib)+'</ATTRIB><PATH>'+DispName+'</PATH></ITEM>'+#13#10;
                    end;
              16 : Begin // directory
                      if isIntergrated then // Flatten
                        Result := Result + GetMediaFilesFromPath(item,path.text,RCAT)
                      Else                   // Show As Directory for B6
                        begin
                          Result := Result + '<ITEM><ATTRIB>16</ATTRIB><PATH>'+DispName+'</PATH></ITEM>'+#13#10;
                          if RCAT then
                            Result := Result + GetMediaFilesFromPath(item,path.text,RCAT)
                        end;
                   End;
              0 : Begin // virtual path
                    DispName := DispName+VirtualDisplayTag+DispName;
                    if rcat then
                      Result := Result + GetItemListFromXMLNode(item,UserIP,RCAT)
                    else
                      Result := Result + '<ITEM><ATTRIB>16</ATTRIB><PATH>'+DispName+'</PATH></ITEM>'+#13#10;
                  End;
            end;
        End;
    End;
End;

Function HostStillThere(aIP:String):Boolean;
var
  tmpIcmp:TIdIcmpClient;
Begin
  Result := True;
  tmpIcmp:=TIdIcmpClient.Create(Nil);
  tmpIcmp.ReceiveTimeout := 300;
  Try
    tmpIcmp.Host := aIP;
    tmpIcmp.Ping();
    if tmpIcmp.ReplyStatus.ReplyStatusType = rsTimeOut then
      Result := False;
  Except
    on Exception do
      Result := False;
  End;
  FreeAndNil(tmpIcmp);
End;

Function GetDivRatio(x:Int64):Integer;
Begin
  Result := 1;
  While x / Result > 2147483640 do
    Begin
      Result := Result + 1;
    End;
End;

// this function is called by indy tcpserver
// this is the handler from the xbox mediaplayer requests
procedure TdmListener.IdTCPServer1Connect(AThread: TIdPeerThread);
var
  Greeting : String;
  command : String;
  param : String;
  x:Longint;
  done : Boolean;
  MediaStream : TStream;
  Response : String;
  ResponseData : String;
  buf:array[1..800000] of byte;
  bufzise : Longint;
  DisplayObject : TDisplayObject;

  Timedout : Boolean;
  UserIP : String;
  tmpsl : TStringlist;

  tmpxml : TJanXMLNode2;
  attributeXML : TJanXMLNode2;
  pathXML : TJanXMLNode2;
  itemXML : TJanXMLNode2;

  sl:TStringlist;
  Divratio:Longint;
  Foundone : Boolean;

  SubtitleStream:Boolean;
  RCAT : Boolean;
begin
  // need nodelay for FAST streaming! Thanks runtime!
  // offcause also tanks to runtime for supplying the .NET source of the
  // xstream server.. this made it alot easyer to know what requests are
  // to be expected!

  aThread.Synchronize(frmMain.addConnection);
//  aThread.Priority := tpHighest;
  DisplayObject := Nil;
  timedout := False;
  done := false;
  DivRatio := 1;
  Try
    (aThread.Connection.IOHandler as TIdIOHandlerSocket).Binding.SetSockOpt(Id_IPPROTO_TCP, Id_TCP_NODELAY, PChar(@Id_SO_True), SizeOf(Id_SO_True));
    UserIP := (AThread.Connection.IOHandler as TIdIOHandlerSocket).Binding.PeerIP;
    Log(0,'---------------------------------------------------------------------------',aThread,UserIP);
    log(2,'Incomming connection from '+UserIP,aThread,UserIP);
    if isIpAllowed(UserIP,frmMain.SecurityIpList.text) then
      begin
        Log(1,'Security passed...',aThread,UserIP);
        Log(1,'Waiting for greeting',aThread,UserIP);
        Greeting := aThread.Connection.ReadLn(#10,4000,2000);
        Log(1,'received greeting :'+greeting,aThread,UserIP);
        Log(1,'Sending greeting : HELLO XBOX!',aThread,UserIP);
        aThread.connection.Write('HELLO XBOX!');
        AThread.Connection.ReadTimeout:=5000; // 5 second timeout!
        Log(1,'Waiting in endles loop for commands',aThread,UserIP);
      end
    else
      begin
        aThread.connection.Write('U have no rights to speak here.. connection terminated.. RelaX V'+Version);
        Log(1,'Security failure .. ip is not in the allowed iplist! connection terminated..',aThread,UserIP);
        Done:=True;
      end;


  except
    on exception do
      done := True;
  End;
  if done then aThread.Connection.Disconnect;
  While not done do
    Try
      done := False;
      Response := '-1 UNKNOWN ERROR';
      ResponseData := '';
      bufzise := 0;
      Try
        command := aThread.Connection.ReadString(4);
      except
        on exception do
          command := '';
      End;
      if aThread.Connection.Connected=false then
        done := True;
      if command='' then
        Begin
          if not timedout then
            log(4,'command timeout',aThread,UserIP);
          // ping the xbox .. ! on pingtimeout disconnect
          if Assigned(mediaStream) and (not HostStillThere(UserIP)) then
            begin
              FreeAndNil(MediaStream); // free and end!
              log(4,'command timeout and host is not there (no response to ping).. stopping the connection',aThread,UserIP);
            end;

          done := not assigned(MediaStream);
          timedout := true;
        end
      else
        Begin
          if timedout then
            Log(4,'End of timeout',aThread,UserIP);
          timedout := false;
          param := aThread.Connection.ReadString(aThread.Connection.Inputbuffer.Size);
          param := Trim(param);

          if command<>'READ' then
            Log(1,'Command gotten : '+command,aThread,UserIP);

          if (command = '*CAT') or (command='RCAT') then
            Begin
              RCAT := command='RCAT';

              x:=IpCurrentPath.IndexOf(UserIP);
              Log(1,'param : '+param,aThread,UserIP);

              if x=-1 then
                Begin // ip is not yet in List! adding root!
                  tmpsl := TStringlist.Create;
                  tmpsl.AddObject('',shares);
                  IpCurrentPath.AddObject(UserIP,tmpsl);
                End
              Else// ip is already downloading listing;
                tmpsl := TStringlist(IpCurrentPath.Objects[x]);
              // tmpsl should be filled with the backlog of the current user (ip)
              if (param='') or (Pos(RootIdent,param)>0) then
                begin // resetting the directory to root when no param is given (only at startup! and B5)
                  while tmpsl.count>1 do tmpsl.delete(tmpsl.count-1);
                  if (Pos(RootIdent,param)>0) then
                    Delete(param,pos(RootIdent,param),6);
                end;

              if Length(param)>0 then
                Begin

                  if GetParam(1,param)='BACK' then
                    Begin // going back a directory
                      if tmpsl.Count >1 then // only back when we are not in the root!
                        tmpsl.Delete(tmpsl.count-1); // we just want to go back one :)
                    End
                  Else
                    Begin// going forward a directory
                      tmpXML := TJanXMLNode2(tmpsl.Objects[tmpsl.count-1]);
                      if assigned(tmpXML) then
                        Begin
                          foundone := False;
                          for x:=0 to tmpXML.nodes.Count-1 do
                            Begin // Going trough the nodelist seeking the parent
                              itemXML := TJanXMLNode2(tmpXML.nodes.Items[x]);
                              if itemXML.name = 'ITEM' then
                                Begin
                                  pathXML := GetNodeByName('PATH',itemXML.nodes);
                                  if assigned(pathXML) and (pathXML.text=GetParam(1,param)) then
                                    Begin
                                      tmpSL.AddObject(pathXML.text,itemXML);
                                      foundone := True;
                                    End;
                                End; // if itemXML.name = 'ITEM'
                            End; // for x:=0 to tmpXML.nodes.count-1
                          if not foundone then
                            tmpsl.Add(GetParam(1,param));
                        End // if assigned(tmpxml)
                      Else // no xml object so must be in directory
                        tmpsl.Add(GetParam(1,param));
                    End;
                End;

              ResponseData := '<catalogue>'+#13#10;
              Try
                attributeXML := Nil;
                if tmpsl.Objects[tmpsl.Count-1]<>nil then
                  attributeXML        := GetNodeByName('ATTRIBUTE'       ,TJanXMLNode2(tmpsl.Objects[tmpsl.Count-1]).Nodes);
                if   (    (Assigned(attributeXML))
                      and (attributeXML.text = '0') // virtual directory
                      )
                    or (tmpsl.Objects[tmpsl.Count-1] = shares)
                  then // show filelist from a virtual directory!
                    ResponseData := ResponseData+GetItemListFromXMLNode(TJanXMLNode2(tmpsl.objects[tmpsl.count-1]),UserIP,RCAT)
                  else
                    begin
                      // showfileslist from real directory
                      itemXML := Nil;
                      // Searching for the last configured object!
                      // this to get the configuration of the last itemXML
                      for x:=0 to tmpsl.Count-1 do
                        if tmpsl.Objects[x]<>nil then
                          itemXML := TJanXMLNode2(tmpsl.Objects[x]);
                      // no root no glory:)
                      if itemxml<>nil then
                        begin
                          ResponseData := ResponseData+GetMediaFilesFromPath(ItemXML,tmpsl.Strings[tmpsl.count-1],RCAT) // flatten
                        end;
                    end;
              except
                on e:exception do
                  Log(5,e.message,aThread,UserIP);
              end;

              ResponseData := ResponseData + '</catalogue>'+#13#10;
//              logfile(extractfilepath(paramstr(0))+'\XMLRESPONSE.TXT',Responsedata);
              Response := inttostr(length(ResponseData))+' OK';
              Done := True;
            End;
          if command = 'OPEN' then
            Begin
              log(1,'Opening file :'+GetParam(1,param),athread,userip);
              SubTitleStream := False;
              if     (Pos('.SRT',Uppercase(param))>0)
                  or (Pos('.TXT',Uppercase(param))>0)
                  or (Pos('.SUB',Uppercase(param))>0)
                then
                begin
                  SubtitleStream := True;
                  if (pos(VirtualDisplayTag,param)>0) then
                    begin
                      log(1,'Subtitle support currently in the way of iso stream support!',aThread,userip);
                      subtitlestream := False;
                      param:='';
                    end;
                end;
              if param <> '' then
                MediaStream := GetMediaFile(GetParam(1,param));
              if (MediaStream = nil) and (POS('.TBN',uppercase(param))>0) and (frmMain.SubsDirectory.text<>'')then
                begin
                  Log(1,' Trying global tbn directory for tbn file! '+frmMain.TBNDirectory.text+ExtractFileName(GetParam(1,param)),aThread,UserIP);
                  MediaStream := GetMediaFile(frmMain.TBNDirectory.text+ExtractFileName(GetParam(1,param)));
                end;
              if assigned(MEdiaStream) then
                Log(1,' File Found ',aThread,UserIP);
              if (SubTitleStream) and (MediaStream = nil) then
                Begin
                  Log(1,'Trying to save the day by searching for other subtitle files',aThread,UserIP);
                  sl:=TStringlist.Create;
                  sl.Text := uSRTMaker.GetSRTList(GetParam(1,param),frmMain.SubsDirectory.text);
                  if sl.Text<>'' then
                    Begin
                      Log(1,' Found subtitle file in subtitle directory!',aThread,UserIP);
                      MediaStream := TMemoryStream.Create;
                      sl.SaveToStream(MediaStream);
                    End
                  Else
                    Log(1,' No Subtitles found!',aThread,UserIP);
                  FreeAndNil(sl);
                End;
              if assigned(MediaStream) then
                Begin
                  DisplayObject := TDisplayObject.Create;
                  if assigned(frmMain) then
                    DisplayObject.Parent := frmMain.Scrollbox1;
                  DisplayObject.Filename := extractfilename(GetParam(1,param));
                  DisplayObject.Progress := 0;
                  DivRatio := GetDivRatio(MediaStream.Size);
                  Log(0,'DivRatio = '+inttostr(divRatio),aThread,userIP);
                  DisplayObject.MaxValue := MediaStream.Size div divratio;
                  DisplayObject.MinValue := 0;
                  DisplayObject.RemoteIP := UserIP;
                  AThread.Synchronize(DisplayObject.Start);

                  MediaStream.Position := 0;
                  Response := Inttostr(MediaStream.Size)+' OK';
                  Done := False;
                End
              else
                Begin
                  Response := '-1 UNABLE TO OPEN';
                  Log(1,' File not found',aThread,UserIP);
                  Done:=True;
                End;
            End;

          if command = 'INFO' then
            Begin
              Log(1,'Depricated info handling :'+GetParam(1,param),aThread,UserIP);
              Responsedata := '';
              Response := '-1 ERROR';
              Done := True;
            end;

          if command = 'READ' then
            Begin
              Done := False;
              if assigned(MediaStream) then
                Begin
                  MediaStream.Position := StrToInt64(GetParam(1,param)); // integer64
                  bufzise := MediaStream.Read(buf,StrToInt(GetParam(2,param)));
                  if assigned(displayobject) then
                    Begin
                      DisplayObject.Progress := MediaStream.position div divratio;
                      AThread.Synchronize(DisplayObject.Update);
                    End;
                  Response := inttostr(bufzise)+' OK';
                  ResponseDAta := '';
                End
              Else
                Begin
                  Response := '-1 READ FAILED';
                  Done := True;
                End;
            end;
          if command = 'TELL' then
            Begin
              if assigned(MediaStream) then
                Response := Inttostr(MediaStream.Position)+' OK'
              Else
                Response := '-1 TELL FAILED';
            end;

          if command = 'CLSE' then
            Begin
              FreeAndNil(MediaStream);
              Response := '0 OK';
              Done := True;
            end;

          if command = 'DBUG' then
            Begin
              Response := '0 OK';

            end;
          Response := MAX(Response,32);
          aThread.Connection.WriteBuffer(Response[1],Length(Response),true);
          if ResponseData <> '' then
            aThread.Connection.WriteBuffer(Responsedata[1],Length(Responsedata),true);
          if bufzise <> 0 then
            aThread.Connection.WriteBuffer(buf,bufzise,true);
          if assigned(DisplayObject) and DisplayObject.ForceStop then
            Done:=True;

          if done then
            aThread.Connection.Disconnect
          else
            application.ProcessMessages;

        End;
    except
      on e:exception do
        Begin
          FreeAndNil(MediaStream);
          log(5,e.Message,aThread,UserIP);
          Done := True;
          aThread.Connection.Disconnect;
        End;
    End;
  Log(0,'End of it all',aThread,UserIP);
  if assigned(DisplayObject) then
    Try
      AThread.Synchronize( DisplayObject.Stop );
      DisplayObject.Free;
    except
      on e:Exception do
        log(5,e.Message,aThread,UserIP);
    End;
  aThread.Synchronize(frmMain.DeleteConnection);
end;

procedure TdmListener.IdTCPServer1Disconnect(AThread: TIdPeerThread);
begin
  Log(0,'Disconnected',athread,'connection lost');
end;

procedure TdmListener.DataModuleCreate(Sender: TObject);
begin
  IpCurrentPath := TStringList.Create;
  IdTCPServer1.DefaultPort := StrToInt(frmMain.ListenPort.text);
  IdTCPServer1.Active := True;
  log(0,'Listener started',nil);
end;

procedure TdmListener.DataModuleDestroy(Sender: TObject);
begin
  FreeAndNil(IpCurrentPath);
  IdTCPServer1.Active := False;
  log(0,'Listener stopped',nil);
end;

end.

