{ ---------------------------------------------------------------------------- }
{ Wrapperclass for VCLUnzip                                                    }
{                                                                              }
{                                                                              }
{                                                                              }
{                                                                              }
{ ---------------------------------------------------------------------------- }
unit uZipper;

interface
uses
  classes,uIZipper,VCLUnzip;

Type
  TZipper = Class(TInterfacedObject,IZipper)
  Private
    fVCLUnzip : TVCLUnZip;
  Protected
    Procedure SetZipName(aZipName:Pchar);
    Procedure ReadZip;
    Procedure UnZipToStream(aStream:TStream;aFilename:Pchar);
    Procedure UnZipToFile(aStorePath:Pchar;aFilename:PChar);
    Function GetCount:Integer;
    Function GetFullName(idx:Integer):Pchar;
    Function GetExternalFileAttributes(idx:Integer):Integer;
    Function GetFilename(idx:Integer):Pchar;
  Public
    Constructor Create; 
    Destructor Destroy; Override;
  end;
implementation

{ TZipper }

constructor TZipper.Create;
begin
  fVCLUnzip := TVCLUnZip.Create(Nil);
end;

destructor TZipper.Destroy;
begin
  fVCLUnzip.Free;
  fVCLUnzip := Nil;
  inherited;
end;

function TZipper.GetCount: Integer;
begin
  Result := FVCLUnzip.Count;
end;

function TZipper.GetExternalFileAttributes(idx: Integer): Integer;
begin
  Result := fVCLUnzip.ExternalFileAttributes[idx];
end;

function TZipper.GetFilename(idx: Integer): Pchar;
begin
  Result := Pchar(fVCLUnzip.FileName[idx]);
end;

function TZipper.GetFullName(idx: Integer): Pchar;
begin
  Result := Pchar(fVCLUnzip.Fullname[idx]);
end;

procedure TZipper.ReadZip;
begin
  fVCLUnzip.ReadZip;
end;

procedure TZipper.SetZipName(aZipName: Pchar);
begin
  fVCLUnzip.ZipName := aZipName;
end;

procedure TZipper.UnZipToFile(aStorePath, aFilename: PChar);
var
  aStream:TFileStream;
begin
  aStream := TFileStream.Create(aStorePath,fmCreate);
  fVCLUnzip.UnZipToStream(aStream,aFilename);
  aStream.Free;
end;

procedure TZipper.UnZipToStream(aStream: TStream; aFilename: Pchar);
begin
  fVCLUnzip.UnZipToStream(aStream,aFilename);
end;

end.
