unit uShoutcastDirectoryInfo;

interface
uses
  uIDirectoryInfo,Classes,Sysutils,uiZipper,janXMLparser2,uIdProxyLayer,ZLib,uGeneral,main,
  uShoutcastStream,dialogs,inifiles;

Type
  TCachedXML = Class(TObject)
    XmlFile       : TJanXMLParser2;
    playlistxml   : TJanXMLNode2;
    LastTimeRefresh : TDateTime;
  end;

  TShoutcastDirectoryInfo = Class(TInterfacedObject , IDirectoryInfo)
  Protected
    genre : String;
    bitrate : String;
    cachesize : String;
    refreshinterfall : String;
    CachedXML : TCachedXML;

    Function Init(aRootPath:String; aPath: String):Longint;
    Function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec):Longint;
    Function FindNext(var aSearchRec: TSearchRec):Longint;
    Procedure FindClose(var aSearchRec: TSearchRec);
    Function FileExists(aFileName: String):Boolean;
    Function GetFileStream(aRootPath:String; aFilename:String):TStream;
  Public
    Destructor Destroy; Override;
  End;

implementation

uses Math, DateUtils;

var
  CacheObject   : TStringlist;


// this is done in an attempt to mask the url from where i get the shoutcast live xml feed..
// on request of tom pepper
function GetStreamingXMLurlEx:PChar; safecall;external 'SHOUTcastLive.dll';


Procedure CheckXML(CachedXML:TCachedXML;Refreshinterfall:Integer;Limit:String;Bitrate:String;Genre:String);
var
  idhttp : TRelaXHttp;
  ms     : TStream;
  ds     : TStream;
  s      : String;
  buf    : array[1..30000] of byte;
  lp     : Longint;
  r      : Longint;
  tmpXML : TJanXMLNode2;
  curGenre:String;
  curBitrate:STring;
  keepit : Boolean;
  url : PChar;
Begin
  If SecondsBetween(now,CachedXML.LastTimeRefresh)>(Refreshinterfall*100) then
    begin
      idHttp := TRelaXHTTP.Create(Nil);
      ms := TMemoryStream.Create;
      url := GetStreamingXMLurlEx;
      s:=url;
      s := s+main.ShortVersion+'&no_compress=0&limit='+limit;
      idHttp.Get(s,ms);
      ms.Position := 0;
      Try
        ds:=TdecompressionStream.Create(ms);
        s:='';
        Repeat
          r := ds.Read(buf[1],length(buf));
          if r<>0 then
            begin
              lp := Length(s);
              SetLength(s,lp+r);
              Move(buf[1],s[lp+1],r);
            end;
        until r<>Length(buf);
      Finally
        FreeAndNil(idHttp);
        FreeAndNil(ds);
        FreeAndNil(ms);
      End;
      Try
        CachedXML.XmlFile.xml := s;
      Except
        on exception do
          CachedXML.XmlFile.xml := s;
      end;
      CachedXML.playlistxml := GetNodeByName('playlist',CachedXML.xmlFile.nodes);
      CachedXML.LastTimeRefresh := Now;
      For r := CachedXML.playlistxml.nodes.Count-1 downto 0 do
        begin
          tmpXML := TJanXMLNode2(CachedXML.playlistxml.nodes.Items[r]);
          curGenre := GetNodeByName('Genre',tmpXML.nodes).text;
          curBitrate := GetNodeByName('Bitrate',TmpXML.nodes).text;
          keepit := True;

          if (pos(Uppercase(genre),uppercase(curGenre))=0) and (uppercase(genre)<>'ALL') then
            keepit := False;
          if (bitrate <> curbitrate) and (uppercase(bitrate)<>'ALL') then
            keepit := False;
          if not keepit then
            CachedXML.playlistxml.nodes.Delete(r);

{  <entry Playstring="http://www.shoutcast.com/sbin/tunein-station.pls?id=8809&amp;filename=playlist.pls">
	<Name>WOLF FM - The hottest mix of the 70s, 80s and today!</Name>
	<Genre>pop rock 80s</Genre>
	<Nowplaying/>
	<Listeners>1890</Listeners>
	<Bitrate>128</Bitrate>
  </entry>}

        end;
    end;
End;

{ TShoutcastDirectoryInfo }

destructor TShoutcastDirectoryInfo.Destroy;
begin
  inherited;
end;

function TShoutcastDirectoryInfo.FileExists(aFileName: String): Boolean;
begin
  Result := False;
end;

procedure TShoutcastDirectoryInfo.FindClose(var aSearchRec: TSearchRec);
begin
//
end;

function TShoutcastDirectoryInfo.FindFirst(aWildCard: String;
  FileMode: Integer; var aSearchRec: TSearchRec): Longint;
begin
  aSearchrec.FindHandle := 0;
  Result := FindNext(aSearchRec);
end;

Function CorrectName(aName:String) : String;
var
  x: Longint;
Begin
  Result := '';
  For X:=0 to Length(aName) do
    Case aName[x] of
      'A'..'Z','a'..'z',' ','.','-','[',']','1'..'9','0':Result := Result + aName[x];
    End;
End;

function TShoutcastDirectoryInfo.FindNext(var aSearchRec: TSearchRec): Longint;
var
  p : Integer;
  Url:String;
  Name:String;
  Listeners : String;
  Bitrate : String;
  nr:String;
//  entry : TJanXMLNode2;
begin
  p := aSearchRec.FindHandle;
//  While (p<playlistxml.nodes.Count-1)
//    and (TJanXMLNode2(playlistxml.nodes.Items[p]).name<>'entry')
//    and (GenresListed.indexof(GetNodeByName('Genre',(TJanXMLNode2(playlistxml.nodes.Items[p]).nodes)).text)<>-1)
//    do
//    begin
//      inc(p);
//    end;
  if p < CachedXML.playlistxml.nodes.count-1 then
    begin
      Url := TJanXMLNode2(CachedXML.PlaylistXml.nodes.items[p]).attribute['Playstring'];
      Name := GetNodeByName('Name',(TJanXMLNode2(CachedXML.playlistxml.nodes.Items[p]).nodes)).text;
      Listeners := GetNodeByName('Listeners',(TJanXMLNode2(CachedXML.playlistxml.nodes.Items[p]).nodes)).text;
      Bitrate := GetNodeByName('Bitrate',(TJanXMLNode2(CachedXML.playlistxml.nodes.Items[p]).nodes)).text;
      While Length(Listeners)<4 do
        Listeners := '0'+Listeners;
      nr := Inttostr(p+1);
      While LEngth(nr)<4 do
        nr := '0'+nr;
      aSearchRec.Name := Url+VirtualDisplayTag+nr+' '+Listeners+' '+Bitrate+' '+CorrectName(Name)+'.mp3';
      inc(p);
      aSearchRec.FindHandle := p;
      aSearchRec.Attr := faReadOnly;
      Result := 0;
    end
  else
    begin
      Result := -1;
    end;
end;

function TShoutcastDirectoryInfo.GetFileStream(aRootPath, aFilename: String): TStream;
begin
  Result :=  TShoutCastStream.Create(aFileName);;
end;

function TShoutcastDirectoryInfo.Init(aRootPath, aPath: String): Longint;
var
  tmpInifile:Tinifile;
  idx:Integer;
begin
  tmpInifile:= TInifile.Create(aRootPath);
  genre            := tmpInifile.ReadString('config','genre','all');
  bitrate          := tmpInifile.ReadString('config','bitrate','all');
  cachesize        := tmpInifile.ReadString('config','cachesize','300');
  refreshinterfall := tmpInifile.ReadString('config','refreshinterfall','5');
  FreeAndNil(tmpInifile);
  if CacheObject.Find(uppercase(aRootPath),idx) then
    begin
      CachedXML := TCachedXML(CacheObject.Objects[idx]);
    end
  else
    begin
      cachedXML := TCachedXML.Create;
      CachedXML.XmlFile := TjanXMLParser2.create;
      CachedXML.LastTimeRefresh := 0;
      cacheObject.AddObject(Uppercase(aRootPath),cachedXML)
    end;
  CheckXML(cachedXML,StrToInt(refreshinterfall),cachesize,bitrate,genre);
  Result := -1;
end;

initialization
  CacheObject   := TStringlist.Create;
  CacheObject.Sorted := True;
finalization
  FreeAndNil(CacheObject);
end.
