unit uService;

interface

uses
   Windows      // Delphi VCL
  ,SysUtils     // Delphi VCL
  ,Classes      // Delphi VCL
  ,Forms        // Delphi VCL
  ,IdIcmpClient // Part of Indy Delphi Components Suite
  ,SvcMgr       // Delphi VCL
  ;

type
  TRelaxService = class(TService)
    procedure ServiceStart(Sender: TService; var Started: Boolean);
    procedure ServiceStop(Sender: TService; var Stopped: Boolean);
    procedure ServiceCreate(Sender: TObject);
    procedure ServiceDestroy(Sender: TObject);
    procedure ServiceAfterInstall(Sender: TService);
    procedure ServiceBeforeInstall(Sender: TService);
    procedure ServiceAfterUninstall(Sender: TService);
    procedure ServiceBeforeUninstall(Sender: TService);
  private
  public
    serviced : Boolean;
    function GetServiceController: TServiceController; override;
  end;

var
  RelaxService: TRelaxService;

implementation

uses
  main; // Part of RelaX


{$R *.DFM}

procedure ServiceController(CtrlCode: DWord); stdcall;
begin
  RelaxService.Controller(CtrlCode);
end;

function TRelaxService.GetServiceController: TServiceController;
begin
  Result := ServiceController;
end;

procedure TRelaxService.ServiceStart(Sender: TService; var Started: Boolean);
begin
  Application.CreateForm(TFrmMain, frmMain);
  frmMain.service := True;
  frmMain.BorderIcons := [];
  Started := True;
  Serviced := True;
end;

procedure TRelaxService.ServiceStop(Sender: TService; var Stopped: Boolean);
begin
  Try
    frmMain.service := False;
    FreeAndNil(frmMain);
  Except
    on exception do ;
  End;
  Stopped := True;
  Serviced := True;
end;


procedure TRelaxService.ServiceCreate(Sender: TObject);
begin
  setpriorityclass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
  Serviced := False;
end;

procedure TRelaxService.ServiceDestroy(Sender: TObject);
begin
  if Serviced=false then
    Begin // if not serviced then go in idleloop;
      Application.CreateForm(TFrmMain, frmMain);
      frmMain.service := False;
      frmMain.Show;
      while not frmMain.done do ;
    End;
  FreeAndNil(frmMain);

end;

procedure TRelaxService.ServiceAfterInstall(Sender: TService);
begin
  serviced := True;
end;

procedure TRelaxService.ServiceBeforeInstall(Sender: TService);
begin
  serviced := True;
end;

procedure TRelaxService.ServiceAfterUninstall(Sender: TService);
begin
  serviced := True;
end;

procedure TRelaxService.ServiceBeforeUninstall(Sender: TService);
begin
  serviced := True;
end;

End.

