unit uRealDirectoryInfo;

interface
uses
  uIDirectoryInfo,Classes,Sysutils,uShoutCastStream,uHTTPMemoryStream;

Type
  TRealDirectoryInfo = Class(TInterfacedObject , IDirectoryInfo)
  Protected
    RootDirectory : String;
    Function Init(aRootPath:String; aPath: String):Longint;
    Function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec):Longint;
    Function FindNext(var aSearchRec: TSearchRec):Longint;
    Procedure FindClose(var aSearchRec: TSearchRec);
    Function FileExists(aFileName: String):Boolean;
    Function GetFileStream(aRootPath:String; aFilename:String):TStream;
  End;

implementation

{ TRealDirectoryInfo }

function TRealDirectoryInfo.FileExists(aFileName: String): Boolean;
begin
  Result := SysUtils.FileExists(aFileName)
end;

procedure TRealDirectoryInfo.FindClose(var aSearchRec: TSearchRec);
begin
  Sysutils.FindClose(aSearchRec);
end;

function TRealDirectoryInfo.FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec): Longint;
begin
  Result := SysUtils.FindFirst(RootDirectory+aWildCard,FileMode,aSearchRec);
end;

function TRealDirectoryInfo.FindNext(var aSearchRec: TSearchRec): Longint;
begin
  Result := SysUtils.FindNext(aSearchRec);
end;

function TRealDirectoryInfo.GetFileStream(aRootPath, aFilename: String): TStream;
begin
       if pos('XNSCAST.MP3',uppercase(afilename))>0 then
          Result := TShoutCastStream.Create(aFilename)
  else if pos('.PLS',uppercase(afilename))>0 then
          Result := TShoutCastStream.Create(aFilename)
  else if pos('HTTP://',uppercase(aFilename))>0 then
          Result := THTTPMemoryStream.Create(aFilename)
  else
          Result := TFileStream.Create(aFilename,fmOpenRead+fmShareDenyNone);
end;

function TRealDirectoryInfo.Init(aRootPath, aPath: String): Longint;
begin
  Result := 0;
  Try
    RootDirectory := aPath;
    If (Length(RootDirectory)>0) and (RootDirectory[Length(RootDirectory)]<>'\') then
      RootDirectory := RootDirectory + '\';
  Except
    on exception do
      Result := -1;
  End;
end;

end.
