unit uISODirectoryInfo;

interface
uses
  uIDirectoryInfo,Classes,Sysutils, UnISOReader;

Type

  TISODirectoryInfo = Class(TInterfacedObject , IDirectoryInfo)
  protected
    FISOReader: TSearchableISOFileReader;
    function FileExists(aFileName: String): Boolean;
    procedure FindClose(var aSearchRec: TSearchRec);
    function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec): Longint;
    function FindNext(var aSearchRec: TSearchRec): Longint;
    function GetFileStream(aRootPath, aFilename: String): TStream;
    function Init(aRootPath, aPath: String): Longint;
  Public
    Constructor Create; 
    Destructor Destroy; Override;
  end;
implementation

{ TISODirectoryInfo }

constructor TISODirectoryInfo.Create;
begin
  Inherited Create;
  FIsoReader := Nil;
end;

destructor TISODirectoryInfo.Destroy;
begin
  FreeAndNil(FISOReader);
end;

function TISODirectoryInfo.FileExists(aFileName: String): Boolean;
begin
  Result := False;
end;

procedure TISODirectoryInfo.FindClose(var aSearchRec: TSearchRec);
begin
  FISOReader.FindClose(aSearchRec);
end;

function TISODirectoryInfo.FindFirst(aWildCard: String; FileMode: Integer;
  var aSearchRec: TSearchRec): Longint;
begin
  Result := FIsoReader.FindFirst(aWildCard, FileMode, aSearchRec);
end;

function TISODirectoryInfo.FindNext(var aSearchRec: TSearchRec): Longint;
begin
  Result := FIsoReader.FindNext(aSearchRec);
end;

function TISODirectoryInfo.GetFileStream(aRootPath,
  aFilename: String): TStream;
begin
  try
    Result := TISOFileStream.Create(aRootPath, aFileName, 0,fmOpenRead+fmShareDenyNone);
  except
    Result := nil;
  end;
end;

function TISODirectoryInfo.Init(aRootPath, aPath: String): Longint;
begin
  Result := 0;
  try
    FISOReader:=  TSearchableISOFileReader.Create(ARootPAth);
    FISOReader.SetCurrentDirectory(aPath);
    //, fmOpenRead + fmShareDenyNone);
  except
    Result := -1;
  end;

end;

end.

