unit uFAQonline;

interface

uses
  SysUtils,
  Classes,
  Controls,
  Forms,
  StdCtrls,
  IdHTTP,      // Part of Indy Delphi Components Suite
  ExtCtrls;

type
  TfrmFaq = class(TForm)
    Label1: TLabel;
    lblStatus: TLabel;
    btnUpdate: TButton;
    btnClose: TButton;
    Timer1: TTimer;
    Timer2: TTimer;
    memolog: TMemo;
    procedure btnUpdateClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    procedure updatelog;
  public
  end;

implementation

{$R *.dfm}

uses main;

{ TfrmFaq }

procedure TfrmFaq.updatelog;
var
  s:String;
  IdHTTP1 : TIdHTTP;
begin
  lblStatus.Caption := 'Checking online FAQ';
  Application.ProcessMessages;

  IdHTTP1 := TIdHTTP.Create(Self);
  idHTTP1.Request.UserAgent := 'Relax '+main.Version;

  s:='';
  Try
    s := IdHTTP1.Get('http://www.raforce.nl/RelaX.Faq');
  Except
    on e:Exception do
      Begin
        lblStatus.Caption := 'Checking for FAQ Failed -'+e.Message;
        s:='';
      End;
  End;
  Try
    IdHTTP1.Disconnect;
  Except
    on exception do ;
  End;
  FreeAndNil(IdHTTP1);

  if (s<>'') then
    Begin
      lblStatus.caption := 'Online FAQ found';
      memolog.Text := s;
    End;

  btnUpdate.Enabled := False;
  Timer1.Enabled := True;
end;

procedure TfrmFaq.btnUpdateClick(Sender: TObject);
begin
  updatelog;
end;

procedure TfrmFaq.Timer1Timer(Sender: TObject);
begin
  // Floodprotection!
  timer1.Enabled := False;
  btnUpdate.Enabled := True;
end;

procedure TfrmFaq.Timer2Timer(Sender: TObject);
begin
  timer2.enabled := False;
  updatelog;
end;

procedure TfrmFaq.btnCloseClick(Sender: TObject);
begin
  close;
end;

procedure TfrmFaq.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
