unit uSRTCleaner;

interface

uses
  sysutils,
  dialogs,
  classes;

Function GetCleanSRTStream(aSRTStream:TStream; CleanStripes,ReduceLines:Boolean; MaxLineSize:Integer):TStream;

implementation



Type TitleState=(TSRow,TSTime,TSSubs);

Procedure CorrectSub(Sub:Tstringlist; CleanStripes,ReduceLines:Boolean;MaxLineSize:Integer);
Var
  X: Longint;
  Max:Longint;
  Res,tmp:String;
  tmpCh : char;
  Done : Boolean;
  OverMaxSize : Boolean;
Begin

  if MaxLineSize=0 then
    Max:=45
  else
    Max:= MaxLineSize;

  if CleanStripes then
    For x:=0 to Sub.Count-1 do
      Begin
        Res := Sub.Strings[x];
        while (length(res)>0) and ((res[1]='-') or (res[1]=' ')) do
          Delete(Res,1,1);
        while (length(res)>0) and ((res[Length(res)]='-') or (res[Length(res)]=' ')) do
          Delete(Res,Length(res),1);
        Sub.Strings[x] := Res;
      End;

  Res := '';

  OverMaxSize := False;
  if MaxLineSize>0 then
    Begin
      For X:=0 to Sub.Count-1 do
        if Length(Sub[x])>MaxLineSize then
          OverMaxSize := True;
    End;


  if    (    (sub.count>2)
         and (ReduceLines))
     or (    (OverMaxSize))
    then // longer than 2 lines of subtitles.. lets cleanup
    Begin
      For X:=0 to Sub.Count-1 do
        Res:=Res+' '+Trim(Sub[x]);
      Sub.Clear;

      While Length(Res)>0 do
        Begin
          if Length(res)>Max then
            Begin
              Tmp:=copy(Res,1,Max);
              Delete(Res,1,Max);
              if (pos(' ',tmp)>0) or (pos('.',tmp)>0) or (pos(',',tmp)>0) then
                Begin // found marks to Cut back to!
                  Done := False;
                  Repeat
                    TmpCh := tmp[Length(tmp)];
                    delete(Tmp,Length(Tmp),1);
                    Case TmpCh of
                      ' ':Begin
                            Done := True;
                          End;
                      ',','.':Begin
                            Done := True;
                            tmp:=Tmp+tmpch;
                          End;
                      Else Res := TmpCh + Res;
                    End;
                  Until done;
                End;
              Sub.Add(tmp);
            End
          Else
            Begin
              Sub.Add(Res);
              Res := '';
            End;
        End;
    End;
End;



Function GetCleanSRTStream(aSRTStream:TStream; CleanStripes,ReduceLines:Boolean; MaxLineSize:Integer):TStream;
var
  slfrom:TStringlist;
  slto:TStringlist;

  s1: String;
  s2: String;
  x:Longint;
  Sub : TStringlist;
  ts : TitleState;
  s:String;

Begin
  Result := TMemoryStream.Create;

  slFrom := TStringlist.Create;
  slTo := TStringlist.Create;
  Sub := TStringlist.Create;

  aSRTStream.Position := 0;
  slFrom.LoadFromStream(aSRTStream);

  FreeAndNil(aSRTStream);
  Try
    Ts := TSRow;

    For x:=0 to slFrom.Count-1 do
      Begin
        s:=slFrom.Strings[x];
        Case TS of
          TSRow : Begin
                    S1 := s;
                    TS := TSTime;
                  End;
          TSTime : Begin
                      S2 := s;
                     TS:= TSSubs;
                   End;
          TSSubs : Begin
                     if s<>'' then
                       Begin
                         Sub.Add(s);
                       End
                     Else
                       Begin
//                         CorrectSub(Sub,CleanStripes,ReduceLines,MaxLineSize);
                         SlTo.Add(S1);
                         SlTo.Add(S2);
                         SlTo.AddStrings(Sub);
                         SlTo.Add('');
                         TS := TSRow;
                         Sub.Clear;
                       End;
                   End;
        end;
      End;
    slTo.SaveToStream(Result);
  Except
    On Exception do
      slFrom.SaveToStream(Result);
  End;
  Result.Position := 0;

  FreeAndNil(slFrom);
  FreeAndNil(slTo);
  FreeAndNil(Sub);
End;

end.
