unit AviInfo;
// (c) 2002 by Remco Sonnema
// Part of RelaX
// released under GPU
// coded in Delphi 6 pro (www.borland.com)
interface

Type Avi_Info = Record
       Compressor : String;
       Width:String;
       Height:String;
       Aspect:String;
       FrameRate:String;
       RealFrameRate:Real;
       Duration:String;
       size:String;
     end;

Function GetAviInfo(AviFile:String):Avi_info;

implementation

uses
  registry,sysutils,windows;

Const
  Nxt : String = '	';
  Offset : Integer =0;
Type
  arr4 = Array[1..4] of char;
  TAviStruct = Record
    Riff  : Longint; // 'RIFF'
    Duno  : Longint; //
    Avi   : Longint; // 'AVI '
    List  : Longint; // 'LIST'
    Duno2 : array[1..8] of Longint;
    TotalFrames : Longint;
    Duno3 : array[1..3] of Longint;
    Width : Longint;
    Height: Longint;
    Duno4 : Array[1..10] of Longint;
    Compressor : arr4;
    Duno5 : Array[1..3] of Longint;
    Scale : Longint;
    Rate : Longint;
    Duno6 : array[1..13] of Longint;
    CompressorComment : arr4;
  End;

function LeadingZero(i:Integer):String;
Begin
  Result := Inttostr(i);
  if length(Result)=1 then
    Result := '0'+Result;
End;

Function GetCompressor(arr:arr4):String;
Var
  MyReg:TRegistry;
Begin
  MyReg := TRegistry.Create;
  MyReg.RootKey := HKEY_CURRENT_USER;
  if MyReg.OpenKeyReadOnly('Software\Microsoft\ActiveMovie\devenum\{33D9A760-90C8-11D0-BD43-00A0C911CE86}\'+arr) then
    Result := MyReg.ReadString('FriendlyName')
  Else
    Result := arr;
  FreeAndNil(MyReg);
End;

Function GetAviInfo(AviFile:String):Avi_info;
var
  F     : File;
  FrameRateString : String;
  FrameRate : Real;
  TimeString  : String;
  hours , Minutes, Seconds : Longint;
  x:Longint;
  AviStruct : TAviStruct;
  fs:Longint;
  Aspect : Real;
begin
  Filemode := fmOpenRead + fmShareDenyNone;
  AssignFile(F,AviFile);
  {$I-}
  Reset(F,1);
  {$I+}
  If IOResult = 0 then
    Begin
      Seek(F,Offset);
      x:=Sizeof(AviStruct);
      BlockRead(F,AviStruct,x);
      FS := FileSize(f);
      CloseFile(F);
      FrameRateString:='0.0000';
      FrameRate := AviStruct.Rate / AviStruct.Scale;
      if AviStruct.Scale <> 0 then
        Str((FrameRate):0:4,FrameRateString);
      While (FrameRateString[Length(FrameRateString)] = '0')
        and (Length(FrameRateString) > 1)
        and (FrameRateString[Length(FrameRateString)-1] <> '.') do
        Delete(FrameRateString,Length(FrameRateString),1);
//        ('FileName :'+ExtractFilename(Opendialog1.filename));
//        ('Scale :'+Inttostr(AviStruct.Scale));
//        ('Rate :'+Inttostr(AviStruct.Rate));
//        ('Width :'+Inttostr(AviStruct.Width));
//        ('Height :'+Inttostr(AviStruct.Height));
//        ('Compressor :'+getCompressor(AviStruct.Compressor));
//        ('FileSize :'+Inttostr(fs));
//        ('TotalFrames :'+Inttostr(AviStruct.TotalFrames));
//        ('FrameRate :'+FrameRateString);
      Seconds := Round(AviStruct.totalframes / FrameRate);

      Hours := Seconds div 3600;
      Seconds := Seconds - (Hours * 3600);

      Minutes := Seconds div 60;
      Seconds := Seconds - (Minutes * 60);
      TimeString := Inttostr(hours)+' : '+LeadingZero(Minutes)+' : '+LeadingZero(Seconds);

      Aspect := (AviStruct.width / aviStruct.Height);
      Result.Compressor :=getCompressor(AviStruct.Compressor);
      Result.Width := inttostr(AviStruct.Width);
      Result.Height := inttostr(AviStruct.Height);
      Str(Aspect:0:3,Result.Aspect);

      if (aspect >= 2.201) and (aspect <= 2.450) then
        Result.Aspect := 'ultra widescreen';

      if (aspect >= 1.901) and (aspect <= 2.200) then
        Result.Aspect := 'widescreen plus';

      if (aspect >= 1.751) and (aspect <= 1.900) then
        Result.Aspect := 'widescreen';

      if (aspect >= 1.200) and (aspect <= 1.400) then
        Result.Aspect := 'normal 3 : 4';


      Result.FrameRate := FrameRateString;
      Result.RealFrameRate := FrameRate;
      Result.Duration := timeString;
      Result.size := Inttostr(fs);
    End;
end;


end.
