{**************************************************************************************************}
{ This unit contains the object that supports the IDirectoryInfo Interface.                        }
{ The object is the "binding" between relax and the XISOReader                                     }
{                                                                                                  }
{                                                                                                  }
{ Original unit name; UnXISODirectoryInfo.pas                                                      }
{                                                                                                  }
{ References                                                                                       }
{                                                                                                  }
{**************************************************************************************************}
{                                                                                                  }
{ IDirectoryInfo interfaced object for XISO Reading                                                }
{                                                                                                  }
{ Unit owner: Espen Schaathun                                                                      }
{ Last modified: December 02, 2002                                                                 }
{                                                                                                  }
{**************************************************************************************************}
unit UnXISODirectoryInfo;

interface
uses
  SysUtils,
  Classes,
  uIDirectoryInfo,
  UnXISOReader;
type
  TXISODirectoryInfo = class(TInterfacedObject, IDirectoryInfo)
  private
    FReader: TSearchableXISOReader;
  protected
  Public
    Constructor Create;
    Destructor Destroy; Override;
    Function Init(aRootPath:String; aPath: String):Longint;
    Function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec):Longint;
    Function FindNext(var aSearchRec: TSearchRec):Longint;
    Procedure FindClose(var aSearchRec: TSearchRec);
    Function FileExists(aFileName: String):Boolean;
    function GetFileStream(aRootPath, aFilename: String): TStream;
  end;

implementation

{ TXISODirectoryInfo }

constructor TXISODirectoryInfo.Create;
begin
  Inherited Create;
  FReader := Nil;
end;

destructor TXISODirectoryInfo.Destroy;
begin
  FreeAndNil(FReader);
  inherited;
end;

function TXISODirectoryInfo.FileExists(aFileName: String): Boolean;
begin
  Result := FReader.FileExists(aFileName);
end;

procedure TXISODirectoryInfo.FindClose(var aSearchRec: TSearchRec);
begin
  FReader.FindClose(aSearchRec);
end;

function TXISODirectoryInfo.FindFirst(aWildCard: String; FileMode: Integer;
  var aSearchRec: TSearchRec): Longint;
begin
  Result:= FREader.FindFirst(aWildCard, FileMode, aSearchRec);
end;

function TXISODirectoryInfo.FindNext(var aSearchRec: TSearchRec): Longint;
begin
  Result := FReader.FindNext(aSearchRec)
end;

function TXISODirectoryInfo.GetFileStream(aRootPath,
  aFilename: String): TStream;
begin
  Result := TXISOFileStream.Create(ARootPath, aFilename,0,0);
end;

function TXISODirectoryInfo.Init(aRootPath, aPath: String): Longint;
begin
  FReader:= TSearchableXISOReader.Create(ARootPath);
  Result := FReader.SetWorkingDirectory(aPath);
end;

end.
