unit TestClientMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdComponent, IdTCPConnection, IdTCPClient,
  StdCtrls, IdBaseComponent, IdAntiFreezeBase, IdAntiFreeze,janXMLParser2,
  ImgList, ComCtrls, FileCtrl, Spin;

type
  TForm1 = class(TForm)
    edtIP: TEdit;
    Button1: TButton;
    ImageList1: TImageList;
    lv: TListView;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    pb: TProgressBar;
    Label1: TLabel;
    fn: TLabel;
    edtRootPath: TEdit;
    lbpos: TLabel;
    IdAntiFreeze1: TIdAntiFreeze;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    Button2: TButton;
    memcbx: TCheckBox;
    SpinEdit2: TSpinEdit;
    edtUrlToGet: TEdit;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure lvDblClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    doStop : Boolean;
    procedure DoDirectory(dir: String);
    function DoRequest(ip, Request: String; ResultStream: TStream;
      KeepOpen: Boolean; var TCPClient: TIdTCPClient): Integer;
    procedure DoCopyFile(aRemoteFile, LocalFileName: String);
  public
  end;

var
  Form1: TForm1;

implementation

uses DateUtils;

{$R *.dfm}

Function TForm1.DoRequest(ip,Request:String;ResultStream:TStream;KeepOpen:Boolean;Var TCPClient:TIdTCPClient):Integer;
var
  Greeting : String;
  Answer : String;
  AnswerLength : Int64;
begin
  Result := 0;
  if not assigned(TCPClient) then
    begin
      TCPClient := TIdTCPClient.Create(Self);
      TCPClient.Host := IP;
      TCPClient.Port := Spinedit2.Value;
      TCPClient.Connect(2000);
      // handshaking
      TCPClient.Writeln('This is XNS Protocol Tester');
      Greeting := TCPClient.ReadString(11);
    End
  else
    greeting := 'HELLO XBOX!';

  if Greeting = 'U have no r' then
    showmessage('Secure System');
  if Greeting = 'HELLO XBOX!' then
    begin
      TCPClient.Writeln(Request);
      Answer := TCPClient.ReadString(32);
      AnswerLength := StrToInt(Copy(Answer,1,pos(' ',Answer)-1));
      if Assigned(ResultStream) then
        TCPClient.ReadStream(ResultStream,AnswerLength,False)
      else
        Result := AnswerLength;
    end;
  if not KeepOpen then
    begin
       TCPClient.Disconnect;
       FreeAndNil(TCPClient);
    End;
end;

Procedure TForm1.DoCopyFile(aRemoteFile,LocalFileName:String);
var
  tmpIdTCPClient:TIdTCPClient;
  FileLength : Int64;
  mfs:TStream;
  BytesToGet:Int64;
  StartTime:TDateTime;
  Seconds : Integer;
  LastRefresh: Integer;
begin
  tmpIdTCPClient := Nil;
  Filemode := fmShareDenyNone;
  if memcbx.checked then
    mfs := TMemoryStream.Create
  else
    begin
      mfs := TFileStream.Create(localFileName,fmCreate,fmOpenReadWrite+fmShareDenyNone);
    end;
  lv.Enabled := False;
  Application.processMessages;
  StartTime := Now;
  LastRefresh:=0;
  DoStop := False;
  Try
    FileLength := DoRequest(edtIP.Text,'OPEN,'+aRemoteFile,nil,True,tmpIdTCPClient);
    if filelength=-1 then
      begin
        showmessage('File not found');
        abort;
      end;
    fn.Caption := ExtractFileName(aRemoteFile);
    pb.Position := 0;
    pb.Max := FileLength;
    While (mfs.Position <> FileLength) and (not doStop) do
      Begin
         BytesToGet := Spinedit1.Value;
         if mfs.position + BytesToGet > FileLength then
           BytesToGet := FileLength - mfs.Position;
         DoRequest(edtIP.Text,'READ,'+IntToStr(mfs.Position)+','+IntToStr(BytesToGet),mfs,true,tmpIdTCPClient);
         pb.Position := mfs.Position;
         mfs.free;
         mfs := TFileStream.Create(localFileName,fmOpenReadWrite+fmShareDenyNone);
         mfs.Position := mfs.Size;

         Seconds := SecondsBetween(Now,StartTime);
         if (lastRefresh<>seconds) then
           begin
             lastRefresh := seconds;
             lbpos.caption := InttoStr(mfs.Position div 1024) + ' K    '+Inttostr((mfs.position div seconds) div 1024)+' K/s'+ '    '+Inttostr(seconds)+' Sec';
             lbpos.Update;
             Application.processMessages;
           end;
      end;
    DoRequest(edtIP.Text,'CLSE',nil,False,tmpIdTCPClient);
  finally
    FreeAndNil(mfs);
    lv.Enabled := True;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  DoDirectory(edtRootPath.Text);
end;

procedure TForm1.DoDirectory(dir:String);
var
  MemStream:TmemoryStream;
  sl:TStringList;
  Catalogue  : TjanXMLParser2;
  item : TJanXMLNode2;
  tmpItem : TJanXMLNode2;
  x,y:Longint;
  attrib : Integer;
  Path : String;
  ln : TListITem;
  tmpIdTCPClient:TIdTCPClient;
begin
  MemStream:=TMEmoryStream.Create();
  sl := TStringList.Create;
  Catalogue  := TjanXMLParser2.create;

  if dir <> '' then
    dir := ','+Dir;
  tmpIdTCPClient := nil;
  DoRequest(edtIP.Text,'*CAT'+dir,MemStream,false,tmpIdTCPClient);
  MemStream.Position := 0;
  sl.LoadFromStream(MemStream);
  Catalogue.XML := sl.text;
  lv.Clear;
  lv.update;
  ln := lv.Items.Add;
  ln.Caption := '..';
  ln.ImageIndex := 0;
  ln.SubItems.Add('BACK');
  For x:=0 to Catalogue.nodes.Count-1 do
    begin
      item := Catalogue.nodes[x];
      attrib := 0;
      Path := '';
      For y:=0 to item.nodes.Count-1 do
        begin
          tmpItem := TJanXMLNode2(item.nodes[y]);
          if Uppercase(tmpITem.name) = 'ATTRIB' then Attrib := StrToInt(tmpItem.text);
          if Uppercase(tmpITem.name) = 'PATH' then   path := tmpItem.text;
        end;
      ln := lv.Items.Add;
      ln.Caption := ExtractFileName(path);
      if ln.caption = '' then ln.caption := path;
      if attrib and 16 = 16 then ln.ImageIndex := 0
                           else ln.ImageIndex := 1;
      ln.SubItems.Add(Path)
    end;

  FreeAndNil(Catalogue);
  FreeAndNil(sl);
  FreeAndNil(MemStream);
end;

procedure TForm1.lvDblClick(Sender: TObject);
begin
  if assigned(lv.Selected) then
    case lv.Selected.ImageIndex of
      0 : DoDirectory(lv.Selected.SubItems[0]);
      1 : DoCopyFile(lv.Selected.SubItems[0],DirectoryListBox1.Directory+'\'+lv.Selected.Caption);
    End;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  doStop := True;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
//
  DoCopyFile(edtUrlToGet.text,DirectoryListBox1.Directory+'\Test.html');
end;

end.
