/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Core;

import com.superhac.JXBStreamer.Core.Debug;
import com.superhac.JXBStreamer.Core.XBMSPxmlEncoder;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryHandlerObject {
    private int handle;
    private File path;
    private ArrayList<File> files = new ArrayList();
    private ArrayList<File> virtualRoot = null;
    private int totalDirectoryEntries;
    private int directoryListingPosition = 0;
    private static Logger logger;
    private boolean isVirtualRoot = false;

    protected DirectoryHandlerObject(int handle, File path) {
        logger = Debug.getLogger();
        this.handle = handle;
        this.path = path;
        this.buildDirectoryList();
    }

    protected DirectoryHandlerObject(int handle, ArrayList<File> virtualRoot) {
        logger = Debug.getLogger();
        this.handle = handle;
        this.virtualRoot = virtualRoot;
        this.path = null;
        this.isVirtualRoot = true;
        this.buildVirtualRootList();
    }

    private void buildDirectoryList() {
        this.files.removeAll(this.files);
        File[] children = this.path.listFiles();
        int i = 0;
        while (i < children.length) {
            this.files.add(children[i]);
            ++i;
        }
        this.totalDirectoryEntries = this.files.size();
        if (Debug.debug) {
            logger.info("Build directory list.  Total Entries:" + this.totalDirectoryEntries);
        }
    }

    private void buildVirtualRootList() {
        this.files.removeAll(this.files);
        this.files = (ArrayList)this.virtualRoot.clone();
        this.totalDirectoryEntries = this.files.size();
    }

    protected int getHandle() {
        return this.handle;
    }

    protected String[] getNextEntry() {
        String[] payloadStrings = new String[2];
        if (this.directoryListingPosition == this.totalDirectoryEntries) {
            payloadStrings[0] = null;
            payloadStrings[1] = null;
            this.directoryListingPosition = 0;
            if (this.isVirtualRoot) {
                this.buildVirtualRootList();
            } else {
                this.buildDirectoryList();
            }
            if (Debug.debug) {
                logger.info("Last directory entry.  Reset List..");
            }
            return payloadStrings;
        }
        if (Debug.debug) {
            logger.info("Reading and packing next directory entry at position: " + this.directoryListingPosition);
        }
        File entry = this.files.get(this.directoryListingPosition);
        payloadStrings[0] = entry.getName();
        payloadStrings[1] = XBMSPxmlEncoder.encodeEntry(entry);
        ++this.directoryListingPosition;
        return payloadStrings;
    }

    protected int getFileIndexNumber(String name) {
        if (Debug.debug) {
            logger.info("Getting file index number in directory for file <" + name + "?");
        }
        int i = 0;
        while (i < this.files.size()) {
            if (this.files.get(i).getName().compareTo(name) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String[] getEntryDataByIndex(int index) {
        if (Debug.debug) {
            logger.info("Getting entry data(xml) by index...");
        }
        String[] payloads = new String[]{this.files.get(index).getName(), XBMSPxmlEncoder.encodeEntry(this.files.get(index))};
        return payloads;
    }

    protected File getFileByIndex(int index) {
        if (Debug.debug) {
            logger.info("Get file by index....");
        }
        File file = this.files.get(index);
        return file;
    }

    protected File getPath() {
        return this.path;
    }
}

