/*
 * Decompiled with CFR 0.152.
 */
package xbmsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import xbmsp.Server;

public class ServiceThread
implements Runnable {
    private static final int COMMAND_BUFFER_SIZE = 4096;
    private static final int READ_BUFFER_SIZE = 16384;
    private Logger logger = Logger.getLogger("xbmsp");
    private Socket client;
    private FileInputStream currentStream = null;
    private MappedByteBuffer bb = null;
    private byte[] readBuffer = new byte[16384];

    public ServiceThread(Socket client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCurrentStream() {
        block6: {
            try {
                if (this.currentStream != null) {
                    this.logger.fine("Closing stream");
                    FileInputStream fileInputStream = this.currentStream;
                    synchronized (fileInputStream) {
                        this.currentStream.close();
                        this.currentStream = null;
                        this.bb = null;
                    }
                    this.logger.fine("Stream closed");
                    break block6;
                }
                this.logger.fine("Stream not open");
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error closing stream", ex);
            }
        }
    }

    public void run() {
        try {
            this.logger.fine("Client thread started " + Thread.currentThread().getName());
            InputStream is = this.client.getInputStream();
            OutputStream os = this.client.getOutputStream();
            byte[] mainbuffer = new byte[4096];
            int count = 1;
            while (count > 0) {
                this.logger.info("Waiting for command");
                count = is.read(mainbuffer);
                if (count <= -1) continue;
                String line = new String(mainbuffer, 0, count).trim();
                this.logger.info("Line: '" + line + "'");
                if (line != null) {
                    if ("HELLO XSTREAM 6.0".equals(line)) {
                        os.write("HELLO XBOX!".getBytes());
                    } else {
                        String[] parts;
                        String command = line.substring(0, 4);
                        this.logger.info("Command: '" + command + "'");
                        if ("OPEN".equals(command)) {
                            this.closeCurrentStream();
                            String filename = line.substring(line.indexOf(44) + 1).trim();
                            if (filename.charAt(2) == '/') {
                                this.logger.warning("Removing a slash from the beginning of " + filename);
                                filename = filename.substring(1);
                            }
                            this.logger.info("Filename: '" + filename + "'");
                            File f = new File(Server.rootDir, filename);
                            if (f.exists()) {
                                try {
                                    this.logger.info("Opened file: " + f.getAbsolutePath());
                                    this.currentStream = new FileInputStream(f);
                                    FileChannel fc = this.currentStream.getChannel();
                                    this.bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, f.length());
                                    os.write(ServiceThread.pad((int)f.length()));
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    os.write(ServiceThread.pad(0));
                                }
                            } else {
                                this.logger.warning("No such file: " + f.getAbsolutePath());
                                os.write(ServiceThread.pad(0));
                            }
                        } else if ("*CAT".equals(command)) {
                            parts = line.split(",");
                            if (parts.length > 1) {
                                File cd = new File(Server.rootDir, parts[1]);
                                if (cd.exists()) {
                                    this.logger.fine("CD: " + cd.getAbsolutePath());
                                    Server.currentDir = cd;
                                } else {
                                    this.logger.warning("CD: " + cd.getAbsolutePath() + " does not exist");
                                }
                            }
                            StringBuffer result = new StringBuffer("<SHARES>\n");
                            File[] files = Server.currentDir.listFiles();
                            int i = 0;
                            while (i < files.length) {
                                if (!files[i].isHidden()) {
                                    result.append("<ITEM><ATTRIB>");
                                    result.append(files[i].isDirectory() ? "16" : "128");
                                    result.append("</ATTRIB><PATH>");
                                    result.append(files[i].getAbsolutePath().substring(Server.rootDir.getAbsolutePath().length()));
                                    result.append("</PATH></ITEM>\n");
                                }
                                ++i;
                            }
                            result.append("</SHARES>");
                            os.write(ServiceThread.pad(result.length()));
                            os.write(result.toString().getBytes());
                        } else if ("READ".equals(command)) {
                            if (this.currentStream == null) {
                                this.logger.warning("No open stream");
                            } else {
                                parts = line.split(",");
                                int pos = 0;
                                int len = 0;
                                if (parts.length > 2) {
                                    pos = Integer.parseInt(parts[1]);
                                    len = Integer.parseInt(parts[2]);
                                }
                                this.logger.info("\nPOS: " + pos + "\nLEN: " + len);
                                if (pos + len > this.bb.limit()) {
                                    len = this.bb.limit() - pos;
                                    this.logger.warning("Reducing len: " + len);
                                }
                                ((Buffer)this.bb).position(pos);
                                try {
                                    this.bb.get(this.readBuffer, 0, len);
                                }
                                catch (BufferUnderflowException bue) {
                                    bue.printStackTrace();
                                }
                                this.logger.info("\nBytes requested: " + len);
                                os.write(ServiceThread.pad(len));
                                os.write(this.readBuffer, 0, len);
                            }
                        } else if ("CLSE".equals(command)) {
                            this.closeCurrentStream();
                            os.write(ServiceThread.pad(0));
                        } else {
                            this.logger.warning("Command '" + command + "' not recognized... ignoring");
                        }
                    }
                }
                this.logger.info("command done");
            }
            this.client.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.logger.fine("Client thread finished " + Thread.currentThread().getName());
    }

    private static final byte[] pad(int foo) {
        byte[] lenbuf = "                                ".getBytes();
        String lenString = Integer.toString(foo);
        byte[] lsb = lenString.getBytes();
        int i = 0;
        while (i < lsb.length) {
            lenbuf[i] = lsb[i];
            ++i;
        }
        return lenbuf;
    }
}

