/*
 * Decompiled with CFR 0.152.
 */
package xbmsp;

import java.io.File;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import xbmsp.ServiceThread;

public class Server {
    static final Logger logger = Logger.getLogger("xbmsp");
    private short port = (short)1400;
    static File rootDir;
    static File currentDir;

    public Server(File root) {
        try {
            rootDir = root;
            logger.info("Opening server-socket at port " + this.port);
            ServerSocket ss = new ServerSocket(this.port);
            while (true) {
                logger.info("Accept...");
                Socket client = ss.accept();
                logger.info("Connection!");
                new Thread(new ServiceThread(client)).start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        try {
            File root;
            if (args.length == 0) {
                System.err.println("Usage: xbmsp.Server <root-directory> [OFF|SEVERE|WARNING|INFO|CONFIG|FINE|FINER|FINEST|ALL]");
                System.exit(1);
            }
            if (!(root = new File(args[0])).exists()) {
                System.err.println("Directory: '" + args[0] + " does not exist");
                System.exit(1);
            }
            if (!root.isDirectory()) {
                System.err.println("'" + args[0] + " is not a directory");
                System.exit(1);
            }
            if (args.length > 1) {
                try {
                    Level level = Level.parse(args[1]);
                    Handler[] handlers = logger.getHandlers();
                    int i = 0;
                    while (i < handlers.length) {
                        handlers[i].setLevel(level);
                        ++i;
                    }
                    logger.setLevel(level);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            new Server(root);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        currentDir = rootDir = null;
    }
}

