#pragma once

/////////////////////////////////////////////////////////////////////////////////////////////
//
#include "CSocket.h"
#include "CWaitable.h"
#include "CString.h"
#include "NTService.h"

/////////////////////////////////////////////////////////////////////////////////////////////
//
class XDebugServer 
	: 
	public CNTService
{
	public:
		XDebugServer( int iPort = 7654 );
		virtual ~XDebugServer();

	protected:
		// CNTService
		virtual bool HandlePreRun( void );
		virtual void HandleRun( void );
		virtual void HandleStop( void );
		virtual void HandlePostRun( void );

	private:
		CWaitableCollection		m_SocketEvents;
		CSocket					m_ServerSocket;
		CSocket*				m_pClientSocket;
		CStringEx				m_sClientIpAddr;

		int						m_iPort;
		bool					m_bIsInitialized;
		bool					m_bIsActive;

		void OnEvent( CSocket* pSocket );
		void HandleSocketAccept( CSocket* pSocket );
		void HandleSocketRead( CSocket* pSocket );
		void HandleSocketWrite( CSocket* pSocket );
		void HandleSocketClose( CSocket* pSocket );
};
