#pragma once
#pragma warning(disable:4786)
#include <map>
#include "CCriticalSection.h"
#include "CWaitable.h"
#include "COsEvent.h"

class CPoolable;
class CResourceFactory;

/////////////////////////////////////////////////////////////////////////////////////////
//
class CResourcePool : public CWaitable
{
	public:
		CResourcePool
		( 
			CResourceFactory* pResourceFactory, 
			int iResourcePoolSize
		);
		virtual ~CResourcePool();

		bool Acquire( CPoolable*& pResource );
		bool Relinquish( CPoolable* pResource );

		// Waitable interface
		virtual HANDLE GetWaitHandle( void )
			{ return m_AvailableEvent; }
		virtual void CancelWait( void )
			{ m_AvailableEvent.Signal(); }

	protected:
		typedef std::map< long, CPoolable* >		RESOURCEMAP;

		int					m_iResourcePoolSize;
		int					m_iResourcesAllocated;
		CResourceFactory*	m_pResourceFactory;
		RESOURCEMAP			m_IdleResourceMap;
		COsEvent			m_AvailableEvent;
		CCriticalSection	m_CriticalSection;

		bool CreateResource( CPoolable*& pResource );
		bool IsAvailable( void );
		void UpdateAvailability( void );
};

/////////////////////////////////////////////////////////////////////////////////////////
//
class CPoolable
{
	public:
		CPoolable()
			{ m_pResourcePool = NULL; }
		virtual ~CPoolable()
			{ if ( m_pResourcePool ) m_pResourcePool->Relinquish( this ); }

		virtual void AttachToPool( CResourcePool* pResourcePool )
			{ m_pResourcePool = pResourcePool; }
		virtual void DetachFromPool( void )
			{ m_pResourcePool = NULL; }

		virtual long GetId( void )=0;

	protected:
		CResourcePool*		m_pResourcePool;
};

/////////////////////////////////////////////////////////////////////////////////////////
//
class CResourceFactory
{
	public:
		CResourceFactory()
			{;}
		virtual ~CResourceFactory()
			{;}
		virtual bool CreateInstance( CPoolable*& pObject )=0;
};


