#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef _XBOX
#include <xtl.h>
#else
#include <windows.h>
#endif

/////////////////////////////////////////////////////////////////////////////////////////////
//
//
class XCriticalSection
{
	friend class XLock;

	public:
		XCriticalSection()
			{ InitializeCriticalSection( &m_CriticalSection ); }
		~XCriticalSection()
			{ DeleteCriticalSection( &m_CriticalSection ); }

	private:
		CRITICAL_SECTION		m_CriticalSection;

		void Acquire( void )
			{ EnterCriticalSection( &m_CriticalSection );	}

		void Relinquish( void )
			{ LeaveCriticalSection( &m_CriticalSection ); }
};

/////////////////////////////////////////////////////////////////////////////////////////////
//
//
class XLock
{
	public:
		// Acquire the state of the semaphore
		XLock( XCriticalSection &cs )
			: m_CriticalSection( cs )
			{ m_CriticalSection.Acquire(); }

		// Release the state of the semaphore
		~XLock()
			{ m_CriticalSection.Relinquish(); }

	private:
		XCriticalSection&		m_CriticalSection;
};
