#pragma once
#define _WIN32_WINNT 0x0400
#include <windows.h>

/////////////////////////////////////////////////////////////////////////////////////////////
//
//

class CCriticalSection
{
	friend class CLock;

	public:
		CCriticalSection()
			{ ::InitializeCriticalSection( &m_CriticalSection); }
		~CCriticalSection()
			{ ::DeleteCriticalSection( &m_CriticalSection ); }

	private:
		CRITICAL_SECTION		m_CriticalSection;

		void Acquire( void )
			{ ::EnterCriticalSection( &m_CriticalSection );	}

		void Relinquish( void )
			{ ::LeaveCriticalSection( &m_CriticalSection ); }
};

/////////////////////////////////////////////////////////////////////////////////////////////
//
//

class CLock
{
	public:
		// Acquire the state of the semaphore
		CLock( CCriticalSection &cs )
			: m_CriticalSection( cs )
			{ m_CriticalSection.Acquire(); }

		// Release the state of the semaphore
		~CLock()
			{ m_CriticalSection.Relinquish(); }

	private:
		CCriticalSection&		m_CriticalSection;
};
