;-------------------------------------------------------------------------------
; PRO-PACK Unpack Source Code - IBM PC, Method 2
; Copyright (c) 1991,92 Rob Northen Computing, UK. All Rights Reserved.
;
; 32bit X86 Xbox Version Done By
; Destop - Crazy Nation 
; nasmw.exe -t -f  win32 -o$(IntDir)\$(InputName).obj -Xvc $(InputName).asm
; ppibm p -m2 file
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
; Return Codes
;-------------------------------------------------------------------------------

NOT_PACKED      EQU     0
PACKED_CRC      EQU     -1
UNPACKED_CRC    EQU     -2

;-------------------------------------------------------------------------------
; Other Equates
;-------------------------------------------------------------------------------

HEADER_LEN      EQU     18

;-------------------------------------------------------------------------------
; Macros
;-------------------------------------------------------------------------------

%macro reload	0
                lodsb
                adc al,al
%ENDM

%macro getbit	0
                add al,al
%ENDM

%macro getraw	0  
                movsb
%ENDM

%macro	getrawREP 0
				rep     movsw
%ENDM

;-------------------------------------------------------------------------------
; Code Segment
;-------------------------------------------------------------------------------

section                .data

input_hi		dd      0
output_hi		dd		0
unpack_len      dd      0
pack_paras      dd      0
RNC_MAGIC		db		02,'CNR'


;------------------------------------------------------------------------------
; PRO-PACK Unpack Routine - IBM PC, Method 2
;
; Returns,
;       Length of unpacked file in bytes OR error code
;            0 = not a packed file
;
; To Call from Assembler,
;	lea		esi,packed_file
;	lea		edi,output_buffer
;	call	Unpack
; Current Version doesnt allow unpacking over itself
;
; On exit,
;       EAX = length of unpacked file in bytes OR error code (low word)
;            0 = not a packed file
;           -1 = packed data crc error
;           -2 = unpacked data crc error
;------------------------------------------------------------------------------
;section			.code
GLOBAL RNCUnpack
RNCUnpack						
                cld
                call    read_long
				cmp		eax,[RNC_MAGIC]
				jne		near not_pack

				call	read_long
				mov		[unpack_len],eax

				call	read_long			;packed length

                add     esi,HEADER_LEN-12
				xor		ebx,ebx
unpack4:
                stc
                reload
                getbit
                jmp     PackBits2

Fetch0:
                reload
                jmp     Back0

PackRaw:
                mov     ecx,4
PackRaw2:
                getbit
                jz      Fetch0
Back0:
                adc     bh,bh
                loop    PackRaw2
                mov     ecx,3
                add     cl,bh
                add     cl,cl
                getrawREP
                jmp     PackBits2

Fetch1:
                reload
                jmp     Back1
Fetch2:
                reload
                jmp     Back2
Fetch3:

                reload
                jmp     Back3
Fetch4:
                reload
                jmp     Back4
Fetch5:
                reload
                jmp     Back5
Fetch6:
                reload
                jmp     Back6
Fetch7:
                reload
                jmp     Back7

PackLen:
                getbit
                jz      Fetch1
Back1:
                adc     cl,cl
                getbit
                jz      Fetch2
Back2:
                jnc     PackCopy
                getbit
                jz      Fetch3
Back3:
                dec     ecx
                adc     cl,cl
                cmp     cl,9
                jz      PackRaw

PackCopy:
                getbit
                jz      Fetch4
Back4:
                jnc     ByteDisp
                getbit
                jz      Fetch5
Back5:
                adc     bh,bh
                getbit
                jz      Fetch6
Back6:
                jc      PackDisp
                or      bh,bh
                jnz     ByteDisp
                inc     bh
PackCopy2:
                getbit
                jz      Fetch7
Back7:
                adc     bh,bh

ByteDisp:
                mov     bl,[byte esi]
                inc     esi
                mov     ebp,esi
                mov     esi,edi
                dec     esi
                sub     esi,ebx			;ebx is cleared before unpack
                rep     movsb	
                mov     esi,ebp
                jmp     PackBits2

PackBits:
                reload
                jc      PackString
PackBits1:
                getraw
PackBits2:
                getbit
                jc      PackBits3
                getraw
                getbit
                jnc     PackBits1
PackBits3:
                jz      PackBits

PackString:
                mov     cx,2
                sub     bh,bh
                getbit
                jz      Fetch8
Back8:
                jnc     PackLen
                getbit
                jz      Fetch9
Back9:
                jnc     ByteDisp
                inc     cx
                getbit
                jz      Fetch10
Back10:
                jnc     PackCopy
                movzx   ecx,[byte esi]
                inc     esi
                or      cl,cl
                jz      PackEnd
                add     cx,8
                jmp     PackCopy

PackDisp:
                getbit
                jz      Fetch11
Back11:
                adc     bh,bh
                or      bh,4
                getbit
                jz      Fetch12
Back12:
                jc      ByteDisp
                jmp     PackCopy2

Fetch8:
                reload
                jmp     Back8
Fetch9:
                reload
                jmp     Back9
Fetch10:
                reload
                jmp     Back10
Fetch11:
                reload
                jmp     Back11
Fetch12:
                reload
                jmp     Back12

PackEnd:
                getbit
                jnz     PackEnd2
                reload
PackEnd2:
                jc      PackBits2

                mov     eax,[unpack_len]
                jmp     unpack_end
not_pack:
                xor     eax,eax
unpack_end:
                ret
	;Unpack  

read_long
				lodsd
				bswap	eax
				ret

                END
