;==========================================================================
;
;    Angle_Union     UNION
;        B       db  ?
;        W       dw  ?
;    Angle_Union     ENDS    ;creates a new data type (eg. DW, DB, DD) called
STRUC    Point_Struc   
        X:       resw  1
        Y:       resw  1
        Z:       resw  1
ENDSTRUC    ;Create a structure (or a record)

  
Zan         dw  $07f
Yan         dw  $06f
Xan         dw  0
PathAn1     dw  0
PathAn2     dw  0
TempX       dw  0                                
TempY       dw  0
PreAddX     dw    0             ;amount to ADD to each X, Y & Z >BEFORE<
PreAddY     dw    0             ;the distance transforms
PreAddZ     dw    0             ;causes the change to be scaled

PostAddX    dw  SCREEN_WIDTH/2             ;amount to ADD to each X & Y >AFTER<
PostAddY    dw  SCREEN_HEIGHT/2             ;the distance transforms

Distance    dw  200
Zoom        dw  0
ZanVel      db    0             ;angle velocities
YanVel      db    0
XanVel      db    0
P1Vel       dw    0
P2Vel       dw    0
 
	
NumPts  EQU 40*40
RotCord:
; LABEL        Point_Struc 
 istruc Point_Struc 
 at X, dw 0
 at Y, dw 0
 at Z, dw 0
 iend
 ;
    ;DESTROYS: ax,dx,si,di,es,ds
    ;Input: BX= X CX= Y BP= Z
    ;OutPut:BX= X CX= Y BP= Z
RotateXYZ:
                    
    mov     edi,0                       ; X-rotation
                                        ; Y := cos(Xan) * y - sin(Xan) * z
    mov     [word TempY],cx       ;save y    ; Z := sin(Xan) * y + cos(Xan) * z
    mov     di,[Xan]
    add     di,di                       ; si = angle x
    mov     ax,[Cosine+edi]              ; ax = cos(angle x)
    imul    cx                          ; ax = cos(angle x) * y
    mov     cx,dx
    shl     ecx,16
    mov     cx,ax                       ; store for later use
    mov     ax,[Sine+edi]                ; ax = sin(angle x)
  
    imul    bp                          ; ax = sin(angle x) * z
    shl     edx,16
    mov     dx,ax
    sub     ecx,edx                     ; cx = cx-ax = cos(vx)*y - sin(vz)*z
    shl     ecx,2
    sar     ecx,16
    mov     [TempX],cx                  ; updated y

    mov     ax,[Sine+edi]                ; ax = sin(angle x)
    imul    [word TempY]                     ; ax = sin(angle x) * y
    mov     cx,dx
    shl     ecx,16
    mov     cx,ax
    mov     ax,[Cosine+edi]              ; ax = cos(angle x)
    imul    bp                          ; ax = cos(angle x) * z
    shl     edx,16
    mov     dx,ax
    add     ecx,edx                     ; cx = cx-ax = sin(vx)*y + cos(vx)*z
    shl     ecx,2
    sar     ecx,16

    mov     ax,[TempX]
    mov     [word TempY],ax                  ; update y
    mov     bp,cx                       ; update z
                                        ; Y-rotation
                                        ; X :=  cos(vy) * xc + sin(vy) * zc
                                        ; Z := -sin(vy) * xc + cos(vy) * zc
    mov     di,[Yan]
    add     di,di                       ; si = angle y
    mov     ax,[Cosine+edi]              ; ax = cos(angle y)
    imul    bx                          ; ax = cos(angle y) * x
    mov     cx,dx
    shl     ecx,16
    mov     cx,ax                       ; store for later use
    mov     ax,[Sine+edi]                ; ax = sin(angle y)
    imul    bp                          ; ax = sin(angle y) * z
    shl     edx,16
    mov     dx,ax
    add     ecx,edx                     ; ci = ci+ax = cos(vy)*x + sin(vy)*z
    shl     ecx,2
    sar     ecx,16
    mov     [TempX],cx                  ; es = x-coordinate

    mov     ax,[Sine+edi]                ; ax = sin(angle y)
    neg     ax                          ; ax =-sin(angle y)
    imul    bx                          ; ax =-sin(angle y) * x
    mov     cx,dx
    shl     ecx,16
    mov     cx,ax
    mov     ax,[Cosine+edi]              ; ax = cos(angle y)
    imul    bp                          ; ax = cos(angle y) * z
    shl     edx,16
    mov     dx,ax
    add     ecx,edx                     ; cx = cx-ax = sin(vy)*x - cos(vy)*z
    shl     ecx,2
    sar     ecx,16

    mov     bx,[TempX]                  ; update x
    mov     bp,cx                       ; update z
                                        ; Z-rotation
                                        ; X := cos(vz) * xc - sin(vz) * yc
                                        ; Y := sin(vz) * xc + cos(vz) * yc
    mov     di,[Zan]
    add     di,di                       ; si = angle z
    mov     ax,[Cosine+edi]              ; ax = cos(angle z)
    imul    bx                          ; ax = cos(angle z) * x
    mov     cx,dx
    shl     ecx,16
    mov     cx,ax
    mov     ax,[Sine+edi]                ; ax = sin(angle z)

    imul    [word TempY]                     ; ax = sin(angle z) * y
    shl     edx,16
    mov     dx,ax
    sub     ecx,edx                     ; cx = cx-ax = cos(vz)*x - sin(vz)*y
    shl     ecx,2
    sar     ecx,16
    mov     [TempX],cx                  ; es = x-coordinate

    mov     ax,[Sine+edi]                ; ax = sin(angle z)
    imul    bx                          ; ax = sin(angle z) * x
    mov     cx,dx
    shl     ecx,16
    mov     cx,ax
    mov     ax,[Cosine+edi]              ; ax = cos(angle z)
    imul    [word TempY]                     ; ax = cos(angle z) * y
    shl     edx,16
    mov     dx,ax
    add     ecx,edx                     ; cx = cx+ax = sin(vz)*x+cos(vz)*y
    shl     ecx,2
    sar     ecx,16
    mov     bx,[TempX]                  ; update x
    ret
;RotateXYZ  ENDP
;--------------------------------------------------------------------------
RotateBox:
    pushad          ;saves EVERYTHING (extended registers, too), except flags
    mov     edi,0   ;point counter
@@DoNextPoint:
    ;Input: BX= X CX= Y BP= Z
    ;OutPut:BX= X CX= Y BP= Z

    mov     bx,[XYZcord+X+edi]   ;load in cordinates to rotate
    mov     cx,[XYZcord+Y+edi]
    mov     bp,[XYZcord+Z+edi]
    push    edi
    call    RotateXYZ
    pop     edi

    mov     [RotCord+X],bx  ;save rotated cordinates IN A DIFFERENT PLACE
    mov     [RotCord+Y],cx
    add     bp,[Distance]
    mov     [RotCord+Z],bp

    push    edi
    call    DrawBox
    pop     edi

    add     edi,6  ;8            ;size of each entry
    cmp     edi,NumPts*6  ;8     ;are we done, yet?
    jb      @@DoNextPoint   ;No. Do another
    
    popad
    ret
;RotateBox ENDP

;--------------------------------------------------------------------------
DrawBox:
    pusha               ;saves only non extended registers

    mov     edi,[SCREENBUF]
    mov     esi,0
    xor     ecx,ecx
    movsx   ecx,[word RotCord+Z]
    mov     [Zoom],cx
    movsx   ebx,[word PreAddZ]
    add     ecx,ebx

    xor     eax,eax
    xor     edx,edx
    movsx   eax,[word RotCord+Y]
    add     ax,[PreAddY]
   
    cmp     cx,0
    je      DontDraw
    movsx   edx,ah
    sar     edx,8
    shl     eax,16
    idiv    ecx              ; the divide that you just can't get rid of
    sar     eax,8
    movsx   ebx,[word PostAddY]
    add     eax,ebx
    cmp     eax,SCREEN_HEIGHT
    jge     DontDraw
    cmp     eax,0
    jl      DontDraw
    imul    eax,SCREEN_WIDTH*SCREEN_MODE
    add     edi,eax

    xor     eax,eax
    xor     edx,edx
    movsx   eax,[word RotCord+X]
    add     ax,[PreAddX]
    movsx   edx,ah
    sar     edx,8
    shl     eax,16
    idiv    ecx              ;Aaarrrgghh! Another one!
    sar     eax,8
    movsx   ebx,[word PostAddY]
    add     eax,ebx
    cmp     eax,SCREEN_WIDTH
    jge     DontDraw
    cmp     eax,0
    jl      DontDraw
    imul    eax,SCREEN_MODE
    add     edi,eax
    mov     eax,$0ffffffff
    mov     ecx,0
	if (videomode=4)
    stosd
	elif (videomode=2)
	stosw
	endif
DontDraw:
    popa
    ret

;DrawBox     ENDP

;--------------------------------------------------------------------------


makewave:
	mov		ax,1
    mov     [P2Vel],ax

    xor     esi,esi
    mov     edi,XYZcord+X
    mov     eax,40
    push    eax
@yloop:
    movzx   edx,[word P1Vel]
    mov     ecx,40
@xloop:
    mov     esi,edx
    shl     esi,1
    movsx   eax,[word Sine+esi]
    movzx   esi,[word P2Vel]
    shl     esi,1
    movsx   ebx,[word Sine+esi]
    imul    eax,40
    shl     eax,2
    sar     eax,16
  push  edx
    imul    eax,ebx
  pop   edx
    shl     eax,2
    sar     eax,16
    mov     [edi+4],ax
    add     edi,6
    add     edx,6
    and     edx,$01ff   ;angle
    dec     ecx
    jnz     @xloop

    movzx   eax,[word P2Vel]
    add     eax,20
    and     eax,$1ff
    mov     [P2Vel],ax


    pop     eax
    dec     eax
    push    eax
    jnz     @yloop
    pop     eax


    movzx   edx,[word P1Vel]
    add     edx,4
    and     edx,$01ff
    mov     [P1Vel],dx
    ret

;--------------------------------------------------------------------------
AddAngles:
    pushad
    movsx    ax,[XanVel]
    add     [Xan],ax
    and     [word Xan],$1ff
    movsx    ax,[YanVel]
    add     [Yan],ax
    and     [word Yan],$1ff
    movsx    ax,[ZanVel]
    add     [Zan],ax
    and     [word Zan],$1ff
    popad
    ret
