#include "xboxSave.h"
#include <xtl.h>
#include <iostream>
#include <string>
#include <iomanip>
#include <sstream>
#include <list>
#include <errno.h>
#include <SDL.h>

// Write a SaveMeta.xbx file
void xbox_WriteSaveMeta(std::string path, std::string text);

// Get a unique save path for a save slot
std::string xbox_GetSavePath(std::string file, int slot);

string PATHSEP = "\\"; 

//
// xbox_WriteSaveMeta
//
void xbox_WriteSaveMeta(string path, string text)
{
    if(!path.size() || !text.size())
        return;

    string   filename = path + PATHSEP + "SaveMeta.xbx";
    ofstream metafile(filename.c_str());

    if(metafile.fail())
    {
        I_Error ("Failed to create %s save meta:\n%s",
               filename.c_str(), strerror (errno));
        return;
    }

    metafile << "Name=" << text;

    metafile.close();
}

//
// xbox_GetSavePath
//
string xbox_GetSavePath(string file, int slot)
{
    ostringstream path;
    DWORD         attrs;

    path << setiosflags(ios::right);
    path << setfill('0');

    path << "U:" << PATHSEP << setw(12) << slot;

    if((attrs = GetFileAttributes(path.str().c_str())) == INVALID_FILE_ATTRIBUTES)
    {
        if(!SUCCEEDED(CreateDirectory(path.str().c_str(), NULL)))
        {
            I_FatalError ("Failed to create %s directory:\n%s",
                           path.str().c_str(), strerror (errno));
        }

        xbox_WriteSaveMeta(path.str(), "Empty Slot");
    }
    else
    {
        if (!(attrs & FILE_ATTRIBUTE_DIRECTORY))
            I_FatalError ("%s must be a directory", path.str().c_str());
    }

    path << PATHSEP << file;

    return path.str();
}