#include <SDL.h>
#include "xboxJoy.h"

extern SDL_Joystick *js;
Uint8 *key2joy()
{
	Uint8 *keyboard;
	keyboard = SDL_GetKeyState(NULL);

	keyboard[SDLK_UP] = false;
	keyboard[SDLK_DOWN] = false;
	keyboard[SDLK_LEFT] = false;
	keyboard[SDLK_RIGHT] = false;
	keyboard[SDLK_SPACE] = false;
	keyboard[SDLK_PAGEUP] = false;
	keyboard[SDLK_PAGEDOWN] = false;
	keyboard[SDLK_F1] = false;
	keyboard[SDLK_F2] = false;
	keyboard[SDLK_F3] = false;
	keyboard[SDLK_F4] = false;
	keyboard[SDLK_F5] = false;
	keyboard[SDLK_m] = false;
	keyboard[SDLK_ESCAPE] = false;

	//Xbox Buttons
	if(SDL_JoystickGetButton(js, JOY_BTTN_LTRIG))
		keyboard[SDLK_F4] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_RTRIG))
		keyboard[SDLK_F5] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_BACK))
		keyboard[SDLK_ESCAPE] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_Y))
		keyboard[SDLK_F1] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_X))
		keyboard[SDLK_m] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_B))
		keyboard[SDLK_F3] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_A))
		keyboard[SDLK_SPACE] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_WHITE))
		keyboard[SDLK_PAGEUP] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_BLACK))
		keyboard[SDLK_PAGEDOWN] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_START))
		keyboard[SDLK_F2] = SDL_PRESSED;

    //Xbox Joystick
	if(SDL_JoystickGetAxis(js, JOY_AXIS_LX) < -JOY_DEADZONE)
		keyboard[SDLK_LEFT] = SDL_PRESSED;
	if(SDL_JoystickGetAxis(js, JOY_AXIS_LX) > JOY_DEADZONE)
		keyboard[SDLK_RIGHT] = SDL_PRESSED;
	if(SDL_JoystickGetAxis(js, JOY_AXIS_LY) < -JOY_DEADZONE)
		keyboard[SDLK_UP] = SDL_PRESSED;
	if(SDL_JoystickGetAxis(js, JOY_AXIS_LY) > JOY_DEADZONE)
		keyboard[SDLK_DOWN] = SDL_PRESSED;

	//Xbox DPAD
	switch(SDL_JoystickGetHat(js, 0))
	{
	case SDL_HAT_UP:
		keyboard[SDLK_UP] = SDL_PRESSED;
		break;
	case SDL_HAT_DOWN:
		keyboard[SDLK_DOWN] = SDL_PRESSED;
		break;
	case SDL_HAT_LEFT:
	case SDL_HAT_LEFTUP:
	case SDL_HAT_LEFTDOWN:
		keyboard[SDLK_LEFT] = SDL_PRESSED;
		break;
	case SDL_HAT_RIGHT:
	case SDL_HAT_RIGHTUP:
	case SDL_HAT_RIGHTDOWN:
		keyboard[SDLK_RIGHT] = SDL_PRESSED;
		break;
	default:
		break;
	}
	return keyboard;
}