/*

    Zelda Time to Triumph

    Copyright (C) 2007-2009  Vincent Jouillat

    Please send bug reports with examples or suggestions to www.zeldaroth.fr

*/

#ifndef __KEYBOARD_H__
#define __KEYBOARD_H__

#include "Carte.h"
#include "Encyclopedie.h"
#include "Poissons.h"

//Xbox Joy Deadzone
#define JOY_DEADZONE 3200

////////////////////
//Our Xbox buttons//
////////////////////
enum
{
    JOY_BTTN_A = 0,
    JOY_BTTN_B,
    JOY_BTTN_X,
    JOY_BTTN_Y,
	JOY_BTTN_BLACK,
    JOY_BTTN_WHITE,
	JOY_BTTN_LTRIG,
    JOY_BTTN_RTRIG,
    JOY_BTTN_START,
    JOY_BTTN_BACK,
	JOY_BTTN_LSTICK,
    JOY_BTTN_RSTICK,
	JOY_BTTN_TOTAL
};

//////////////////////
//Our Xbox joystick //
//////////////////////
enum
{
    JOY_AXIS_LX = 0,
    JOY_AXIS_LY,
    JOY_AXIS_RX,
    JOY_AXIS_RY,
    JOY_AXIS_TOTAL
};

class Keyboard {

public :

        Keyboard(Jeu* jeu, Carte* carte, Encyclopedie* encycl, Poissons* poissons,
            SDL_Surface* screen, int m, bool e);
        int gererClavier();
        int getMode();
        void setMode(int i);
        int getLigne();
        int getColonne();
        int getSave(int i);
        void setSave(int i, int val);
        int getLigneOption();
        int getVolume();
        int getVolson();
        int getLigneRecord();
        int getColonneRecord();
        int getTemps();
        void setTemps(int t);
        int getRang(int i);
        void setRang(int i);
        int getLigneVal();
        int getIntro();
        int getTelep();
        void setTelep(int i);
        void saveP();
        Carte* getCarte();
        int attendEntreeOuTemps(Uint32 t);
        int isFullScreen();

private :

        void loadP();
        void loadOldP();
        int pollKey(Uint8* keys);
        void pollKeys(Uint8* keys);
        void toggleFullScreen();
        Jeu* gpJeu;
        Carte* gpCarte;
        Encyclopedie* gpEncyclopedie;
        Poissons* gpPoissons;
        int mode;
        int gFullScreen;
        SDL_Surface* gpScreen;
        int tmp;
        int tmpx;
        int tmpc;
        int tmpw;
        int tmpt;
        int tmpp;
        int tmpm;
        int tmpo;
        int tmptp;
        int tmpl;
        int tmpi;
        int ligne;
        int colonne;
        int save[3];
        int ligneOption;
        int volume;
        int volson;
        int ligneRecord;
        int colonneRecord;
        int temps;
        int rang[9];
        int ligneVal;
        int intro;
        int telep;
        bool etire;
        SDL_Event event;
        Uint8* keys;

//Xbox
public:

	      SDL_Joystick *JOYPAD;
		  int XBUTTON, XPAD, XJOY, XAXIS, YAXIS, LXAXIS, LYAXIS, oldLYAXIS, oldLAXIS;
		  bool readSign;
		  int tempPress;

   	
        
};

#endif  // Keyboard.h
