/*

    Zelda Time to Triumph

    Copyright (C) 2007-2009  Vincent Jouillat

    Please send bug reports with examples or suggestions to www.zeldaroth.fr

*/

#include <sstream>
#include <fstream>
#include <iostream>

#include <SDL.h>

#include "Audio.h"

Audio::Audio() : musiqueId(0), specialId(0) {
    SOUND = true;
    music = NULL;

    if(SDL_InitSubSystem(SDL_INIT_AUDIO) == -1) SOUND = false;

    if (SOUND) {
        Mix_OpenAudio(44100, AUDIO_S16SYS, 2, 2048);
        previous_volume = Mix_VolumeMusic(32);
        loadSounds();
        setVolson(32);
    }
}

Audio::~Audio() {
    if (SOUND) {
        freeSounds();
        Mix_PauseMusic();
        Mix_VolumeMusic(previous_volume);
        Mix_HaltMusic();
        Mix_FreeMusic(music);
        Mix_CloseAudio();
    }
}

void Audio::setVolume(int volume) {
    if (SOUND) Mix_VolumeMusic(volume);
}

void Audio::setVolson(int volson) {
    if (SOUND) for (int i = 0; i < 44; i++) Mix_VolumeChunk(sons[i], volson);
}

void Audio::loadSounds() {
    sons = new Mix_Chunk*[44];

    sons[0] = Mix_LoadWAV("D:\\data\\sound\\text.ogg"); // lettres
    sons[1] = Mix_LoadWAV("D:\\data\\sound\\menu1.ogg"); // menu 1
    sons[2] = Mix_LoadWAV("D:\\data\\sound\\menu2.ogg"); // menu 2
    sons[3] = Mix_LoadWAV("D:\\data\\sound\\menu3.ogg"); // menu 3
    sons[4] = Mix_LoadWAV("D:\\data\\sound\\menu4.ogg"); // menu 4
    sons[5] = Mix_LoadWAV("D:\\data\\sound\\timewarp.ogg"); // time retour
    sons[6] = Mix_LoadWAV("D:\\data\\sound\\tombe.ogg"); // tombe (ennemi)
    sons[7] = Mix_LoadWAV("D:\\data\\sound\\hitenemy.ogg"); //shot 1
    sons[8] = Mix_LoadWAV("D:\\data\\sound\\killenemy.ogg"); // shot 2
    sons[9] = Mix_LoadWAV("D:\\data\\sound\\surprise.ogg"); // surprise
    sons[10] = Mix_LoadWAV("D:\\data\\sound\\monte.ogg"); // monte
    sons[11] = Mix_LoadWAV("D:\\data\\sound\\descend.ogg"); // descend
    sons[12] = Mix_LoadWAV("D:\\data\\sound\\chute.ogg"); // chute
    sons[13] = Mix_LoadWAV("D:\\data\\sound\\item.ogg"); // item
    sons[14] = Mix_LoadWAV("D:\\data\\sound\\rupee.ogg"); // rubis
    sons[15] = Mix_LoadWAV("D:\\data\\sound\\heart.ogg"); // coeur
    sons[16] = Mix_LoadWAV("D:\\data\\sound\\bomb.ogg"); // bombe
    sons[17] = Mix_LoadWAV("D:\\data\\sound\\textnext.ogg"); // suite texte
    sons[18] = Mix_LoadWAV("D:\\data\\sound\\textend.ogg"); // fin texte
    sons[19] = Mix_LoadWAV("D:\\data\\sound\\happy.ogg"); // trouve objet
    sons[20] = Mix_LoadWAV("D:\\data\\sound\\door.ogg"); // ouvre porte
    sons[21] = Mix_LoadWAV("D:\\data\\sound\\pics.ogg"); // pics contre mur
    sons[22] = Mix_LoadWAV("D:\\data\\sound\\sword.ogg"); // Epe
    sons[23] = Mix_LoadWAV("D:\\data\\sound\\SwordCharging.ogg"); // charge
    sons[24] = Mix_LoadWAV("D:\\data\\sound\\Sword360.ogg"); // spin
    sons[25] = Mix_LoadWAV("D:\\data\\sound\\shoot.ogg"); // flche
    sons[26] = Mix_LoadWAV("D:\\data\\sound\\hookshot.ogg"); // grappin
    sons[27] = Mix_LoadWAV("D:\\data\\sound\\stamp.ogg"); // pose bombe
    sons[28] = Mix_LoadWAV("D:\\data\\sound\\magic.ogg"); // magie
    sons[29] = Mix_LoadWAV("D:\\data\\sound\\burn.ogg"); // br˚le
    sons[30] = Mix_LoadWAV("D:\\data\\sound\\hammer.ogg"); // marteau
    sons[31] = Mix_LoadWAV("D:\\data\\sound\\plouf.ogg"); // plouf
    sons[32] = Mix_LoadWAV("D:\\data\\sound\\danger.ogg"); // danger
    sons[33] = Mix_LoadWAV("D:\\data\\sound\\hurt.ogg"); // link se blesse
    sons[34] = Mix_LoadWAV("D:\\data\\sound\\porte.ogg"); // porte objet
    sons[35] = Mix_LoadWAV("D:\\data\\sound\\lance.ogg"); // lance objet
    sons[36] = Mix_LoadWAV("D:\\data\\sound\\casse.ogg"); // casse objet
    sons[37] = Mix_LoadWAV("D:\\data\\sound\\charge.ogg"); // charge magie
    sons[38] = Mix_LoadWAV("D:\\data\\sound\\buisson.ogg"); // coupe buisson
    sons[39] = Mix_LoadWAV("D:\\data\\sound\\pousse.ogg"); // pousse caisse
	sons[40] = Mix_LoadWAV("D:\\data\\sound\\envol.ogg"); // chant envol
    sons[41] = Mix_LoadWAV("D:\\data\\sound\\inverse.ogg"); // hymne vide
    sons[42] = Mix_LoadWAV("D:\\data\\sound\\accelere.ogg"); // chant esprit
    sons[43] = Mix_LoadWAV("D:\\data\\sound\\splash.ogg"); // ...
}

void Audio::freeSounds() {
    if (SOUND) {
        for (int i = 0; i < 44; i++) Mix_FreeChunk(sons[i]);
        delete[] sons;
    }
}

void Audio::playSound(int id, int chl) {
    if (SOUND) Mix_PlayChannel(chl,sons[id],0);
}

void Audio::stopSound() {
    if (SOUND) {if (SOUND) Mix_HaltChannel(-1); musiqueId=0;}
}

void Audio::playMusic(int id) {
    if (SOUND) {
	if (id == 2 || id == 5 || id == 7 || id == 8 || id == 9 || id == 14) id = 1;
        if (id == 20 || id == 22 || id == 24) id = 17;
        if (id == 29) id = 19;
        if (id == 32 || id == 34 || id == 35 || id == 39 || id == 44) id = 31;
        if (id >= 61 && id <= 78) id = 61;
        if (id == 82 || id == 84 || id == 94 || id == 98 || id == 99
        || id == 101 || id == 107 || id == 108 || id == 109 || id == 112
        || id == 117 || id == 118 || id == 122 || id == 128 || id == 129
        || id == 142 || id == 143 || id == 148 || id == 149) id = 81; //magasins
        if (id == 91 || id == 120 || id == 132) id = 85; //potions
        if (id == 102 || id == 136) id = 80; //bar
        if (id == 105 || id == 106 || id == 131 || id == 139 || id == 147) id = 95; //maire
        if (id == 152 || id == 153) id = 151; //temple temps
        if (musiqueId != id) {
	    musiqueId = id;
            if (specialId == 0) {
		Mix_HaltMusic();
		Mix_FreeMusic(music);
		music = choixMusique(id);
		Mix_PlayMusic(music,-1);
		specialId = 0;
	    }
        }
    }
}

bool Audio::isSpecial() {return (specialId>0);}

void Audio::stopMusic() {
    if (SOUND) Mix_HaltMusic();
}

void Audio::replayMusic() {
    if (SOUND) Mix_PlayMusic(music,-1);
}

Mix_Music* Audio::choixMusique(int id) {
    switch (id) {
	case 1 : case 2 : case 7 : return Mix_LoadMUS("D:\\data\\music\\PlaineP.ogg");
        case 3 : return Mix_LoadMUS("D:\\data\\music\\VilleCP.ogg");
        case 4 : return Mix_LoadMUS("D:\\data\\music\\TerresS.ogg");
        case 6 : return Mix_LoadMUS("D:\\data\\music\\BoisPerdus.ogg");
        case 8 : return Mix_LoadMUS("D:\\data\\music\\CimetiereP.ogg");
        case 10 : return Mix_LoadMUS("D:\\data\\music\\VillageMP.ogg");
        case 11 : return Mix_LoadMUS("D:\\data\\music\\LacP.ogg");
        case 12 : return Mix_LoadMUS("D:\\data\\music\\DesertP.ogg");
        case 13 : return Mix_LoadMUS("D:\\data\\music\\Cocorico.ogg");
        case 15 : return Mix_LoadMUS("D:\\data\\music\\MontP.ogg");
        case 16 : return Mix_LoadMUS("D:\\data\\music\\Foret.ogg");
        case 17 : return Mix_LoadMUS("D:\\data\\music\\Plaine.ogg");
        case 18 : return Mix_LoadMUS("D:\\data\\music\\Cite.ogg");
        case 19 : return Mix_LoadMUS("D:\\data\\music\\Chateau.ogg");
        case 21 : return Mix_LoadMUS("D:\\data\\music\\Lanelle.ogg");
        case 23 : return Mix_LoadMUS("D:\\data\\music\\Cimetiere.ogg");
        case 25 : return Mix_LoadMUS("D:\\data\\music\\VillageM.ogg");
        case 26 : return Mix_LoadMUS("D:\\data\\music\\Lac.ogg");
        case 27 : return Mix_LoadMUS("D:\\data\\music\\Desert.ogg");
        case 28 : return Mix_LoadMUS("D:\\data\\music\\VillageO.ogg");
        case 30 : return Mix_LoadMUS("D:\\data\\music\\Mont.ogg");
        case 31 : case 32 : case 34 : case 35 :
            return Mix_LoadMUS("D:\\data\\music\\Ombre.ogg");
        case 33 : return Mix_LoadMUS("D:\\data\\music\\VilleF.ogg");
        case 36 : return Mix_LoadMUS("D:\\data\\music\\BoisPerdusF.ogg");
        case 37 : return Mix_LoadMUS("D:\\data\\music\\Cascades.ogg");
        case 38 : return Mix_LoadMUS("D:\\data\\music\\CimetiereF.ogg");
        case 40 : return Mix_LoadMUS("D:\\data\\music\\VillageMF.ogg");
        case 41 : return Mix_LoadMUS("D:\\data\\music\\LacF.ogg");
        case 42 : return Mix_LoadMUS("D:\\data\\music\\DesertF.ogg");
        case 43 : return Mix_LoadMUS("D:\\data\\music\\VillageOF.ogg");
        case 45 : return Mix_LoadMUS("D:\\data\\music\\MontF.ogg");
        case 46 : return Mix_LoadMUS("D:\\data\\music\\Courage.ogg");
        case 47 : return Mix_LoadMUS("D:\\data\\music\\Sagesse.ogg");
        case 48 : return Mix_LoadMUS("D:\\data\\music\\Force.ogg");
        case 49 : return Mix_LoadMUS("D:\\data\\music\\Abysses.ogg");
        case 50 : return Mix_LoadMUS("D:\\data\\music\\PyramideF.ogg");
        case 51 : return Mix_LoadMUS("D:\\data\\music\\PyramideP.ogg");
        case 52 : return Mix_LoadMUS("D:\\data\\music\\Ordinn.ogg");
        case 53 : return Mix_LoadMUS("D:\\data\\music\\Air.ogg");
        case 54 : return Mix_LoadMUS("D:\\data\\music\\Glace.ogg");
        case 55 : return Mix_LoadMUS("D:\\data\\music\\Feu.ogg");
        case 56 : return Mix_LoadMUS("D:\\data\\music\\Titre.ogg");
        case 57 : return Mix_LoadMUS("D:\\data\\music\\DFinal.ogg");
        case 58 : return Mix_LoadMUS("D:\\data\\music\\Casino.ogg");
        case 59 : return Mix_LoadMUS("D:\\data\\music\\Gemme.ogg");
        case 60 : return Mix_LoadMUS("D:\\data\\music\\DestinationF.ogg");
        case 61 : return Mix_LoadMUS("D:\\data\\music\\Cave.ogg");
        case 79 : return Mix_LoadMUS("D:\\data\\music\\Home.ogg");
        case 80 : return Mix_LoadMUS("D:\\data\\music\\Bar.ogg");
        case 81 : return Mix_LoadMUS("D:\\data\\music\\Magasin.ogg");
        case 83 : return Mix_LoadMUS("D:\\data\\music\\Maison.ogg");
        case 85 : return Mix_LoadMUS("D:\\data\\music\\Potion.ogg");
        case 89 : return Mix_LoadMUS("D:\\data\\music\\Jeu.ogg");
        case 95 : return Mix_LoadMUS("D:\\data\\music\\Maire.ogg");
        case 119 : return Mix_LoadMUS("D:\\data\\music\\Cafe.ogg");
        case 144 : return Mix_LoadMUS("D:\\data\\music\\Sages.ogg");
        case 150 : return Mix_LoadMUS("D:\\data\\music\\Opera.ogg");
        case 151 : return Mix_LoadMUS("D:\\data\\music\\Epee.ogg");
        case 154 : return Mix_LoadMUS("D:\\data\\music\\Prison.ogg");
        case 155 : return Mix_LoadMUS("D:\\data\\music\\ChateauF.ogg");
        case 218 : return Mix_LoadMUS("D:\\data\\music\\probleme.ogg");
        case 219 : return Mix_LoadMUS("D:\\data\\music\\Epee.ogg");
        case 180 : return Mix_LoadMUS("D:\\data\\music\\Titre.ogg");
        case 190 : return Mix_LoadMUS("D:\\data\\music\\Selection.ogg");
        case 199 : return Mix_LoadMUS("D:\\data\\music\\Nuit.ogg");
        case 200 : return Mix_LoadMUS("D:\\data\\music\\Debut.ogg");
        default : return Mix_LoadMUS("D:\\data\\music\\Maison.ogg");
    }
}

void Audio::playSpecial(int id) {
    if (SOUND) {
        if (specialId != id) {
            Mix_HaltMusic();
            Mix_FreeMusic(music);
            music = choixSpecial(id);
            Mix_PlayMusic(music,-1);
            specialId=id;
        }
    }
}

void Audio::stopSpecial() {
    if (!specialId) return;
    int tmp = musiqueId;
    musiqueId = 0;
    specialId = 0;
    playMusic(tmp);
}

Mix_Music* Audio::choixSpecial(int id) {
    switch (id) {
	case 1 : return Mix_LoadMUS("D:\\data\\music\\Boss.ogg");
        case 2 : return Mix_LoadMUS("D:\\data\\music\\Mort.ogg");
        case 3 : return Mix_LoadMUS("D:\\data\\music\\Epee.ogg");
        case 4 : return Mix_LoadMUS("D:\\data\\music\\BossF.ogg");
        case 5 : return Mix_LoadMUS("D:\\data\\music\\Fin.ogg");
        case 6 : return Mix_LoadMUS("D:\\data\\music\\BossM.ogg");
        case 7 : return Mix_LoadMUS("D:\\data\\music\\Area81.ogg");
        case 8 : return Mix_LoadMUS("D:\\data\\music\\OniLink.ogg");
        case 9 : return Mix_LoadMUS("D:\\data\\music\\probleme.ogg");
        case 10 : return Mix_LoadMUS("D:\\data\\music\\Harpie.ogg");
        case 11 : return Mix_LoadMUS("D:\\data\\music\\Crabe.ogg");
        case 12 : return Mix_LoadMUS("D:\\data\\music\\Imp.ogg");
        case 13 : return Mix_LoadMUS("D:\\data\\music\\Masamune.ogg");
        case 14 : return Mix_LoadMUS("D:\\data\\music\\ZoraS.ogg");
        case 15 : return Mix_LoadMUS("D:\\data\\music\\Marlag.ogg");
        case 16 : return Mix_LoadMUS("D:\\data\\music\\Fantomas.ogg");
        case 17 : return Mix_LoadMUS("D:\\data\\music\\Vampire.ogg");
        case 18 : return Mix_LoadMUS("D:\\data\\music\\Araignee.ogg");
        case 19 : return Mix_LoadMUS("D:\\data\\music\\Plumes.ogg");
        case 20 : return Mix_LoadMUS("D:\\data\\music\\Garuda.ogg");
        case 21 : return Mix_LoadMUS("D:\\data\\music\\Heckran.ogg");
        case 22 : return Mix_LoadMUS("D:\\data\\music\\Sun.ogg");
        case 23 : return Mix_LoadMUS("D:\\data\\music\\Orcus.ogg");
        case 24 : return Mix_LoadMUS("D:\\data\\music\\Agahnim.ogg");
        case 25 : return Mix_LoadMUS("D:\\data\\music\\Zelda.ogg");
        case 26 : return Mix_LoadMUS("D:\\data\\music\\AgahnimFinal.ogg");
        case 27 : return Mix_LoadMUS("D:\\data\\music\\GanondorfFinal.ogg");
        case 28 : return Mix_LoadMUS("D:\\data\\music\\Quizz.ogg");
        case 29 : return Mix_LoadMUS("D:\\data\\music\\FinalBattle.ogg");
        default : return Mix_LoadMUS("D:\\data\\music\\Boss.ogg");
    }
}

