/*

    Zelda Time to Triumph

    Copyright (C) 2007-2009  Vincent Jouillat

    Please send bug reports with examples or suggestions to www.zeldaroth.fr

*/

#include <SDL.h>
#include <SDL_image.h>

#include "Texte.h"
#include "Menu.h"
#include "Joueur.h"
#include "Monde.h"
#include "Projectile.h"
#include "Jeu.h"
#include "Keyboard.h"

Texte::Texte(Jeu* jeu) : gpJeu(jeu), vitesse(40), av(0), x(0), y(0), w(0), h(0),
id(0), idsuiv(0), def(false), cadre(false), texte(""), buffer("") {
    lastAnimTime = SDL_GetTicks();
    imageFont = IMG_Load("D:\\data\\images\\texte\\font.png");
    SDL_SetColorKey(imageFont,SDL_SRCCOLORKEY,SDL_MapRGB(imageFont->format,0,0,255));
    imageCoeur = IMG_Load("D:\\data\\images\\menu\\coeur.png");
    SDL_SetColorKey(imageCoeur,SDL_SRCCOLORKEY,SDL_MapRGB(imageCoeur->format,0,0,255));
}

Texte::~Texte() {
    SDL_FreeSurface(imageFont);
    SDL_FreeSurface(imageCoeur);
}

void Texte::chercheText() {
    ostringstream os;
    ostringstream os2;
    int tmp;
    switch (id) {
        case 1 : texte = "This is a trade item ... **Find the right person to trade it to ..."; break;
        case 2 : texte = "You can't fish here. You must locate a pontoon..."; break;
        case 3 : 
            tmp = 4-(gpJeu->getJoueur()->nbQuarts()%4);
            os << tmp;
            texte = "You found a piece of Heart!!!";
            if (tmp<4) buffer = "Collect "+os.str()+" more to form a complete heart!!!";
            else buffer = "You've gained one heart level!!!";
            break;
        case 4 : texte = "You really enjoy talking to trees, don't you?"; break;
        case 5 : texte = "Link's house**Don't come any closer."; break;
        case 6 : texte = "North: Kakariko Village"; break;
        case 7 : texte = "East : Hyrule City"; break;
        case 8 : texte = "...you caught nothing."; break;
        case 9 : texte = "You caught a crawfish!"; break;
        case 10 : texte = "You caught a smelt!"; break;
        case 11 : texte = "You caught a zebrafish!"; break;
        case 12 : texte = "You caught a goby!"; break;
        case 13 : texte = "You caught a crab!"; break;
        case 14 : texte = "You caught an eel larvae!"; break;
        case 15 : texte = "You caught a minnow!"; break;
        case 16 : texte = "You caught a goldfish!"; break;
        case 17 : texte = "You caught a bleak!"; break;
        case 18 : texte = "You caught a gudgeon!"; break;
        case 19 : texte = "You caught a loach!"; break;
        case 20 : texte = "You caught a stickleback!"; break;
        case 21 : texte = "You caught a ruffe!"; break;
        case 22 : texte = "You caught a blenny!"; break;
        case 23 : texte = "You caught a magikarp!"; buffer="It had no effect..."; break;
        case 24 : texte = "You caught a trout!*It's a big fish!"; break;
        case 25 : texte = "You caught an ayu!*It's a big fish!"; break;
        case 26 : texte = "You caught a black perch!*It's a big fish!"; break;
        case 27 : texte = "You caught an eel!*It's a big fish!"; break;
        case 28 : texte = "You caught a catfish!*It's a big fish!"; break;
        case 29 : texte = "You caught a largemouth bass!*It's a big fish!"; break;
        case 30 : texte = "You caught a huchen!*It's a big fish!"; break;
        case 31 : texte = "You caught a barbell!*It's a big fish!"; break;
        case 32 : texte = "You caught a lamprey!*It's a big fish!"; break;
        case 33 : texte = "You caught a nase!*It's a big fish!"; break;
        case 34 : texte = "You caught a salmon!*This fish is huge!"; break;
        case 35 : texte = "You caught a sturgeon!*This fish is huge!"; break;
        case 36 : texte = "You caught an arctic charr!*This fish is huge!"; break;
        case 37 : texte = "You caught a carp!*This fish is huge!"; break;
        case 38 : texte = "You caught a brown bullhead!*This fish is huge!"; break;
        case 39 : texte = "You have found a power gem!"; break;
        case 40 : 
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_GARDE_DEVANT_CHEZ_LINK) {id=44; chercheText();break;}
            texte = "Good morning sir Link!*You look dreadful, were you asleep?"; idsuiv=41; break;
        case 41 : texte = "The princess wants to see you at the castle, it's urgent!"; idsuiv=42; break;
        case 42 : texte = "..."; idsuiv=43; break;
        case 43 : texte = "..."; idsuiv=44; break;
        case 44 : texte = "The castle is to the east, don't tell me you've forgotten?"; break;
        case 45 : texte = "Hem Hem ..."; idsuiv=46; break;
        case 46 : texte = "TUTORIAL : Press (B) near someone to talk with them, or in front of a sign to read it."; break;
        case 47 : texte = "You didn't learn any songs.";
            if (gpJeu->getJoueur()->hasMelodie(0)) {id=48; chercheText();break;}
            if (gpJeu->getJoueur()->hasMelodie(1)) {id=57; chercheText();break;}
            if (gpJeu->getJoueur()->hasMelodie(2)) {id=59; chercheText();break;}
            break;
        case 48 : texte = "- SONG OF SOARING*- Do not play";
            if (gpJeu->getJoueur()->hasMelodie(1)) {id=50; chercheText();break;}
            if (gpJeu->getJoueur()->hasMelodie(2)) {id=61; chercheText();break;}
            break;
        case 49 : texte = "- Song of Soaring*- DO NOT PLAY"; break;
        case 50 : texte = "- SONG OF SOARING*- Inverted Song of Time*- Do not play";
            if (gpJeu->getJoueur()->hasMelodie(2)) {id=53; chercheText();break;}
            break;
        case 51 : texte = "- Song of Soaring*- INVERTED SONG OF TIME*- Do not play"; break;
        case 52 : texte = "- Song of Soaring*- Inverted Song of Time*- DO NOT PLAY"; break;
        case 53 : texte = "- SONG OF SOARING*- Inverted Song of Time*- Song of Double Time*- Do not play"; break;
        case 54 : texte = "- Song of Soaring*- INVERTED SONG OF TIME*- Song of Double Time*- Do not play"; break;
        case 55 : texte = "- Song of Soaring*- Inverted Song of Time*- SONG OF DOUBLE TIME*- Do not play"; break;
        case 56 : texte = "- Song of Soaring*- Inverted Song of Time*- Song of Double Time*- DO NOT PLAY"; break;
        case 57 : texte = "- INVERTED SONG OF TIME*- Do not play";
            if (gpJeu->getJoueur()->hasMelodie(2)) {id=64; chercheText();break;}
            break;
        case 58 : texte = "- Inverted Song of Time*- DO NOT PLAY"; break;
        case 59 : texte = "- SONG OF DOUBLE TIME*- Do not play"; break;
        case 60 : texte = "- Song of Double Time*- DO NOT PLAY"; break;
        case 61 : texte = "- SONG OF SOARING*- Song of Double Time*- Do not play"; break;
        case 62 : texte = "- Song of Soaring*- SONG OF DOUBLE TIME*- Do not play"; break;
        case 63 : texte = "- Song of Soaring*- Song of Double Time*- DO NOT PLAY"; break;
        case 64 : texte = "- INVERTED SONG OF TIME*- Song of Double Time*- Do not play"; break;
        case 65 : texte = "- Inverted Song of Time*- SONG OF DOUBLE TIME*- Do not play"; break;
        case 66 : texte = "- Inverted Song of Time*- Song of Double Time*- DO NOT PLAY"; break;
        case 67 : texte = "No effect..."; break;
        case 68 : texte = "Link's estate*Private property"; break;
        case 69 : texte = "Welcome to Hyrule City"; break;
        case 70 : texte = "Looks like there are no fish in these waters..."; break;
        case 71 : texte = "North: Hyrule Castle"; break;
        case 72 : texte = "The castle is north of here, hurry!"; break;
        case 73 : texte = "The castle is on the other side of the bridge, hurry up!"; break;
        case 74 : texte = "The princess is waiting for you at the castle, north of here."; break;
        
        case 75 : texte = "You don't have enough."; break;
        case 76 : texte = "Come back if you change your mind."; break;
        case 77 : 
            if (gpJeu->getJoueur()->getTroc(M_ROUAGE)>-1) {id=80; chercheText();break;}
            texte = "A cogwheel for a chicken and 100 rupees?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<100
            || gpJeu->getJoueur()->getTroc(M_POULET)<1) idsuiv=75;
            break;
        case 78 : texte = "A cogwheel for a chicken and 100 rupees?**              yes              NO ?"; idsuiv=76; break;
        case 79 : texte = "You got a cogwheel!";
			      buffer= "Go and give it to the bridge operator near waterfall!"; break;
        case 80 : 
            if ((gpJeu->getJoueur()->getCoeur(14) && gpJeu->getZone()==18)
            || (gpJeu->getJoueur()->getCoeur(15) && gpJeu->getZone()==3)) {
                id=82; chercheText();break;}
            texte = "A piece of heart for a magma rock and a frosty rock?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_ROC_MAGMA)<1
            || gpJeu->getJoueur()->getTroc(M_ROC_GIVRE)<1) idsuiv=75;
            break;
        case 81 : texte = "A piece of heart for a magma rock and a frosty rock?*              yes              NO ?"; idsuiv=76; break;
        case 82 : texte = "Sorry, I have nothing in stock."; break;
        case 83 : 
            if (gpJeu->getJoueur()->getRubisMax()>=200) {id=86; chercheText();break;}
            texte = "A wallet able to hold up to 200 rupees for 1 feather and 10 rupees?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<10
            || gpJeu->getJoueur()->getTroc(M_PLUME)<1) idsuiv=75;
            break;
        case 84 : texte = "A wallet able to hold up to 200 rupees for 1 feather and 10 rupees?*              yes              NO ?"; idsuiv=76; break;
        case 85 : texte = "You got a regular sized wallet!";
			      buffer= "You can now hold up to 200 rupees!"; break;
        case 86 : 
            if (gpJeu->getJoueur()->getRubisMax()>=500) {id=89; chercheText();break;}
            texte = "A wallet able to hold up to 500 rupees for a tapestry and 100 rupees?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<100
            || gpJeu->getJoueur()->getTroc(M_TAPISSERIE)<1) idsuiv=75;
            break;
        case 87 : texte = "A wallet able to hold up to 500 rupees for a tapestry and 100 rupees?*              yes              NO ?"; idsuiv=76; break;
        case 88 : texte = "You got a big wallet!";
			      buffer= "You can now hold up to 500 rupees!!!"; break;
        case 89 : 
            if (gpJeu->getJoueur()->getRubisMax()==999) {id=82; chercheText();break;}
            texte = "A wallet able to hold up to 999 rupees for 1 amulet, 1 magma rock and 250 rupees?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<250
            || gpJeu->getJoueur()->getTroc(M_AMULETTE)<1
            || gpJeu->getJoueur()->getTroc(M_ROC_MAGMA)<1) idsuiv=75;
            break;
        case 90 : texte = "A wallet able to hold up to 999 rupees for 1 amulet, 1 magma rock and 250 rupees?*              yes              NO ?"; idsuiv=76; break;
        case 91 : texte = "You got a huge wallet!!!";
			      buffer= "You can now hold up to 999 rupees!!!"; break;
        case 92 : 
            texte = "A chicken for 2 bags of rice and 3 bags of olives?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_RIZ)<2
            || gpJeu->getJoueur()->getTroc(M_OLIVES)<3) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_POULET)>=99) idsuiv=95;
            break;
        case 93 : texte = "A chicken for 2 bags of rice and 3 bags of olives?**              yes              NO ?"; idsuiv=76; break;
        case 94 : texte = "You got a chicken!"; break;
        case 95 : texte = "You can't carry any more..."; break;
        case 96 : 
            texte = "A feather for 2 jars of spices and 2 bags of olives ?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_EPICES)<2
            || gpJeu->getJoueur()->getTroc(M_OLIVES)<2) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_PLUME)>=99) idsuiv=95;
            break;
        case 97 : texte = "A feather for 2 jars of spices and 2 bags of olives?*              yes              NO ?"; idsuiv=76; break;
        case 98 : texte = "You got a feather!"; break;
        case 99 : 
            texte = "A bag of rice for 15 rupees?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<15) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_RIZ)>=99) idsuiv=95;
            break;
        case 100 : texte = "A bag of rice for 15 rupees?**              yes              NO ?"; idsuiv=76; break;
        case 101 : texte = "You got a bag of rice!"; break;
        case 102 : 
            texte = "A bag of olives for 10 rupees?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<10) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_OLIVES)>=99) idsuiv=95;
            break;
        case 103 : texte = "A bag of olives for 10 rupees?**              yes              NO ?"; idsuiv=76; break;
        case 104 : texte = "You got a bag of olives!"; break;
        case 105 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)>2) {id=112; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)==2 
            && gpJeu->getJoueur()->getObjet()==15) {id=106; chercheText();break;}
            texte = "I feel like I've spent my entire life sweeping....";
			buffer ="One of these days I would like to go on a vacation..."; break;
        case 106 : texte = "Is this a map you have? *Do you mind giving it to me?";
			       buffer= "I have always dreamed of traveling and seeing wonderful things!"; idsuiv=107; break;
        case 107 : texte = "I will give you my broom in return, is it okay with you?*              YES ?            no  "; idsuiv=109; break;
        case 108 : texte = "I will give you my broom in return, is it okay with you?*              yes              NO ?"; idsuiv=110; break;
        case 109 : texte = "Thank you! Take my broom as a reward.";
			       buffer= "It's a first-class broom! It's been in my family for centuries, trust me, it's a very good deal!"; break;
        case 110 : texte = "Oh. If that's so I guess I just have to keep sweeping..."; break;
        case 111 : texte = "You traded the map for a broom!"; break;
        case 112 : texte = "So, where am I going?"; break;
        case 113 : texte = "Sometimes, in my dreams ...I eat them ...slowly roasted and dripping in ...";
			       buffer ="-cough cough- err, excuse me."; break;
        case 114 : texte = "This town is full of all kinds of shops, too bad none of them interest me..."; break;
        case 115 : texte = "Ever since peace was restored, princess Zelda has done so much for Hyrule.";
			       buffer= "The town would not be as prosperous without her."; break;
        case 116 : texte = "You should trade with merchants if you want rare objects, or ingredients needed for cooking."; break;
        case 117 : texte = "My mother always tells me not to get close the hens... But why?"; break;
        case 118 : texte = "The princess insists that we keep watch over the city... But everyone knows that Ganon is dead..."; break;
        case 119 : texte = "I would rather sleep in the castle, but instead I'm standing guard here..."; break;
        case 120 : texte = "Life in Hyrule is great now that Ganon is dead, thanks again Link!"; break;
        case 121 : texte = "Since the theft in the castle the princess has doubled the guard... and here I am, again..."; break;
        case 122 : texte = "''Join up,'' they said... ''It's a man's life,'' they said..."; break;
        case 123 : texte = "I heard that a very precious object was stolen from the castle, and ever since the princess has been a paranoid mess...";
            buffer="It must of been something she really adored ... A mirror from her collection perhaps? ..."; break;
        case 124 : texte = "Zzzzz... Zzzzz..."; break;
        case 125 : texte = "North: Ganon Castle"; break;
        case 126 : 
            if (gpJeu->getJoueur()->hasObjet(O_PERLE)) {id=82; chercheText();break;}
            texte = "The Moon Pearl for a wheel, a gauge, an energy core and 100 Gold Ganon?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<100
            || gpJeu->getJoueur()->getTroc(M_ROUE)<1
            || gpJeu->getJoueur()->getTroc(M_JAUGE)<1
            || gpJeu->getJoueur()->getTroc(M_SOURCE_ENERGIE)<1) idsuiv=75;
            break;
        case 127 : texte = "The Moon Pearl for a wheel, a gauge, an energy core and 100 Gold Ganon?*              yes              NO ?"; idsuiv=76; break;
        case 128 : texte = "You got the Moon Pearl!";
			       buffer= "You regain your normal form, and the use of your weapons!"; break;
        case 129 : 
            if (gpJeu->getJoueur()->getGanonMax()>=200) {id=132; chercheText();break;}
            texte = "A wallet able to hold up to 200 Gold Ganon for a pearl and 10 Gold Ganon?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<10
            || gpJeu->getJoueur()->getTroc(M_PERLES)<1) idsuiv=75;
            break;
        case 130 : texte = "A wallet able to hold up to 200 Gold Ganon for a pearl and 10 Gold Ganon?*              yes              NO ?"; idsuiv=76; break;
        case 131 : texte = "You got a regular sized wallet!";
			       buffer= "You can now hold up to 200 Gold Ganon!"; break;
        case 132 : 
            if (gpJeu->getJoueur()->getGanonMax()>=500) {id=135; chercheText();break;}
            texte = "A wallet able to hold up to 500 Gold Ganon for an amulet and 100 Gold Ganon?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<100
            || gpJeu->getJoueur()->getTroc(M_AMULETTE)<1) idsuiv=75;
            break;
        case 133 : texte = "A wallet able to hold up to 500 Gold Ganon for an amulet and 100 Gold Ganon?*              yes              NO ?"; idsuiv=76; break;
        case 134 : texte = "You got a big wallet!";
			       buffer= "You can now hold up to 500 Gold Ganon!!!"; break;
        case 135 : 
            if (gpJeu->getJoueur()->getGanonMax()==999) {id=82; chercheText();break;}
            texte = "A wallet able to hold up to 999 Gold Ganon for a perfume, a frosty rock and 250 Gold Ganon?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<250
            || gpJeu->getJoueur()->getTroc(M_PARFUM)<1
            || gpJeu->getJoueur()->getTroc(M_ROC_GIVRE)<1) idsuiv=75;
            break;
        case 136 : texte = "A wallet able to hold up to 999 Gold Ganon for a perfume, a frosty rock and 250 Gold Ganon?*              yes              NO ?"; idsuiv=76; break;
        case 137 : texte = "You got a huge wallet!!!";
			       buffer= "You can now hold up to 999 Gold Ganon!!!"; break;
        case 138 : 
            if (gpJeu->getJoueur()->getTroc(M_ROUE)>-1) {id=141; chercheText();break;}
            texte = "A wheel for 3 jars of spices?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_EPICES)<3) idsuiv=75;
            break;
        case 139 : texte = "A wheel for 3 jars of spices?**              yes              NO ?"; idsuiv=76; break;
        case 140 : texte = "You got a wheel!"; break;
        case 141 : 
            if (gpJeu->getJoueur()->hasObjet(O_SAC_BOMBES)) {id=82; chercheText();break;}
            texte = "A bomb bag for 1 pepper and 3 jars of spices?**             YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_POIVRON)<1
            || gpJeu->getJoueur()->getTroc(M_EPICES)<3) idsuiv=75;
            break;
        case 142 : texte = "A bomb bag for 1 pepper and 3 jars of spices?**             yes              NO ?"; idsuiv=76; break;
        case 143 : texte = "You got a bomb bag!";
			       buffer= "You can now blast your way through walls and brittle stones!"; break;
        case 144 : 
            texte = "A magma rock for a tapestry, an amulet and a perfume?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_TAPISSERIE)<1
            || gpJeu->getJoueur()->getTroc(M_AMULETTE)<1
            || gpJeu->getJoueur()->getTroc(M_PARFUM)<1) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_ROC_MAGMA)>=99) idsuiv=95;
            break;
        case 145 : texte = "A magma rock for a tapestry, an amulet and a perfume?*              yes              NO ?"; idsuiv=76; break;
        case 146 : texte = "You got a magma rock!"; break;
        case 147 : 
            texte = "A pearl for 5 jars of spices and 5 Gold Ganon? *              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<5
            || gpJeu->getJoueur()->getTroc(M_EPICES)<5) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_PERLES)>=99) idsuiv=95;
            break;
        case 148 : texte = "A pearl for 5 jars of spices and 5 Gold Ganon? *              yes              NO ?"; idsuiv=76; break;
        case 149 : texte = "You got a pearl!"; break;
        case 150 : 
            texte = "A jar of spices for 10 Gold Ganon?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<10) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_EPICES)>=99) idsuiv=95;
            break;
        case 151 : texte = "A jar of spices for 10 Gold Ganon?**              yes              NO ?"; idsuiv=76; break;
        case 152 : texte = "You got a jar of spice!"; break;
        case 153 : texte = "He! Heeeee! Heeeeeeee!"; break;
        case 154 : texte = "Last night the bartender ran out of beer... Ganon turned red with rage and started to destroy everything..."; buffer="In the end...we are all without beer..."; break;
        case 155 : texte = "The houses that are destroyed used to belong to opponents of Ganon..."; 
            buffer="The bar was destroyed too, but... ummm ...for other reasons..."; break;
        case 156 : texte = "Now that the bar is ruined, the market place is the main attraction of the city..."; break;
        case 157 : 
            if (gpJeu->getJoueur()->hasObjet(O_PERLE)) texte = "You got the Moon Pearl? *Hmmmmmm, now that I've had a look at you, I'm thinking it wasn't such a good deal...";
            else texte = "The Moon Pearl helps you regain human form. I heard a merchant has one, but it's far too expensive..."; break;
        case 158 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "North: Holy Lands - Camping Prohibited!"; break;
        case 159 : 
            if (gpJeu->getJoueur()->getPieceMax()>=200) {id=162; chercheText();break;}
            texte = "A wallet able to hold up to 200 Gold coins for a chicken and 10 Gold coins?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<10
            || gpJeu->getJoueur()->getTroc(M_POULET)<1) idsuiv=75;
            break;
        case 160 : texte = "A wallet able to hold up to 200 Gold coins for a chicken and 10 Gold coins?*              yes              NO ?"; idsuiv=76; break;
        case 161 : texte = "You got a regular sized wallet!";
			       buffer= "You can now hold up to 200 Gold coins!"; break;
        case 162 : 
            if (gpJeu->getJoueur()->getPieceMax()>=500) {id=165; chercheText();break;}
            texte = "A wallet able to hold up to 500 Gold coins for a perfume and 100 Gold coins?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<100
            || gpJeu->getJoueur()->getTroc(M_PARFUM)<1) idsuiv=75;
            break;
        case 163 : texte = "A wallet able to hold up to 500 Gold coins for a perfume and 100 Gold coins?*              yes              NO ?"; idsuiv=76; break;
        case 164 : texte = "You got a big wallet!";
			       buffer= "You can now hold up to 500 Gold coins!!!"; break;
        case 165 : 
            if (gpJeu->getJoueur()->getPieceMax()==999) {id=82; chercheText();break;}
            texte = "A wallet able to hold up to 999 Gold coins for a tapestry, a magma rock and 250 Gold coins?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<250
            || gpJeu->getJoueur()->getTroc(M_TAPISSERIE)<1
            || gpJeu->getJoueur()->getTroc(M_ROC_MAGMA)<1) idsuiv=75;
            break;
        case 166 : texte = "A wallet able to hold up to 999 Gold coins for a tapestry, a magma rock and 250 Gold coins?*              yes              NO ?"; idsuiv=76; break;
        case 167 : texte = "You got a huge wallet!!!";
			       buffer= "You can now hold up to 999 Gold coins!!!"; break;
        case 168 : 
            texte = "An amulet for 1 chicken and 2 bags of olives?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_POULET)<1
            || gpJeu->getJoueur()->getTroc(M_OLIVES)<2) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_AMULETTE)>=99) idsuiv=95;
            break;
        case 169 : texte = "An amulet for 1 chicken and 2 bags of olives?*              yes              NO ?"; idsuiv=76; break;
        case 170 : texte = "You got an amulet!"; break;
        case 171 : 
            texte = "A feather for a jar of spices and a bag of olives?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_EPICES)<1
            || gpJeu->getJoueur()->getTroc(M_OLIVES)<1) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_PLUME)>=99) idsuiv=95;
            break;
        case 172 : texte = "A feather for a jar of spices and a bag of olives?*              yes              NO ?"; idsuiv=76; break;
        case 173 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "With all these wolves, it's very dangerous to leave the village..."; break;
        case 174 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "Your weapon looks like that of a Knights... *Did you ever fight wolves with it?"; break;
        case 175 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "I hate hens, but if the wolves manage to get into the village, maybe they'll protect me ..."; break;
        case 176 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "The torches at the village entry keep the wolves away, but still they come closer and closer every day..."; break;
        case 177 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "The mayor of the village recently had a bar built... They say that he did this to attract the Hylian Knights so they would protect us..."; break;
        case 178 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            if (!gpJeu->getJoueur()->getPieceMax()) {id=771; chercheText(); break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)>3) {id=185; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)==3 
            && gpJeu->getJoueur()->getObjet()==15) {id=179; chercheText();break;}
            texte = "Usually when I get bored, I make marmelade to keep me busy... But this season, I guess I will have to find another hobby..."; break;
        case 179 : texte = "Is that a broom you have? I hear a job calling me! ...";
			       buffer= "Will you trade it to me for my last marmelade jar?"; idsuiv=180; break;
        case 180 : texte = "This broom for a marmalade jar?**              YES ?            no  "; idsuiv=182; break;
        case 181 : texte = "This broom for a marmalade jar?**              yes              NO ?"; idsuiv=183; break;
        case 182 : texte = "Great! This will keep my mind free of all the worlds problems, and maybe it will even keep the wolves away!"; break;
        case 183 : texte = "Sooner or later, I'm sure you will give it to me..."; break;
        case 184 : texte = "You traded the broom for a marmalade jar!"; break;
        case 185 : texte = "Giving is giving!"; break;
        case 186 : texte = "Welcome to Hyrule Castle"; break;
        case 187 : texte = "North: The Graveyard"; break;
        case 188 : texte = "Welcome to the castle, Sir Link!"; break;
        case 189 : texte = "We have orders to let you pass."; break;
        case 190 : texte = "Welcome to Ganon Castle"; break;
        case 191 : 
            texte = "5 Gold Ganon and we let ya come'n go in the castle?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<5) idsuiv=75;
            break;
        case 192 : texte = "5 Gold Ganon and we let ya come'n go in the castle?*              yes              NO ?"; idsuiv=76; break;
        case 193 : texte = "Go on ahead... **-wink wink-"; break;
        case 194 : texte = "MAY THE WAY TO THE TRIFORCE BE OPENED FOR YOU...*SEE THE TEMPLE OF THE TRIFORCE APPEAR!"; break;
        case 195 : texte = "West: Hyrule Castle"; break;
        case 196 : texte = "North: The Waterfalls"; break;
        case 197 : texte = "East: The Lost Woods"; break;
        case 198 : 
            tmp = 6-(gpJeu->getJoueur()->nbCristaux());
            os << tmp;
            texte = "You found a magic crystal!!!";
            if (tmp>0) buffer = "There are still "+os.str()+" left to find!";
            else buffer = "Finally you've got them all!!!";
            break;
        case 199 : texte = "Do you want to save your game?**                    ? YES ?*                      no   "; break;
        case 200 : texte = "Do you want to save your game?**                      yes  *                    ? NO  ?"; break;
        case 201 : texte = "Game saved."; break;
        
        case 202 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)>6) {id=209; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==6 
            && gpJeu->getJoueur()->getObjet()==11) {id=203; chercheText();break;}
            texte = "I'm creating an opera here! I don't have time to talk!"; 
            buffer="What's more, I've lost my precious star accessory..."; break;
        case 203 : texte = "You found my fetish skull??? I forgot it in jail? I had no idea!";
			       buffer= "Give it back and I will be eternally grateful!"; idsuiv=204; break;
        case 204 : texte = "This skull for my gratefulness, ok?**              YES ?            no  "; idsuiv=206; break;
        case 205 : texte = "This skull for my gratefulness, ok?**              yes              NO ?"; idsuiv=207; break;
        case 206 : texte = "Thank you! I've regained my motivation! Now I will finish this opera!"; buffer="After a break..."; break;
        case 207 : texte = "Thief ..."; break;
        case 208 : texte = "You traded the skull for an IOU!"; break;
        case 209 : texte = "To be or not to be? that is the question..."; buffer="do I say it well ?"; break;
        case 210 : texte = "Temple of Courage ** - Those who fear, flee! -"; break;
        case 211 : texte = "Welcome to Tingle's place!"; break;
        case 212 : texte = "Temple of Air ** - The forcast calls for extreme wind! -"; break;
        case 213 : texte = "South: Mabe Village"; break;
        case 214 : texte = "Welcome to Mabe Village"; break;
        case 215 : 
            texte = "A tapestry for 2 pearls and 5 jars of spices? **              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_PERLES)<2
            || gpJeu->getJoueur()->getTroc(M_EPICES)<5) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_TAPISSERIE)>=99) idsuiv=95;
            break;
        case 216 : texte = "A tapestry for 2 pearls and 5 jars of spices? **              yes              NO ?"; idsuiv=76; break;
        case 217 : texte = "You got a tapestry!"; break;
        case 218 : 
            texte = "An amulet for 5 chickens and 5 bags of olives? *              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_POULET)<5
            || gpJeu->getJoueur()->getTroc(M_OLIVES)<5) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_AMULETTE)>=99) idsuiv=95;
            break;
        case 219 : texte = "An amulet for 5 chickens and 5 bags of olives? *              yes              NO ?"; idsuiv=76; break;
        case 220 : 
            texte = "A pearl for 2 jars of spices and 2 bags of rice?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_EPICES)<2
            || gpJeu->getJoueur()->getTroc(M_RIZ)<2) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_PERLES)>=99) idsuiv=95;
            break;
        case 221 : texte = "A pearl for 2 jars of spices and 2 bags of rice?*              yes              NO ?"; idsuiv=76; break;
        case 222 : 
            texte = "A bag of rice for a bag of olives and 2 rupees? *              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<2
            || gpJeu->getJoueur()->getTroc(M_OLIVES)<1) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_RIZ)>=99) idsuiv=95;
            break;
        case 223 : texte = "A bag of rice for a bag of olives and 2 rupees? *              yes              NO ?"; idsuiv=76; break;
        case 224 : 
            if (gpJeu->getJoueur()->hasObjet(O_CANNE)==0) 
                texte = "The men of the village are all obsessed with the fishing contest...*I wonder who the winner will be..."; 
            else if (gpJeu->getJoueur()->hasObjet(O_POISSONS)==0)
                {texte = "You're participating in the fishing contest too?*...*..."; buffer="In the end you're just like the others...";} 
            else {texte = "You won the fishing contest?*...*..."; buffer="I am your biggest fan!!!";}
            break;
        case 225 : 
			if (gpJeu->getJoueur()->hasObjet(O_CANNE)==0){ 
                texte = "A fishing shop has just opened on the west side of the village...";
				buffer= "The owner organized a fishing contest to mark the opening of his shop.";} 
            else if (gpJeu->getJoueur()->hasObjet(O_POISSONS)==0)
                {texte = "You're in the contest too? *...................";
			     buffer= "It's hopeless, you might as well quit... I can't find more than three types of fish.";} 
            else {texte = "Now that the fishing contest is over, everything is back to business as usual.";}
            break;
        case 226 : texte = "Ma e Vi l ge"; break;
        case 227 : 
            texte = "Hang-out of the Fearless Knights";
            if (gpJeu->getJoueur()->getAvancement()<GANON_CAPTURE)
            texte += "**NB : If we are not here, try the tavern."; break;
        case 228 :
            if (gpJeu->getJoueur()->getGemme(91)) {id=230; chercheText();break;}
            texte = "A power gem for 2 pearls?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_PERLES)<2) idsuiv=75;
            break;
        case 229 : texte = "A power gem for 2 pearls?**              yes              NO ?"; idsuiv=76; break;
        case 230 : 
            if (gpJeu->getJoueur()->getGemme(92)) {id=232; chercheText();break;}
            texte = "A power gem for 2 feathers?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_PLUME)<2) idsuiv=75;
            break;
        case 231 : texte = "A power gem for 2 feathers?**              yes              NO ?"; idsuiv=76; break;
        case 232 : 
            if (gpJeu->getJoueur()->getGemme(93)) {id=82; chercheText();break;}
            texte = "A power gem for 2 chickens?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_POULET)<2) idsuiv=75;
            break;
        case 233 : texte = "A power gem for 2 chickens?**              yes              NO ?"; idsuiv=76; break;
        case 234 : 
            texte = "A chicken for 1 bag of rice and 2 bags of olives? *              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_OLIVES)<2
            || gpJeu->getJoueur()->getTroc(M_RIZ)<1) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_POULET)>=99) idsuiv=95;
            break;
        case 235 : texte = "A chicken for 1 bag of rice and 2 bags of olives? *              yes              NO ?"; idsuiv=76; break;
        case 236 : texte = "Beyond Hyrule's South border, a gigantic ocean is said to exist..."; buffer="At the mating season the seagull's fly over the cliff that separates us from the seashore and come into the village."; break;
        case 237 : texte = "This village is under the protection of the Hylian Knights, you are safe here."; 
            if (gpJeu->getJoueur()->getAvancement()<GANON_CAPTURE) 
            buffer="Yet, since a tavern opened in the neighboring town, we don't see our protectors around anymore..."; break;
        case 238 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)>2) {id=245; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)==2 
            && gpJeu->getJoueur()->getObjet()==7) {id=239; chercheText();break;}
            texte = "Not here either? But where did I lose it?"; break;
        case 239 : texte = "You found my mother-in-law's vase??? *She's had me searching these waters for centuries!";
			       buffer= "Give it back right away!!! **I'll even give you this thing I found for it"; idsuiv=240; break;
        case 240 : texte = "This vase for a thing I found, ok?**              YES ?            no  "; idsuiv=242; break;
        case 241 : texte = "This vase for a thing I found, ok?**              yes              NO ?"; idsuiv=243; break;
        case 242 : texte = "Wise resolution kid."; break;
        case 243 : texte = "Have it your way! *......*......"; break;
        case 244 : texte = "You traded the boot for a hammer!"; break;
        case 245 : texte = "You wanna enter my gang?**              YES ?            no  "; idsuiv=247; break;
        case 246 : texte = "You wanna enter my gang?**              yes              NO ?"; idsuiv=243; break;
        case 247 : texte = "Ha! Ha! Ha! *I was kidding you pathetic little fool! *Do you realize who you're talking to?!?"; break;
        case 248 : texte = "Temple of Wisdom ** - You would be wise not to enter -"; break;
        case 249 : texte = "Mabe Village Boat Rentals"; break;
        case 250 : texte = "The shop is closed today, I'm about to win the fishing contest, I already have three types!"; break;
        case 251 : 
            if (gpJeu->getJoueur()->hasObjet(O_PALMES)) {texte="Some monsters sunk my boat... *Sorry, but you will have to swim from now on ....";break;}
            if (gpJeu->getJoueur()->hasObjet(O_BARQUE)) {id=253; chercheText();break;}
            texte = "Would you like to rent a boat for 15 rupees?**              YES ?            no  "; idsuiv=253;
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<15) idsuiv=75;
            break;
        case 252 : texte = "Would you like to rent a boat for 15 rupees?**              yes              NO ?"; idsuiv=76; break;
        case 253 : texte = "You can use the boat at the pontoon, have fun, but don't go too far."; break;
        case 254 : texte = "(Distant voice:) *I told you... DON'T GO TOO FAR!!!!"; break;
        case 255 : texte = "-Abyss Ruins -*I Thank you to not come looking for the descendant of the Wise Men who is not hiding here."; break;
        case 256 : texte = "Blacksmith"; break;
        case 257 : texte = "Great Pyramid"; break;
        case 258 : texte = "HINT 1: The right most stone is the second one. *HINT 2: The stones must all be removed in order by weight."; break;
        case 259 : texte = "HINT 3: The tail's stones must be removed before the fin's stones. *HINT 4: The eye's stone must be the fifth you remove."; break;
        case 260 : texte = "HINT 5: The water's stones must be removed before the last tail stone. *HINT 6: The eye's stone must be removed after the fin's stone."; break;
        case 261 : texte = "HINT 7: The last stone is not the eye. *HINT 8: The 2 stones of the tail must not be removed one after the other."; break;
        case 262 : texte = "HINT 9: One of the nine hints is a fake."; break;
        case 263 : texte = "North: Rocky Mountains"; break;
        case 264 : texte = "Welcome to Kakariko Village"; break;
        case 265 : 
            if (gpJeu->getJoueur()->hasObjet(O_BOTTES)) {id=82; chercheText();break;}
            texte = "The Pegasus boots for a tapestry and a perfume? *              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_TAPISSERIE)<1
            || gpJeu->getJoueur()->getTroc(M_PARFUM)<1) idsuiv=75;
            break;
        case 266 : texte = "The Pegasus boots for a tapestry and a perfume? *              yes              NO ?"; idsuiv=76; break;
        case 267 : texte = "You got the Pegasus boots!";
			       buffer= "You can now hold the RIGHT TRIGGER to run!"; break;
        case 268 : 
            texte = "A perfume for 3 feathers and 4 bags of rice? **              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_PLUME)<3
            || gpJeu->getJoueur()->getTroc(M_RIZ)<4) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_PARFUM)>=99) idsuiv=95;
            break;
        case 269 : texte = "A perfume for 3 feathers and 4 bags of rice? **              yes              NO ?"; idsuiv=76; break;
        case 270 : texte = "You got a perfume!"; break;
        case 271 : 
            texte = "A bag of olives for 15 rupees?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<15) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_OLIVES)>=99) idsuiv=95;
            break;
        case 272 : texte = "A bag of olives for 15 rupees?**              yes              NO ?"; idsuiv=76; break;
        case 273 : 
            texte = "A jar of spices for 20 rupees?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<20) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_EPICES)>=99) idsuiv=95;
            break;
        case 274 : texte = "A jar of spices for 20 rupees?**              yes              NO ?"; idsuiv=76; break;
        case 275 : texte = "Kakariko Village is the first stop for all adventurers willing to climb up the mountain.";
			       buffer= "Though, the less brave ones just reach the saloon..."; break;
        case 276 : texte = "Welcome to our village, Link! *Have fun, but don't go too close to the cactus..."; break;
        case 277 : texte = "The Pegasus boots don't just look flashy, they also give you great speed! It's a real advantage in a fight.."; 
            if (gpJeu->getJoueur()->hasObjet(O_BOTTES)) buffer="WAIT! You have the boots?!? I knew there was something different about the way you were walking!"; break;
        case 278 : 
            texte = "A frosty rock for a tapestry, an amulet and a perfume? *              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_TAPISSERIE)<1
            || gpJeu->getJoueur()->getTroc(M_AMULETTE)<1
            || gpJeu->getJoueur()->getTroc(M_PARFUM)<1) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_ROC_GIVRE)>=99) idsuiv=95;
            break;
        case 279 : texte = "A frosty rock for a tapestry, an amulet and a perfume? *              yes              NO ?"; idsuiv=76; break;
        case 280 : texte = "You got a frosty rock!"; break;
        case 281 : 
            texte = "A pearl for a jar of spices and a bag of rice? *              YES ?            no  "; 
            if (gpJeu->getJoueur()->getTroc(M_EPICES)<1
            || gpJeu->getJoueur()->getTroc(M_RIZ)<1) idsuiv=75;
            else if (gpJeu->getJoueur()->getTroc(M_PERLES)>=99) idsuiv=95;
            break;
        case 282 : texte = "A pearl for a jar of spices and a bag of rice? *              yes              NO ?"; idsuiv=76; break;
        case 283 : texte = "This village is under the protection of the 7 Wise Men. Because of their magic, you have to go pretty far before seeing a wolf..."; break;
        case 284 : texte = "You are in one of the safest villages in Hyrule, enjoy your stay .."; break;
        case 285 : texte = "Temple of Time"; break;
        case 286 : texte = "Mine Entrance"; break;
        case 287 : texte = "Temple of Power **- If weak of heart, turn back now! -"; break;
        case 288 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)>2) {id=295; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==2 
            && gpJeu->getJoueur()->getObjet()==11) {id=289; chercheText();break;}
            texte = "I isolated myself from the world to meditate on the meaning of life..."; buffer="...but I must admit .... I would really enjoy a glass of wine from the tavern where I lived as a young man"; break;
        case 289 : texte = "Is this a bottle of wine you have??? *Give it to me! I will give you gold for it!!!"; idsuiv=290; break;
        case 290 : texte = "This bottle of wine for gold, ok ?**              YES ?            no  "; idsuiv=292; break;
        case 291 : texte = "This bottle of wine for gold, ok ?**              yes              NO ?"; idsuiv=293; break;
        case 292 : texte = "I feel I'm getting close of the truth!"; break;
        case 293 : texte = "I will have to meditate on the meaning of your refusal..."; break;
        case 294 : texte = "You traded the bottle for Gold Dust!"; break;
        case 295 : texte = "I finally found the meaning of life... -hiccup-"; break;
        case 296 : texte = "Tower of Ice**When all power gems are found you may enter."; break;
        case 297 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)>1) {id=304; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)==1 
            && gpJeu->getJoueur()->getObjet()==3) {id=298; chercheText();break;}
            texte = "From here I can admire the lake of lava... **I love all red and shiny things."; break;
		case 298 : texte = "Mmm ... that's an amazing gemstone you have there...";
			       buffer= "Would you trade it to me for ...a surprise?"; idsuiv=299; break;
        case 299 : texte = "This red gemstone for a surprise, ok?**              YES ?            no  "; idsuiv=301; break;
        case 300 : texte = "This red gemstone for a surprise, ok?**              yes              NO ?"; idsuiv=302; break;
        case 301 : texte = "Thank you! Here is your surprise! I've tried to get rid this for a looooong time..."; break;
        case 302 : texte = "Too bad for you...no gemstone, no surprise!"; break;
        case 303 : texte = "You traded the red gemstone for an anvil, you can't run or swim while you have it!"; break;
        case 304 : texte = "I feel like a great weight has been lifted, and I'm rich!!!!"; break;
        case 305 : texte = "Temple of Fire ** -Those who wield true power may enter-"; break;
        case 306 : texte = "We are talking reindeer."; break;
        case 307 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)>4) {id=314; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)==4 
            && gpJeu->getJoueur()->getObjet()==7) {id=308; chercheText();break;}
            texte = "We crashed here after flying into a seagull... *It wouldn't have happened if I had a bell ..."; 
            buffer = "Oh, I almost forgot: *Ho! Ho! Ho!"; break;
        case 308 : texte = "Is this a bell you have? Would you give it to me?";
			       buffer= "I don't have any money, but I can find something in my bag of gifts to thank you ..."; idsuiv=309; break;
        case 309 : texte = "This little bell for a gift, ok?**              YES ?            no  "; idsuiv=311; break;
        case 310 : texte = "This little bell for a gift, ok?**              yes              NO ?"; idsuiv=312; break;
        case 311 : texte = "Thank you! Here is your gift: I was delivering it to the local executioner ...."; break;
        case 312 : texte = "What is your name, naughty boy?*I will cross you off my list!"; break;
        case 313 : texte = "You traded the little bell for an axe!"; break;
        case 314 : texte = "Ho! Ho! Ho!"; buffer="Now how do I get down from here?"; break;
        case 315 : texte = "TUTORIAL :*hitting one of these colored spheres will switch the stumbling blocks up and down, give it a try!."; break;
        case 316 : texte = "You have found a sword!!!*Use it with the (A) button, or hold (A) to charge a spin attack!"; break;
        case 317 : texte = "TUTORIAL :*Falling into a hole will bring you to the floor below. However, if there is no floor below (like in this cave), falling will cause you to lose life and will bring you to the area's entrance, so be careful!"; break;
        case 318 : texte = "TUTORIAL :*During the game, you might see areas that seem to be inaccessible, like the platform below.";
			       buffer= "You must"; buffer="come back later with the right equipment to reach these areas."; break;
        case 319 : texte = "@+@+@+@+@+@+@@@+*@=++=@=+@=+@=+=@*+@+@+@+=+="; break;
        case 320 : texte = "The guards saw you heading toward the forest, I thought you may have a lead so I ran up..."; break;
        case 321 : texte = "Mmm... This stele is written in ancient hylian... I will translate it:"; idsuiv=322; break;
        case 322 : texte = "At the dawn of cataclysm shall the hero find this stele, with the Pendants of Courage, Wisdom and Power in his possession, his chance to save the world will arise."; break;
        case 323 : texte = "..."; buffer="I'm afraid we'll have to forget about the ocarina for a moment...*If this stele is true, you have to gather the 3 pendants as soon as possible..."; idsuiv=324; break;
        case 324 : texte = "They are hidden in 3 temples, the nearest is north of here, in a tower by the waterfalls... Take this map, it will help you find your way!"; break;
        case 325 : texte = "You got a map of Hyrule!";
			       buffer= "Press (Y) when outdoors to open it, press (Y) again to close it"; break;
        case 326 : 
            if (!gpJeu->getJoueur()->hasMedaillon(0)) {texte = "The first pendent is in a tower to the North of this forest. Leave the forest to the West and head North to the waterfalls."; break;}
            if (!gpJeu->getJoueur()->hasMedaillon(1)) {texte = "The second pendent is in the temple, located in the middle of the Lake. You should rent a boat in Mabe village to sail there..."; break;}
            if (!gpJeu->getJoueur()->hasMedaillon(2)) {texte = "The last pendent is in a temple surrounded by the mountains, North of Kakariko Village."; break;}
            if (gpJeu->getJoueur()->getEpee()<2) {id=327; chercheText();break;}
            id=329; chercheText();break;
        case 327 : texte = "You've found all the pendants ?*Very well...";
			       buffer= "I cannot be sure of what challenges await you, take this sword, it will help you on your journey."; break;
        case 328 : texte = "You got the Master Sword!!!";
			       buffer= "- As you grasp it, you can feel its power coursing through your veins! -"; break;
        case 329 : 
            if (gpJeu->getJoueur()->getAvancement() == PORTAIL_F_OUVERT) {texte = "It looks like a teleportation portal! But ...we have no information about where it goes..."; break;}
            texte = "Try to touch the stele, now that you've got the pendants something might happen..."; break;
        case 330 : texte = "One last thing:*Monsters are starting to appear everywhere in Hyrule... It's a very bad omen... Be careful!"; break;
        case 331 : 
            texte = "Hello Link, I don't get many visitors these days...";
            if (gpJeu->getJoueur()->getBouclier()!=1) {idsuiv=333; break;}
            buffer="Let me improve your shield..."; break;
        case 332 : texte = "You got a better shield!!!";
			       buffer= "Your defense has increased by one point!"; break;
        case 333 : texte = "Come back and see me if you're hurt, I will heal your wounds."; break;
        case 334 : texte = "You got 10 bags of rice!"; break;
        case 335 : texte = "You got 10 jars of spices!"; break;
        case 336 : texte = "You got 10 bags of olives!"; break;
        case 337 : texte = "To reach the Pyramid, find and write down the 9 hints hidden on the desert's signs, then lift the whale's stones in the right order, only then will the way will open to you..."; break;
        case 338 :
            if (gpJeu->getJoueur()->getAvancement() < GARS_MINE_AIDE) {
                texte = "Cart express: I'm out for the moment, in case of emergency, I am at the saloon.** - The mine employee -"; break;}
            texte = "Cart express : service is provided again!"; break;
        case 339 : texte = "Jump on the cart and let me take care of the lever...";
			       buffer= "Don't worry ...I've been pulling this lever since I was just a boy ... -Hiccup-"; break;
        case 340 : texte = "You found some wooden planks!*You could use them to build a bridge..."; break;
        case 341 : texte = "Looks like a good place to build a bridge."; break;
        case 342 : texte = "                      Link*                 Hero of Hyrule*               - Killed by Ganon -"; break;
        case 343 : texte = "Now that we're are all together, we will open the portal ..."; break;
        case 344 : 
            if (gpJeu->getJoueur()->getAvancement() < SAGES_GROTTE) {id=347; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement() < PORTAIL_PRE_PRESENT_FERME) {texte = "Be sure to prepare yourself, the ocarina's thief is probably a powerfull creature..."; break;}
            texte = "You took the ocarina before the theif showed up? Congratulations!"; break;
        case 345 : 
            if (gpJeu->getJoueur()->getAvancement() < SAGES_GROTTE) {id=347; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement() < PORTAIL_PRE_PRESENT_FERME) {texte = "This portal is very special, it leads to an exact moment in the past... But we can't keep it opened forever, so hurry up!"; break;}
            texte = "You got the ocarina? Then we have completed the mission our ancestors entrusted us with..."; break;
        case 346 : 
            if (gpJeu->getJoueur()->getAvancement() < SAGES_GROTTE) {id=347; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement() < PORTAIL_PRE_PRESENT_FERME) {texte = "The portal is finally opened... Hurry Link, you've got to stop the theif from stealing the ocarina!"; break;}
            texte = "Go to the Temple of Time, and fulfill your destiny!"; break;
        case 347 : texte = "When all descendants are present and you have The Key of Time, we can open the portal..."; break;
        case 348 : texte = "You succeeded! ... We will close the portal now ..."; break;
        case 349 : texte = "You got a gauge!"; break;
        case 350 :
            if (gpJeu->getJoueur()->getBombeMax()<30 || gpJeu->getJoueur()->getFlecheMax()<70)
                {id=351; chercheText();break;}
            if (!gpJeu->getJoueur()->hasObjet(O_RECUP_FLECHE) 
            || !gpJeu->getJoueur()->hasObjet(O_RECUP_BOMBE))
                {id=356; chercheText();break;}
            texte = "Okay I have enough gold, go away."; break;
            break;
        case 351 : 
            texte = "Can you spare 100 Gold Ganon?**    YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<100) idsuiv=75;
            break;
        case 352 : texte = "Can you spare 100 Gold Ganon?**    yes              NO ?"; idsuiv=353; break;
        case 353 : texte = ".... some people, sheesh!"; break;
        case 354 : texte = "For your generosity, I will increase the number of arrows you can carry."; break;
        case 355 : texte = "For your generosity, I will increase the number of bombs you can carry."; break;
        case 356 : 
            texte = "Can you spare 999 Gold Ganon? I will give you something priceless in return, ok?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<999) idsuiv=75;
            break;
        case 357 : texte = "Can you spare 999 Gold Ganon? I will give you something priceless in return, ok?*              yes              NO ?"; idsuiv=353; break;
        case 358 : texte = "Your arrows supply will now stay magically full, don't hesitate to shoot!"; break;
        case 359 : texte = "Your bomb stock will now stay magically full, you can blow things up freely now!"; break;
        case 360 : 
            if (gpJeu->getJoueur()->getMagieMax()>32) {id=333; chercheText();break;}
            texte = "Welcome hero! Allow me to increase your Magic Meter, I think you may need it on your journey."; break;
        case 361 : texte = "Your stock of magic power doubled!"; break;
        case 362 : 
            if (gpJeu->getEpoque()==T_PASSE && !gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "What? Do you want a drink or something?"; break;
        case 363 : texte = "According to the gossip, a fairy hid behind the waterfall...Absolute poppycock if you ask me..."; break;
        case 364 : texte = "I'm er... mounting guard in the bar, that's it. But I would prefer this stay between you and me, ok?"; break;
        case 365 : texte = "Hobo of Hyrule, or whatever they call you, don't think you can drink for free!"; break;
        case 366 : texte = "It's too risky for you to go in there, you could be seen."; break;
        case 367 : 
            if (gpJeu->getEpoque()==T_PASSE && !gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            if (gpJeu->getZone()==84 && gpJeu->getJoueur()->getNbGemmes() == 200 
            && gpJeu->getJoueur()->getGemme() == 0) {id=405; chercheText(); break;}
            texte = "Walk up to the item you would like and press (B) to purchass it *"; break;
        case 368 : texte = "10 arrows for 20 rupees?**              YES ?            no  ";
            if (!gpJeu->getJoueur()->hasObjet(O_ARC)) {id=373; chercheText(); break;}
            else if (gpJeu->getJoueur()->getFleche() == gpJeu->getJoueur()->getFlecheMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<20) idsuiv=75; break;
        case 369 : texte = "10 arrows for 20 rupees?**              yes              NO ?"; break;
        case 370 : texte = "5 bombs for 30 rupees?**              YES ?            no  ";
            if (!gpJeu->getJoueur()->hasObjet(O_SAC_BOMBES)) {id=372; chercheText(); break;}
            else if (gpJeu->getJoueur()->getBombe() == gpJeu->getJoueur()->getBombeMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<30) idsuiv=75; break;
        case 371 : texte = "5 bombs for 30 rupees?**              yes              NO ?"; break;
        case 372 : texte = "You need a bomb bag to buy this."; break;
        case 373 : texte = "You need a bow to buy this."; break;
        case 374 : texte = "You don't need this."; break;
        case 375 : texte = "Thank you."; break;
        case 376 : texte = "A heart for 5 rupees?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getVie() == gpJeu->getJoueur()->getVieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<5) idsuiv=75; break;
        case 377 : texte = "A heart for 5 rupees?**              yes              NO ?"; break;
        case 378 : texte = "A little magic jar for 15 rupees?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getMagie() == gpJeu->getJoueur()->getMagieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<15) idsuiv=75; break;
        case 379 : texte = "A little magic jar for 15 rupees?**              yes              NO ?"; break;
        case 380 : texte = "A big magic jar for 25 rupees?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getMagie() == gpJeu->getJoueur()->getMagieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<25) idsuiv=75; break;
        case 381 : texte = "A big magic jar for 25 rupees?**              yes              NO ?"; break;
        case 382 :
            if (gpJeu->getJoueur()->getAvancement()<APPREND_POUR_ROC_GIVRE) {texte = "Sorry, I've just arrived in the city and my shop isnt open yet.";
																			 buffer= "Come back later, after I get things set up."; break;}
            if (gpJeu->getJoueur()->getAvancement()==APPREND_POUR_ROC_GIVRE 
            && gpJeu->getJoueur()->getTroc(M_ROC_GIVRE)==-1) {
                texte = "Do I have a frosty rock?*Yes, that I do."; idsuiv=383; break;
            }
            texte = "WOW...I Didn't think people collected power gems anymore. I wasn't even sure if I was ever going to open my shop....";
            buffer = "Upon your next visit I will be open for business, and you'll be able to trade me your power gems for extremely rare items.";
            break;
        case 383 : texte = "I'll let you have it for 30 power gems, ok?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getGemme()<30) idsuiv=385; break;
        case 384 : texte = "I'll let you have it for 30 power gems, ok?**              yes              NO ?"; idsuiv=76; break;
        case 385 : texte = "You don't have enough gems.*Keep your eyes open, they can be found anywhere."; break;
        case 386 : texte = "This detector will help you determine whether you have all the power gems in the area. An essential tool for someone looking to find all the gems, it's yours for 20 power gems!"; idsuiv=387; break;
        case 387 : texte = "The detector for 20 power gems, ok?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getGemme()<20) idsuiv=385; break;
        case 388 : texte = "The detector for 20 power gems, ok?**              yes              NO ?"; break;
        case 389 : texte = "You got the detector!";
			       buffer= "When you press START, the number of gems in your possession will be written in green if you have all the gems in the area."; break;
        case 390 : 
            if (gpJeu->getJoueur()->hasBouteille(0)) {id=393; chercheText(); break;}
            texte = "An empty bottle for 10 power gems?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getGemme()<10) idsuiv=385; break;
        case 391 : texte = "An empty bottle for 10 power gems?**              yes              NO ?"; break;
        case 392 : texte = "You got a bottle!";
			       buffer= "These are perfect for storing useful potions!"; break;
        case 393 : texte = "An empty bottle for 20 power gems?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getGemme()<20) idsuiv=385; break;
        case 394 : texte = "An empty bottle for 20 power gems?**              yes              NO ?"; break;
        case 395 : 
            if (gpJeu->getJoueur()->hasObjet(O_BONUS_FORCE)==1) {id=398; chercheText(); break;}
            texte = "Increase your strength for 20 power gems? *              YES ?            no  ";
            if (gpJeu->getJoueur()->getGemme()<20) idsuiv=385; break;
        case 396 : texte = "Increase your strength for 20 power gems? *              yes              NO ?"; break;
        case 397 : texte = "Your strength increases by one point!"; break; 
        case 398 : 
            texte = "Increase your strength for 40 power gems? *              YES ?            no  ";
            if (gpJeu->getJoueur()->getGemme()<40) idsuiv=385; break;
        case 399 : texte = "Increase your strength for 40 power gems? *              yes              NO ?"; break;
        case 400 : 
            if (gpJeu->getJoueur()->hasObjet(O_BONUS_DEFENSE)==1) {id=403; chercheText(); break;}
            texte = "Increase your defense for 20 power gems? *              YES ?            no  ";
            if (gpJeu->getJoueur()->getGemme()<20) idsuiv=385; break;
        case 401 : texte = "Increase your defense for 20 power gems? *              yes              NO ?"; break;
        case 402 : texte = "Your defense increases by one point!"; break; 
        case 403 : 
            texte = "Increase your defense for 40 power gems? *              YES ?            no  ";
            if (gpJeu->getJoueur()->getGemme()<40) idsuiv=385; break;
        case 404 : texte = "Increase your defense for 40 power gems? *              yes              NO ?"; break;
        case 405 : texte = "Mmm... my stock is empty..."; idsuiv=406; break;
        case 406 : texte = "I guess you've found all the power gems, that's incredible..."; idsuiv=407; break;
        case 407 : texte = "According to an old legend, when all the power gems are found, a temple hidding a fabulous treasure will open...*We just have to wait..."; break;
        case 408 : texte = "Come back when you have an empty bottle and I will sell you my potions."; break;
        case 409 :
            if (gpJeu->getJoueur()->hasBouteille(0)!=1 
            && gpJeu->getJoueur()->hasBouteille(1)!=1
            && gpJeu->getJoueur()->hasBouteille(2)!=1
            && gpJeu->getJoueur()->hasBouteille(3)!=1) {id=408; chercheText(); break;}
            texte = "Red potions restore your energy and green potions restore your magic."; 
            idsuiv=410; break;
        case 410 : texte = "Which one would you like?*                ? RED POTION ?*                  green potion  *                    nothing      "; idsuiv=413; break;
        case 411 : texte = "Which one would you like?*                  red potion  *                ? GREEN POTION ?*                    nothing      "; 
            if (!gpJeu->getJoueur()->hasObjet(O_LANTERNE)) idsuiv=374;
            else idsuiv=415; break;
        case 412 : texte = "Which one would you like?*                  red potion  *                  green potion  *              ?     NOTHING     ?"; break;
        case 413 : texte = "A red potion for 60 rupees?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<60) idsuiv=75; break;
        case 414 : texte = "A red potion for 60 rupees?**              yes              NO ?"; break;
        case 415 : texte = "A green potion for 40 rupees?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<40) idsuiv=75; break;
        case 416 : texte = "A green potion for 40 rupees?**              yes              NO ?"; break;
        case 417 : texte = "You got a red potion!!!**Drink it to restore all your energy!!!"; break;
        case 418 : texte = "You got a green potion!!!**Drink it to restore all your magic!!!"; break;
        case 419 : texte = "You got a blue potion!!!**Drink it to restore your energy and your magic!!!"; break;
        case 420 : texte = "You don't need this potion right now."; break;
        case 421 : texte = "?                 CONTINUE                 ?                   Save and quit                               Quit without saving            "; break;
        case 422 : texte = "                  Continue                     ?               SAVE AND QUIT              ?                Quit without saving            "; break;
        case 423 : texte = "                  Continue                                     Save and quit                  ?            QUIT WITHOUT SAVING           ?"; break;
        case 424 : 
            if (gpJeu->getJoueur()->getCoffre(15,14)) {id=431; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)==3 
            && gpJeu->getJoueur()->getObjet()==3) {id=425; chercheText();break;}
            texte = "I am the unluckiest man in the world, nothing good ever happens to me..."; break;
        case 425 : texte = "Is this a lucky charm you have?*Give it to me!*Nobody needs it more than me!"; idsuiv=426; break;
        case 426 : texte = "This horseshoe for... nothing, ok?**              YES ?            no  "; idsuiv=428; break;
        case 427 : texte = "This horseshoe for... nothing, ok?**              yes              NO ?"; idsuiv=429; break;
        case 428 : texte = "Thank you so much! Maybe my luck will begin to turn around!"; 
            buffer = "Unfortunately I have nothing to give you in return, unlucky for you I guess."; break;
        case 429 : texte = "-sigh- *......*Just my luck ..."; break;
        case 430 : texte = "You traded the horseshoe for... his gratitude?"; break;
        case 431 : texte = "In the end I'm just a lucky devil."; break;
        case 432 : texte = "I don't have prizes to put into the game anymore, sorry."; break;
        case 433 : 
            tmp = 4-(gpJeu->getJoueur()->getCoeur(28) + gpJeu->getJoueur()->getGemme(160) 
            + gpJeu->getJoueur()->getGemme(161) + gpJeu->getJoueur()->getGemme(162));
            if (tmp==0) {id=432; chercheText();break;}
            os << tmp; os2 << ((4-tmp+1)*5);
            texte = "There are "+os.str()+" prize(s) in these 9 chests, do you want to try your luck for "+os2.str()+" rupees ?*You can open only one chest, ok?*              YES ?            no  ";
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<(4-tmp+1)*5) idsuiv=75; break;
        case 434 : 
            tmp = 4-(gpJeu->getJoueur()->getCoeur(28) + gpJeu->getJoueur()->getGemme(160) 
            + gpJeu->getJoueur()->getGemme(161) + gpJeu->getJoueur()->getGemme(162));
            os << tmp; os2 << ((4-tmp+1)*5);
            texte = "There are "+os.str()+" prizes in these 9 chests, do you want to try your luck for "+os2.str()+" rupees ?*You can open only one chest, ok?*              yes              NO ?"; break;
        case 435 : texte = "Please choose a chest."; break;
        case 436 : texte = "Hey! You gotta pay to open one of my chests!!!"; break;
        case 437 : texte = "You lose! That chest is empty."; break;
        case 438 :
            if (gpJeu->getJoueur()->hasObjet(O_SAC_TROC)) {id=444; chercheText();break;}
            texte = "Good morning, Link! I take it you want to cross the bridge over to the temple?"; idsuiv=439;
            break;
        case 439 : texte = "Usually I would just pull this lever and let you cross, but I played with it all last night and well... I broke it."; 
            buffer="Then I went out and got some wooden planks to put down, so travelers could cross, but someone stole them during the night..."; idsuiv=440; break;
        case 440 : texte = "I could fix the lever, but I need a replacement part, and I can't leave my post..."; idsuiv=441; break;
        case 441 : texte = "I need a cogwheel, they can be found at the marketplace in Hyrule City."; idsuiv=442; break;
        case 442 : texte = "You know how it works, don't you? Each stall merchant offers some products that they will trade for others. You've got to gather what they want in order to trade for what you want."; idsuiv=443; break;
        case 443 : texte = "I will give some merchandise that I don't need to get you started.*If you want to see what you have in your bag, press LEFT on the RIGHT JOYSTICK."; break;
        case 444 : 
            if (gpJeu->getJoueur()->getTroc(M_ROUAGE)==0) {id=446; chercheText();break;}
            if (gpJeu->getJoueur()->getTroc(M_ROUAGE)>0) {id=445; chercheText();break;}
            texte = "I still need a cogwheel to fix this lever.*Go and find one in Hyrule city, that is if you want to cross the bridge."; break;
        case 445 : texte = "You brought me a cogwheel? Very well, it should work now."; break;
        case 446 : texte = "The lever is broken again... *..... *.....";
			       buffer= "Maybe it's time I built a better bridge"; break;
        case 447 : 
            if (gpJeu->getJoueur()->hasBouteille(0)!=1 
            && gpJeu->getJoueur()->hasBouteille(1)!=1
            && gpJeu->getJoueur()->hasBouteille(2)!=1
            && gpJeu->getJoueur()->hasBouteille(3)!=1) {id=408; chercheText(); break;}
            texte = "Would you like to buy my world famous blue potion for 160 rupees?*              YES ?            no  "; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<160) idsuiv=75; break;
        case 448 : texte = "Would you like to buy my world famous blue potion for 160 rupees?*              yes            ? NO  "; break;
        case 449 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)>1) {id=456; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)==1 
            && gpJeu->getJoueur()->getObjet()==15) {id=450; chercheText();break;}
            texte = "I'm fond of everything green and shiny!"; 
            buffer = "But don't worry, I'm not going to steal your rupees... I'm trying to quit."; break;
        case 450 : texte = "WOW! what a beautiful green gemstone you have ... I love it!";
			       buffer= "I'll trade you a map of EXTREME value for it!"; idsuiv=451; break;
        case 451 : texte = "This green gemstone for a map, ok?**              YES ?            no  "; idsuiv=453; break;
        case 452 : texte = "This green gemstone for a map, ok?**              yes              NO ?"; idsuiv=454; break;
        case 453 : texte = "Thank youuuu!!! Here is your map, now get lost!"; break;
        case 454 : texte = "Very well... *I would keen an eye on those rupees if I was you!!"; break;
        case 455 : texte = "You traded the gemstone for a map!"; break;
        case 456 : texte = "You came to give me some rupees?*How nice of you!"; break;
        case 457 : texte = "The princess wants me to warn her if anything strange happens here in town..."; 
            buffer = "This morning I saw a seagull flying weird... I'm not sure whether I've got to tell her or not..."; break;
        case 458 :
            if (gpJeu->getJoueur()->hasObjet(O_CANNE)) {id=478; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement() == PARLE_PECHE) {id=460; chercheText();break;}
            gpJeu->getJoueur()->setAvancement(PARLE_PECHE);
            texte = "Hello Link, welcome to the fishing shop!"; idsuiv = 459; break;
        case 459 : texte = "To celebrate the my grand opening, I'm organizing a great fishing contest!";
			       buffer= "You've probably heard about it, the whole city is participating!"; idsuiv=460; break;
        case 460 : texte = "To win the contest, and the special prize, you've got to be the first one to hook 5 different types of fish."; idsuiv=461; break;
        case 461 : texte = "Do you want to sign up? The registration fee is 10 Rupees, ok?*              YES ?            no  "; idsuiv=463;
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<10) idsuiv=75; break;
        case 462 : texte = "Do you want to sign up? The registration fee is 10 Rupees, ok?*              yes              NO ?"; idsuiv=464; break;
        case 463 : texte = "Excellent! Here is a fishing rod, come back when you've caught 5 different types of fish."; break;
        case 464 : 
            texte = "Mmm... Do you want to participate for 5 Rupees? *              YES ?            no  "; idsuiv=466; 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<5) idsuiv=75; break;
        case 465 : texte = "Mmm... Do you want to participate for 5 Rupees? *              yes              NO ?"; idsuiv=467; break;
        case 466 : texte = "Very well. Here is a fishing rod, come back when you've caught 5 different types of fish."; break;
        case 467 : texte = "And for 2 Rupees?**              YES ?            no  "; idsuiv=469;
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<2) idsuiv=75; break;
        case 468 : texte = "And for 2 Rupees?**              yes              NO ?"; idsuiv=470; break;
        case 469 : texte = "Well...Here is a fishing rod, come back when you've caught 5 different types of fish."; break;
        case 470 : texte = "For 1 Rupees ?**              YES ?            no  "; idsuiv=472;
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()<1) idsuiv=75; break;
        case 471 : texte = "For 1 Rupees ?**              yes              NO ?"; idsuiv=473; break;
        case 472 : texte = "*-sigh-* ...here is a fishing rod, come back when you've caught 5 different types of fish."; break;
        case 473 : texte = "Don't tell me you want to participate for free???*               YEAH ?          no  "; idsuiv=475; break;
        case 474 : texte = "Don't tell me you want to participate for free???*               yeah            NO ?"; idsuiv=476; break;
        case 475 : texte = "... Here is a fishing rod, come back when you've caught 5 different types of fish."; break;
        case 476 : texte = "Go away, enemy of fishermen!"; break;
        case 477 : texte = "You got a fishing rod! Press (X) to cast and when the line is moving press (X) again to reel er' in";
			buffer= "HINT : *The docks leading into the water are called Pontoons, you must be standing on one of these in order to fish"; break;
        case 478 : 
            if (gpJeu->getJoueur()->hasObjet(O_POISSONS)) {id=487; chercheText();break;}
            if (gpJeu->getJoueur()->nbPoissons()>=5) {id=479; chercheText();break;}
            tmp = 5-gpJeu->getJoueur()->nbPoissons();
            os << tmp;
            if (tmp > 1) texte = "Still "+os.str()+" types fish to find, good luck!";
            else texte = "Just one more fish to find!"; break;
        case 479 : texte = "You've found 5 fish???*You must be a super-fisherman!"; idsuiv=480; break;
        case 480 : texte = "This means the fishing contest is over, and you are the winner!"; idsuiv=481; break;
        case 481 : texte = "I guess you want your prize now?...*Well, as a reward for your victory in the fishing contest: *... ... ..."; idsuiv=482; break;
        case 482 : texte = "I hire you!"; idsuiv=483; break;
        case 483 : texte = "There are a lot of fish in Hyrule, and I want a list of them all!"; idsuiv=484; break;
        case 484 : texte = "I will reward you each time you find 5 new types of fish.";
				   buffer= "From now on you can check your list by pressing UP on the RIGHT JOYSTICK."; idsuiv=485; break;
        case 485 : texte = "With your current fishing rod, you will only be able to catch little fish..."; break;
        case 486 : texte = "Be sure to go fishing everywhere!*Each fish you catch gives you some energy, did you notice that?"; break;
        case 487 :
            if (gpJeu->getJoueur()->hasObjet(O_CANNE)>1) {id=490; chercheText();break;}
            if (gpJeu->getJoueur()->nbPoissons()>=10) {id=488; chercheText();break;}
            tmp = 10-gpJeu->getJoueur()->nbPoissons(); os << tmp;
            texte = "Bring me "+os.str()+" new types of fish for the next reward!";
            break;
        case 488 : texte = "Here is your reward for the 10 different types of fish you found:"; break;
        case 489 : texte = "You got a better fishing rod!!!";
			       buffer= "You'll be able to catch regular sized fish now!"; break;
        case 490 : 
            if (gpJeu->getJoueur()->hasBouteille(2)) {id=492; chercheText();break;}
            if (gpJeu->getJoueur()->nbPoissons()>=15) {id=491; chercheText();break;}
            tmp = 15-gpJeu->getJoueur()->nbPoissons(); os << tmp;
            texte = "Bring me "+os.str()+" new types of fish for the next reward!";
            break;
        case 491 : texte = "Here is your reward for the 15 different types of fish you found:"; break;
        case 492 : 
            if (gpJeu->getJoueur()->hasObjet(O_CANNE)>2) {id=495; chercheText();break;}
            if (gpJeu->getJoueur()->nbPoissons()>=20) {id=493; chercheText();break;}
            tmp = 20-gpJeu->getJoueur()->nbPoissons(); os << tmp;
            texte = "Bring me "+os.str()+" new types of fish for the next reward!";
            break;
        case 493 : texte = "Here is your reward for the 20 different types of fish you found:"; break;
        case 494 : texte = "You got an even better fishing rod!!!";
			       buffer= "You will be able to catch gigantic fish now!!!"; break;
        case 495 : 
            if (gpJeu->getJoueur()->getCoeur(27)) {id=497; chercheText();break;}
            if (gpJeu->getJoueur()->nbPoissons()>=25) {id=496; chercheText();break;}
            tmp = 25-gpJeu->getJoueur()->nbPoissons(); os << tmp;
            texte = "Bring me "+os.str()+" new types of fish for the next reward!";
            break;
        case 496 : texte = "Here is your reward for the 25 different types of fish you found:"; break;
        case 497 : 
            if (gpJeu->getJoueur()->hasObjet(O_POISSONS)>1) {id=500; chercheText();break;}
            if (gpJeu->getJoueur()->nbPoissons()>=30) {id=498; chercheText();break;}
            tmp = 30-gpJeu->getJoueur()->nbPoissons(); os << tmp;
            texte = "Bring me "+os.str()+" new types of fish for the next reward!";
            break;
        case 498 : texte = "Here is your reward for finding all the different types of fish in Hyrule:"; break;
        case 499 : texte = "YOU'RE FIRED!!!!"; break;
        case 500 : texte = "Finally, I have a list of every type of fish in Hyrule, my fisherman guidebook is finished..."; break;
        case 501 : texte = "Good morning, Link! *I am the mayor of Mabe Village."; 
            if (gpJeu->getJoueur()->hasObjet(O_POISSONS)) idsuiv=503; else idsuiv=502; break;
        case 502 : texte = "Right now there is a fishing contest going on in town, it's all anyone can about...";
			       buffer= "Is that why you came?"; break;
        case 503 : texte = "Now that the fishing contest is over, things have returned to their usual calmness around here."; break;
        case 504 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)>1) {id=511; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)==1 
            && gpJeu->getJoueur()->getObjet()==7) {id=505; chercheText();break;}
            texte = "I'm Hyrule's most legendary fisherman!*I've always loved the blue and shiny color of the ocean..."; 
            buffer = "Why didn't I win the fishing contest?*Well... it's because I'm not interested in that kind of thing.... That's why!"; break;
        case 505 : texte = "A blue and shiny gemstone?*I need it!";
			       buffer= "I'll trade you the last thing I hooked for it!"; idsuiv=506; break;
        case 506 : texte = "The blue gemstone for his last catch, ok ?**              YES ?            no  "; idsuiv=508; break;
        case 507 : texte = "The blue gemstone for his last catch, ok ?**              yes              NO ?"; idsuiv=509; break;
        case 508 : texte = "He-he! You drive a hard bargain kid."; buffer="This boot was full of sand when I found it, unusual isn't it?"; break;
        case 509 : texte = "You're too kind, but don't worry about me, I'm happy to trade away my prized catch for a mere gemstone."; break;
        case 510 : texte = "You traded the blue gemstone for an old boot!*..... Way to go"; break;
        case 511 : texte = "If you ever find other blue gemstones, it will be my pleasure take them off your hands!"; break;
        case 512 : 
            if (!gpJeu->getJoueur()->hasObjet(O_CANNE)) texte = "These days, young men never listen to their elder's advice...*I think this fishing contest will last...";
            else {texte = "I used to be a famous fisherman, do you want me to give you some hints?"; idsuiv=513;} break;
        case 513 : texte = "ABOUT THE TYPES OF FISH          ?*About fishing areas              *About the bonus                   *Nothing at all                    "; idsuiv=517; break;
        case 514 : texte = "About the types of fish           *ABOUT FISHING AREAS              ?*About the bonus                   *Nothing at all                    "; idsuiv=518; break;
        case 515 : texte = "About the types of fish           *About fishing areas               *ABOUT THE BOUNS                  ?*Nothing at all                    "; idsuiv=519; break;
        case 516 : texte = "About the types of fish           *About fishing areas               *About the bonus                   *NOTHING AT ALL                   ?"; idsuiv=520; break;
        case 517 : texte = "They say that the waters of Hyrule provide a habitat for no less than 30 types of fish, but they all live in their own area, you will not find them all in the same place."; break;
        case 518 : texte = "Hyrule has many spots to fish, but only 6 distinct areas. To find new fish you will have to go fishing in various places."; 
            buffer="If you find a fish you already hooked somewhere else, this means you are in the same fishing area."; break;
        case 519 : texte = "Fishing is not just for fun, hooking a fish will give you energy. The amount of energy earned depends on the type of fish."; break;
        case 520 : texte = "Tsss... kids these days..."; break;
        case 521 : 
            if (!gpJeu->getJoueur()->hasObjet(O_POISSONS)) texte = "I spent hours fishing in the lake and could only find 3 different types of fish..."; 
            else texte = "We have to fish at different places to find more than 3 types fish?!?";
			     buffer= ".......... *.......... *.........."; break;
        case 522 :
            if (gpJeu->getJoueur()->getAvancement()==PARLE_GARS_MINE_SALOON) {id=523; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_BARMAN_SALOON
            && gpJeu->getJoueur()->getAvancement()<DETTE_PAYEE) {id=528; chercheText();break;}
            texte = "Do you want something to drink?"; break;
        case 523 : texte = "You need help from the drunk guy there? *Unfortunately I can't let him go if he doesn't pay."; idsuiv=524; break;
        case 524 : texte = "You want to pay it off? It's 10 000 Rupees, ok? *              YES ?            no  "; idsuiv=75; break;
        case 525 : texte = "You want to pay it off? It's 10 000 Rupees, ok? *              yes              NO ?"; idsuiv=526; break;
        case 526 : texte = "Of course..."; buffer="Okay, I got another idea: usually I use a frosty rock to prepare my fresh drinks, but I just finished my last one..."; idsuiv=527; break;
        case 527 : texte = "If you bring me a new frosty rock, I will consider his debt payed."; break;
        case 528 : 
            if (gpJeu->getJoueur()->getTroc(M_ROC_GIVRE)>0) {id=529; chercheText();break;}
            texte = "So, you can't find a frosty rock?"; break;
        case 529 : texte = "You got a frosty rock? Impressive..."; idsuiv=530; break;
        case 530 : texte = "Give me the frosty rock and I'll forgive his debt, ok?*              YES ?            no  "; idsuiv=533; break;
        case 531 : texte = "Give me the frosty rock and I'll forgive his debt, ok?*              yes              NO ?"; idsuiv=532; break;
        case 532 : texte = "I understand, after all it's none of your business."; break;
        case 533 : texte = "Thank you!*As promised, the old man can go, his debt is forgiven."; break;
        case 534 : 
            if (gpJeu->getJoueur()->getAvancement()==PANCARTE_MINE_LUE) {id=535; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()==PARLE_GARS_MINE_SALOON) {id=537; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()==PARLE_BARMAN_SALOON) {id=538; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()>PARLE_BARMAN_SALOON
            && gpJeu->getJoueur()->getTroc(M_ROC_GIVRE)<0) {id=540; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()<DETTE_PAYEE
            && gpJeu->getJoueur()->getTroc(M_ROC_GIVRE)>0) {id=541; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()==DETTE_PAYEE) {id=542; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()==GARS_MINE_AIDE) {id=543; chercheText();break;}
            texte = "I drink alone! -hiccups- !"; break;
        case 535 : texte = "You've been to the mine?*I used to work there...*But when monsters appeared inside, the mine was temporarily closed..."; idsuiv=536; break;
        case 536 : texte = "I would like to help you get through the mine, but the bartender wont let me go if I don't pay my debt.";
			       buffer= "Sadly, I don't have any money, and what makes it worse is I drink more to pass the time. -hiccup-"; idsuiv=537; break;
        case 537 : texte = "Someone should really pay off my debt... ...* -hiccup- !"; break;
        case 538 : texte = "You want to know where to find a frosty rock? *Mmm ...";
			       buffer= "I heard a new shop recently opened in Hyrule City... -hiccup-"; idsuiv=539; break;
        case 539 : texte = "...I think they have a froggy lock -hiccup- ... errr, I mean a frosty rock."; break;
        case 540 : texte = "Go to the strange shop in Hyrule City, they should have a frosty rock."; break;
        case 541 : texte = "You got a frosty rock???*Give it to the bartender, I promise I will help you with the mine!"; break;
        case 542 : texte = "Oh, I'm free to leave? ... I thought I would have to do the dishes for the rest of the week!*Thank you, Link!"; idsuiv=543; break;
        case 543 : texte = "You can go to the mine, I'll meet you there.** -hiccup- !"; break;
        case 544 : texte = "Welcome to the saloon, make yourself at home, Link!"; break;
        case 545 : texte = "While the mine up north is closed, I have nothing to do but spend my time here..."; break;
        case 546 : texte = "Almost all the men in the village work in the mine to the north."; buffer="This morning monsters appeared inside so the mine had to close."; break;
        case 547 : texte = "Rice, spices and olives are the basis of all trading in Hyrule, you should always have some of these items with you."; break;
        case 548 : texte = "I'm the mine foreman, which makes me the most powerful man in the village. Don't you dare look down on me!"; break;
        case 549 : texte = "I thought becoming mayor would give me a great opportunity to make changes around here ....";
			       buffer= "....As it turns out, the mine foreman is much more influential, he gave jobs to almost all the men in the village."; break;
        case 550 : texte = "The bank is under our surveillance. Nothing to report."; break;
        case 551 : 
            if ((gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece())==0 
            && (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon())==0) idsuiv=552;
            if ((gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece())==0 
            && (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon())>0) idsuiv=553;
            if ((gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece())>0 
            && (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon())==0) idsuiv=559;
            if ((gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece())>0 
            && (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon())>0) idsuiv=564;
            texte = "Welcome to the Hyrule bank. I specialize in all kind of currencies."; break;
        case 552 : texte = "You don't have anything interesting, come back if you find gold, I'll give you a good price for it."; break;
        case 553 : texte = "You have some gold coins? With the face of a monster on it?... Gold Ganon you say?"; idsuiv=554; break;
        case 554 : texte = "It's really ugly, but the gold is reusable, let's see..."; idsuiv=555; break;
        case 555 : 
            int g;
            int gmax;
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()>gpJeu->getJoueur()->getRubisMax()-2) {id=557; chercheText();break;}
            g=gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon();
            gmax = ((gpJeu->getJoueur()->getRubisMax()-(gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()))/2);
            if (g > gmax) g=gmax;
            os << g; os2 << (g*2);
            texte = os.str()+" Gold Ganon for "+os2.str()+" Rupees, ok?**              YES ?            no  "; idsuiv=558; break;
        case 556 : 
            g=gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon();
            gmax = ((gpJeu->getJoueur()->getRubisMax()-(gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()))/2);
            if (g > gmax) g=gmax;
            os << g; os2 << (g*2);
            texte = os.str()+" Gold Ganon for "+os2.str()+" Rupees, ok?**              yes              NO ?"; idsuiv=76; break;
        case 557 : texte = "Sorry, Your wallet is full, come back later when you're not doing so well financially ."; break;
        case 558 : texte = "It's a deal!"; break;
        case 559 : texte = "You have Gold Coins? I thought this currency didn't exist anymore..."; idsuiv=560; break;
        case 560 : texte = "I'll give you a good price for it, let's see..."; idsuiv=561; break;
        case 561 : 
            if (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()>gpJeu->getJoueur()->getRubisMax()-4) {id=557; chercheText();break;}
            g=gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece();
            gmax = ((gpJeu->getJoueur()->getRubisMax()-(gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()))/4);
            if (g > gmax) g=gmax;
            os << g; os2 << (g*4);
            texte = os.str()+" Gold Coins for "+os2.str()+" Rupees, ok?**              YES ?            no  "; idsuiv=563; break;
        case 562 : 
            g=gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece();
            gmax = ((gpJeu->getJoueur()->getRubisMax()-(gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis()))/4);
            if (g > gmax) g=gmax;
            os << g; os2 << (g*4);
            texte = os.str()+" Gold Coins for "+os2.str()+" Rupees, ok?**              yes              NO ?"; idsuiv=76; break;
        case 563 : texte = "It's a deal!"; break;
        case 564 : texte = "What do you want to sell me?*   - GOLD COINS ?*   - Gold Ganon  *   - Nothing  "; idsuiv=560; break;
        case 565 : texte = "What do you want to sell me?*   - Gold Coins  *   - GOLD GANON ?*   - Nothing  "; idsuiv=554; break;
        case 566 : texte = "What do you want to sell me?*   - Gold Coins  *   - Gold Ganon  *   - NOTHING ?"; idsuiv=76; break;
        case 567 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)==10
            && gpJeu->getJoueur()->hasObjet(O_TROC2)==10
            && gpJeu->getJoueur()->hasObjet(O_TROC3)==10
            && gpJeu->getJoueur()->hasObjet(O_TROC4)==10) {id=574; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)==7 
            && gpJeu->getJoueur()->getObjet()==3) {id=568; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)==7 
            && gpJeu->getJoueur()->getObjet()==7) {id=575; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==8 
            && gpJeu->getJoueur()->getObjet()==11) {id=580; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)==7 
            && gpJeu->getJoueur()->getObjet()==15) {id=585; chercheText();break;}
            texte = "I'm here to build a bridge to the north. I'm sure it will be useful some day."; 
            buffer = "The problem is ...I don't have any tools *...... *......"; break;
        case 568 : texte = "This hammer looks great! I could really use it!";
			       buffer= "When I was an explorer I found a legendary treasure that might interest you, would you like to trade?"; idsuiv=569; break;
        case 569 : texte = "This hammer for a legendary treasure, ok?**              YES ?            no  "; idsuiv=571; break;
        case 570 : texte = "This hammer for a legendary treasure, ok?**              yes              NO ?"; idsuiv=572; break;
        case 571 : texte = "Thank you, you can have this:"; break;
        case 572 : texte = "I don't think I'll ever finish this bridge..."; break;
        case 573 : texte = "You got the Fire Arrows!";
			       buffer= "These magic arrows burn red hot, and release a sizzling power!"; break;
        case 574 : texte = "Looks like I finally got all I need...*I'll get myself motivated and finish!"; break;
        case 575 : texte = "Is that a bridge plan?*I really need that, will you give it to me for a legendary treasure I found when I was an explorer?"; idsuiv=576; break;
        case 576 : texte = "This plan for a legendary treasure, ok?**              YES ?            no  "; idsuiv=578; break;
        case 577 : texte = "This plan for a legendary treasure, ok?**              yes              NO ?"; idsuiv=572; break;
        case 578 : texte = "Thank you, take this gift in return:"; break;
        case 579 : texte = "You got the Ice Arrows!";
			       buffer= "These magic arrows are ice cold, and release a chilling power!"; break;
        case 580 : texte = "You've got a saw?";
			       buffer= "I can't make a bridge without it, will you give it to me for a legendary treasure I found when I was an explorer?"; idsuiv=581; break;
        case 581 : texte = "This saw for a legendary treasure, ok?**              YES ?            no  "; idsuiv=583; break;
        case 582 : texte = "This saw for a legendary treasure, ok?**              yes              NO ?"; idsuiv=572; break;
        case 583 : texte = "Thank you, take this in exchange:"; break;
        case 584 : texte = "You got the Light Arrows!";
			       buffer= "These arrows use a lot of magic, but release the ultimate power!"; break;
        case 585 : texte = "You've got a nail?*I guess it may help, will you give it to me for a bottle?"; idsuiv=586; break;
        case 586 : texte = "This nail for a bottle, ok?**              YES ?            no  "; idsuiv=588; break;
        case 587 : texte = "This nail for a bottle, ok?**              yes              NO ?"; idsuiv=572; break;
        case 588 : texte = "Thank you, take this in return:"; break;
        case 589 : 
            if (gpJeu->getJoueur()->hasObjet(O_ENCYCL)) {id=593; chercheText();break;}
            texte = "Hello Link, do you remember me?"; idsuiv=590; break;
        case 590 : texte = "Monsters appeared in Hyrule today! Once again I'll try to get a list of them all, and I'll need your help!"; idsuiv=591; break;
        case 591 : texte = "Pressing DOWN on the RIGHT JOYSTICK you can see the monsters already listed. All you have to do is kill a monster to add it to the list."; idsuiv=592; break;
        case 592 : 
            switch (gpJeu->getEpoque()) {
                case T_PASSE : os<<"10 Gold Coins"; break;
                case T_PRESENT : os<<"40 Rupees"; break;
                case T_FUTUR : os<<"20 Gold Ganon"; break;
            }
            texte = "I'll owe you "+os.str()+" for each new monster you find. Come and see me when you have some time and I'll be sure to pay you."; break;
        case 593 :
            g = gpJeu->getJoueur()->getSolde();
            if (g == 0) {id=595; chercheText();break;}
            switch (gpJeu->getEpoque()) {
                case T_PASSE : os<<(g/4)<<" Gold Coins"; break;
                case T_PRESENT : os<<g<<" Rupees"; break;
                case T_FUTUR : os<<(g/2)<<" Gold Ganon"; break;
            }
            texte = "I owe you "+os.str()+", do you want to be paid now?*              YES ?            no  "; break;
        case 594 : 
            g = gpJeu->getJoueur()->getSolde();
            switch (gpJeu->getEpoque()) {
                case T_PASSE : os<<(g/4)<<" Gold Coins"; break;
                case T_PRESENT : os<<g<<" Rupees"; break;
                case T_FUTUR : os<<(g/2)<<" Gold Ganon"; break;
            }
            texte = "I owe you "+os.str()+", do you want to be paid now?*              yes              NO ?"; break;
        case 595 : texte="Your account is at 0, I gave you everything."; break;
        case 596 : 
            if ((gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece())==0 
            && (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis())<2) idsuiv=597;
            if ((gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece())==0 
            && (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis())>1) idsuiv=598;
            if ((gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece())>0 
            && (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis())<2) idsuiv=603;
            if ((gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece())>0 
            && (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis())>1) idsuiv=608;
            texte = "Welcome to the Hyrule Bank. I specialize in all types of currencies."; break;
        case 597 : texte = "You don't have anything interesting, come back if you find some gold or rupees, I'll give you a good price for them."; break;
        case 598 : texte = "You have some rupees? We haven't used them here in ages, but they are still very valuable..."; idsuiv=599; break;
        case 599 : texte = "Let's see..."; idsuiv=600; break;
        case 600 : 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()==gpJeu->getJoueur()->getGanonMax()) {id=557; chercheText();break;}
            g=gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis();
            if (g%2 != 0) g--;
            gmax = (gpJeu->getJoueur()->getGanonMax()-(gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()))*2;
            if (g > gmax) g=gmax;
            os << g; os2 << (g/2);
            texte = os.str()+" Rupees for "+os2.str()+" Gold Ganon, ok?**              YES ?            no  "; idsuiv=602; break;
        case 601 : 
            g=gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis();
            if (g%2 != 0) g--;
            gmax = (gpJeu->getJoueur()->getGanonMax()-(gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()))*2;
            if (g > gmax) g=gmax;
            os << g; os2 << (g/2);
            texte = os.str()+" Rupees for "+os2.str()+" Gold Ganon, ok?**              yes              NO ?"; idsuiv=76; break;
        case 602 : texte = "It's a deal!"; break;
        case 603 : texte = "You possess Gold Coins? It's unbelievable that you could find such an ancient money!"; idsuiv=604; break;
        case 604 : texte = "They contain a lot of reusable gold... *Let's see..."; idsuiv=605; break;
        case 605 : 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()>gpJeu->getJoueur()->getGanonMax()-2) {id=557; chercheText();break;}
            g=gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece();
            gmax = ((gpJeu->getJoueur()->getGanonMax()-(gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()))/2);
            if (g > gmax) g=gmax;
            os << g; os2 << (g*2);
            texte = os.str()+" Gold Coins for "+os2.str()+" Gold Ganon, ok?**              YES ?            no  "; idsuiv=607; break;
        case 606 : 
            g=gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece();
            gmax = ((gpJeu->getJoueur()->getGanonMax()-(gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()))/2);
            if (g > gmax) g=gmax;
            os << g; os2 << (g*2);
            texte = os.str()+" Gold Coins for "+os2.str()+" Gold Ganon, ok?**              yes              NO ?"; idsuiv=76; break;
        case 607 : texte = "It's a deal!"; break;
        case 608 : texte = "What do you want to sell me?*   - GOLD COINS ?*   - Rupees  *   - Nothing  "; idsuiv=604; break;
        case 609 : texte = "What do you want to sell me?*   - Gold Coins  *   - RUPEES ?*   - Nothing  "; idsuiv=599; break;
        case 610 : texte = "What do you want to sell me?*   - Gold Coins  *   - Rupees  *   - NOTHING ?"; idsuiv=76; break;
        case 611 : texte = "It's been a long time since I had so much fun!"; break;
        case 612 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)>6) {id=619; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)==6 
            && gpJeu->getJoueur()->getObjet()==7) {id=613; chercheText();break;}
            texte = "One of my ancestors wanted to build a bridge here, but in the end he just wrote down the plan..."; 
            buffer = "I'm from a long lineage of failures, no wonder I fail at everything I do... On top of that I'm sick, and nobody loves me..."; break;
        case 613 : texte = "You have a rope?*Can I have it, I will give you an antique that's been in my family for generations ..."; idsuiv=614; break;
        case 614 : texte = "This rope for an antique, ok?**              YES ?            no  "; idsuiv=616; break;
        case 615 : texte = "This rope for an antique, ok?**              yes              NO ?"; idsuiv=617; break;
        case 616 : texte = "Thank you so much!*I don't have any descendants to give it to anyway ...."; break;
        case 617 : texte = "I knew you would say that, nobody ever gives me anything..."; break;
        case 618 : texte = "You traded the rope for a bridge plan written on old parchment"; break;
        case 619 : texte = "...*I would like to be alone just a moment..."; break;
        case 620 : 
            if (gpJeu->getJoueur()->getTroc(M_POIVRON)>-1) {id=624; chercheText();break;}
            texte = "Good day, you must be Link?*I've been awaiting your arrival ..."; idsuiv=621; break;
        case 621 : texte = "As you already know, I'm a descendant of the 7 Wise Men. I was chased from my village by Ganon's minions, and soon found myself here in hiding";
				   buffer= "I have to say ... Knowing that you've reached this point gives me much hope, I'll see you at to the portal!"; idsuiv=622; break;
        case 622 : texte = "Oh, Wait! *...take this, I think it might help you on your journey"; break;
        case 623 : texte = "You got a pepper!"; break;
        case 624 : texte = "Good luck, Link!"; break;
        case 625 : 
            if (gpJeu->getJoueur()->hasObjet(O_GRAPPIN)) {id=635; chercheText();break;}
            texte = "Welcome, Link! I was waiting for you..."; idsuiv=626; break;
        case 626 : texte = "I suppose you have a lot of questions for me, allow me to explain ...."; idsuiv=627; break;
        case 627 : texte = "As you may have guessed, we are still in Hyrule, albeit in a future state...";
			       buffer= "The portal you stepped into allowed you to travel forward through time ...and now you see the sad reality that is our future"; idsuiv=628; break;
        case 628 : texte = "What happened? Ganon attacked the castle, stronger than ever, he defeated you and took control of Hyrule."; idsuiv=629; break;
        case 629 : texte = "Before her execution, princess Zelda managed to send a message to the Wise Men.";
			       buffer= "She believed the theft of the Ocarina was the turning point of the war, so she asked that we give you the Ocarina, if one day you should arrived through the portal."; idsuiv=630; break;
        case 630 : texte = "Since you are here, in front of me, this means the day has finally arrived. However ...the ocarina was never found."; idsuiv=631; break;
        case 631 : texte = "But don't worry, we have come up with another plan. We are going to send you to the past, to the night the ocarina was stolen, and you will catch the thief red-handed."; idsuiv=632; break;
        case 632 : texte = "You must first find the two other remaining descendants of the Wise Men, as well as the Key of Time, then we'll be able to open the portal and send you back."; idsuiv=633; break;
        case 633 : texte = "Take this, it will help you on your journey:"; break;
        case 634 : texte = "You got the hookshot!";
			       buffer= "You can use it to cross over ditches!"; break;
        case 635 : 
            if (gpJeu->getJoueur()->getCoffre(3,29)) {id=636; chercheText();break;}
            texte = "One of the descendants is hidden in the ruins near the middle of the lake ..."; break;
        case 636 : 
            if (gpJeu->getJoueur()->getTroc(M_POIVRON)>-1) {id=637; chercheText();break;}
            texte = "The other descendant is hidden somewhere near The Waterfalls."; break;
        case 637 : 
            if (gpJeu->getJoueur()->hasObjet(O_CLE_TEMPS)) {id=638; chercheText();break;}
            texte = "You will find The Key of Time hidden within the Great Pyramid, just South of here ..."; break;
        case 638 : 
            if (gpJeu->getJoueur()->getAvancement()>SAGES_GROTTE) {id=639; chercheText();break;}
            texte = "The Wise Men are in the cave, and The Key of Time is in your possession? ...";
			buffer= "Very well ... meet us at the portal, and hurry!"; break;
        case 639 :
            if (gpJeu->getJoueur()->hasMelodie(1)) {id=640; chercheText();break;}
            texte = "In the Temple of Time a song is hidden that, if played with the ocarina, will bring you back to your own time."; break;
        case 640 : texte = "Good luck, Link... we are all counting on you."; break;
        case 641 : texte = "10 arrows for 10 Gold Ganon?**              YES ?            no  ";
            if (!gpJeu->getJoueur()->hasObjet(O_ARC)) {id=373; chercheText(); break;}
            else if (gpJeu->getJoueur()->getFleche() == gpJeu->getJoueur()->getFlecheMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<10) idsuiv=75; break;
        case 642 : texte = "10 arrows for 10 Gold Ganon?**              yes              NO ?"; break;
        case 643 : texte = "5 bombs for 15 Gold Ganon?**              YES ?            no  ";
            if (!gpJeu->getJoueur()->hasObjet(O_SAC_BOMBES)) {id=372; chercheText(); break;}
            else if (gpJeu->getJoueur()->getBombe() == gpJeu->getJoueur()->getBombeMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<15) idsuiv=75; break;
        case 644 : texte = "5 bombs for 15 Gold Ganon?**              yes              NO ?"; break;
        case 645 : texte = "One heart for 4 Gold Ganon?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getVie() == gpJeu->getJoueur()->getVieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<4) idsuiv=75; break;
        case 646 : texte = "One heart for 4 Gold Ganon?**              yes              NO ?"; break;
        case 647 : texte = "A little magic jar for 8 Gold Ganon?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getMagie() == gpJeu->getJoueur()->getMagieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<8) idsuiv=75; break;
        case 648 : texte = "A little magic jar for 8 Gold Ganon?**              yes              NO ?"; break;
        case 649 : texte = "A big magic jar for 16 Gold Ganon? *              YES ?            no  ";
            if (gpJeu->getJoueur()->getMagie() == gpJeu->getJoueur()->getMagieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<16) idsuiv=75; break;
        case 650 : texte = "A big magic jar for 16 Gold Ganon? *              yes              NO ?"; break;
        case 651 : 
            if (gpJeu->getJoueur()->getGanonMax()>0) {id=652; chercheText(); break;}
            texte = "One second is one drip of the coffee pot. Let's hurry it up."; break;
        case 652 :
            if (gpJeu->getJoueur()->getCafe()>-1) {id=653; chercheText(); break;}
            texte = "You want to work for me? The true measure of a man is in the amount of work he does. That's what I always say."; idsuiv=653; break;
        case 653 : 
            if (gpJeu->getJoueur()->getChargeCafe()==-1 
            && gpJeu->getMonde()->motifValue(6*16,8*16)==1005) {id=655; chercheText(); break;}
            if (gpJeu->getJoueur()->getCafe()>=17) {id=672; chercheText(); break;}
            texte = "Run on the moving walkway to charge the dynamo, then stand on the button. This will start up the coffee maker.";
			buffer= "Come and talk to me when you're done to receive your pay..."; idsuiv=654; break;
        case 654 : texte = "I'm not going to ask if you're ready, preparation is the last refuge of the weak.."; break;
        case 655 : 
            if (gpJeu->getJoueur()->getCafe()>1) {
                id=654+gpJeu->getJoueur()->getCafe(); chercheText(); break;}
            texte = "I never drink more than 17 cups of coffee a day....But the first one is always the best."; break;
        case 656 : texte = "Darker than a moonless night, hotter than Hell itself, and more bitter than a woman scorned...";
			       buffer= "That is coffee...."; break;
        case 657 : texte = "Obviously, I'll take another."; break;
        case 658 : texte = "By the way, I wouldn't put salt in coffee. The two don't go well together...at all."; break;
        case 659 : texte = "This coffee here... It's my own special blend. I call it Godot 107. I'm trying to decide whether to cut down on the acidity or the bitterness..."; buffer="That's the only thing I've got on my mind right now..."; break;
        case 660 : texte = "Ha... !*My 6th cup of coffee is staring up at me coldly."; break;
        case 661 : texte = "Godot Blend 102... My personal favorite."; break;
        case 662 : texte = "Ha... ! *Godot Blend 107...*I've decided... It's a little too bitter after all!"; break;
        case 663 : texte = "...Aaah, bitter!"; break;
        case 664 : texte = "The weak get washed away by the tides of fate, The strong drink it up! "; break;
        case 665 : texte = "...My 11th cup..What's better than 11 you ask?";
			       buffer= "12! Ha!!! I'll have another!!!! woooooo!"; break;
        case 666 : texte = "A single drop of milk is all it takes to destroy the pure black magic in this cup!"; break;
        case 667 : texte = "Ha! You will learn to appreciate the bitterness when you're older."; break;
        case 668 : texte = "You know what my golden rule is?";
			       buffer= "If the coffee doesn't taste right, dump it down the drain ...You can always hire someone to brew you another!"; break;
        case 669 : texte = "Ha... ! I always have time to enjoy another cup of pure black magic!"; break;
        case 670 : texte = "It takes longer than two minutes to brew a good ol' cup of Joe..."; break;
        case 671 : texte = "Ahhhhh ...Cup number 17!";
			       buffer= "It seems like only a moment ago I drank my first cup of the day ....."; break;
        case 672 : 
            if (gpJeu->getJoueur()->getGemme(173)) {id=673; chercheText(); break;}
            texte = "You helped me on my daily quest of drinking 17 cups of Joe, here's a reward"; break;
        case 673 : texte = "You still need money? Here's..."; break;
        case 674 :
            if (gpJeu->getJoueur()->hasBouteille(0)!=1 
            && gpJeu->getJoueur()->hasBouteille(1)!=1
            && gpJeu->getJoueur()->hasBouteille(2)!=1
            && gpJeu->getJoueur()->hasBouteille(3)!=1) {id=408; chercheText(); break;}
            texte = "Red potions restore your energy and green potions restore your magic."; 
            idsuiv=675; break;
        case 675 : texte = "Which one do you want?*                ? RED POTION ?*                  green potion  *                    nothing      "; idsuiv=678; break;
        case 676 : texte = "Which one do you want?*                  red potion  *                ? GREEN POTION ?*                    nothing      "; 
            if (!gpJeu->getJoueur()->hasObjet(O_LANTERNE)) idsuiv=374;
            else idsuiv=680; break;
        case 677 : texte = "Which one do you want?*                  red potion  *                  green potion  *              ?     NOTHING     ?"; break;
        case 678 : texte = "A red potion for 40 Gold Ganon?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<40) idsuiv=75; break;
        case 679 : texte = "A red potion for 40 Gold Ganon?**              yes              NO ?"; break;
        case 680 : texte = "A green potion for 25 Gold Ganon?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<25) idsuiv=75; break;
        case 681 : texte = "A green potion for 25 Gold Ganon?**              yes              NO ?"; break;
        case 682 : 
            if (gpJeu->getJoueur()->getCoffre(15,14)) {id=683; chercheText();break;}
            texte = "I come from a long line of misfortunate individuals...For centuries my family has struggled to make ends meet";
			buffer= ".....even if I wanted to help you, I have nothing to give."; break;
        case 683 :
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)>=4) {id=685; chercheText();break;}
            texte = "I am the luckiest man in all of Hyrule."; buffer = "You don't believe me?*Take this treasure I found while wandering around this morning, I will probably find another one tomorrow!"; break;
        case 684 : texte = "You got a precious jewel!"; break;
        case 685 : texte = "How strange, giving you this jewel makes me feel like I've settled an old family debt..."; break;
        case 686 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)>4) {id=693; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)==4 
            && gpJeu->getJoueur()->getObjet()==15) {id=687; chercheText();break;}
            texte = "I am the best pastry chef in the country."; buffer = "Unfortunately, I have nothing in stock, it's hard to find anything sweet around here..."; break;
        case 687 : texte = "You have marmalade???*I thought the last of it was used up centuries ago!";
			       buffer= "Give it to me and I'll give you my special breakfast stock!"; idsuiv=688; break;
        case 688 : texte = "This marmalade for his stock, ok?**              YES ?            no  "; idsuiv=690; break;
        case 689 : texte = "This marmalade for his stock, ok?**              yes              NO ?"; idsuiv=691; break;
        case 690 : texte = "I will give you the best breakfast item you have ever eaten! Here, I had this put aside:"; break;
        case 691 : texte = "In that case? Why did you display it? *.... Show off"; break;
        case 692 : texte = "You traded the marmalade for a croissant."; break;
        case 693 : texte = "Sooner or later, I guess I will have to find a new job..."; break;
        case 694 :
            if (gpJeu->getJoueur()->getGanonMax() > 0) {id=696; chercheText();break;}
            texte = "You look even more broke than me... You should go and talk to the guy who runs the coffee shop, he is looking for a new hire."; buffer = "Also, take this, you need it more than I do ...:"; break;
        case 695 : texte = "You got a small wallet!";
				   buffer= "Yo can now hold up to 99 Gold Ganon!"; break;
        case 696 : texte = "So, making money?"; break;
        case 697 : 
            if ((gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon())<2 
            && (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis())<4) idsuiv=698;
            if ((gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon())<2 
            && (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis())>3) idsuiv=699;
            if ((gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon())>1 
            && (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis())<4) idsuiv=704;
            if ((gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon())>1 
            && (gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis())>3) idsuiv=709;
            texte = "Welcome to the Hyrule Bank. I specialize in all types of currencies."; break;
        case 698 : texte = "You don't have anything interesting, come back if you find precious currencies, I will give you a good price."; break;
        case 699 : texte = "These are rupees you say? Pretty curious."; idsuiv=700; break;
        case 700 : texte = "It seems to be precious, let's see..."; idsuiv=701; break;
        case 701 : 
            if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()==gpJeu->getJoueur()->getPieceMax()) {id=557; chercheText();break;}
            g=gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis();
            while (g%4 != 0) g--;
            gmax = (gpJeu->getJoueur()->getPieceMax()-(gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()))*4;
            if (g > gmax) g=gmax;
            os << g; os2 << (g/4);
            texte = os.str()+" Rupees for "+os2.str()+" Gold Coins, ok?**              YES ?            no  "; idsuiv=703; break;
        case 702 : 
            g=gpJeu->getJoueur()->getRubis() + gpJeu->getJoueur()->getBoostRubis();
            while (g%4 != 0) g--;
            gmax = (gpJeu->getJoueur()->getPieceMax()-(gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()))*4;
            if (g > gmax) g=gmax;
            os << g; os2 << (g/4);
            texte = os.str()+" Rupees for "+os2.str()+" Gold Coins, ok?**              yes              NO ?"; idsuiv=76; break;
        case 703 : texte = "It's a deal!"; break;
        case 704 : texte = "You have gold? With a monster head on it... You call that Gold Ganon?"; idsuiv=705; break;
        case 705 : texte = "It's really ugly, but the gold is reusable, let's see..."; idsuiv=706; break;
        case 706 : 
            if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()==gpJeu->getJoueur()->getPieceMax()) {id=557; chercheText();break;}
            g=gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon();
            if (g%2 != 0) g--;
            gmax = (gpJeu->getJoueur()->getPieceMax()-(gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()))*2;
            if (g > gmax) g=gmax;
            os << g; os2 << (g/2);
            texte = os.str()+" Gold Ganon for "+os2.str()+" Gold Coins, ok?**              YES ?            no  "; idsuiv=708; break;
        case 707 : 
            g=gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon();
            if (g%2 != 0) g--;
            gmax = (gpJeu->getJoueur()->getPieceMax()-(gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()))*2;
            if (g > gmax) g=gmax;
            os << g; os2 << (g/2);
            texte = os.str()+" Gold Ganon for "+os2.str()+" Gold Coins, ok?**              yes              NO ?"; idsuiv=76; break;
        case 708 : texte = "It's a deal!"; break;
        case 709 : texte = "What do you want to sell me?*   - RUPEES ?*   - Gold Ganon  *   - Nothing  "; idsuiv=700; break;
        case 710 : texte = "What do you want to sell me?*   - Rupees  *   - GOLD GANON ?*   - Nothing  "; idsuiv=705; break;
        case 711 : texte = "What do you want to sell me?*   - Rupees  *   - Gold Ganon  *   - NOTHING ?"; idsuiv=76; break;
        case 712 :
            if (gpJeu->getJoueur()->getCoffre(15,22)) {id=717; chercheText();break;}
            texte = "Hello Link, I was waiting for you."; idsuiv=713; break;
        case 713 : texte = "I am the leader of the 7 Wise Men, and also the most powerful. I saw you in my dreams, as well as a very sad future..."; idsuiv=714; break;
        case 714 : texte = "Your presence here seems to show that I was successful... At least partially..."; idsuiv=715; break;
        case 715 : texte = "I was the one who created the portal to the future, for you to witness my visions."; idsuiv=716; break;
        case 716 : texte = "I also built the Temple of Time with the other Wise Men, so that you would be able to travel through time as you saw fit."; idsuiv=717; break;
        case 717 : texte = "From now on it's up to you. You must find the 7 magic crystals that open the way to the legendary Goddesses Temple, and be the first to find and take the Triforce!"; idsuiv=718; break;
        case 718 : texte = "May the way of the Hero lead to the Triforce!"; break;
        case 719 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)>2
            && gpJeu->getJoueur()->hasObjet(O_TROC2)>3
            && gpJeu->getJoueur()->hasObjet(O_TROC3)>3) {id=726; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)==2 
            && gpJeu->getJoueur()->getObjet()==3) {id=720; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)==3 
            && gpJeu->getJoueur()->getObjet()==7) {id=727; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==3 
            && gpJeu->getJoueur()->getObjet()==11) {id=733; chercheText();break;}
            texte = "Don't judge me by my size, I'm a first-class blacksmith!"; 
            buffer = "... It's just, I arrived here only yesterday, and I couldn't bring my forge with me... So I don't have anything to craft metal."; break;
        case 720 : texte = "You've carried an anvil with you all this way??? What are you, stupid?"; buffer = "I can take it off your hands if you want? I would even give you a little reward for your trouble."; idsuiv=721; break;
        case 721 : texte = "This anvil for a reward, ok?**              YES ?            no  "; idsuiv=723; break;
        case 722 : texte = "This anvil for a reward, ok?**              yes              NO ?"; idsuiv=724; break;
		case 723 : texte = "Thank you, here, I made this some time ago, it's always brought me great luck:"; break;
        case 724 : texte = "I only said I would take it to help you out, just so you know ..."; break;
        case 725 : texte = "You got a horseshoe!"; break;
        case 726 : texte = "With all these things you brought to me, I can open my forge again!"; break;
        case 727 : texte = "That's a good hammer you have there...*It may be useful in my forge...";
			       buffer= "Will you give it to me? I will reward you with one of my creations."; idsuiv=728; break;
        case 728 : texte = "This hammer for a reward, ok?**              YES ?            no  "; idsuiv=730; break;
        case 729 : texte = "This hammer for a reward, ok?**              yes              NO ?"; idsuiv=731; break;
        case 730 : texte = "Thank you, here is one of my most beautiful creations:"; break;
        case 731 : texte = "As if you know what to do with this hammer ..."; break;
        case 732 : texte = "You got a little bell!"; break;
        case 733 : texte = "You have some Gold Dust?*I will need it to forge new wonderful objects, will you give it to me for a wonderful reward?"; idsuiv=734; break;
        case 734 : texte = "The Gold Dust for a wonderful reward, ok?**              YES ?            no  "; idsuiv=736; break;
        case 735 : texte = "The Gold Dust for a wonderful reward, ok?**              yes              NO ?"; idsuiv=737; break;
        case 736 : texte = "Thank you, take this magic mirror in return! *It was bewitched by the Wise Men, it has some mysterious powers..."; break;
        case 737 : texte = "What a great reward..."; break;
        case 738 : texte = "You got the magic mirror!"; break;
        case 739 : 
            if (gpJeu->getJoueur()->getEpee()>2) {id=748; chercheText();break;}
            if (gpJeu->getJoueur()->getEpee()==0) {id=745; chercheText();break;}
            texte = "Your sword is really impressive... But I think I could make it stronger!"; idsuiv=740; break;
        case 740 : texte = "Do you want me to temper your sword?**              YES ?            no  "; idsuiv=742; break;
        case 741 : texte = "Do you want me to temper your sword?**              yes              NO ?"; idsuiv=743; break;
        case 742 : texte = "You wont regret it! *Next time you visit your sword will be complete"; break;
        case 743 : texte = "What a pity, your sword really is fascinating..."; break;
        case 744 : texte = "You entrusted the blacksmith with the Master Sword."; break;
        case 745 : texte = "It won't be long, don't worry."; break;
        case 746 :
            if (gpJeu->getJoueur()->getEpee()) {id=748; chercheText();break;}
            texte = "It's done, here is your sword:"; break;
        case 747 : texte = "The Master Sword has been tempered! It's power has imcreased!"; break;
        case 748 : texte = "I can't make that sword any stronger, sorry!"; break;
        case 749 : texte = "You shouldn't travel too far from the village in this weather..."; break;
        case 750 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "10 arrows for 5 Gold Coins?**              YES ?            no  ";
            if (!gpJeu->getJoueur()->hasObjet(O_ARC)) {id=373; chercheText(); break;}
            else if (gpJeu->getJoueur()->getFleche() == gpJeu->getJoueur()->getFlecheMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<5) idsuiv=75; break;
        case 751 : texte = "10 arrows for 5 Gold Coins?**              yes              NO ?"; break;
        case 752 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "5 bombs for 10 Gold Coins?**              YES ?            no  ";
            if (!gpJeu->getJoueur()->hasObjet(O_SAC_BOMBES)) {id=372; chercheText(); break;}
            else if (gpJeu->getJoueur()->getBombe() == gpJeu->getJoueur()->getBombeMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<10) idsuiv=75; break;
        case 753 : texte = "5 bombs for 10 Gold Coins?**              yes              NO ?"; break;
        case 754 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "One heart for 1 Gold Coins?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getVie() == gpJeu->getJoueur()->getVieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<1) idsuiv=75; break;
        case 755 : texte = "One heart for 1 Gold Coins?**              yes              NO ?"; break;
        case 756 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "A little magic jar for 3 Gold Coins? *              YES ?            no  ";
            if (gpJeu->getJoueur()->getMagie() == gpJeu->getJoueur()->getMagieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<3) idsuiv=75; break;
        case 757 : texte = "A little magic jar for 3 Gold Coins? *              yes              NO ?"; break;
        case 758 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "A big magic jar for Gold Coins? *              YES ?            no  ";
            if (gpJeu->getJoueur()->getMagie() == gpJeu->getJoueur()->getMagieMax()) {id=374; chercheText(); break;}
            else if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<6) idsuiv=75; break;
        case 759 : texte = "A big magic jar for 6 Gold Coins? *              yes              NO ?"; break;
        case 760 : texte = "You found the book of Mudora!";
			       buffer= "From now on you will be able to read ancient Hylian!"; break;
        case 761 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "Hello, I am the mayor of this village";
			buffer= "Don't listen to the gossip about all of our lives being endangered ...just enjoy your time with us."; break;
        case 762 : texte = "Looks like it stopped snowing..."; break;
        case 763 :
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            if (gpJeu->getJoueur()->hasBouteille(0)!=1 
            && gpJeu->getJoueur()->hasBouteille(1)!=1
            && gpJeu->getJoueur()->hasBouteille(2)!=1
            && gpJeu->getJoueur()->hasBouteille(3)!=1) {id=408; chercheText(); break;}
            texte = "Red potions restore your energy and green potions restore your magic."; 
            idsuiv=764; break;
        case 764 : texte = "Wich one do you want?*                ? RED POTION ?*                 green potion   *                    nothing    "; idsuiv=767; break;
        case 765 : texte = "Wich one do you want?*                  red potion  *               ? GREEN POTION ? *                    nothing    "; 
            if (!gpJeu->getJoueur()->hasObjet(O_LANTERNE)) idsuiv=374;
            else idsuiv=769; break;
        case 766 : texte = "Wich one do you want?*                  red potion  *                 green potion   *                ?   NOTHING   ?"; break;
        case 767 : texte = "A red potion for 15 Gold Coins?**              YES ?            no  "; 
            if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<15) idsuiv=75; break;
        case 768 : texte = "A red potion for 15 Gold Coins?**              yes              NO ?"; break;
        case 769 : texte = "A green potion for 10 Gold Coins?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<10) idsuiv=75; break;
        case 770 : texte = "A green potion for 10 Gold Coins?**              yes              NO ?"; break;
        case 771 : texte = "You look pretty poor, you don't even have a wallet? Here, take this one:"; break;
        case 772 : texte = "You got a small wallet!";
			       buffer= "You can now hold up to 99 Gold Coins!"; break;
        case 773 :
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "Hello, I am one of the 7 Wise Men, I'm just passing through this town."; idsuiv=774; break; 
        case 774 :
            texte ="The book of Mudora was bewitched to enable anyone having it to speak our language.";
            buffer = "You must have come from far away if you don't speak it already... Keep this book, it will help you."; break;
        case 775 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "Hi, the name's Ganondorf, if you hear anything about any magic crystals, you come and speak to me, ya' got it?"; break;
        case 776 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "I am the general of the Hylian Knights. *If you don't want any trouble then behave yourself, follow Ganondorf's example, he is a good guy."; break;
        case 777 :
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "This Ganondorf keeps treating us to drinks ... *He really is a good fellow ..."; break;
        case 778 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)>5) {id=785; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)==5 
            && gpJeu->getJoueur()->getObjet()==15) {id=779; chercheText();break;}
            texte = "Drinking is great... but when do we eat?"; break;
        case 779 : texte = "Don't tell me... This smell... It's a croissant!";
			       buffer= "Give it to me for my endless friendship?"; idsuiv=780; break;
        case 780 : texte = "This croissant for his friendship, ok?**              YES ?            no  "; idsuiv=782; break;
        case 781 : texte = "This croissant for his friendship, ok?**              yes              NO ?"; idsuiv=783; break;
        case 782 : texte = "Thank you!!!*Take this as a symbol of our new friendship!"; break;
        case 783 : texte = "... You're declaring war on the Hylian Knights??? Are you out of your mind???"; break;
        case 784 : texte = "You traded the croissant for a beer."; break;
        case 785 : texte = "Hi pal!*Will you drink with us?"; break;
        case 786 :
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            texte = "If you want a hylian knight to disclose his secrets, you must treat him to a drink. It's the rules."; break;
        case 787 :
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            if (gpJeu->getJoueur()->getCoffre(15,23)<3) {id=788; chercheText(); break;}
            texte = "You already know all my secrets...*Hic!"; break;
        case 788 : 
            texte = "I know a lot of secrets... secrets only known to ourselves and Ganondorf. A glass of beer is 1 Gold Coin, do we have a deal?"; idsuiv=789; break;
        case 789 : 
            texte = "A secret for 1 Gold Coin, ok?**              YES ?            no  ";
            if (gpJeu->getJoueur()->getPiece() + gpJeu->getJoueur()->getBoostPiece()<1) idsuiv=75; break;
        case 790 : texte = "A secret for 1 Gold Coin, ok?**              yes              NO ?"; idsuiv=76; break;
        case 791 : 
            if (gpJeu->getJoueur()->getCoffre(15,23)>0) {id=792; chercheText(); break;}
            texte = "The Hylian Knights were founded to protect the temple of the Goddesses... This temple is said to hide a powerful relic called the Triforce..."; break;
        case 792 : 
            if (gpJeu->getJoueur()->getCoffre(15,23)>1) {id=793; chercheText(); break;}
            texte = "To open the way to the temple of the Goddesses, you have to go to the Holy Land, North of here, and stand on the Triforce symbol with the 7 crystals in your possession."; break;
        case 793 : texte = "The 7 magic crystals are hidden everywhere in Hyrule... And, keep this a secret, one of them is kept by the legendary Hylian Knights!"; break;
        case 794 : texte = "The general chased him downstairs..."; break;
        case 795 : texte = "What a strong man... he beat us so easily..."; break;
        case 796 : texte = "He is... downstairs... Be careful..."; break;
        case 797 : texte = "He is too strong... The general won't hold out much longer...*Help him, I'm begging you..."; break;
        case 798 : texte = "Someone ... stop him ..."; break;
        case 799 : texte = "Do you intend to stand in my way too? en garde!"; break;
        case 800 : texte = "I failed...*Forgive me master..."; break;
        case 801 : texte = "Thank you for your help Link, without you, Ganondorf would have taken the crystal..."; idsuiv=802; break;
        case 802 : texte = "The order of the Hylian Knights was founded to protect the entrance to the Temple of the Goddesses.";
			       buffer= "It was our mission to keep the crystal safe. Without this one, the 6 others are useless."; idsuiv=803; break;
        case 803 : texte = "Unfortunately, with time, the order has become weak. And today, we failed."; idsuiv=804; break;
        case 804 : texte = "Keep the crystal, you seem to be more able to defend it than we are..."; idsuiv=805; break;
        case 805 : texte = "As for Ganondorf... We couldn't have guessed he would betray us... He was almost one of us..."; idsuiv=806; break;
        case 806 : texte = "He was sent to the Supermax prison, North of here... He shouldn't be any trouble now ..."; break;
        case 807 : 
            if (gpJeu->getJoueur()->getGemme(178)) {id=816; chercheText(); break;}
            texte = "I failed against Ganondorf, but don't underestimate me. I am the man who killed a hundred wolves!"; idsuiv=808; break;
        case 808 : 
            g=gpJeu->getJoueur()->nbLoups();
            if (g>=1) {id=809; chercheText(); break;}
            texte = "You haven't killed any wolves???*You are a coward!"; break;
        case 809 : 
            g=gpJeu->getJoueur()->nbLoups();
            if (g>=2) {id=810; chercheText(); break;}
            texte = "You killed only one wolf???*You are weak!"; break;
        case 810 : 
            g=gpJeu->getJoueur()->nbLoups();
            if (g>=50) {id=811; chercheText(); break;}
            os << g;
            texte = "You killed only "+os.str()+" wolves?*That's not that great..."; break;
        case 811 : 
            g=gpJeu->getJoueur()->nbLoups();
            if (g>=80) {id=812; chercheText(); break;}
            os << g;
            texte = "You killed "+os.str()+" wolves? Not bad..."; break;
        case 812 : 
            g=gpJeu->getJoueur()->nbLoups();
            if (g>=100) {id=813; chercheText(); break;}
            os << g;
            texte = "You killed "+os.str()+" wolves? Pretty impressive..."; break;
        case 813 : 
            g=gpJeu->getJoueur()->nbLoups();
            if (g>100) {id=814; chercheText(); break;}
            texte = "You killed 100 wolves?*As many as I did... it's hard to believe..."; break;
        case 814 : 
            texte = "You killed more than a hundred wolves??? Incredible..."; idsuiv=815; break;
        case 815 : texte = "You really deserve this reward:"; break;
        case 816 : texte = "It's time for me to go back into training..."; break;
        case 817 : texte = "I will change my hairstyle."; break;
        case 818 : texte = "I will start a diet."; break;
        case 819 : texte = "I won't sell secrets anymore."; break;
        case 820 : texte = "I won't spend my days in the tavern."; break;
        case 821 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)>5) {id=828; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC2)==5 
            && gpJeu->getJoueur()->getObjet()==7) {id=822; chercheText();break;}
            texte = "I broke my last axe... Now I play hangman to kill time, but it's not the same..."; break;
        case 822 : texte = "You have an axe??? Give it to me! I will trade you a rope for it, it's just as effective at ending a life!"; idsuiv=823; break;
        case 823 : texte = "This axe for a rope, ok?**              YES ?            no  "; idsuiv=825; break;
        case 824 : texte = "This axe for a rope, ok?**              yes              NO ?"; idsuiv=826; break;
        case 825 : texte = "I am so touched ... This is for you:"; break;
        case 826 : texte = "Your answer should be punishable by the death penalty ..."; break;
        case 827 : texte = "You traded the axe for a rope."; break;
        case 828 : texte = "I can't wait to try this axe!"; break;
        case 829 : texte = "Hello, I am the mayor of this village."; idsuiv=830; break;
        case 830 : texte = "Mabe village is like paradise for tourists, but like hell for robbers."; buffer = "Did you know that famous pirate was captured when he passed through here?"; break;
        case 831 : texte = "You found a hammer!"; break;
        case 832 : 
            if (gpJeu->getJoueur()->getCoffre(15,26)) {id=839; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)==6 
            && gpJeu->getJoueur()->getObjet()==3) {id=833; chercheText();break;}
            texte = "My husband is a guard at the prison.*It's a full-time job so I don't see him very often..."; break;
        case 833 : texte = "???*What do you have here???*Let me have a look at it!"; idsuiv=834; break;
        case 834 : texte = "Give her the wedding ring, ok?**              YES ?            no  "; idsuiv=836; break;
        case 835 : texte = "Give her the wedding ring, ok?**              yes              NO ?"; idsuiv=837; break;
        case 836 : texte = "It's my husband's wedding ring!*Don't tell me he went to see HER again!!!"; break;
        case 837 : texte = "...*This seems more and more shady...*Gimme that!"; idsuiv=834; break;
        case 838 : texte = "You traded the wedding ring for nothing."; break;
        case 839 : texte = "Out of my way!"; break;
        case 840 : texte = "Don't go in the storeroom, I haven't cleaned it in ages!"; break;
        case 841 : texte = "A famous pirate named Ganon D. Roger was captured in this town a long time ago...";
            buffer = "They say that a descendant of this pirate lives in Hyrule..."; break;
        case 842 : texte = "You are in the 7 Wise Men's residence.*This place is devoted to meditation and knowledge."; break;
        case 843 : texte = "Our master, who is the most powerful of the 7 wise men, is barely seen here.";
			       buffer= "He prefers meditating in his house in the South of the Village."; break;
        case 844 : texte = "Some years ago, we were 8 Wise Men. One of us, Agahnim, thought that it was our duty to take the Triforce and to use it for the good of all peoples."; idsuiv=845; break;
        case 845 : texte = "The master squarely refused. He said that such a power should not fall into the hands of men, that the consequences could be disastrous..."; idsuiv=846; break;
        case 846 : texte = "After this quarrel, Agahnim left the order. But lately, he reappeared, endowed with strange powers..."; buffer="We unfortunately do not know what he is planning."; break;
        case 847 : texte = "A legendary pirate came to Hyrule long ago. He was captured after a long fight with the Hylian Knights of the time."; idsuiv=848; break;
        case 848 : texte = "The day of his public execution, a man in the crowd asked him where he had hidden his treasure. The pirate explained that it was hidden within 4 temples around Hyrule."; idsuiv=849; break;
        case 849 : texte = "After this declaration, many men went in search of this treasure but nobody ever came back..."; break;
        case 850 : texte = "Did you meet a man named Ganondorf? *When he was just a child he almost ended up in the stomach of a wolf, but he was saved by a former member of our order."; idsuiv=851; break; 
        case 851 : texte = "Since then he considers the man who saved him his master."; break;
        case 852 : texte = "The mayor asked us to gather our powers in order to create a very special temple to the East of here. He says that this temple will save the world..."; break;
        case 853 : 
            if (gpJeu->getJoueur()->getGemme(182)) {id=854; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)>0) {id=855; chercheText();break;}
            texte = "The mountain to the North of the village hides a temple. Within this temple is hidden an incredible treasure. But... it's far to dangerous to go in."; break;
        case 854 : texte = "I still can't believe you were able to find this treasure..."; break;
        case 855 : texte = "WHAT ??? YOU FOUND THE TREASURE IN THE TEMPLE!!!"; idsuiv=856; break;
        case 856 : texte = "Incredible... take this, I want to reward you for this feat!"; break;
        case 857 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)>4) {id=864; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)==4 
            && gpJeu->getJoueur()->getObjet()==3) {id=858; chercheText();break;}
            texte = "It's been a long time since HE gave me anything..."; break;
        case 858 : texte = "You have a jewel?*It's from HIM, isn't it?*Yes, it can only be from HIM!"; idsuiv=859; break;
        case 859 : texte = "Give her the jewel?**              YES ?            no  "; idsuiv=861; break;
        case 860 : texte = "Give her the jewel?**              yes              NO ?"; idsuiv=862; break;
        case 861 : texte = "It's so nice of him ...";
			       buffer= "Could you please go to the prison and give him this letter?"; break;
        case 862 : texte = "... HE will be hearing about this!"; break;
        case 863 : texte = "You traded the jewel for a letter."; break;
        case 864 : texte = "He! He! He!"; break;
        case 865 : texte = "I am the mayor of this village and er... anyway the Wise Men are the ones in real control here..."; break;
        case 866 :
            if (gpJeu->getJoueur()->getCoffre(15,27)==12) {id=886; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(15,27)) {id=868; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==7 
            && gpJeu->getJoueur()->getObjet()==11) {id=867; chercheText();break;}
            texte = "We are closed to the public."; break;
        case 867 : texte = "We have waited for you a very long time, Link.";
			       buffer= "Please take the time to visit my opera house..."; break;
        case 868 : texte = "This opera house has a long story, take your time and let it sink in..."; break;
        case 869 : texte = "Welcome visitor, allow me to tell you the story of this opera house."; buffer="I am the founder of the opera house, but before I built it I was nothing, a mere thief."; break;
        case 870 : texte = "One day, a burglary went wrong and the Hylian Knights patrolling near the tavern converged on me. I was beaten and sent to prison."; break;
        case 871 : texte = "In prison, I found an old skull under my bed. I used it as a prop to practice my stand up routine, much to the delight of my cell mate."; idsuiv=872; break;
        case 872 : texte = "Thus my passion for the theater was born!"; break;
        case 873 : texte = "Shortly before my release, I made a promise on the old skull to construct the most sumptuous of theaters before my cellmate's release."; break;
        case 874 : texte = "Once free, I went in search of the perfect place to build it. Until the day when, chased by wolves, I had to take refuge in the Lost Woods."; idsuiv=875; break;
        case 875 : texte = "That's when I found this glade, at the far end of the forest, in a green setting, protected by the one-thousand-year-old trees..."; break;
        case 876 : texte = "I started to build my opera house. The plans were quickly made, but without money to pay workers, it seemed to be an impossible task."; idsuiv=877; break;
        case 877 : texte = "Just when I was thinking of giving up, an odd fellow came and gave me the old skull I found in prison, this reminded me of my promise."; break;
        case 878 : texte = "After months of work, the opera house was finished. It was the most beautiful opera house Hyrule had ever seen."; break;
        case 879 : texte = "Quickly, prestigious artists came from all over the world to perform here. I had fufilled my dream and kept my promise."; break;
        case 880 : texte = "During the war against Ganon, many smugglers used the chaos to prosper."; idsuiv=881; break;
        case 881 : texte = "One of them was none other than my old cellmate, just released, he asked to use the opera house as his hideout."; break;
        case 882 : texte = "With the return of peace, the King of Hyrule wanted to end the smuggling. He sent his best soldiers to chase the culprits."; idsuiv=883; break;
        case 883 : texte = "I was afraid of losing everything because of my complicity, I asked my old friend to leave the opera house, saying that I would hand him over to the king if he refused."; break;
        case 884 : texte = "Obliged to leave the opera house, the bandits locked me in their old hideout with all my employees, and burned it down."; idsuiv=885; break;
        case 885 : texte = "This is how I died, along with my opera house, it was destroyed forever..."; break;
        case 886 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)>7) {id=893; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==7 
            && gpJeu->getJoueur()->getObjet()==11) {id=887; chercheText();break;}
            texte = "You know my story, don't you have anything to show me?"; break;
        case 887 : texte = "I have waited centuries for your arrival, so I could settle that old debt ..."; idsuiv=888; break;
        case 888 : texte = "Make him settle his debt?**              YES ?            no  "; idsuiv=890; break;
        case 889 : texte = "Make him settle his debt?**              yes              NO ?"; idsuiv=891; break;
        case 890 : texte = "My life was short but exciting. None of it would have been possible without your help."; buffer="I wanted to give you this: the saw I used to construct this opera house!"; break;
        case 891 : texte = "You must be kidding?"; break;
        case 892 : texte = "You traded the IOU for a saw!"; break;
        case 893 : texte = "Go now, it is time for us to rest in peace..."; break;
        case 894 : 
            if (!gpJeu->getJoueur()->hasObjet(O_LIVRE)) {id=319; chercheText(); break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)>1) {id=901; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==1 
            && gpJeu->getJoueur()->getObjet()==11) {id=895; chercheText();break;}
            texte = "I am the bartender, I know all the gossip ...Here's a good one:";
            buffer = "My favorite color is said to be yellow, but you didn't hear that from me ...."; break;
        case 895 : texte = "WOW, that's a pretty yellow gemstone you have there ...";
			       buffer= "Would you trade it to me for my best bottle of wine?"; idsuiv=896; break;
        case 896 : texte = "This yellow gemstone for a bottle of wine, ok?**              YES ?            no  "; idsuiv=898; break;
        case 897 : texte = "This yellow gemstone for a bottle of wine, ok?**              yes              NO ?"; idsuiv=899; break;
        case 898 : texte = "Yay! It's mine!"; break;
        case 899 : texte = "Tsss... like anybody else would want it..."; break;
        case 900 : texte = "You traded the yellow gemstone for a bottle of wine."; break;
        case 901 : texte = "You want something to drink? Free of charge, for you."; break;
        case 902 : texte = "A melody is engraved on the stele:"; break;
        case 903 : texte = "You learn the song of soaring!*Play it outside to teleport!"; break;
        case 904 : texte = "You learn the inverted song of time!*Play it outside to go back in time!"; break;
        case 905 : texte = "You learn the song of double time!*Play it outside to travel to the future!"; break;
        case 906 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)>5) {id=913; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC1)==5 
            && gpJeu->getJoueur()->getObjet()==3) {id=907; chercheText();break;}
            texte = "I'm a part-time guard here at the prison. *Outside of the visiting hours I'm not allowed to let you pass."; break;
        case 907 : texte = "This letter is for me? It's probably from HER... Give it here, quickly!"; idsuiv=908; break;
        case 908 : texte = "Give the letter?**              YES ?            no  "; idsuiv=910; break;
        case 909 : texte = "Give the letter?**              yes              NO ?"; idsuiv=911; break;
        case 910 : texte = "...*...*..."; buffer="I have to leave my post... it's er... an emergency... You look like a good guy, take my place. Oh and hang on to this for me:"; break;
        case 911 : texte = "It's not for me?*Too bad..."; break;
        case 912 : texte = "You traded the letter for a wedding ring."; break;
        case 913 : texte = "I gotta go!"; break;
        case 914 : 
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)>5) {id=921; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==5 
            && gpJeu->getJoueur()->getObjet()==11) {id=915; chercheText();break;}
            texte = "I am a mere innocent, here by mistake... *You wouldn't have something to help me escape from here, would you?"; break;
        case 915 : texte = "A... spoon huh?"; idsuiv=916; break;
        case 916 : texte = "Give the spoon?**              YES ?            no  "; idsuiv=918; break;
        case 917 : texte = "Give the spoon?**              yes              NO ?"; idsuiv=919; break;
        case 918 : texte = "Thank you... ... ...*Here, take this gift as a thank you...*It belonged to my former cellmate..."; break;
        case 919 : texte = "Looks like a wonderful spoon charged prison break has eluded me..."; break;
        case 920 : texte = "You traded the spoon for a skull."; break;
        case 921 : texte = "Well... now I have some work to do..."; break;
        case 922 : texte = "I didn't think I could fail... The Hylian Knights aren't very strong, even their leader is getting weaker..."; break;
        case 923 : texte = "The explosion came from the in other room."; break;
        case 924 : texte = "So this is the man who was able to stop the powerful Ganondorf..."; idsuiv=925; break;
        case 925 : texte = "I am Agahnim, former Wise Man, and Ganondorf's master. As for you, you must be Link..."; idsuiv=926; break;
        case 926 : texte = "Like it or not, we are taking the Triforce. Farewell!"; break;
        case 927 : texte = "                    Level 1 :                                                                                Temple of Courage"; break;
        case 928 : texte = "                    Level 2 :                                                                                 Temple of Wisdom"; break;
        case 929 : texte = "                    Level 3 :                                                                                  Temple of Power"; break;
        case 930 : texte = "                    Level 4 :                                                                                   Abyss Ruins"; break;
        case 931 : texte = "                    Level 5 :                                                                                 Phantom Pyramid"; break;
        case 932 : texte = "                 Great Pyramid"; break;
        case 933 : texte = "                Temple of Earth"; break;
        case 934 : texte = "                 Temple of Air"; break;
        case 935 : texte = "                Temple of Water"; break;
        case 936 : texte = "                 Temple of Fire"; break;
		case 937 : texte = "               Temple of Goddesses"; break;
        case 938 : 
            if (gpJeu->getAudio()->isSpecial()) {
            texte = "                 Hyrule Castle"; break;}
            texte = "                   Final Level :                                                                               Hyrule Castle"; break;
        case 939 : texte = "            Second Quest - Level 1 :                                                                               Casino"; break;
        case 940 : texte = "            Second Quest - Level 2 :                                                                            Tower of Gem"; break;
        case 941 : texte = "          Second Quest - Final Level :                                                                        Final Destination"; break;
        
        case 942 : texte = "You found the map!!!";
			       buffer= "You can now press (Y) to see the dungeon map."; break;
        case 943 : texte = "You found the compass!!!";
			       buffer= "Now you can pinpoint the location of chests, and the dungeon's evil master!"; break;
        case 944 : texte = "You found the Big Key!!!";
			       buffer= "Use it to open the door to the boss's chamber."; break;
        case 945 : texte = "You found a small key!"; break;
        case 946 : texte = "You found a heart container!!!";
			       buffer= "Your heart level has increased by one!!!"; break;
        case 947 : texte = "You found a bow!!!";
			       buffer= "Equip it by pressing START and selecting it, then use it with (X) to attack enemies from a distance!"; break;
        case 948 : 
            if (gpJeu->getZone()==47) {id=949; chercheText();break;}
            if (gpJeu->getZone()==48) {id=950; chercheText();break;}
            texte = "You found the Pendant of Courage!!! **Two Pendants remain!"; break;
        case 949 : texte = "You found the Pendant of Wisdom!!!";
			       buffer= "Your goal of finding three Pendants is in sight! Go for the last one!"; break;
        case 950 : texte = "You found the Pendant of Power!!! **That's it! The final pendant!";
			       buffer= "Go now and speak to the princess, she is waiting for you in The Lost Woods..."; break;
        case 951 : texte = "You found the Power Gloves!!!";
			       buffer= "You can pick up and carry stones now!"; break;
        case 952 : 
            if (gpJeu->getJoueur()->hasObjet(O_GANTS)) {id=954; chercheText();break;}
            if (gpJeu->getJoueur()->getExplore(1,16,4)) {id=953; chercheText();break;}
            texte = "I give up, you win!";
			buffer= "How could you see through my Ultimate LOL technique???"; break;
        case 953 : texte = "You won't let me get off that easy, huh?";
			       buffer= "The code for the next room is 12086... Now get lost."; break;
        case 954 : texte = "I should have stayed in the family gang..."; break;
        case 955 : texte = "You found the lantern!!!";
			       buffer= "Now you can light torches and see your way in darkness."; break;
        case 956 : texte = "You found the flippers!!!";
			       buffer= "With these you wll be able to swim through the water!"; break;
        case 957 : 
            if (gpJeu->getJoueur()->getCoffre(3,29)) {id=960; chercheText();break;}
            texte = "Oh my! *How did you make it in here alive?!?"; idsuiv=958; break;
        case 958 : texte = "You're Link, you say?*So the time has finally come? ......."; idsuiv=959; break;
        case 959 : texte = "Ganon's minions discovered my existence and destroyed my village. That's why I came to this temple to hide.";
			       buffer= "The beast you killed was here to protect me, in case Ganon ever discovered my location"; idsuiv=960; break;
        case 960 : texte = "You must continue your quest, Link ... I will see you again at the portal!"; break;
        case 961 : texte = "You found a tougher tunic!!!";
				   buffer= "Your defense raises by one point!"; break;
        case 962 : texte = "You found the Key of Time!!!";
			       buffer= "Now go and show it to the Wise Men!"; break;
        case 963 : texte = "You found the Magic Hammer!!!";
				   buffer= "Use it to pound down stakes that block your way!"; break;
        case 964 : texte = "You found the Titan's Mitt!!!";
			       buffer= "Now you can lift the heaviest rocks!!!"; break;
        case 965 : texte = "You found a Yellow Gemstone!";
			       buffer= "It's an invaluable treasure, keep it safe!"; break;
        case 966 : texte = "You found the Fairy Bow!!!";
			       buffer= "Your arrows are now incredibly powerful!!!"; break;
        case 967 : texte = "You found a Green Gemstone!";
			       buffer= "It's an invaluable treasure, keep it safe!"; break;
        case 968 : texte = "You found the Ice Rod!!!";
			       buffer= "Now you can freeze your enemies from a distance!!!"; break;
        case 969 : texte = "You found a Blue Gemstone!";
			       buffer= "It's an invaluable treasure, keep it safe!"; break;
        case 970 : texte = "You found the Fire Rod!!!";
			       buffer= "You can now shoot powerful fire balls!!!"; break;
        case 971 : texte = "You found a Red Gemstone!";
			       buffer= "It's an invaluable treasure, keep it safe!"; break;
	    case 972 : texte = "You found an incredibly tough shield!!!";
			       buffer= "Your defense raises by one point!"; break;
        case 973 : texte = "At last, here you are."; idsuiv=974; break;
        case 974 : texte = "Did you really think you could outrun a sorcerer?"; idsuiv=975; break;
        case 975 : texte = "I guess I owe you thanks, really. Ganondorf and I spent months searching and didnt even find one crystal."; idsuiv=976; break;
        case 976 : texte = "Then, the day when we were about to capture one with ease, you turned up and brought down the powerful Ganondorf..."; idsuiv=977; break;
        case 977 : texte = "I didn't expect that, but it seemed obvious that we were working towards the same end, and that you were ahead of us."; idsuiv=978; break;
        case 978 : texte = "So we decided to let you find this temple for us."; idsuiv=979; break;
        case 979 : texte = "You had fun all this time being the hero, but now it's our turn."; idsuiv=980; break;
        case 980 : texte = "It is time for you to disappear."; break;
        case 981 : texte = "What??? *You couldn't possibly defeat Aghanim???"; idsuiv=982; break;
        case 982 : texte = "... *Hope still remains, I can do something..."; break;
        case 983 : texte = "Welcome Link. *We are Din, Nayru and Farore, the founding Goddesses of Hyrule."; idsuiv=984; break;
        case 984 : texte = "Your efforts to save Hyrule have finally lead you to us."; idsuiv=985; break;
        case 985 : texte = "As you may have already discovered, You cannot change the past. All of your acts have only prepared you for the present."; idsuiv=986; break;
        case 986 : texte = "Ganondorf came to our temple to follow his master, and he finally brought him back to life."; idsuiv=987; break;
        case 987 : texte = "He wished to gain the ability to travel between life and death, but only the most powerful demons can do that."; idsuiv=988; break;
        case 988 : texte = "With his new powers, Ganon was able to bring Aghanim back to life, but his new nature outweighed his reason."; idsuiv=989; break;
        case 989 : texte = "He changed Agahnim into a zombie to repay him, and proclaimed himself King of all Evil, then came back to conquer Hyrule."; idsuiv=990; break;
        case 990 : texte = "The mayor of the middle village organized the defense of Hyrule after proclaiming himself King. He had the Master Sword forged and gathered knights and Wise Men to work together."; idsuiv=991; break;
        case 991 : texte = "The Hylian Knights were destroyed, but their general, armed with the Master Sword, held back Ganon long enough to give the Wise Men time to seal him up forever."; idsuiv=992; break;
        case 992 : texte = "But you know what happened next. Using Agahnim, Ganon eliminated the wise men's descendants and broke the seal."; idsuiv=993; break;
        case 993 : texte = "With the Master Sword you beat him several times, but death can't keep him prisoner for long."; idsuiv=994; break;
        case 994 : texte = "Ganon found the Triforce, but this temple hides other treasures..."; idsuiv=995; break;
        case 995 : texte = "To stand against the Triforce, able to give an illumined power to the one touching it, we created an Anti-Triforce."; idsuiv=996; break;
        case 996 : texte = "They are 3 weapons with an exceptional power. If two of them unite against the Triforce holder, they will grant his wish."; idsuiv=997; break;
        case 997 : texte = "The Sword of Courage is rightfully yours. We also entrust you with the Bow of Wisdom, give it to the only one able to handle it."; idsuiv=998; break;
        case 998 : texte = "As for the Trident of Power, we send it to the last chosen one."; break;
		case 999 : texte = "You got the Sword of Courage!!!";
			       buffer= "This legendary weapon gives off a tremendous feeling of power."; break;
        case 1000: texte = "You got the Bow of Wisdom!!!";
			       buffer= "A mysterious power prevents you from using it..."; break;
        case 1001: texte = "You must go now, Link. We shall send you back to your own time."; break;
        case 1002: texte = "Link! It's Zelda! I'm talking with you through telepathy!"; idsuiv=1003; break;
        case 1003: texte = "Ganon is back! He's attacking the castle!";
			       buffer= "All of the guards have been turned into monsters, and are under his control, be careful!"; break;
        case 1004: 
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_GARDE_PALAIS) {id=1010; chercheText();break;}
            texte = "The throne room is further North."; break;
        case 1005: 
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_ZELDA_PALAIS) {id=1010; chercheText();break;}
            if (gpJeu->getJoueur()->getRubisMax()) {id=1013; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_GARDE_PALAIS) {id=1007; chercheText();break;}
            texte = "The princess is not ready to see you yet."; idsuiv=1006; break; 
        case 1006: texte = "However, she instructed me to tell that some items have been set aside for you in the royal storeroom."; break;
        case 1007: texte = "The princess will be ready to see you in a few minutes."; break;
        case 1008:
            if (gpJeu->getJoueur()->getRubisMax()) {id=1010; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()<PARLE_GARDE_PALAIS) {id=1004; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_GARDE_RESERVE) {id=1009; chercheText();break;}
            texte = "You say you've got authorization to go in the royal storeroom? *Very well, you may enter."; break;
        case 1009: texte = "The storeroom is further East"; break;
        case 1010: texte = "Everything here is under control. Move along."; break;
        case 1011: texte = "You found a shield!";
			       buffer= "Your defense raises by one point!"; break;
        case 1012: texte = "You got a small wallet!";
			       buffer= "You can now hold up to 99 Rupees!"; break;
        case 1013: texte = "Princess Zelda is waiting for you."; break;
        case 1014: texte = "Hello Link."; break;
        case 1015: texte = "Er, Link! *I'm here!*Yoo-hoo!"; break;
        case 1016: 
            if (gpJeu->getJoueur()->getAvancement()>=PASSAGE_TROUVE) {id=1031; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()>=ZELDA_SOUS_SOL) {id=1025; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_ZELDA_PALAIS) {id=1019; chercheText();break;}
            texte = "Something terrible happenned last night, Link..."; idsuiv=1017; break;
        case 1017: texte = "The Ocarina of Time you brought back from Termina... *I kept it in a vault here in the castle, but it's been stolen!"; idsuiv=1018; break;
        case 1018: texte = "I sent guards all over Hyrule, so I don't think the thief could of got very far..."; idsuiv=1019; break;
        case 1019: texte = "I would like you to find the Ocarina and bring it back to me. Start your investigation in the castle vaults, I'll meet you there."; break;
        case 1020: 
            if (gpJeu->getJoueur()->getAvancement()<PARLE_ZELDA_PALAIS) {id=1004; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_GARDE_CH_FORTE) {id=1010; chercheText();break;}
            texte = "The vaults are this way."; break;
        case 1021: texte = "Access to this vault is stricly forbidden."; break;
        case 1022: 
            if (gpJeu->getJoueur()->getAvancement()>=PARLE_GARDE_SOUS_SOL) {id=1023; chercheText();break;}
            texte = "The Princess trusted you with investigating the Ocarina theft? *In that case you can enter. There is nothing left to steal anyway..."; break;
        case 1023: texte = "I was guarding this door last night. I am absolutely sure nobody came through it..."; break;
        case 1024: texte = "That's where the Ocarina was kept. The guard heard a lot of noise. But before he realized it was coming from inside the room, the safe had been cleared out."; idsuiv=1025; break;
        case 1025: texte = "If you see anything suspicious, go in front of it and press (X) to point it out to me."; break;
        case 1026: texte = "It's a torch... What were you expecting? A ceiling chandelier?"; break;
        case 1027: texte = "This safe is where the Ocarina was kept. Until last night..."; break;
        case 1028: 
            if (gpJeu->getJoueur()->getAvancement()>=RIDEAUX_REPERES) {id=1030; chercheText();break;}
            texte = "This room used to lead out into the sewer... *When it was made into a vault I had the way sealed off. The curtains are here to hide the sealed doorway..."; break;
        case 1029: texte = "It's er... a rubber duck. *Don't ask me what it's doing here..."; break;
        case 1030: texte = "These curtains intrigue you apparently... *Let's see what's behind them..."; break;
        case 1031: texte = "So that's where the thief came from! *What are you waiting for? Go after him!"; break;
        case 1032: texte = "I feel so forgotten... *Here I am, guarding an empty vault..."; break;
        case 1033: texte = "The thief is probably somewhere in this forest, you can't give up now!"; break;
        case 1034: texte = "TUTORIAL : Press (B) in front of a light object, like a jar, in order to lift it up. Press (B) it a second time to throw it."; break;
        case 1035: texte = "TUTORIAL : Press (B) in front of a chest to open it. You can only open a chest if you are in front of it."; break;
        case 1036: texte = "                 Hyrule Castle"; break;
        case 1037: texte = "This way leads to the prison cells, you have no buisness there, move along..."; break;
        case 1038: texte = "Beyond this point is a restricted area, even the Hero of Hyrule is not allowed to enter..."; break;
        case 1039: texte = "Er... How did you get in here?"; break;
        case 1040: texte = "These stairs lead down to the vaults."; break;
        case 1041: texte = "The throne room is behind this door."; break;
        case 1042: texte = "The throne room got it's name because this is the only throne we have left..."; break;
        case 1043: texte = "The door on the left leads to the dance hall and VIP quarters, the door above leads to the dining room and the kitchen."; break;
        case 1044: texte = "Back in the day I played the piano standing up, but over time, I decided to sit."; break;
        case 1045: texte = "I'm here as a musician, but some nights I prefer to forget the harp and dance!"; break;
        case 1046: texte = "I heard that a thief of musical instruments robbed the castle last night."; idsuiv=1047; break;
        case 1047: texte = "Fortunately, he didn't see my violin."; break;
        case 1048: texte = "A little tonic ?**              YES ?            no  "; break;
        case 1049: texte = "A little tonic ?**              yes              NO ?"; break;
        case 1050: texte = "I'm one of the chefs, it's not like being a 'HERO' or anything....But someone has to do it"; break;
        case 1051: texte = "They say the best chefs can read and cook at the same time. As for me?... I can half-way do it."; break;
        case 1052: texte = "I never know what to prepare, I have to think of something quick! The entire castle staff depends on me!"; break;
        case 1053: texte = "I have a nice job here, it's quiet and as the castles only waitress the tips are real good."; break;
		case 1054: texte = "The West wing of the castle is only for VIP's and errr... I don't see your name on the list...."; break;
        case 1055: texte = "The East wing of the castle is for guards only. Please move along."; break;
        case 1056: texte = "This door leads to the royal storeroom."; break;
        case 1057: texte = "shhhhh... there is no talking in the library!"; break;
        case 1058: texte = "You got an energy core!"; break;
        case 1059: 
            if (gpJeu->getJoueur()->getAvancement()>=MOT_DE_PASSE_DONNE) {id=1062; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()==MOT_DE_PASSE_CONNU) {id=1061; chercheText();break;}
            texte = "Only authorized people may access the throne room"; break;
        case 1060: 
            if (gpJeu->getJoueur()->getAvancement()>=MULTIPASSE_UTILISE) {id=1062; chercheText();break;}
            if (gpJeu->getJoueur()->getAvancement()>=MULTIPASS) {id=1063; chercheText();break;}
            texte = "Only the renovation staff may access to this part of the castle"; break;
        case 1061: texte = "You know the secret phrase?*I knew that under your cute little bunny face lye one of Ganon's elite soldiers!"; break;
        case 1062: texte = "You may enter."; break;
        case 1063: texte = "You got authorization from Ganon to go anywhere in the castle???";
			       buffer= "....Well, go ahead then"; break;
        case 1064: 
            if (gpJeu->getJoueur()->getAvancement()>=MOT_DE_PASSE_CONNU) {id=1070; chercheText();break;}
            texte = "You came here to free me? *I didn't need your help..."; idsuiv=1065; break;
        case 1065: texte = "I wanted to take this castle by force... So I came here to challenge Ganon."; idsuiv=1066; break;
        case 1066: texte = "It was a long and terrible fight... *But the throne room guards finally arrested me..."; idsuiv=1067; break;
        case 1067: texte = "Such rotten luck, I really wanted to meet Ganon..."; idsuiv=1068; break;
        case 1068: texte = "I've since learned there's a secret phrase you must give to the guards in order to pass. You have to tell them this :"; idsuiv=1069; break;
        case 1069: texte = "Sorry, but our princess is in another castle!"; idsuiv=1070; break;
        case 1070: texte = "... I guess next time I'll know"; break;
        case 1071: texte = "Hey!!! you're ..."; idsuiv=1072; break;
        case 1072: 
            gpJeu->getAudio()->stopSpecial();
            texte = "A little pink bunny! *I love pink!"; idsuiv=1073; break;
        case 1073: texte = "Make yourself at home little pink bunny! The entire castle is yours to explore!";
			       buffer= "If any of the gaurds give you trouble, just tell them you're a guest of Ganon's!"; break;
        case 1074: 
            if (gpJeu->getJoueur()->isLapin()) {id=1073; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)>6) {id=1078; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC4)==6 
            && gpJeu->getJoueur()->getObjet()==15) {id=1075; chercheText();break;}
            texte = "I feel like I've met you somewhere before...";
			buffer= "Anyway, do you know where I might find a good beer?"; break;
        case 1075: texte = "That's a beer you have? I'll take it!"; idsuiv=1076; break;
        case 1076: texte = "Here, you can have this nail, you know ...as a reward."; break;
        case 1077: texte = "You traded the beer for a nail!"; break;
        case 1078: texte = "I think I like you, you're a good guy. You wouldn't have another beer for me, would you?"; break;
        case 1079: texte = "A score is engraved here. If you had an instrument you could try to play it."; break;
        case 1080: texte = "You have... er... stolen the ocarina ??? *Let's say it's for a good cause..."; break;
        case 1081: texte = "At the moment he played the tune with the ocarina, Link was brought back to his own time. He ran to the castle to tell his story to the Princess..."; break;
        case 1082: texte = "What an awful story... *Is the Hyrule Realm really doomed to fall into Ganon's hands?"; idsuiv=1083; break;
        case 1083: 
            if (gpJeu->getJoueur()->getEpee()==5 && gpJeu->getJoueur()->hasObjet(O_ARC_OR) < 2) {id=1092; chercheText();break;}
            if (gpJeu->getJoueur()->hasObjet(O_TROC3)==4 
            && gpJeu->getJoueur()->getObjet()==11) {id=1085; chercheText();break;}
            if (gpJeu->getJoueur()->getEpee()==5 && gpJeu->getJoueur()->getEnnemi(50)) {id=1112; chercheText();break;}
            if (gpJeu->getJoueur()->getEpee()==5) {id=1095; chercheText();break;}
            texte = "What should we do now? *If only Ganon had never found the Triforce..."; break;
        case 1084: texte = "The Ocarina carried Link away once again. The Hero of Hyrule arrived in a vast snow-covered field..."; break;
        case 1085: texte = "Is that mirror for me?**              YES ?            no  "; idsuiv=1087; break;
        case 1086: texte = "Is that mirror for me?**              yes              NO ?"; idsuiv=1088; break;
        case 1087: texte = "You're giving me a mirror??? What, do you think I'm the kind of girl who spends her whole day looking at herself???"; 
            buffer = "Well, either way you can have this, as a thank you."; break;
        case 1088: texte = ".......*.......";
			       buffer= "Go away, if you don't want to end up in a cell."; break;
        case 1089: texte = "You traded the mirror for a spoon!"; break;
        case 1090: texte = "You are in a restricted area, I must ask you to leave."; break;
        case 1091: texte = "You found an extremely tough tunic!!!";
			       buffer= "Your defense raises by one point!"; break;
        case 1092: texte = "Happy to see you at last, Link!"; idsuiv=1093; break;
        case 1093: texte = "You're saying that this bow is for me, and it's able to defeat Ganon?*Great!"; break;
        case 1094: texte = "You gave the Bow of Wisdom to the Princess."; break;
        case 1095: texte = "Don't worry about me, I'll be able to make it on my own now!"; idsuiv=1096; break;
        case 1096: texte = "We have to stop Ganon, you go and I'll meet you there.*I have to put my make-up on first."; break;
        case 1097: texte = "Look!!! *Ganon regained his human form! *He's not a demon anymore, and wont be able to come back from the dead!"; break;
        case 1098: texte = "???"; break;
        case 1099: texte = "Link! Here you are at last. *This time victory will be mine, I've perfected my techniques since we last met."; break;
        case 1100: texte = "Once again we face each other. *I feel like I woke up from a long nightmare..."; idsuiv=1101; break;
        case 1101: texte = "Agahnim was wrong, the Triforce should have never been found."; idsuiv=1102; break;
        case 1102: texte = "Listen to me carefully, a long long time ago now, Agahnim disappeared after he left the order of the Wise Men."; idsuiv=1103; break;
        case 1103: texte = "The day he came back, he was gifted with very dark power. As a Wiseman, he would never have been able to shoot fire balls ..."; idsuiv=1104; break;
        case 1104: texte = "I owed too much to Agahnim to stand against him, but I made a inquiry while we were looking for the crystals."; idsuiv=1105; break;
        case 1105: texte = "It seems he got his powers from an entity far more dangerous and powerful than I or him"; idsuiv=1106; break;
        case 1106: texte = "There are still places in Hyrule you didn't explore and enemies you didn't fight. Your quest is not finished yet..."; idsuiv=1107; break;
        case 1107: texte = "You want to know why I'm telling you all of this? I guess I'm not gonna get out of it that easily, after what I've done..."; idsuiv=1108; break;
        case 1108: texte = "If I fail today, someone will have to avenge Aghanim instead of me. But..."; idsuiv=1109; break;
        case 1109: texte = "... will you be able to?"; break;
        case 1110: texte = "You have found the Triforce!!!"; break;
        case 1111: texte = "That's how Ganondorf was defeated once and for all. The Triforce was once again recovered and kept safe in the castle. **However, concerned by Ganondorf's last words, Link spent the rest of his life watching over Hyrule. ***End of the First Quest."; break;
        case 1112: texte = "Ganon has recovered his human form ... *is he still our enemy?"; break;
        case 1113: texte = "Ready for one last duel?"; break;
	case 1114: 
            if (gpJeu->getMonde()->motifValue(69*16,90*16) == 6380) {texte = "Welcome to the Casino !"; break;}
            texte = "Welcome, dear guest. The entry fee is 10 Golden Ganon, are you okay with that?*              YES ?            no  "; idsuiv=1117; break;
        case 1115: texte = "Welcome, dear guest. The entry fee is 10 Golden Ganon, are you okay with that?*              yes              NO ?"; idsuiv=1116; break;
        case 1116: texte = "Too bad."; break;
        case 1117: 
            if (gpJeu->getMonde()->motifValue(69*16,90*16) != 6380 &&
            gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<10) {id=1118; chercheText();break;}
            texte = "Welcome to the Casino!"; break;
        case 1118: texte = "Be back when you have some money, my friend."; break;
        case 1119: texte = "We are closed for now, come back later."; break;
        case 1120: texte = "Welcome to the Casino, do you want me to explain the rules for 5 Golden Ganon?*              YES ?            no  "; idsuiv=1122; break;
        case 1121: texte = "Welcome to the Casino, do you want me to explain the rules for 5 Golden Ganon?*              yes              NO ?"; idsuiv=1116; break;
        case 1122: 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<5) {id=1118; chercheText();break;}
            texte = "In this casino, enemies won't take your energy, just your money. Each attack makes you lose a little more energy than the last one."; idsuiv=1123; break;
        case 1123: texte = "When you don't have a single Golden Ganon left, you're expelled. We're not interested in having broke clients."; idsuiv=1124; break;
        case 1124: texte = "However, if you win the various games in the casino, you will win marvelous prizes."; break;
        case 1125: 
            if (gpJeu->getJoueur()->getCoffre(12,1)) {id=1128; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 2) {id=1129; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 3) {id=1130; chercheText();break;}
            texte = "Strike the enemies to stop them on a mark. Get 4 different marks and you'll win the prize."; 
            if (!gpJeu->getJoueur()->getCoffre(12,13)) idsuiv=1126; break;
        case 1126: texte = "Do you want to try for 10 Golden Ganon?**              YES ?            no  "; break;
        case 1127: texte = "Do you want to try for 10 Golden Ganon?**              yes              NO ?"; idsuiv=1116; break;
        case 1128: texte = "You already won this game."; break;
        case 1129: texte = "Congratulation!*Here is your prize:"; break;
        case 1130: texte = "You will probably be more lucky next time."; break;
        case 1131:
            if (gpJeu->getJoueur()->getCoffre(12,2)) {id=1128; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 2) {id=1129; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 3) {id=1132; chercheText();break;}
            texte = "Strike the enemies to stop them on a number. Get a 4, a 2 and a 1 and you'll get the prize."; 
            buffer="Talk to me if you lose, you'll just start again with the right numbers you've already found."; 
            if (!gpJeu->getJoueur()->getCoffre(12,13)) idsuiv=1126; break;
        case 1132: texte = "Do you want to compete for 5 Golden Ganon?**              YES ?            no  "; break;
        case 1133: texte = "Do you want to compete for 5 Golden Ganon?**              yes              NO ?"; idsuiv=1116; break;
        case 1134:
            if (gpJeu->getJoueur()->getCoffre(12,5)) {id=1128; chercheText();break;}
            if (gpJeu->getJoueur()->isTempsVisible()) {id=1135; chercheText();break;}
            texte = "This is the Casino's Great Race starting line, you've got 30 seconds to reach the finish line."; 
            idsuiv=1126; break;
        case 1135: texte = "You're losing time there, you know?"; break;
        case 1136:
            if (gpJeu->getJoueur()->getCoffre(12,5)) {id=1128; chercheText();break;}
            texte = "This is the Casino's Great Race finish line. Go to the starting line if you want to try and break the record."; break;
        case 1137:
            if (gpJeu->getJoueur()->getCle(12,0)) {id=1128; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 2) {id=1129; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 3) {id=1130; chercheText();break;}
            texte = "Strike the enemies to stop them on a number and get more than I do with one die less."; 
            if (!gpJeu->getJoueur()->getCoffre(12,13)) idsuiv=1126; break;
        case 1138:
            if (gpJeu->getJoueur()->getCoffre(12,4)) {id=1128; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 2) {id=1129; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 3) {id=1130; chercheText();break;}
            texte = "Chose a number, either 1 or 6. I will throw 4 dices, if your number hits, you win, if not, you pay 10 time the difference of the closest dice."; 
            idsuiv=1139; break;
        case 1139: texte = "Do you want to try?**              YES ?            no  "; idsuiv=1141; break;
        case 1140: texte = "Do you want to try?**              yes              NO ?"; idsuiv=1116; break;
        case 1141: texte = "Which number do you choose?**              ONE  ?            six  "; break;
        case 1142: texte = "Which number do you choose?**              one               SIX ?"; break;
        case 1143:
            if (gpJeu->getJoueur()->getCle(12,1)) {id=1128; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 2) {id=1129; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) == 3) {id=1130; chercheText();break;}
            texte = "Strike the enemy to stop them on a number that will be handed over to a block on the right. Then push the blocks so that they arrive at 0 on the flagstones."; 
            if (!gpJeu->getJoueur()->getCoffre(12,13)) idsuiv=1126; break;
        case 1144:
            if (gpJeu->getJoueur()->getCoffre(12,3)) {id=1128; chercheText();break;}
            if (gpJeu->getJoueur()->getCoffre(12,13) > 1) {id=1145; chercheText();break;}
            texte = "I'll sell you a key for a price equal to the sum of your four dices times the amount of mine."; 
            if (!gpJeu->getJoueur()->getCoffre(12,13)) idsuiv=1126; break;
        case 1145:
            tmp = gpJeu->getJoueur()->getCoffre(12,13)-2; os << tmp;
            texte = "I'll sell you a key for "+os.str()+" Golden Ganon, are you okay with that?*              YES ?            no  "; idsuiv=1129; 
            if (gpJeu->getJoueur()->getGanon() + gpJeu->getJoueur()->getBoostGanon()<tmp) {idsuiv=1118;break;}
            break;
        case 1146:
            tmp = gpJeu->getJoueur()->getCoffre(12,13)-2; os << tmp;
            texte = "I'll sell you a key for "+os.str()+" Golden Ganon, are you okay with that?*              yes              NO ?"; idsuiv=1116; break;
            break;
        case 1147:
            if (gpJeu->getJoueur()->getCle(12,2)) {id=1148; chercheText();break;}
            texte = "The Chest room is at the end of the corridor to the left. Only the best customers can hope to reach it.";
            break;
        case 1148: 
            if (gpJeu->getJoueur()->getCoeur(11)) {id=1149; chercheText();break;}
            texte = "Did you open the chest?*Then you should try the Special Room."; break;
        case 1149: texte = "People like you have got no business in a casino..."; break;
        case 1150: texte = "Welcome to the Casino's Great Quiz!"; idsuiv=1151; break;
        case 1151: texte = "I will ask you questions, and let me tell you, incorrect answers are expensive!"; idsuiv=1152; break;
        case 1152: 
            gpJeu->getJoueur()->setCoffre(12,14,0); // ->nb questions poses
            for (int i = 0; i < MAX_QUIZZ; i++) gpJeu->getJoueur()->setCoffre(12,15+i,0);
            tmp = rand()%MAX_QUIZZ; idsuiv = 1154 + tmp*4;
            gpJeu->getJoueur()->setCoffre(12,15+tmp,1);
            texte = "I don't ask you if you want to play, I'm a boss after all! So let's get it started..."; 
            break;
        case 1153: 
            if ((MAX_QUIZZ-gpJeu->getJoueur()->getCoffre(12,14)) > 0) {
                tmp = rand()%(MAX_QUIZZ-gpJeu->getJoueur()->getCoffre(12,14));
                for (int i = 0; i <= tmp; i++) {
                    if (gpJeu->getJoueur()->getCoffre(12,15+i) > 0) {
                        tmp++;
                    }
                } 
                idsuiv=1154+tmp*4;
                gpJeu->getJoueur()->setCoffre(12,15+tmp,1);
            }
            texte = "Next question..."; break;
        case 1154: texte = "This casino houses a total of 6 different games not counting this quiz, right?*              RIGHT ?          wrong  "; idsuiv=1157; break;
        case 1155: texte = "This casino houses a total of 6 different games not counting this quiz, right?*              right            WRONG ?"; idsuiv=1156; break;
        case 1156: texte = "Correct! There are 7 games, 1 for the map, 1 for the compass and 5 for the keys."; break;
        case 1157: texte = "No! There are 7 games, 1 for the map, 1 for the compass and 5 for the keys."; break;
        
        case 1158: texte = "The guy in the coffee house never drinks more than 16 cofeecups a day, right?*             RIGHT ?          wrong  "; idsuiv=1161; break;
        case 1159: texte = "The guy in the coffee house never drinks more than 16 cofeecups a day, right?*             right            WRONG ?"; idsuiv=1160; break;
        case 1160: texte = "Correct! He can go up to 17 cups!"; break;
        case 1161: texte = "No! He can go up to 17 cups!"; break;
        
        case 1162: texte = "This game contains a total of 150 power gems, right?*             RIGHT ?          wrong  "; idsuiv=1165; break;
        case 1163: texte = "This game contains a total of 150 power gems, right?*             right            WRONG ?"; idsuiv=1164; break;
        case 1164: texte = "Correct! There are 200."; break;
        case 1165: texte = "No! There are 200."; break;
        
        case 1166: texte = "There are only 7 houses left in the middle village, is that so?*             RIGHT ?          wrong  "; idsuiv=1168; break;
        case 1167: texte = "There are only 7 houses left in the middle village, is that so?*             right            WRONG ?"; idsuiv=1169; break;
        case 1168: texte = "Correct! The 3 others are destroyed."; break;
        case 1169: texte = "No! There are 10 houses, 3 of them are destroyed, so only 7 are left."; break;

        case 1170: 
            tmp = gpJeu->getJoueur()->getMort() + 1; os << tmp;
            texte = "You died "+os.str()+" times, am I right?**             RIGHT ?          wrong  "; idsuiv=1173; break;
        case 1171: 
            tmp = gpJeu->getJoueur()->getMort() + 1; os << tmp;
            texte = "You died "+os.str()+" times, am I right?**             right            WRONG ?"; idsuiv=1172; break;
        case 1172: 
            tmp = gpJeu->getJoueur()->getMort(); os << tmp;
            texte = "Correct! You died "+os.str()+" times."; break;
        case 1173: 
            tmp = gpJeu->getJoueur()->getMort(); os << tmp;
            texte = "No! You died "+os.str()+" times."; break;
            
        case 1174: texte = "Your name is Link, right?*             RIGHT ?          wrong  "; idsuiv=1176; break;
        case 1175: texte = "Your name is Link, right?*             right            WRONG ?"; idsuiv=1177; break;
        case 1176: texte = "Correct! You know your name!"; break;
        case 1177: texte = "No! How do you not know your own name?"; break;
        
        case 1178: texte = "I'm the coolest boss in the game, right?**             RIGHT ?          wrong  "; idsuiv=1180; break;
        case 1179: texte = "I'm the coolest boss in the game, right?**             right            WRONG ?"; idsuiv=1181; break;
        case 1180: texte = "Ha! Ha! We agree."; break;
        case 1181: texte = "... *This one is wrong, on principle..."; break;
        
        case 1182: texte = "Only 3 dungeons are necessary to finish the game, right? *             RIGHT ?          wrong  "; idsuiv=1184; break;
        case 1183: texte = "Only 3 dungeons are necessary to finish the game, right? *             right            WRONG ?"; idsuiv=1185; break;
        case 1184: texte = "Correct! Temple of Air, Temple of Fire and the Goddesses Temple."; break;
        case 1185: texte = "No! There are 3 indeed, the temple of the air, temple of fire and the Goddesses Temple."; break;
        
        case 1186: texte = "More than 4000 Golden Ganon are necessary to get all of the fat fairy's prizes, right?*            RIGHT ?          wrong  "; idsuiv=1189; break;
        case 1187: texte = "More than 4000 Golden Ganon are necessary to get all of the fat fairy's prizes, right?*            right            WRONG ?"; idsuiv=1188; break;
        case 1188: texte = "Correct! 3798 are enough."; break;
        case 1189: texte = "No! 3798 are enough."; break;
        
        case 1190: texte = "In Zelda's time, the palace had 80 pillars, right?*             RIGHT ?          wrong  "; idsuiv=1192; break;
        case 1191: texte = "In Zelda's time, the palace had 80 pillars, right?*             right            WRONG ?"; idsuiv=1193; break;
        case 1192: texte = "Correct! There were 80 indeed."; break;
        case 1193: texte = "No! There were actually 80."; break;
        
        case 1194: 
            tmp = gpJeu->getJoueur()->getCoffre(12,14) + 1; os << tmp;
            texte = "You already answered "+os.str()+" of my questions, is that so?*             RIGHT ?          wrong  "; idsuiv=1197; break;
        case 1195: 
            tmp = gpJeu->getJoueur()->getCoffre(12,14) + 1; os << tmp;
            texte = "You already answered "+os.str()+" of my questions, is that so?*             right            WRONG ?"; idsuiv=1196; break;
        case 1196: texte = "Correct! But now you did."; break;
        case 1197: texte = "No! But now you did."; break;
        
        case 1198: texte = "You can find a maximum of 16 pieces of heart in this game, right?*             RIGHT ?          wrong  "; idsuiv=1200; break;
        case 1199: texte = "You can find a maximum of 16 pieces of heart in this game, right?*             right            WRONG?"; idsuiv=1201; break;
        case 1200: texte = "Correct! There are 16 in all."; break;
        case 1201: texte = "No! There are 16 in all."; break;
        
        case 1202: texte = "A blue potion costs the equivalent of 40 Rupees plus 40 Golden Ganon plus 10 Gold Coins, right?*             RIGHT ?          wrong  "; idsuiv=1204; break;
        case 1203: texte = "A blue potion costs the equivalent of 40 Rupees plus 40 Golden Ganon plus 10 Gold Coins, right?*             right            WRONG ?"; idsuiv=1205; break;
        case 1204: texte = "Correct! That is 160 Rupees."; break;
        case 1205: texte = "No! This equals 160 Rupees, so the price of a blue potion."; break;
        
        case 1206: texte = "In the mine, the trolley's track could change with 3 levers, right?*             RIGHT ?          wrong  "; idsuiv=1209; break;
        case 1207: texte = "In the mine, the trolley's track could change with 3 levers, right?*             right            WRONG ?"; idsuiv=1208; break;
        case 1208: texte = "Correct! There were 2 only."; break;
        case 1209: texte = "No! There were 2 only."; break;
        
        case 1210: texte = "You had to find 3 different kinds of fish to win the fishing contest, right?*             RIGHT ?          wrong  "; idsuiv=1213; break;
        case 1211: texte = "You had to find 3 different kinds of fish to win the fishing contest, right?*             right            WRONG ?"; idsuiv=1212; break;
        case 1212: texte = "Correct! You needed 5."; break;
        case 1213: texte = "No! You needed 5."; break;
        
        case 1214: texte = "Only the Master Sword is able to strike back the projectiles, right?*             RIGHT ?          wrong  "; idsuiv=1217; break;
        case 1215: texte = "Only the Master Sword is able to strike back the projectiles, right?*             right            WRONG ?"; idsuiv=1216; break;
        case 1216: texte = "Correct! Your current sword can do that too."; break;
        case 1217: texte = "No! Your current sword can do that too."; break;
        
        case 1218: texte = "Zelda is taller than you, true?**             RIGHT ?          wrong  "; idsuiv=1221; break;
        case 1219: texte = "Zelda is taller than you, true?**             right            WRONG ?"; idsuiv=1220; break;
        case 1220: texte = "Correct! You are a pixel taller."; break;
        case 1221: texte = "No! You are a pixel taller."; break;
        
        case 1222: texte = "Dungeon 3 has 3 floors, right?**             RIGHT ?          wrong  "; idsuiv=1224; break;
        case 1223: texte = "Dungeon 3 has 3 floors, right?**             right            WRONG ?"; idsuiv=1225; break;
        case 1224: texte = "Correct! And one only for the boss."; break;
        case 1225: texte = "No! 2 floors plus 1 for the boss, so 3."; break;
        
        case 1226: texte = "Link's demonic incarnation is a pink bunny, right?*             RIGHT ?          wrong  "; idsuiv=1229; break;
        case 1227: texte = "Link's demonic incarnation is a pink bunny, right?*             right            WRONG ?"; idsuiv=1228; break;
        case 1228: texte = "Correct! It's Oni Link."; break;
        case 1229: texte = "No! It's Oni Link."; break;
        
        case 1230: texte = "Tingle should never had existed, right?**             RIGHT ?          wrong  "; idsuiv=1232; break;
        case 1231: texte = "Tingle should never had existed, right?**             right            WRONG ?"; idsuiv=1233; break;
        case 1232: texte = "Er... we're getting off the point here, but I'll say it's okay."; break;
        case 1233: texte = "... *To me, he shouldn't have."; break;
        
        case 1234: texte = "You want to give me Golden Ganon, right?**             RIGHT ?          wrong  "; idsuiv=1237; break;
        case 1235: texte = "You want to give me Golden Ganon, right?**             right            WRONG ?"; idsuiv=1236; break;
        case 1236: texte = "Correct! Alas..."; break;
        case 1237: texte = "Thanks!"; break;
        
        case 1238: texte = "Snakes' bites leave you half a heart no matter your life and defense, right?*             RIGHT ?          wrong  "; idsuiv=1241; break;
        case 1239: texte = "Snakes' bites leave you half a heart no matter your life and defense, right?*             right            WRONG ?"; idsuiv=1240; break;
        case 1240: texte = "Correct! If you had only half a heart left, the bite leaves you nothing."; break;
        case 1241: texte = "No! If you had only half a heart left, the bite leaves you nothing."; break;
        
        case 1242: texte = "Link's property has 77 grass tuft, right?**             RIGHT ?          wrong  "; idsuiv=1244; break;
        case 1243: texte = "Link's property has 77 grass tuft, right?**             right            WRONG ?"; idsuiv=1245; break;
        case 1244: texte = "Correct! Happy to see I'm not the only who counted them!"; break;
        case 1245: texte = "No! Do you realize I know your property better than you do???"; break;
        
        case 1246: texte = "2 to the power of 12 is smaller than the cube root of 7, is that so?*             RIGHT ?          wrong  "; idsuiv=1249; break;
        case 1247: texte = "2 to the power of 12 is smaller than the cube root of 7, is that so?*             right            WRONG ?"; idsuiv=1248; break;
        case 1248: texte = "Correct! Well, I think."; break;
        case 1249: texte = "No! I think it's the other way around."; break;
        
        case 1250: texte = "It is possible to finish the game moving only in moonwalk, right?*             RIGHT ?          wrong  "; idsuiv=1253; break;
        case 1251: texte = "It is possible to finish the game moving only in moonwalk, right?*             right            WRONG ?"; idsuiv=1252; break;
        case 1252: texte = "Correct! But you can try if you want."; break;
        case 1253: texte = "No! Well, you shall try..."; break;
        
        case 1254: texte = "It's in the past when you can win the most money by killing an enemy, right?*             RIGHT ?          wrong  "; idsuiv=1257; break;
        case 1255: texte = "It's in the past when you can win the most money by killing an enemy, right*             right            WRONG ?"; idsuiv=1256; break;
        case 1256: texte = "Correct! It's in the present, with red Rupees."; break;
        case 1257: texte = "No! It's in the present, with red Rupees."; break;
        
        case 1258: texte = "Your sword can defeat any opponent, except a boss, in less than 6 blows, right?*             RIGHT ?          wrong  "; idsuiv=1261; break;
        case 1259: texte = "Your sword can defeat any opponent, except a boss, in less than 6 blows, right?*             right            WRONG ?"; idsuiv=1260; break;
        case 1260: texte = "Correct! There are enemies that can't be killed with the sword."; break;
        case 1261: texte = "No! There are enemies that can't be killed with the sword."; break;
        
        case 1262: texte = "The puzzle in the desert had 6 stones, didn't it?*             RIGHT ?          wrong  "; idsuiv=1264; break;
        case 1263: texte = "The puzzle in the desert had 6 stones, didn't it?*             right           WRONG ?"; idsuiv=1265; break;
        case 1264: texte = "Correct! And I never could find the order..."; break;
        case 1265: texte = "No! You cheated to solve it, I'm sure..."; break;
        
        case 1266: 
            tmp = gpJeu->getJoueur()->getTemps(2); os << tmp;
            texte = "You played more than "+os.str()+" hours, right?**             RIGHT ?          wrong  "; idsuiv=1268; break;
        case 1267: 
            tmp = gpJeu->getJoueur()->getTemps(2); os << tmp;
            texte = "You played more than "+os.str()+" hours, right?**             right            WRONG ?"; idsuiv=1269; break;
        case 1268: texte = "Correct! It goes by fast, doesn't it?"; break;
        case 1269: texte = "No! It goes by fast, doesn't it?"; break;
        
        case 1270: texte = "The hens in the past are more patient than the ones in the present, right?*             RIGHT ?          wrong  "; idsuiv=1273; break;
        case 1271: texte = "The hens in the past are more patient than the ones in the present, right?*             right            WRONG ?"; idsuiv=1272; break;
        case 1272: texte = "Correct! You know your stuff..."; break;
        case 1273: texte = "No! You'll just have to check..."; break;
        
        case 1274: texte = "It was possible to catch 4 different fishes in the Lake Hylia, right?*             RIGHT ?          wrong  "; idsuiv=1276; break;
        case 1275: texte = "It was possible to catch 4 different fishes in the Lake Hylia, right?*             right            WRONG ?"; idsuiv=1277; break;
        case 1276: texte = "Correct! There were 6 different species."; break;
        case 1277: texte = "No! There were 6 different species, so it was possible to find 4."; break;
        
        case 1278: texte = "Santa Claus exists, is that true?**             RIGHT ?          wrong  "; idsuiv=1280; break;
        case 1279: texte = "Santa Claus exists, is that true?**             right            WRONG ?"; idsuiv=1281; break;
        case 1280: texte = "Correct! And you met him once."; break;
        case 1281: texte = "No! You met him once."; break;
        
        case 1282: texte = "In the past, the mountains had a total of 16 stones, right?*             RIGHT ?          wrong  "; idsuiv=1285; break;
        case 1283: texte = "In the past, the mountains had a total of 16 stones, right?*             right            WRONG ?"; idsuiv=1284; break;
        case 1284: texte = "Correct! There were 15 only, obviously."; break;
        case 1285: texte = "No! There were 15 only, obviously."; break;
        
        case 1286: texte = "There is a total of 42 carpets in this Casino, right? *             RIGHT ?          wrong  "; idsuiv=1289; break;
        case 1287: texte = "There is a total of 42 carpets in this Casino, right? *             right            WRONG ?"; idsuiv=1288; break;
        case 1288: texte = "Correct! There are 44."; break;
        case 1289: texte = "No! There are 44."; break;
        
        case 1290: texte = "Power gems can be swapped for 5 different type of items, right?*             RIGHT ?          wrong  "; idsuiv=1292; break;
        case 1291: texte = "Power gems can be swapped for 5 different type of items, right?*             right            WRONG ?"; idsuiv=1293; break;
        case 1292: texte = "Correct! I see you did not forget the frosty rock."; break;
        case 1293: texte = "No! You probably forgot the frosty rock."; break;
        
        case 1294: texte = "The green tunic gives you but one point of defense, right?*             RIGHT ?          wrong  "; idsuiv=1297; break;
        case 1295: texte = "The green tunic gives you but one point of defense, right?*             right            WRONG ?"; idsuiv=1296; break;
        case 1296: texte = "Correct! The green tunic is your first one and gives no point of defense."; break;
        case 1297: texte = "No! The green tunic is your first one and gives no point of defense."; break;
        
        case 1298: texte = "There were 5 mirrors in Zelda's bedroom, right?*             RIGHT ?          wrong  "; idsuiv=1300; break;
        case 1299: texte = "There were 5 mirrors in Zelda's bedroom, right?*             right            WRONG ?"; idsuiv=1301; break;
        case 1300: texte = "Correct! You gave her the fifth one actually."; break;
        case 1301: texte = "No! In fact you gave her the fifth one."; break;
        
        case 1302: texte = "The Pyramid in the past had 85 rooms, right?**             RIGHT ?          wrong  "; idsuiv=1305; break;
        case 1303: texte = "The Pyramid in the past had 85 rooms, right?**             right            WRONG ?"; idsuiv=1304; break;
        case 1304: texte = "Correct! Only 84."; break;
        case 1305: texte = "No! 84 only."; break;
        
        case 1306: texte = "The fire arrows are stronger than the ice ones, right?*             RIGHT ?          wrong  "; idsuiv=1308; break;
        case 1307: texte = "The fire arrows are stronger than the ice ones, right?*             right            WRONG ?"; idsuiv=1309; break;
        case 1308: texte = "Correct! The fire arrows have a strength of 10, the ice ones have 7."; break;
        case 1309: texte = "No! The fire arrows have a strength of 10, the ice ones have 7."; break;
        
        case 1310: texte = "Bombs cause as much damage as hammer blows, right?*             RIGHT ?          wrong  "; idsuiv=1313; break;
        case 1311: texte = "Bombs cause as much damage as hammer blows, right?*             right            WRONG ?"; idsuiv=1312; break;
        case 1312: texte = "Correct! Bombs have a strength of 5, the hammer of 3."; break;
        case 1313: texte = "No! Bombs have a strength of 5, the hammer of 3."; break;
        
        case 1314: texte = "What??? You defeated me???**             RIGHT ?          right  "; break;
        case 1315: texte = "What??? You defeated me???**             right            RIGHT ?"; break;
        
        case 1316: texte = "You have found the Shield of the Goddesses!!!*Now your life comes back constantly!!!"; break;
        case 1317: texte = "On this stone is written the story of Hyrule in ancient Hylian:"; idsuiv=1318; break;
        case 1318: texte = "After the Goddesses Din, Nayru and Farore created Hyrule, an evil entity with an unequaled power came to occupy this land."; idsuiv=1319; break;
        case 1319: texte = "Despite their great power, the Goddesses had to accept that they could never destroy this creature."; idsuiv=1320; break;
        case 1320: texte = "The continuation of the story is not written here. Maybe on another stone?"; break;
        
        case 1321: texte = "You have found the Tunic of the Goddesses!!!*Now your magic comes back constantly!!!"; break;
        case 1322: texte = "On this stone is written the story of Hyrule in ancient Hylian:"; idsuiv=1323; break;
        case 1323: texte = "Din, Nayru and Farore could not stand by and do nothing, so they challenged the evil entity."; idsuiv=1324; break;
        case 1324: texte = "After a long and hopeless fight, they had to find a compromise and they managed to scatter the entity's power."; idsuiv=1325; break;
        case 1325: texte = "However, in order to do so, they had to create devilish creatures holding fragments of the power."; idsuiv=1326; break;
        case 1326: texte = "What was left of the evil entity is locked in a human form, and shall not be set free as long as all the devilish creatures are not defeated."; break;
		
		case 1327: texte = "Welcome, do you want me to explain how this place works?*              YES ?            no  "; idsuiv=1329; break;
        case 1328: texte = "Welcome, do you want me to explain how this place works?*              yes              NO ?"; idsuiv=1332; break;
        case 1329: texte = "Enemies in this dungeon are very particular, each of their attacks will make you lose twice as much life as the previous blow."; idsuiv=1330; break; 
        case 1330: texte = "Be extremely careful, 7 blows will be enough to kill you."; idsuiv=1331; break;
        case 1331: texte = "Plus, the number of enemies you kill and the type of enemy are counted. A certain amount is needed to open some doors."; idsuiv=1332; break;
        case 1332: texte = "Good luck, no matter what happens it all ends here."; break;
        
        case 1333:
            if (gpJeu->getJoueur()->getCoffre(14,9)) {id=1334; chercheText();break;}
            if (gpJeu->getJoueur()->getCompteurEnn() >= 30 && gpJeu->getJoueur()->getCompteurType() >= 4) {id=1335; chercheText();break;}
            texte = "Eliminate at least 30 enemies of 4 various types and I will open the door."; break;
        case 1334: texte = "Good luck, Link."; break;
        case 1335: texte = "You have defeated enough enemies, I shall open the door..."; break;
        case 1336:
            if (gpJeu->getJoueur()->getCoffre(14,10)) {id=1334; chercheText();break;}
            if (gpJeu->getJoueur()->getCompteurEnn() >= 60 && gpJeu->getJoueur()->getCompteurType() >= 10) {id=1335; chercheText();break;}
            texte = "Eliminate at least 60 enemies of 10 various types and I will open the door."; break;
        case 1337:
            if (gpJeu->getJoueur()->getCoffre(14,11)) {id=1334; chercheText();break;}
            if (gpJeu->getJoueur()->getCompteurEnn() >= 20 && gpJeu->getJoueur()->getCompteurType() >= 3) {id=1335; chercheText();break;}
            texte = "Eliminate at least 20 enemies de 3 various types and I will open the door."; break;
        case 1338:
            if (gpJeu->getJoueur()->getCoffre(14,12)) {id=1334; chercheText();break;}
            if (gpJeu->getJoueur()->getCompteurEnn() >= 99 && gpJeu->getJoueur()->getCompteurType() >= 12) {id=1335; chercheText();break;}
            texte = "Eliminate at least 99 enemies of 12 various types and I will open the door."; break;
        case 1339:
            if (gpJeu->getJoueur()->getCoffre(14,13)) {id=1334; chercheText();break;}
            if (gpJeu->getJoueur()->getCompteurEnn() >= 30 && gpJeu->getJoueur()->getCompteurType() >= 12) {id=1335; chercheText();break;}
            texte = "Eliminate at least 30 enemies of 12 various types and I will open the door."; break;
        case 1340:
            if (gpJeu->getJoueur()->getCoffre(14,14)) {id=1334; chercheText();break;}
            if (gpJeu->getJoueur()->getCompteurEnn() >= 40 && gpJeu->getJoueur()->getCompteurType() >= 6) {id=1335; chercheText();break;}
            texte = "Eliminate at least 40 enemies of various 6 types and I will open the door."; break;
        case 1341:
            if (gpJeu->getJoueur()->getCoffre(14,15)) {id=1334; chercheText();break;}
            if (gpJeu->getJoueur()->getCompteurEnn() >= 50 && gpJeu->getJoueur()->getCompteurType() >= 7) {id=1335; chercheText();break;}
            texte = "Eliminate at least 50 enemies of 7 various types and I will open the door."; break;
        case 1342: texte = "You have found the Mask of Oni Link !!! *Press the WHITE BUTTON to transform yourself and become incredibly powerful."; break;
        case 1343: texte = "Congratulations Link! You've defeated every single type of enemy... It's incredible..."; idsuiv=1344; break;
        case 1344: texte = "I owe you a lot, do you want to be paid now?"; idsuiv=1345; break;
        case 1345: texte = "I'm finally able to re-take my original form, get ready!*Farewell, Hero of Hyrule!"; break;
        case 1346: 
            if (gpJeu->nbEnnemis()==0) {id=1348; chercheText();break;}
            texte = "Hurry Link! Use the Sword of the Godesses to finish him off!"; break;
        case 1347: 
            if (gpJeu->nbEnnemis()==0) {id=1349; chercheText();break;}
            if (gpJeu->getEnnemi()->getSuivant()->getSpecial(2)<13) {id=1350; chercheText();break;}
            texte = "Not on me, goofy..."; break;
        case 1348: texte = "Congratulations Link, let's go home now."; break;
        case 1349: texte = "Justice has been served. My Master has finally been avenged."; break;
        case 1350: texte = "Out of my way!"; break;
        case 1351: texte = "What the hell are you doing?"; break;
        case 1352: texte = "Let me explain the reason for our presence here in the entity with no name's dungeon."; idsuiv=1353; break;
        case 1353: texte = "After your departure from the Castle, that followed my victory over Ganon, Ganondorf gave back the Triforce and told me his story."; idsuiv=1354; break;
        case 1354: texte = "We quickly came to the conclusion that the man with the monster encyclopedia was highly suspicious, so when we learned from a guard that you had gone to see him, we decided to come and help you."; idsuiv=1355; break;
        case 1355: texte = "As we thought, only the power of the 3 Weapons of the Goddesses, unified and used by the 3 Chosen ones, could destroy this plague forever."; idsuiv=1356; break;
        case 1356: texte = "As for Ganondorf, he is no longer the monster we knew, there is no darkness in him anymore, and he is trustworthy."; idsuiv=1357; break;
        case 1357: texte = "From now on Hyrule will be at peace. Monsters will not reappear, evil has been defeated once and for all."; idsuiv=1358; break;
        case 1358: texte = "So tell me Link, what are you going to do now?"; break;
        case 1359: texte = "Hyrule was saved and every threat dispelled. After a long adventure, the three heroes had fulfilled their destiny. **The three Goddesses came back to Hyrule to congratulate them before leaving once again, and taking the Triforce with them. **The powerful Ganondorf quickly became the new leader of the guards and spent the rest of his days protecting the realm against enemies that would never come."; idsuiv=1360; break;
        case 1360: texte = "Princess Zelda was celebrated across the entire country and beyond as being the one that had brought peace to the world. **Link preferred to shy away from celebrity, he disappeared, and nobody ever saw him in Hyrule again."; break;
        case 1361: texte = "After the events that occurred in Termina, Princess Zelda put an end to Link's exile, announcing to the people the victory of the hero on his evil alter-ego."; idsuiv=1362; break;
        case 1362: texte = "But the Hylian Knight, unable to accept his status of hero, left to live as a recluse in the forest given to him by the princess."; idsuiv=1363; break;
        case 1363: texte = "The existence of Termina had to be kept secret, therefore the princess hid the events that took place and let the people live in an illusory peace."; idsuiv=1364; break;
        case 1364: texte = "But both of them knew that, from the bottom of hell, Ganon the immortal drew his power from his"; buffer="first wish to the Triforce, and rounded up his army with a plan to invade Hyrule."; idsuiv=1365; break;
        case 1365: texte = "Until, after months of anticipating an attack, an event occurred that put an end to the waiting..."; break;
        case 1366: texte = "WAKE UP !!! *MY LORD LINK !!!"; break;
        case 1367: texte = "HELP : Press BLACK BUTTON to bring up the help menu."; break;
        case 1368: texte = "Come back when you have a wallet and we'll talk business."; break;
        case 1369: texte = "We heard sounds of battle, and nothing more..."; break;
        case 1370: texte = "What in the world could have happened?"; break;
		case 1371:
            tmp = 0;
            for (int i = 0; i < 9; i++) if (gpJeu->getKeyboard()->getRang(i)) tmp++;
            if (tmp == 9 && gpJeu->getJoueur()->getEnnemi(141)) {id=1372; chercheText();break;}
            texte = "This door leads to a secret room. *Get the 9 ranks on the Records screen, then come back after having got the second ending to penetrate it.";
            break;
        case 1372: texte = "You may go in, Legendary Hero."; break;
        case 1373: texte = "Welcome to 3T's hidden room!"; idsuiv=1374; break;
        case 1374: texte = "I am Vincent, I created and coded the game."; break;
        case 1375: texte = "Hi, I am Lobalz. *I helped invent the game, made some new graphics, tested the majority of the dungeons, and translated the texts."; break;
        case 1376: texte = "Hello, I am Raiden! *I drew the illustrations of the game(... and also the clouds on the maps, but who cares actually...)."; idsuiv=1377; break;
        case 1377: texte = "You may find other drawings from me at the following address : http://alandar.deviantart.com"; break;
        case 1378: texte = "Monsters sank my boat... *I'm sorry, you will have to swim now...";break;
        case 1379: texte = "- GAME OVER -";break;
    }
}

void Texte::affiche(SDL_Surface* gpScreen, std::string s, int a, int b) {
    for (int i = 0; i < (int)s.length(); i++) {
        afficheLettre(gpScreen, s.at(i),a,b);
        a+=6;
    }
}

void Texte::draw(SDL_Surface* gpScreen) {
    
    if (cadre) drawCadre(gpScreen);
    
    if (id==3 && texte == "You found a piece of heart!!!") {
        SDL_Rect src; SDL_Rect dst;
        src.x=16*(gpJeu->getJoueur()->nbQuarts()%4);
        if(src.x==0)src.x=16*4;
        src.y=0; src.w=16; src.h=16; dst.x=160-8; dst.y=120-8+16*5;
        SDL_BlitSurface(imageCoeur, &src, gpScreen, &dst);
    }
    
    int a = x+8; int b = y+8;
    for (int i = 0; i < av; i++) {
        afficheLettre(gpScreen, texte.at(i),a,b);
        a+=6;
        if (a > x+w-16) {a=x+8; b+=16;}
    }
    
    if(SDL_GetTicks() > lastAnimTime + vitesse && def && av < (int)texte.length()) {
        lastAnimTime = SDL_GetTicks();
        do av++;
        while (av < (int)texte.length() && texte.at(av-1) == ' ');
        if (texte.at(av-1) != ' ') gpJeu->getAudio()->playSound(0,1);
    }
}

bool Texte::isFinished() {return (av==(int)texte.length());}

int Texte::getId() {return id;}

void Texte::changeId(int i) {
    id=i; idsuiv=0; buffer="";
    chercheText();
    decoupeText();
    if (av>(int)texte.length()) av=(int)texte.length();
}

void Texte::drawCadre(SDL_Surface* gpScreen) {
    SDL_Rect src;
    SDL_Rect dst;
    
    src.w=8; src.h=8; src.x = 103; src.y = 100; dst.x = x; dst.y = y;
    SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
    
    src.x = 112;
    for (int i = 8; i < w-8; i+=16) {
        dst.x = x+i; src.w=16;
        while (dst.x + src.w > x+w && src.w>0) src.w--;
        if (src.w>0) SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
    }
    
    src.w=8; src.x = 129; dst.x = x+w-8;
    SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
    
    src.y = 109; src.w=8;
    for (int j = 8; j < h-8; j+=16) {
        dst.y = y + j;
        src.x = 103; dst.x = x; src.h=16;
        while (dst.y + src.h > y+h && src.h>0) src.h--;
        if (src.h>0) SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
    
        src.x = 129; dst.x = x+w-8;
        if (src.h>0)SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
    }
    
    src.h=8; src.x = 103; src.y = 126; dst.x = x; dst.y = y+h-8;
    SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
    
    src.x = 112;
    for (int i = 8; i < w-8; i+=16) {
        dst.x = x+i; src.w=16;
        while (dst.x + src.w > x+w && src.w>0) src.w--;
        if (src.w>0) SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
    }
    
    src.w=8; src.x = 129; dst.x = x+w-8;
    SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
}

void Texte::setTexte(int idTxt, int vx, int vy, int vw, int vh, bool cadr, bool defil, int vit) {
    if (idTxt == 0) return;
    id = idTxt; 
    idsuiv = 0;
    buffer = "";
    chercheText();
    
    x = vx; y = vy; w = vw; h = vh;
    decoupeText();
        
    def=defil;
    if (def) av = 0;
    else av = texte.length();
    
    cadre = cadr;
    
    vitesse = vit;
}

void Texte::decoupeText() {
    //compte le nombre de caractres possibles et largeur et en hauteur
    int nbcol = (w-16)/6 -1;
    int nblig = (h-16)/16;
    int tailleMax = nbcol * nblig;
    int taille;
    
    //parcours du texte  afficher;  chaque dbut de mot, 
    //vrifie que le mot peut tenir sur la ligne
    for (int i = 0; i < (int)texte.length(); i++) {
        
        //supprime les espaces isols en dbut de ligne
        if (texte.at(i)==' ' && texte.at(i+1)!=' ' && i%nbcol == 0) texte.erase(i,1);
        //recherche du dbut du prochain mot
        while(texte.at(i)==' ' && i < (int)texte.length()-1) i++;
        
        //saute une ligne si trouve une toile
        if (texte.at(i)=='*') {
            texte.erase(i,1);//replace(i, 1, " ");
            int nb = (nbcol)-(i%(nbcol));
            for (int j = 0; j < nb; j++) texte.insert(i," ");
            continue;
        }
        
        //if the word above
        taille = tailleMot(i);
        if ((i%nbcol)+taille>nbcol) {
            if  (i < tailleMax) {
                //if the word does not fit on one line, it is cut with dashes
                if (taille>nbcol) {
                    texte.insert(((i/nbcol)+1)*nbcol-1,"--");
                    i = 1+((i/nbcol)+1)*nbcol;
                }
                //otherwise, add spaces to start the word line
                else while((i%nbcol) != 0) {texte.insert(i," "); i++;}
            }
        }
        
    }
    
    // if the text is too large, it is cut in half
    if ((int)texte.length() > tailleMax) {
        buffer = texte.substr(tailleMax);
        texte = texte.substr(0, tailleMax);
    }
}

int Texte::tailleMot(int deb) {
    int i = deb;
    int total = 0;
    while (texte.at(i)!=' ') {total++; i++; if (i >= (int)texte.length()) return total;}
    return total;
}

void Texte::afficheLettre(SDL_Surface* gpScreen, char c, int vx, int vy) {
    SDL_Rect src;
    SDL_Rect dst;
    
    int val = (int)c;
    
    dst.x=vx; dst.y=vy;
    src.h=16;src.w=8;
    
    if(val==32) return;
    
    // /
    if(val==47) {src.x=52;src.y=151;}
    
    // @ hylien
    if(val==64) {src.x=4;src.y=151;}
            
    // + hylien
    if(val==43) {src.x=20;src.y=151;}
            
    // = hylien
    if(val==61) {src.x=36;src.y=151;}
            
    //minuscules a-z
    if(val>=97 && val<=122) {src.x=4+16*((val-97)%10); src.y=52+16*((val-97)/10);}
            
    //majuscules A-Z
    if(val>=65 && val<=90) {src.x=6+16*((val-65)%10); src.y=2+16*((val-65)/10);}   
    // 
    if(val==-25) {src.x=148;src.y=34;}
    // 
    if(val==-23) {src.x=100;src.y=84;}
    // 
    if(val==-22) {src.x=116;src.y=84;}
    // 
    if(val==-24) {src.x=132;src.y=84;}
    // 
    if(val==-21) {src.x=132;src.y=151;}
    // 
    if(val==-32) {src.x=148;src.y=84;}
    // 
    if(val==-30) {src.x=148;src.y=103;}
    // 
    if(val==-28) {src.x=148;src.y=135;}
    // 
    if(val==-18) {src.x=84;src.y=119;}
    // 
    if(val==-17) {src.x=116;src.y=151;}
    // 
    if(val==-5) {src.x=84;src.y=103;}
    // 
    if(val==-7) {src.x=148;src.y=151;}
    // 
    if(val==-4) {src.x=116;src.y=135;}
    // 
    if(val==-10) {src.x=132;src.y=135;}
    // 
    if(val==-12) {src.x=148;src.y=119;}
            
    //ponctuation
    // -
    if(val==45) {src.x=102;src.y=34;}
    // .
    if(val==46) {src.x=118;src.y=34;}
    // ,
    if(val==44) {src.x=134;src.y=34;}
    // !
    if(val==33) {src.x=3;src.y=135;}
    // ?
    if(val==63) {src.x=19;src.y=135;}
    // (
    if(val==40) {src.x=35;src.y=135;}
    // )
    if(val==41) {src.x=51;src.y=135;}            
    // ' ( avec @ )
    if(val==39) {src.x=67;src.y=135;}
    // :
    if(val==58) {src.x=83;src.y=135;}
    // ... ( avec % )
    if(val==37) {src.x=101;src.y=135;}
    // >
    if(val==62) {src.x=100;src.y=151;}
    // <
    if(val==60) {src.x=84;src.y=151;}
            
    //chiffres            
    if(val>=48 && val<=57) {src.x=3+16*((val-48)%5); src.y=103+16*((val-48)/5);}
    
    SDL_BlitSurface(imageFont, &src, gpScreen, &dst);
}

bool Texte::hasNext() {
    return (buffer != "" || idsuiv > 0);
}

bool Texte::suite() {
    if (av < (int)texte.length()) {
        av = texte.length();
        return true;
    }
    if (!hasNext()) {
        gpJeu->getAudio()->playSound(18);
        return gpJeu->finTexte(id);
    }
    if (buffer != "") {
        texte = buffer;
        buffer = "";
    }
    else {
        id = idsuiv;
        idsuiv = 0;
        chercheText();
    }
    decoupeText();
    if (def) av = 0;
    else av = texte.length();
    gpJeu->getAudio()->playSound(17);
    return true;
}
