/*

    Zelda Oni Link Begins

    Copyright (C) 2006-2008  Vincent Jouillat

    Please send bugreports with examples or suggestions to www.zeldaroth.fr

*/

#include <sstream>
#include <fstream>
#include <iostream>

#include <SDL.h>

#include "Audio.h"

Audio::Audio() : musiqueId(0), specialId(0) {
    SOUND = true;
    music = NULL;
    
    if(SDL_InitSubSystem(SDL_INIT_AUDIO) == -1) SOUND = false;
    
    if (SOUND) {
        Mix_OpenAudio(44100, AUDIO_S16SYS, 2, 2048);
        previous_volume = Mix_VolumeMusic(32);
        loadSounds();
        setVolson(32);
    }
}

Audio::~Audio() {
    if (SOUND) {
        freeSounds();
        Mix_PauseMusic();
        Mix_VolumeMusic(previous_volume);
        Mix_HaltMusic();
        Mix_FreeMusic(music);
        Mix_CloseAudio();
    }
}

void Audio::setVolume(int volume) {
	Mix_VolumeMusic(volume);
}

void Audio::setVolson(int volson) {
    for (int i = 0; i < 44; i++)
		Mix_VolumeChunk(sons[i], volson);
}

void Audio::loadSounds() {
    sons = new Mix_Chunk*[44];

    sons[0] = Mix_LoadWAV("D:\\data\\sound\\text.ogg"); // lettres
    sons[1] = Mix_LoadWAV("D:\\data\\sound\\menu1.ogg"); // menu 1
    sons[2] = Mix_LoadWAV("D:\\data\\sound\\menu2.ogg"); // menu 2
    sons[3] = Mix_LoadWAV("D:\\data\\sound\\menu3.ogg"); // menu 3
    sons[4] = Mix_LoadWAV("D:\\data\\sound\\menu4.ogg"); // menu 4
    sons[5] = Mix_LoadWAV("D:\\data\\sound\\timewarp.ogg"); // time retour
    sons[6] = Mix_LoadWAV("D:\\data\\sound\\tombe.ogg"); // tombe (ennemi)
    sons[7] = Mix_LoadWAV("D:\\data\\sound\\hitenemy.ogg"); //shot 1
    sons[8] = Mix_LoadWAV("D:\\data\\sound\\killenemy.ogg"); // shot 2
    sons[9] = Mix_LoadWAV("D:\\data\\sound\\surprise.ogg"); // surprise
    sons[10] = Mix_LoadWAV("D:\\data\\sound\\monte.ogg"); // monte
    sons[11] = Mix_LoadWAV("D:\\data\\sound\\descend.ogg"); // descend
    sons[12] = Mix_LoadWAV("D:\\data\\sound\\chute.ogg"); // chute
    sons[13] = Mix_LoadWAV("D:\\data\\sound\\item.ogg"); // item
    sons[14] = Mix_LoadWAV("D:\\data\\sound\\rupee.ogg"); // rubis
    sons[15] = Mix_LoadWAV("D:\\data\\sound\\heart.ogg"); // coeur
    sons[16] = Mix_LoadWAV("D:\\data\\sound\\bomb.ogg"); // bombe
    sons[17] = Mix_LoadWAV("D:\\data\\sound\\textnext.ogg"); // suite texte
    sons[18] = Mix_LoadWAV("D:\\data\\sound\\textend.ogg"); // fin texte
    sons[19] = Mix_LoadWAV("D:\\data\\sound\\happy.ogg"); // trouve objet
    sons[20] = Mix_LoadWAV("D:\\data\\sound\\door.ogg"); // ouvre porte
    sons[21] = Mix_LoadWAV("D:\\data\\sound\\pics.ogg"); // pics contre mur
    sons[22] = Mix_LoadWAV("D:\\data\\sound\\sword.ogg"); // Epe
    sons[23] = Mix_LoadWAV("D:\\data\\sound\\SwordCharging.ogg"); // charge
    sons[24] = Mix_LoadWAV("D:\\data\\sound\\Sword360.ogg"); // spin
    sons[25] = Mix_LoadWAV("D:\\data\\sound\\shoot.ogg"); // flche
    sons[26] = Mix_LoadWAV("D:\\data\\sound\\hookshot.ogg"); // grappin
    sons[27] = Mix_LoadWAV("D:\\data\\sound\\stamp.ogg"); // pose bombe
    sons[28] = Mix_LoadWAV("D:\\data\\sound\\magic.ogg"); // magie
    sons[29] = Mix_LoadWAV("D:\\data\\sound\\burn.ogg"); // br˚le
    sons[30] = Mix_LoadWAV("D:\\data\\sound\\hammer.ogg"); // marteau
    sons[31] = Mix_LoadWAV("D:\\data\\sound\\plouf.ogg"); // plouf
    sons[32] = Mix_LoadWAV("D:\\data\\sound\\danger.ogg"); // danger
    sons[33] = Mix_LoadWAV("D:\\data\\sound\\hurt.ogg"); // link se blesse
    sons[34] = Mix_LoadWAV("D:\\data\\sound\\porte.ogg"); // porte objet
    sons[35] = Mix_LoadWAV("D:\\data\\sound\\lance.ogg"); // lance objet
    sons[36] = Mix_LoadWAV("D:\\data\\sound\\casse.ogg"); // casse objet
    sons[37] = Mix_LoadWAV("D:\\data\\sound\\charge.ogg"); // charge magie
    sons[38] = Mix_LoadWAV("D:\\data\\sound\\buisson.ogg"); // coupe buisson
    sons[39] = Mix_LoadWAV("D:\\data\\sound\\pousse.ogg"); // pousse caisse
	sons[40] = Mix_LoadWAV("D:\\data\\sound\\envol.ogg"); // chant envol
    sons[41] = Mix_LoadWAV("D:\\data\\sound\\vide.ogg"); // hymne vide
    sons[42] = Mix_LoadWAV("D:\\data\\sound\\masque.ogg"); // chant esprit
    sons[43] = Mix_LoadWAV("D:\\data\\sound\\splash.ogg"); // ...
}

void Audio::freeSounds() {
    if (SOUND) {
        for (int i = 0; i < 44; i++) Mix_FreeChunk(sons[i]);
        delete[] sons;
    }
}

void Audio::playSound(int id, int chl) {
    if (SOUND) Mix_PlayChannel(chl,sons[id],0);
}

void Audio::playMusic(int id) {
    if (SOUND) {
        if (musiqueId != id) {
			musiqueId = id;            
            if (specialId == 0) {
				Mix_HaltMusic();
				Mix_FreeMusic(music);
				music = choixMusique(id);
				Mix_PlayMusic(music,-1);
				specialId = 0;
			}
        }
    }
}

bool Audio::isSpecial() {return (specialId>0);}

void Audio::stopMusic() {
    if (SOUND) Mix_HaltMusic();
}

void Audio::replayMusic() {
    if (SOUND) Mix_PlayMusic(music,-1);
}

Mix_Music* Audio::choixMusique(int id) {
    switch (id) {
		case 1 : return Mix_LoadMUS("D:\\data\\music\\Foret.ogg");
        case 2 : return Mix_LoadMUS("D:\\data\\music\\Plaine.ogg");
        case 3 : return Mix_LoadMUS("D:\\data\\music\\Villageest.ogg");
        case 4 : return Mix_LoadMUS("D:\\data\\music\\Vallee.ogg");
        case 5 : return Mix_LoadMUS("D:\\data\\music\\Desert.ogg");
        case 6 : return Mix_LoadMUS("D:\\data\\music\\Lac.ogg");
        case 7 : return Mix_LoadMUS("D:\\data\\music\\Rauru.ogg");
        case 8 : return Mix_LoadMUS("D:\\data\\music\\Chateau.ogg");
        case 9 : return Mix_LoadMUS("D:\\data\\music\\PlaineO.ogg");
        case 10 : return Mix_LoadMUS("D:\\data\\music\\Marais.ogg");
        case 11 : return Mix_LoadMUS("D:\\data\\music\\Ombre.ogg");
        case 12 : return Mix_LoadMUS("D:\\data\\music\\Secret.ogg");
        case 13 : return Mix_LoadMUS("D:\\data\\music\\Mido.ogg");
        case 14 : return Mix_LoadMUS("D:\\data\\music\\Mont.ogg");
        case 15 : case 17 : return Mix_LoadMUS("D:\\data\\music\\Donjon1.ogg");
        case 18 : return Mix_LoadMUS("D:\\data\\music\\Manoir.ogg");
        case 19 : return Mix_LoadMUS("D:\\data\\music\\Ordinn.ogg");
        case 20 : return Mix_LoadMUS("D:\\data\\music\\Colisee.ogg");
        case 21 : return Mix_LoadMUS("D:\\data\\music\\Lanelle.ogg");
        case 22 : return Mix_LoadMUS("D:\\data\\music\\DFinal.ogg");
        case 23 : return Mix_LoadMUS("D:\\data\\music\\DDesert.ogg");
        case 24 : return Mix_LoadMUS("D:\\data\\music\\Glace.ogg");
        case 25 : return Mix_LoadMUS("D:\\data\\music\\Farore.ogg");
        case 26 : return Mix_LoadMUS("D:\\data\\music\\Xanto.ogg");
        case 27 : return Mix_LoadMUS("D:\\data\\music\\DSecret.ogg");
        case 28 : return Mix_LoadMUS("D:\\data\\music\\TourD.ogg");
        case 16 : case 29 : case 31 : case 32 : case 33 : case 34 : case 35 :
        case 36 : case 37 : case 38 : case 40 : case 41 : case 42 : case 43 :
            return Mix_LoadMUS("D:\\data\\music\\Cave.ogg");
        case 30 : case 39 : return Mix_LoadMUS("D:\\data\\music\\Fee.ogg");
        case 44 : return Mix_LoadMUS("D:\\data\\music\\Pit.ogg");
        case 45 : case 46 : case 54 : case 57 : case 58 : case 63 : case 64 :
        case 66 : case 67 : case 71 : return Mix_LoadMUS("D:\\data\\music\\Maison.ogg");
        case 52 : case 56 : case 61 : case 70 :
            return Mix_LoadMUS("D:\\data\\music\\Potion.ogg");
        case 48 : case 53 : return Mix_LoadMUS("D:\\data\\music\\Bar.ogg");
        case 49 : case 62 : case 68 : case 79 : return Mix_LoadMUS("D:\\data\\music\\Maire.ogg");
        case 50 : case 51 : case 59 : case 60 : case 65 : case 69 :
            return Mix_LoadMUS("D:\\data\\music\\Magasin.ogg");
        case 47 : return Mix_LoadMUS("D:\\data\\music\\Jeu.ogg");
        case 55 : return Mix_LoadMUS("D:\\data\\music\\Triste.ogg");
        case 80 : return Mix_LoadMUS("D:\\data\\music\\Titre.ogg");
        case 90 : return Mix_LoadMUS("D:\\data\\music\\Selection.ogg");
        case 100 : return Mix_LoadMUS("D:\\data\\music\\Debut.ogg");
        default : return Mix_LoadMUS("D:\\data\\music\\Maison.ogg");
    }
}

void Audio::playSpecial(int id) {
    if (SOUND) {
        if (specialId != id) {
            Mix_HaltMusic();
            Mix_FreeMusic(music);
            music = choixSpecial(id);
            Mix_PlayMusic(music,-1);
            specialId=id;
        }    
    }
}

void Audio::stopSpecial() {
    if (!specialId) return;
    int tmp = musiqueId;
    musiqueId = 0;
	specialId = 0;
    playMusic(tmp);
}

Mix_Music* Audio::choixSpecial(int id) {
    switch (id) {
		case 1 : return Mix_LoadMUS("D:\\data\\music\\Boss.ogg");
        case 2 : return Mix_LoadMUS("D:\\data\\music\\Mort.ogg");
        case 3 : return Mix_LoadMUS("D:\\data\\music\\Epee.ogg");
        case 4 : return Mix_LoadMUS("D:\\data\\music\\BossF.ogg");
        case 5 : return Mix_LoadMUS("D:\\data\\music\\Fin.ogg");
        case 6 : return Mix_LoadMUS("D:\\data\\music\\BossM.ogg");
        case 7 : return Mix_LoadMUS("D:\\data\\music\\Area81.ogg");
        case 8 : return Mix_LoadMUS("D:\\data\\music\\OniLink.ogg");
        default : return Mix_LoadMUS("D:\\data\\music\\Boss.ogg");
    }
}

