#include <hal/xbox.h>
#include <hal/fileio.h>
#include <openxdk/debug.h>

#include "wl_def.h"

#include "SDL/SDL.h"

byte *gfxbuf = NULL;
SDL_Surface *surface;
SDL_Surface *fullscreenSurface;

KeyboardDef KbdDefs2 = {sc_Control, sc_Alt, sc_Home, sc_UpArrow, sc_PgUp, sc_LeftArrow, sc_RightArrow, sc_End, sc_DownArrow, sc_PgDn};


extern void keyboard_handler(int code, int press);
extern boolean InternalKeyboard[NumCodes];

//int main (int argc, char *argv[])
void XBoxStartup()
{
	WolfMain(0, 0);
}

void DisplayTextSplash(byte *text);

/*
==========================
=
= Quit
=
==========================
*/

void Quit(char *error)
{
	memptr screen = NULL;

	if (!error || !*error) {
		CA_CacheGrChunk(ORDERSCREEN);
		screen = grsegs[ORDERSCREEN];
		WriteConfig();
	} else if (error) {
		CA_CacheGrChunk(ERRORSCREEN);
		screen = grsegs[ERRORSCREEN];
	}
	
	ShutdownId();
	
	if (screen) {
		//DisplayTextSplash(screen);
	}
	
	
	if (error && *error) {
	        debugPrint("\n\n      Quit: %s\n", error);
         	XSleep(5000);
		exit(EXIT_FAILURE);
 	}
	
	exit(EXIT_SUCCESS);
}

void VL_WaitVBL(int vbls)
{
	long last = get_TimeCount() + vbls;
	while (last > get_TimeCount()) ;
}

void VW_UpdateScreen()
{
	//VL_WaitVBL(1); 
	//memcpy(surface->pixels, gfxbuf, vwidth*vheight);
	//SDL_UpdateRect(surface, 0, 0, 0, 0);
	
	// since we're using the xbox we have time to burn so let's stretch the rectangle to fit
	// the entire screen (is there a better way to do this? please let me know of an easier,
	// faster way to do this.
	
	
	unsigned char *src;
	unsigned char *dst;
	
	src = surface->pixels;
	
//	SDL_LockSurface(surface);
//	SDL_LockSurface(fullscreenSurface);
	
	dst = fullscreenSurface->pixels + (40*640);
	
	int i; int j;
	
	for (i = 0; i < 200; i++) {
	   src = surface->pixels + (i*320);
	   for (j = 0; j < 320; j++) {
	      *(dst++) = *(src);
	      *(dst++) = *(src++);
	   }
	   memcpy(dst, dst-641, 640);
	   dst+=640;
//	   src = surface->pixels + (i*320);
//	   for (j = 0; j < 320; j++) {
//              *(dst++) = *(src);
//	      *(dst++) = *(src++);
//	   }
	}
	
//	SDL_UnlockSurface(surface);
//	SDL_UnlockSurface(fullscreenSurface);
	
	SDL_Flip(fullscreenSurface);
}

/*
=======================
=
= VL_Startup
=
=======================
*/

void VL_Startup()
{
	vwidth = 320;
	vheight = 200;
	
	if (MS_CheckParm("x2")) {
		vwidth *= 2;
		vheight *= 2;
	} else if (MS_CheckParm("x3")) {
		vwidth *= 3;
		vheight *= 3;
	}
	
	//if (gfxbuf == NULL) 
	//	gfxbuf = malloc(vwidth * vheight * 1);
/* TODO: renable parachute for release version? */		
	if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_NOPARACHUTE|SDL_INIT_JOYSTICK) < 0) {
		Quit("Couldn't init SDL");
	}
	SDL_JoystickEventState(SDL_ENABLE);
	SDL_JoystickOpen(0);
	
	surface = SDL_CreateRGBSurface(SDL_SWSURFACE|SDL_HWPALETTE, vwidth, vheight, 8, 0,0,0,0);
	
	if (MS_CheckParm("fullscreen"))
		//surface = SDL_SetVideoMode(vwidth, vheight, 8, SDL_SWSURFACE|SDL_HWPALETTE|SDL_FULLSCREEN);
		fullscreenSurface = SDL_SetVideoMode(640,480, 8, SDL_SWSURFACE|SDL_HWPALETTE|SDL_FULLSCREEN|SDL_DOUBLEBUF);
	else
		//surface = SDL_SetVideoMode(vwidth, vheight, 8, SDL_SWSURFACE|SDL_HWPALETTE);
		fullscreenSurface = SDL_SetVideoMode(640,480, 8, SDL_SWSURFACE|SDL_HWPALETTE|SDL_DOUBLEBUF);
		
	if (surface == NULL) {
		SDL_Quit();
		Quit("Couldn't set 320x200 mode");
	}
	gfxbuf = surface->pixels;
	
	if (surface->flags & SDL_FULLSCREEN)
		SDL_ShowCursor(0);
	
	SDL_WM_SetCaption(GAMENAME, GAMENAME);
}

/*
=======================
=
= VL_Shutdown
=
=======================
*/

void VL_Shutdown()
{
	//if (gfxbuf != NULL) {
	//	free(gfxbuf);
	//	gfxbuf = NULL;
	//}
	SDL_Quit();
}

/* ======================================================================== */

/*
=================
=
= VL_SetPalette
=
=================
*/

void VL_SetPalette(const byte *palette)
{
	SDL_Color colors[256];
	int i;
	
	VL_WaitVBL(1);
	
	for (i = 0; i < 256; i++)
	{
		colors[i].r = palette[i*3+0] << 2;
		colors[i].g = palette[i*3+1] << 2;
		colors[i].b = palette[i*3+2] << 2;
	}
	SDL_SetColors(surface, colors, 0, 256);
	SDL_SetColors(fullscreenSurface, colors, 0, 256);
}

/*
=================
=
= VL_GetPalette
=
=================
*/

void VL_GetPalette(byte *palette)
{
	int i;
	for (i=0;i<256;i++)
	{
		palette[i*3+0] = fullscreenSurface->format->palette->colors[i].r >> 2;
		palette[i*3+1] = fullscreenSurface->format->palette->colors[i].g >> 2;
		palette[i*3+2] = fullscreenSurface->format->palette->colors[i].b >> 2;
	}
}

static int XKeysymToScancode(unsigned int keysym)
{
	switch (keysym) {
		case SDLK_KP_ENTER:
		case SDLK_RETURN:
			return sc_Enter;
		case SDLK_ESCAPE:
			return sc_Escape;
		case SDLK_SPACE:
			return sc_Space;
		case SDLK_BACKSPACE:
			return sc_BackSpace;
		case SDLK_TAB:
			return sc_Tab;
		case SDLK_LALT:
			return sc_Alt;
		case SDLK_LCTRL:
			return sc_Control;
		case SDLK_CAPSLOCK:
			return sc_CapsLock;
		case SDLK_LSHIFT:
			return sc_LShift;
		case SDLK_RSHIFT:
			return sc_RShift;
		
		case SDLK_UP:
		case SDLK_KP8:
			return sc_UpArrow;
		case SDLK_DOWN:
		case SDLK_KP2:
			return sc_DownArrow;
		case SDLK_LEFT:
		case SDLK_KP4:
			return sc_LeftArrow;
		case SDLK_RIGHT:
		case SDLK_KP6:
			return sc_RightArrow;
		case SDLK_HOME:
			return sc_Home;
		case SDLK_END:
			return sc_End;
		case SDLK_PAGEUP:
			return sc_PgUp;
		case SDLK_PAGEDOWN:
			return sc_PgDn;
			
		case SDLK_INSERT:
			return sc_Insert;
		case SDLK_DELETE:
			return sc_Delete;
		case SDLK_F1:
			return sc_F1;
		case SDLK_F2:
			return sc_F2;
		case SDLK_F3:
			return sc_F3;
		case SDLK_F4:
			return sc_F4;
		case SDLK_F5:
			return sc_F5;
		case SDLK_F6:
			return sc_F6;
		case SDLK_F7:
			return sc_F7;
		case SDLK_F8:
			return sc_F8;
		case SDLK_F9:
			return sc_F9;
		case SDLK_F10:
			return sc_F10;
		case SDLK_F11:
			return sc_F11;
		case SDLK_F12:
			return sc_F12;	
		
		case SDLK_1:
			return sc_1;
		case SDLK_2:
			return sc_2;
		case SDLK_3:
			return sc_3;
		case SDLK_4:
			return sc_4;
		case SDLK_5:
			return sc_5;
		case SDLK_6:
			return sc_6;
		case SDLK_7:
			return sc_7;
		case SDLK_8:
			return sc_8;
		case SDLK_9:
			return sc_9;
		case SDLK_0:
			return sc_0;
		
		case SDLK_a:
			return sc_A;
		case SDLK_b:
			return sc_B;
		case SDLK_c:
			return sc_C;
		case SDLK_d:
			return sc_D;
		case SDLK_e:
			return sc_E;
		case SDLK_f:
			return sc_F;
		case SDLK_g:
			return sc_G;
		case SDLK_h:
			return sc_H;
		case SDLK_i:
			return sc_I;
		case SDLK_j:
			return sc_J;
		case SDLK_k:
			return sc_K;
		case SDLK_l:
			return sc_L;
		case SDLK_m:
			return sc_M;
		case SDLK_n:
			return sc_N;
		case SDLK_o:
			return sc_O;
		case SDLK_p:
			return sc_P;
		case SDLK_q:
			return sc_Q;
		case SDLK_r:
			return sc_R;
		case SDLK_s:
			return sc_S;
		case SDLK_t:
			return sc_T;
		case SDLK_u:
			return sc_U;
		case SDLK_v:
			return sc_V;
		case SDLK_w:
			return sc_W;
		case SDLK_x:
			return sc_X;
		case SDLK_y:
			return sc_Y;
		case SDLK_z:
			return sc_Z;
		
		case SDLK_PAUSE:
			return 0xE1;
		default:
			return sc_None;
	}
}

void INL_Update()
{
	SDL_Event event;
	boolean DebouncedKeyboard[NumCodes];
		
	memcpy(DebouncedKeyboard, InternalKeyboard, sizeof(DebouncedKeyboard));
		
	if (SDL_PollEvent(&event)) {
		do {
			switch(event.type) {
				case SDL_KEYDOWN:
					keyboard_handler(XKeysymToScancode(event.key.keysym.sym), 1);
					break;
				case SDL_KEYUP:
					keyboard_handler(XKeysymToScancode(event.key.keysym.sym), 0);
					break;
				default:
					break;
				case SDL_JOYBUTTONDOWN:
					if (event.jbutton.button == 7 || event.jbutton.button == 6) {
					   keyboard_handler(sc_Control, 1);
					} else if (event.jbutton.button == 2) {
					   keyboard_handler(sc_Alt, 1);
					} else if (event.jbutton.button == 0) {
					   keyboard_handler(sc_Space, 1);
					} else if (event.jbutton.button == 9) {
					   keyboard_handler(sc_Escape, 1);
					} else if (event.jbutton.button == 8) {
					   keyboard_handler(sc_Enter, 1);
					} else if (event.jbutton.button == 5) {
					   keyboard_handler(sc_1, 1);
					} else if (event.jbutton.button == 4) {
					   keyboard_handler(sc_2, 1);
					}
					break;
				case SDL_JOYBUTTONUP:
					if (event.jbutton.button == 7 || event.jbutton.button == 6) {
					   keyboard_handler(sc_Control, 0);
					} else if (event.jbutton.button == 2) {
					   keyboard_handler(sc_Alt, 0);
					} else if (event.jbutton.button == 0) {
					   keyboard_handler(sc_Space, 0);
					} else if (event.jbutton.button == 9) {
					   keyboard_handler(sc_Escape, 0);
					} else if (event.jbutton.button == 8) {
					   keyboard_handler(sc_Enter, 0);
					} else if (event.jbutton.button == 5) {
					   keyboard_handler(sc_1, 0);
					} else if (event.jbutton.button == 4) {
					   keyboard_handler(sc_2, 0);
					}
					break;
				case SDL_JOYHATMOTION:
					if (event.jhat.value & SDL_HAT_UP) {
					   keyboard_handler(sc_UpArrow, 1);
					} else {
					   keyboard_handler(sc_UpArrow, 0);
					}
					if (event.jhat.value & SDL_HAT_DOWN) {
					   keyboard_handler(sc_DownArrow, 1);
					} else {
					   keyboard_handler(sc_DownArrow, 0);
					} 
					if (event.jhat.value & SDL_HAT_LEFT) {
					   keyboard_handler(sc_LeftArrow, 1);
					} else {
					   keyboard_handler(sc_LeftArrow, 0);
					} 
					if (event.jhat.value == SDL_HAT_RIGHT) {
					   keyboard_handler(sc_RightArrow, 1);
					} else {
					   keyboard_handler(sc_RightArrow, 0);
					}
					break;
			}
		} while (SDL_PollEvent(&event));
	}
	
	if (InternalKeyboard[sc_Alt] && 
	(!DebouncedKeyboard[sc_Return] && InternalKeyboard[sc_Return])) {
		SDL_GrabMode gm;
		
		SDL_WM_ToggleFullScreen(surface);
		
		gm = SDL_WM_GrabInput(SDL_GRAB_QUERY);
		if (gm == SDL_GRAB_OFF && !(surface->flags & SDL_FULLSCREEN))
			SDL_ShowCursor(1);
		else
			SDL_ShowCursor(0);
	}
	
	if (InternalKeyboard[sc_Control] &&
	(!DebouncedKeyboard[sc_G] && InternalKeyboard[sc_G])) {
		SDL_GrabMode gm;
		
		gm = SDL_WM_GrabInput(SDL_GRAB_QUERY);
		SDL_WM_GrabInput((gm == SDL_GRAB_ON) ? SDL_GRAB_OFF : SDL_GRAB_ON);
		
		gm = SDL_WM_GrabInput(SDL_GRAB_QUERY);
		if (gm == SDL_GRAB_OFF && !(surface->flags & SDL_FULLSCREEN))
			SDL_ShowCursor(1);
		else
			SDL_ShowCursor(0);
	}
	
	/* ctrl-z for iconify window? */
}

void IN_GetMouseDelta(int *dx, int *dy)
{
	int x, y;
	
	SDL_GetRelativeMouseState(&x, &y);
	
	if (dx)
		*dx = x;
	if (dy)
		*dy = y;
}

byte IN_MouseButtons()
{
	return SDL_GetMouseState(NULL, NULL);
}
