#include <SDL.h>
#include "xboxJoy.h"


extern SDL_Joystick *js,*js2;
extern void resize_screen();
Uint8 *key2joy()
{
	Uint8 *keyboard;
	keyboard = SDL_GetKeyState(NULL);

	keyboard[SDLK_UP] = false;
	keyboard[SDLK_DOWN] = false;
	keyboard[SDLK_LEFT] = false;
	keyboard[SDLK_RIGHT] = false;
	keyboard[SDLK_SPACE] = false;
	keyboard[SDLK_F1] = false;
	keyboard[SDLK_c] = false;
	keyboard[SDLK_b] = false;
	keyboard[SDLK_a] = false;
	keyboard[SDLK_ESCAPE] = false;

	//Xbox Buttons P1

	if(SDL_JoystickGetButton(js, JOY_BTTN_RTRIG))
		keyboard[SDLK_SPACE] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_BACK))
		keyboard[SDLK_ESCAPE] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_A))
		keyboard[SDLK_SPACE] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js, JOY_BTTN_START))
		keyboard[SDLK_F1] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js,JOY_BTTN_RSTICK))
		resize_screen();

    //Xbox Joystick
	if(SDL_JoystickGetAxis(js, JOY_AXIS_LX) < -JOY_DEADZONE)
		keyboard[SDLK_LEFT] = SDL_PRESSED;
	if(SDL_JoystickGetAxis(js, JOY_AXIS_LX) > JOY_DEADZONE)
		keyboard[SDLK_RIGHT] = SDL_PRESSED;
	if(SDL_JoystickGetAxis(js, JOY_AXIS_LY) < -JOY_DEADZONE)
		keyboard[SDLK_UP] = SDL_PRESSED;
	if(SDL_JoystickGetAxis(js, JOY_AXIS_LY) > JOY_DEADZONE)
		keyboard[SDLK_DOWN] = SDL_PRESSED;

	//Xbox DPAD
	switch(SDL_JoystickGetHat(js, 0))
	{
	case SDL_HAT_UP:
		keyboard[SDLK_UP] = SDL_PRESSED;
		break;
	case SDL_HAT_DOWN:
		keyboard[SDLK_DOWN] = SDL_PRESSED;
		break;
	case SDL_HAT_LEFT:
	case SDL_HAT_LEFTUP:
	case SDL_HAT_LEFTDOWN:
		keyboard[SDLK_LEFT] = SDL_PRESSED;
		break;
	case SDL_HAT_RIGHT:
	case SDL_HAT_RIGHTUP:
	case SDL_HAT_RIGHTDOWN:
		keyboard[SDLK_RIGHT] = SDL_PRESSED;
		break;
	default:
		break;
	}

	//Xbox Buttons P2
	if(SDL_JoystickGetButton(js2, JOY_BTTN_RTRIG))
		keyboard[SDLK_c] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js2, JOY_BTTN_A))
		keyboard[SDLK_c] = SDL_PRESSED;
	if(SDL_JoystickGetButton(js2, JOY_BTTN_START))
		keyboard[SDLK_F1] = SDL_PRESSED;

    //Xbox Joystick
	if(SDL_JoystickGetAxis(js2, JOY_AXIS_LX) < -JOY_DEADZONE)
		keyboard[SDLK_a] = SDL_PRESSED;
	if(SDL_JoystickGetAxis(js2, JOY_AXIS_LX) > JOY_DEADZONE)
		keyboard[SDLK_b] = SDL_PRESSED;

	//Xbox DPAD
	switch(SDL_JoystickGetHat(js2, 0))
	{
	case SDL_HAT_LEFT:
	case SDL_HAT_LEFTUP:
	case SDL_HAT_LEFTDOWN:
		keyboard[SDLK_a] = SDL_PRESSED;
		break;
	case SDL_HAT_RIGHT:
	case SDL_HAT_RIGHTUP:
	case SDL_HAT_RIGHTDOWN:
		keyboard[SDLK_b] = SDL_PRESSED;
		break;
	default:
		break;
	}
	
	return keyboard;
}