
enum {	
	//MatrixMode
	GL_PROJECTION,
	GL_MODELVIEW,

    //Enable
	GL_LINE_SMOOTH,
	GL_BLEND,
	GL_LIGHTING,
	GL_CULL_FACE,
	GL_DEPTH_TEST,
	GL_COLOR_MATERIAL,

	//BindTexture, glTexParameteri, gluBuild2DMipmaps, Enable
	GL_TEXTURE_2D,

	//gluBuild2DMipmaps
	GL_RGB,
	GL_UNSIGNED_BYTE,

	//TexParameteri
	GL_TEXTURE_MAG_FILTER,
	GL_LINEAR,
	GL_TEXTURE_MIN_FILTER,
	GL_LINEAR_MIPMAP_NEAREST,

	//glBegin
	GL_TRIANGLE_FAN,
	GL_LINE_LOOP,
	GL_LINES,
	GL_LINE_STRIP,
	GL_QUADS,

	//BlendFunc
	GL_SRC_ALPHA,
	GL_ONE,

	//clear
	GL_COLOR_BUFFER_BIT
};

#ifdef __cplusplus
extern "C"
{
#endif

void glScreenResize();

void glInitEmuLayer();
void glSwapBuffers();
void glClearColor(float r, float g, float b, float alpha);
void glViewport(int x, int y, int width, int height);
void glMatrixMode(int mode);
void glLoadIdentity();
void glLineWidth(float width);
void glEnable(int cap);
void glDisable(int cap);
void glBlendFunc(int sfactor, int dfactor);
void glGenTextures(int n, int *textures);
void glBindTexture(int target, int texture);
void glTexParameteri(int target, int pname, int param);
void glDeleteTextures(int n, const int *textures);
void glPushMatrix();
void glClear(int mask);
void glPopMatrix();
void glTranslatef(float x, float y, float z);
void glScalef(float x, float y, float z);
void glColor4ub(unsigned char red, unsigned char green, unsigned char blue, unsigned char alpha);
void glBegin(int mode);
void glVertex3f(float x, float y, float z);
void glVertex2f(float x, float y);
void glEnd();
void glRotatef(float angle, float x, float y, float z);
void glTexCoord2f(float s, float t);
void glOrtho(float left, float right, float bottom, float top, float zNear, float zFar);

void gluLookAt(float eyex, 
			   float eyey, 
			   float eyez, 
			   float centerx, 
			   float centery, 
			   float centerz, 
			   float upx, 
			   float upy, 
			   float upz);

void gluPerspective(float fovy, 
					float aspect, 
					float zNear, 
					float zFar);

void gluBuild2DMipmaps(int      target, 
					   int       components, 
					   int       width, 
					   int       height, 
					   int      format, 
					   int      type, 
					   const void  *data);

#ifdef __cplusplus
};
#endif
