/*
 * $Id: screen.h,v 1.4 2003/04/26 03:24:16 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */

/**
 * Opengl screen functions header file.
 *
 * @version $Revision: 1.4 $
 */
#include "libSDLx/include/sdl.h"

#define PAD_UP 1
#define PAD_DOWN 2
#define PAD_LEFT 4
#define PAD_RIGHT 8
#define PAD_BUTTON1 16
#define PAD_BUTTON2 32

#define DEFAULT_BRIGHTNESS 224

extern float eyeX, eyeY, eyeZ;
extern float pitch, roll;
extern float zoom;
extern Uint8 *keys;
extern SDL_Joystick *stick;
extern int buttonReversed;
extern int lowres;
extern int windowMode;
extern int brightness;

void resetButtonState();
int getPadState();
int getButtonState();

/*void loadModel(char *fileName, GLuint *model);*/
void loadGLTexture(char*, int*);
void generateTexture(int*);
void deleteTexture(int*);
void initSDL();
void closeSDL();
void resized(int, int);
void drawGLSceneStart();
void drawGLSceneEnd();
void swapGLScene();

void setScreenShake(int type, int cnt);
void moveScreenShake();

void drawBox(float x, float y, float width, float height, int r, int g, int b);
void drawLine(float, float, float,
	      float, float, float, int, int, int, int);
void drawLinePart(float x1, float y1, float z1,
		  float x2, float y2, float z2, int r, int g, int b, int a, int len);
void drawRollLineAbs(float x1, float y1, float z1,
		     float x2, float y2, float z2, int r, int g, int b, int a, int d1);
void drawRollLine(float x, float y, float z, float width,
		  int r, int g, int b, int a, int d1, int d2);
void drawSquare(float x1, float y1, float z1, 
		float x2, float y2, float z2, 
		float x3, float y3, float z3, 
		float x4, float y4, float z4, 
		int r, int g, int b);
void drawStar(int f, float x, float y, float z, int r, int g, int b, float size);
void drawLaser(float x, float y, float width, float height,
	       int cc1, int cc2, int cc3, int cc4, int cnt, int type);
void drawCore(float x, float y, int cnt, int r, int g, int b);
void drawShipShape(float x, float y, float d, int inv);
void drawBomb(float x, float y, float width, int cnt);
void drawCircle(float x, float y, float width, int cnt, 
		int r1, int g1, int b1, int r2, int b2, int g2);
void drawShape(float x, float y, float size, int d, int cnt, int type,
	       int r, int g, int b);
void drawShapeIka(float x, float y, float size, int d, int cnt, int type, int c);
void drawShot(float x, float y, float d, int c, float width, float height);
void startDrawBoards();
void endDrawBoards();
void drawSideBoards();
void drawTitleBoard();

int drawNum(int n, int x ,int y, int s, int r, int g, int b);
int drawNumRight(int n, int x ,int y, int s, int r, int g, int b);
int drawNumCenter(int n, int x ,int y, int s, int r, int g, int b);
int drawTimeCenter(int n, int x ,int y, int s, int r, int g, int b);
