//-----------------------------------------------------------------------------
// File: gamepad.cpp		v1.01
//
// Desc: GAMEPAD InputDevice shit
//
// Copyright (c) Huirippu. All rights reserved.
//-----------------------------------------------------------------------------
#include "stdafx.h"
//#include <xtl.h>

#include "gamepad.h"



//-----------------------------------------------------------------------------
XINPUT_POLLING_PARAMETERS	CGamePad::m_PollingParams =
													{TRUE, TRUE, 0, 8, 8, 0,};
//-----------------------------------------------------------------------------
CGamePads g_GamePads;
//-----------------------------------------------------------------------------
CGamePad::CGamePad()
{
	ZeroMemory( &m_InputState, sizeof(XINPUT_STATE) );
	m_hDevice = NULL;
}
//-----------------------------------------------------------------------------
CGamePad::~CGamePad()
{
}
//-----------------------------------------------------------------------------
HRESULT CGamePad::Initialise(DWORD dwSlot)
{
	// Get a handle to the device
	m_hDevice = XInputOpen(	XDEVICE_TYPE_GAMEPAD, dwSlot,
							XDEVICE_NO_SLOT, &m_PollingParams);
	if(!m_hDevice)
		return E_FAIL;

	// Initialize last pressed buttons
	XInputGetState(m_hDevice, &m_InputState );
	m_wLastButtons = m_InputState.Gamepad.wButtons;
	for( DWORD b=0; b<8; b++ )
	{
		m_bLastAnalogButtons[b] =
			// Turn the 8-bit polled value into a boolean value
			( m_InputState.Gamepad.bAnalogButtons[b] > XINPUT_GAMEPAD_MAX_CROSSTALK );
	}
	return S_OK;
}
//-----------------------------------------------------------------------------
#define	XBINPUT_DEADZONE	0.24f

void CGamePad::Read()
{
	// If we have a valid device, poll it's state and track button changes
	if(m_hDevice)
	{
		// Read the input state
		XInputGetState(m_hDevice, &m_InputState);

		// Copy gamepad to local structure
		memcpy(this, &m_InputState.Gamepad, sizeof(XINPUT_GAMEPAD));

		// Put Xbox device input for the gamepad into our custom format
		FLOAT f = (sThumbLX+0.5f)/32767.5f;
		m_fX1 = ( f >= 0.0f ? 1.0f : -1.0f ) *
				max( 0.0f, (fabsf(f)-XBINPUT_DEADZONE)/(1.0f-XBINPUT_DEADZONE) );
		f = (sThumbLY+0.5f)/32767.5f;
		m_fY1 = ( f >= 0.0f ? 1.0f : -1.0f ) *
				max( 0.0f, (fabsf(f)-XBINPUT_DEADZONE)/(1.0f-XBINPUT_DEADZONE) );
		f = (sThumbRX+0.5f)/32767.5f;
		m_fX2 = ( f >= 0.0f ? 1.0f : -1.0f ) *
				max( 0.0f, (fabsf(f)-XBINPUT_DEADZONE)/(1.0f-XBINPUT_DEADZONE) );
		f = (sThumbRY+0.5f)/32767.5f;
		m_fY2 = ( f >= 0.0f ? 1.0f : -1.0f ) *
				max( 0.0f, (fabsf(f)-XBINPUT_DEADZONE)/(1.0f-XBINPUT_DEADZONE) );
		// Get the boolean buttons that have been pressed since the last
		// call. Each button is represented by one bit.
		m_wPressedButtons	= (m_wLastButtons ^ wButtons) & wButtons;
		m_wLastButtons		= wButtons;

		// Get the analog buttons that have been pressed or released since
		// the last call.
		BOOL bPressed;
		for(DWORD b=0; b<8; b++)
		{
			// Turn the 8-bit polled value into a boolean value
			bPressed = (bAnalogButtons[b] > XINPUT_GAMEPAD_MAX_CROSSTALK);

			if(bPressed)
				m_bPressedAnalogButtons[b] = !m_bLastAnalogButtons[b];
			else
				m_bPressedAnalogButtons[b] = FALSE;
	        
			// Store the current state for the next time
			m_bLastAnalogButtons[b] = bPressed;
		}
	}
}
//-----------------------------------------------------------------------------
void CGamePad::Remove()
{
	// If the controller was removed after XGetDeviceChanges but before
	// XInputOpen, the device handle will be NULL
	if( m_hDevice )
		XInputClose( m_hDevice );
	m_hDevice = NULL;
//	pGamepads[i].Feedback.Rumble.wLeftMotorSpeed  = 0;
//	pGamepads[i].Feedback.Rumble.wRightMotorSpeed = 0;
}
//-----------------------------------------------------------------------------
CGamePads::CGamePads()
{
}

CGamePads::~CGamePads()
{
}
//-----------------------------------------------------------------------------
// Name: 
// Desc: Initialises attatched gamepad devices
//-----------------------------------------------------------------------------
HRESULT CGamePads::Initialise()
{
	XDEVICE_PREALLOC_TYPE deviceTypes[] = { {XDEVICE_TYPE_GAMEPAD, 1} };
	XInitDevices(1, deviceTypes);	// may take 500msec !!!!

	// Get a mask of all currently available devices
	DWORD dwDeviceMask = XGetDevices(XDEVICE_TYPE_GAMEPAD);

	// Open the devices
	HRESULT		hRes;
	for(DWORD i=0; i<NUM_GAMEPADS; i++)
	{
		if(dwDeviceMask & (1<<i)) 
		{
			if(hRes = m_GamePads[i].Initialise(i))
				return(hRes);
		}
	}

	return S_OK;
}
//-----------------------------------------------------------------------------
// Name: 
// Desc: 
//-----------------------------------------------------------------------------
void CGamePads::ReadDevices()
{
	UpdateDeviceList();
    
	// Loop through all gamepads
	for(DWORD i=0; i<NUM_GAMEPADS; i++ )
	{
		m_GamePads[i].Read();
    }
}
//-----------------------------------------------------------------------------
// Name: 
// Desc: 
//-----------------------------------------------------------------------------
void CGamePads::UpdateDeviceList()
{
	DWORD dwInsertions, dwRemovals;
	XGetDeviceChanges( XDEVICE_TYPE_GAMEPAD, &dwInsertions, &dwRemovals );

	// Loop through all gamepads
	for(DWORD i=0; i<NUM_GAMEPADS; i++)
	{
		if(dwRemovals & (1<<i))
			m_GamePads[i].Remove();
		if(dwInsertions & (1<<i)) 
			m_GamePads[i].Initialise(i);
	}
}
