#pragma once


class CHeightMap;

class CShip
{
public:
	CShip();
	~CShip(void);

	void	SetPosition(const D3DXVECTOR3 &vecPos);

	const D3DXVECTOR3&	GetPosition() const;
	float				GetBearing() const;
	float				GetAltitude() const;
	float				GetLandHeight() const;
	float				GetFuel() const;

	void	FuelBonus(float fFuel);

	void	TurnLeft();
	void	TurnRight();
	void	Thrust();

	void	MoveHorizontal(float fTime);
	bool	MoveVertical(const CHeightMap &HeightMap, float fTime, bool bDemo);


private:
	bool Crashed(const CHeightMap &HeightMap);
	void Limit(float &f1, float &f2);


	// constant ship parameters...
	float		m_fTurnSpeed;
	float		m_fHorizSpeed;

	float		m_fVertAcceleration;
	float		m_fGravAcceleration;
	float		m_fVertMaxSpeed;
	float		m_fTerminalVelocity;
	float		m_fMaxAltitude;

	float		m_fThrustFuelCost;

	float		m_fCrashFuelCost;
	float		m_fCrashBounce;
	float		m_fMinVelocityPostCrash;
	float		m_fMaxVelocityPostCrash;



	float	m_fFuel;				// 0 = Empty, 1 = Full

	float	m_fVertSpeed;

	D3DXVECTOR3	m_vecPos;
	float		m_fBearing;
	float		m_fLandHeight;		// cached every frame

	bool		m_bTurnLeft;
	bool		m_bTurnRight;

	int			m_nCrashImmunityFrames;
};
