//#include <d3dx9.h>
//#include "D3DUtil.h"
#include <xtl.h>
#include "xbresource.h"


#include "Ship.h"
#include "PickUp.h"


	#include "LandScape.h"
		#include "CloudBox.h"
	#include "SkyBox.h"
	#include "ShipModel.h"
	#include "FuelTank.h"
#include ".\SharedGeom.h"


#include "DxObjects.h"

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CSharedGeom::CSharedGeom(void)
{
}

//-----------------------------------------------------------------------------

CSharedGeom::~CSharedGeom(void)
{
}

//-----------------------------------------------------------------------------

HRESULT	CSharedGeom::InitDeviceObjects(const CHeightMap &HeightMap)
{
	HRESULT hr = S_OK;

	if((hr = m_LandScape.InitDeviceObjects(HeightMap)) != S_OK)
		return(hr);
	if((hr = m_SkyBox.InitDeviceObjects()) != S_OK)
		return(hr);
	if((hr = m_ShipModel.InitDeviceObjects()) != S_OK)
		return(hr);
	if((hr = m_FuelTank.InitDeviceObjects()) != S_OK)
		return(hr);

	return hr;
}

//-----------------------------------------------------------------------------

void CSharedGeom::DeleteDeviceObjects()
{
	m_LandScape.DeleteDeviceObjects();
	m_SkyBox.DeleteDeviceObjects();
	m_ShipModel.DeleteDeviceObjects();
	m_FuelTank.DeleteDeviceObjects();
}

//-----------------------------------------------------------------------------

HRESULT	CSharedGeom::RestoreDeviceObjects()
{
	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();


	pDevice->SetRenderState( D3DRS_CULLMODE,   D3DCULL_CW );			// Landscape legacy!!!

//	pDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);		// Improve texture mapping
//	pDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
	pDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);		// Improve texture mapping
	pDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);

	pDevice->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );		// For alpha blending
	pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

	// Setup lighting
    D3DLIGHT8 light;
//    D3DUtil_InitLight( light, D3DLIGHT_DIRECTIONAL, -0.1f, -1.5f, -1.0f );
    D3DXVECTOR3 vecLightDirUnnormalized(-0.1f, -1.5f, -1.0f);
    ZeroMemory( &light, sizeof(D3DLIGHT8) );
    light.Type        = D3DLIGHT_DIRECTIONAL;
    light.Diffuse.r   = 1.0f;
    light.Diffuse.g   = 1.0f;
    light.Diffuse.b   = 1.0f;
    D3DXVec3Normalize( (D3DXVECTOR3*)&light.Direction, &vecLightDirUnnormalized );
    light.Position.x   = -0.1f;
    light.Position.y   = -1.5f;
    light.Position.z   = -1.0f;
    light.Range        = 1000.0f;

	
		light.Specular.r = 1.0f;
		light.Specular.g = 1.0f;
		light.Specular.b = 1.0f;
		light.Specular.a = 1.0f;

		light.Falloff = 0;
		light.Attenuation0 = 1;
		light.Attenuation1 = 0;
		light.Attenuation2 = 0;
    pDevice->SetLight(0, &light);
    pDevice->LightEnable(0, true);

    D3DLIGHT8 light2;
//    D3DUtil_InitLight( light2, D3DLIGHT_DIRECTIONAL, 0.1f, -1.5f, 1.0f );
    D3DXVECTOR3 vecLightDirUnnormalized2(0.1f, -1.5f, 1.0f);
    ZeroMemory( &light2, sizeof(D3DLIGHT8) );
    light2.Type        = D3DLIGHT_DIRECTIONAL;
    light2.Diffuse.r   = 1.0f;
    light2.Diffuse.g   = 1.0f;
    light2.Diffuse.b   = 1.0f;
    D3DXVec3Normalize( (D3DXVECTOR3*)&light2.Direction, &vecLightDirUnnormalized2 );
    light2.Position.x   = 0.1f;
    light2.Position.y   = -1.5f;
    light2.Position.z   = 1.0f;
    light2.Range        = 1000.0f;

	
	
		light2.Diffuse.r = light2.Ambient.r = 0;
		light2.Diffuse.g = light2.Ambient.g = 0;
		light2.Diffuse.b = light2.Ambient.b = 0;
		light2.Diffuse.a = light2.Ambient.a = 0;

		light2.Specular.r = 1.0f;
		light2.Specular.g = 1.0f;
		light2.Specular.b = 1.0f;
		light2.Specular.a = 1.0f;

		light2.Falloff = 0;
		light2.Attenuation0 = 1;
		light2.Attenuation1 = 0;
		light2.Attenuation2 = 0;
    pDevice->SetLight(1, &light2);
    pDevice->LightEnable(1, true);



	HRESULT hr = S_OK;

	// Set fog render states
	if((hr = m_LandScape.RestoreDeviceObjects()) != S_OK)
		return(hr);

	return hr;
}

//-----------------------------------------------------------------------------

void CSharedGeom::RenderSkyBox() const
{
	m_SkyBox.Render();
}

//-----------------------------------------------------------------------------

void CSharedGeom::RenderScene(	int					nPlayer,
								const CShip			&Ship1,
								const CShip			*Ship2,
								const CPickUp&		PickUp) const
{
	m_LandScape.Render();


	D3DXMATRIX matRot, matMove, matWorld;

	D3DXMatrixRotationY(&matRot, Ship1.GetBearing());
	const D3DXVECTOR3 vecShip1 = Ship1.GetPosition();
	D3DXMatrixTranslation(&matMove, vecShip1.x, vecShip1.y, vecShip1.z);
	D3DXMatrixMultiply(&matWorld, &matRot, &matMove);
	
	m_ShipModel.Render(nPlayer, matWorld);


	if(Ship2)
	{
		D3DXMatrixRotationY(&matRot, Ship2->GetBearing());
		const D3DXVECTOR3 vec2 = Ship2->GetPosition();
		D3DXMatrixTranslation(&matMove, vec2.x, vec2.y, vec2.z);
		D3DXMatrixMultiply(&matWorld, &matRot, &matMove);
	
		m_ShipModel.Render9(nPlayer, matWorld);
	}


	D3DXMATRIX matTmp;
	float fRotation = PickUp.GetRotation();
	D3DXMatrixRotationX(&matTmp, fRotation);
	D3DXMatrixRotationZ(&matRot, fRotation);
	D3DXMatrixMultiply(&matRot, &matRot, &matTmp);
	const D3DXVECTOR3 vecPickUp = PickUp.GetPosition();
	D3DXMatrixTranslation(&matMove, vecPickUp.x, vecPickUp.y, vecPickUp.z);
	D3DXMatrixMultiply(&matWorld, &matRot, &matMove);
	
	m_FuelTank.Render(matWorld);
}

//-----------------------------------------------------------------------------
