//#include <d3dx9.h>
//#include "DXUtil.h"
#include <xtl.h>
#include "port.h"

#include "xbresource.h"

#include "HeightMap.h"

#include ".\landscape.h"

#include "DxObjects.h"
//-----------------------------------------------------------------------------
#define TEX_FILE	"RaceTrack1.png"	//"Track01.bmp"
//-----------------------------------------------------------------------------

CLandScape::CLandScape(void)
{
	m_dwFVF		= D3DFVF_XYZ | D3DFVF_TEX1 | D3DFVF_NORMAL;
	//m_dwFVF		= D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_NORMAL;

	m_pVB		= NULL;
#ifdef RNDR_NRMLS
	m_pVBLine	= NULL;
#endif
	m_pIndexBuf	= NULL;
	m_pTexture	= NULL;
	m_nNumPrims	= 0;
	m_nNumVerts	= 0;

	ZeroMemory( &m_mtrl, sizeof(D3DMATERIAL8) );
	m_mtrl.Diffuse.r = m_mtrl.Ambient.r = 0.6f;
	m_mtrl.Diffuse.g = m_mtrl.Ambient.g = 0.6f;
	m_mtrl.Diffuse.b = m_mtrl.Ambient.b = 0.6f;
	m_mtrl.Diffuse.a = m_mtrl.Ambient.a = 1.0f;

	m_mtrl.Specular.r = 0.45f;
	m_mtrl.Specular.g = 0.45f;
	m_mtrl.Specular.b = 0.45f;
	m_mtrl.Specular.a = 1.0f;
	m_mtrl.Power = 100;

	m_bRender = false;
}

//-----------------------------------------------------------------------------

CLandScape::~CLandScape(void)
{
}

//-----------------------------------------------------------------------------

HRESULT CLandScape::InitDeviceObjects(const CHeightMap &HeightMap)
{
	HRESULT hr;
	if((hr = CreateVertexBuffer(HeightMap)) != S_OK)
	{
//        MessageBox(NULL, "LandScape VBuf creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
	if((hr = CreateIndexBuffer(HeightMap)) != S_OK)
	{
//        MessageBox(NULL, "LandScape IndBuf creation error", "FlyPhil.exe", MB_OK);
		return(hr);
	}
//	if((hr = D3DXCreateTextureFromFile( CDxObjects::GetDevice(), "D:\\RaceTrack1.png", &m_pTexture)) != S_OK)
//	{
////        MessageBox(NULL, "LandScape texture creation error", "FlyPhil.exe", MB_OK);
//		return(hr);
//	}
	if(FAILED(m_xbprTexture.Create("D:\\RaceTrack1.xpr"))) return E_FAIL;
	m_pTexture = m_xbprTexture.GetTexture(0UL);

	m_bRender = true;

	return(hr);
}

//-----------------------------------------------------------------------------

void CLandScape::DeleteDeviceObjects()
{
	SAFE_RELEASE(m_pTexture);
	SAFE_RELEASE(m_pIndexBuf);
	SAFE_RELEASE(m_pVB);
#ifdef RNDR_NRMLS
	SAFE_RELEASE(m_pVBLine);
#endif
	m_bRender=false;
}

//-----------------------------------------------------------------------------

HRESULT CLandScape::RestoreDeviceObjects()
{
	LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

	// Fog
	float fFogStart = 0.5f;// 0.3f;
	float fFogEnd	= 1.0f;// 1.0f;
	DWORD colorFog = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
 	pDevice->SetRenderState(D3DRS_FOGCOLOR, colorFog);
	pDevice->SetRenderState(D3DRS_FOGTABLEMODE, D3DFOG_LINEAR);
	pDevice->SetRenderState(D3DRS_FOGSTART, *(DWORD*) (&fFogStart));
	pDevice->SetRenderState(D3DRS_FOGEND, *(DWORD*) (&fFogEnd));
	pDevice->SetRenderState(D3DRS_RANGEFOGENABLE, true);
	pDevice->SetRenderState(D3DRS_SPECULARMATERIALSOURCE, D3DMCS_MATERIAL);

	return S_OK;
}

//-----------------------------------------------------------------------------

void CLandScape::Render() const
{
	if(m_bRender)
	{
		LPDIRECT3DDEVICE8 pDevice = CDxObjects::GetDevice();

#ifndef RNDR_NRMLS
		pDevice->SetStreamSource( 0, m_pVB, sizeof(CUSTOMVERTEX) );
		pDevice->SetVertexShader( m_dwFVF );
#endif
		pDevice->SetIndices(m_pIndexBuf, 0);
		pDevice->SetTexture(0, m_pTexture);
		pDevice->SetMaterial(&m_mtrl);

		pDevice->SetRenderState(D3DRS_FOGENABLE, true);
		pDevice->SetRenderState(D3DRS_LIGHTING, true);
		pDevice->SetRenderState(D3DRS_SPECULARENABLE, true);

		D3DXMATRIX matWorld;
		for(int z = -1; z < 2; ++z)
		{
			for(int x = -1; x < 2; ++x)
			{
#ifdef RNDR_NRMLS
				pDevice->SetStreamSource( 0, m_pVB, 0, sizeof(CUSTOMVERTEX) );
				pDevice->SetFVF( m_dwFVF );
#endif
				D3DXMatrixTranslation(&matWorld, (float)x, 0.0f, (float)z);
				pDevice->SetTransform(D3DTS_WORLD, &matWorld);
				pDevice->DrawIndexedPrimitive(	D3DPT_TRIANGLESTRIP	,
												0, m_nNumVerts, 0,
												m_nNumPrims			);
#ifdef RNDR_NRMLS
				pDevice->SetStreamSource(0, m_pVBLine, 0, sizeof(LINELIST) );
				pDevice->SetFVF(D3DFVF_XYZ);
				pDevice->DrawPrimitive(	D3DPT_LINELIST		,
										0, m_nNumVerts * 2	);
#endif
			}
		}

		pDevice->SetRenderState(D3DRS_SPECULARENABLE, false);
		pDevice->SetRenderState(D3DRS_LIGHTING, false);
		pDevice->SetRenderState(D3DRS_FOGENABLE, false);
	}
}

//-----------------------------------------------------------------------------

HRESULT CLandScape::CreateVertexBuffer(const CHeightMap &HeightMap)
{
	HRESULT hr;
//
// VBuf runs from near-left to far-right in columns then rows...
//
//  z       ...- . -4159-4224
//  ^  |  |  |        |   |      (for 64x64 heightmap)
//  |  2-67-132- . -4097-4162    (ie. 65x65 vBuf)
//  |  1-66-131- . -4096-4161
//  |  0-65-130- . -4095-4160
//
//       ---->x
//
// Because of the way the HeightMap generator works, the landscape
// texture has been saved with a 90 degree clockwise rotation.
// so...  tu = z-coord
//        tv = x-coord
//
	int nNumHeightMapPointsZ = HeightMap.GetSizeZ();
	int nNumHeightMapPointsX = HeightMap.GetSizeX();
	int nNumVertsZ = nNumHeightMapPointsZ + 1;
	int nNumVertsX = nNumHeightMapPointsX + 1;
	m_nNumVerts = nNumVertsZ * nNumVertsX;

	//////////////////////////
	// Create and Lock VBuf //
	//////////////////////////
    if((hr = CDxObjects::GetDevice()->CreateVertexBuffer(	m_nNumVerts*sizeof(CUSTOMVERTEX), 0		,
															m_dwFVF, D3DPOOL_MANAGED, &m_pVB)) != S_OK)
		return(hr);
	CUSTOMVERTEX* pVertices;
	if((hr = m_pVB->Lock( 0, 0, (BYTE**)&pVertices, 0 )) != S_OK)
		return(hr);

#ifdef RNDR_NRMLS
	///////////////////////////////////////////////
	// Optional LineList for "rendering" normals //
	///////////////////////////////////////////////
	CDxObjects::GetDevice()->CreateVertexBuffer(	m_nNumVerts*sizeof(CUSTOMVERTEX)*2, 0			,
													D3DFVF_XYZ, D3DPOOL_MANAGED, &m_pVBLine, NULL	);
	LINELIST* pLines;
	m_pVBLine->Lock(0, 0, (VOID**)&pLines, 0 );
#endif

	//////////////////
	// Fill in VBuf //
	//////////////////
	int nHeightMapZ, nHeightMapX;
	int nCurVertex = 0;
	int x;
	int z;
	for(x=0; x < nNumVertsX; ++x)
	{
		for(z=0; z < nNumVertsZ; ++z)
		{
			nHeightMapZ = z;
			if(nHeightMapZ == nNumHeightMapPointsZ)
				nHeightMapZ = 0;

			nHeightMapX = x;
			if(nHeightMapX == nNumHeightMapPointsX)
				nHeightMapX = 0;

			pVertices[nCurVertex].position.y = HeightMap.GetData(nHeightMapZ, nHeightMapX);
			pVertices[nCurVertex].position.z = (float)z / (float)nNumHeightMapPointsZ;
			pVertices[nCurVertex].position.x = (float)x / (float)nNumHeightMapPointsX;

			pVertices[nCurVertex].tu = pVertices[nCurVertex].position.z;
			pVertices[nCurVertex].tv = pVertices[nCurVertex].position.x;
			//pVertices[nCurVertex].diffuse = D3DCOLOR_RGBA(z * 255 / nNumHeightMapPointsZ, x * 255 / nNumHeightMapPointsX, 0, 255);

			++nCurVertex;
		}
	}

	//// Color alteration to recognise tile boundaries... (DEBUG aid)
	//for(z = 0; z < nNumVertsZ; ++z)
	//{
	//	// average these two normals for first and last column
	//	pVertices[z + nNumVertsZ].diffuse = D3DCOLOR_RGBA(255,255,255,255);
	//	pVertices[nNumVertsZ * (nNumVertsX - 2) + z].diffuse = D3DCOLOR_RGBA(255,255,255,255);

	//	// first and last column are
	//	pVertices[z].diffuse = D3DCOLOR_RGBA(0,0,255,255);
	//	pVertices[(nNumVertsX - 1) * nNumVertsZ + z].diffuse = D3DCOLOR_RGBA(0,0,255,255);
	//}
	//for(x = 0; x < nNumVertsX; ++x)
	//{
	//	// average these two normals for first and last row
	//	pVertices[x * nNumVertsZ + 1].diffuse = D3DCOLOR_RGBA(255,255,255,255);
	//	pVertices[(x * nNumVertsZ) + nNumVertsZ - 2].diffuse = D3DCOLOR_RGBA(255,255,255,255);

	//	// first and last row are
	//	pVertices[x * nNumVertsZ].diffuse = D3DCOLOR_RGBA(0,0,255,255);
	//	pVertices[x * nNumVertsZ + nNumVertsZ - 1].diffuse = D3DCOLOR_RGBA(0,0,255,255);
	//}


	///////////////////////
	// Calculate normals //
	///////////////////////
	int nCurrent, nBelow, nLeft;
	D3DXVECTOR3 vec1, vec2, norm;
	for(x=0; x < nNumVertsX; ++x)
	{
		for(z=0; z < nNumVertsZ; ++z)
		{
			nCurrent = (x * nNumVertsZ) + z;

			if(z)
				nBelow = nCurrent - 1;
			else
				nBelow = nCurrent + nNumVertsZ - 2;

			if(x)
				nLeft = nCurrent - nNumVertsZ;
			else
				nLeft = nCurrent + (nNumVertsZ * (nNumVertsX - 2));

			vec1 = pVertices[nBelow].position - pVertices[nCurrent].position;
			vec1.z = -1.0f / (float)(nNumVertsZ - 1);
			vec2 = pVertices[nLeft].position  - pVertices[nCurrent].position;
			vec2.x = -1.0f / (float)(nNumVertsX - 1);

			D3DXVec3Cross(&norm, &vec1, &vec2);
			D3DXVec3Normalize(&norm, &norm);
			pVertices[nCurrent].normal = norm;
		}
	}

#ifdef RNDR_NRMLS
	/////////////////////////////////////////////
	// Add lines to "render" normal vectors... //
	/////////////////////////////////////////////
	nCurVertex = 0;
	for(x=0; x < nNumVertsX; ++x)
	{
		for(z=0; z < nNumVertsZ; ++z)
		{
			norm = pVertices[nCurVertex].normal;
			D3DXVec3Scale(&norm, &norm, 0.01f);
			pLines[nCurVertex * 2].position		= pVertices[nCurVertex].position;
			pLines[nCurVertex * 2 + 1].position	= pVertices[nCurVertex].position + norm;

			++nCurVertex;
		}
	}

    m_pVBLine->Unlock();
#endif

	/////////////////
	// Unlock VBuf //
	/////////////////
    m_pVB->Unlock();


	return S_OK;
}

//-----------------------------------------------------------------------------

HRESULT CLandScape::CreateIndexBuffer(const CHeightMap &HeightMap)
{
	int nNumHeightMapPointsX = HeightMap.GetSizeZ();
	int nNumHeightMapPointsY = HeightMap.GetSizeX();
	int nNumVertsX = nNumHeightMapPointsX + 1;
	int nNumVertsY = nNumHeightMapPointsY + 1;

	if(!m_pIndexBuf)
	{
		// Create and Lock IndBuf
		int NumOfIndicesInIndexBuf =
			((nNumVertsX*2)+2) * (nNumVertsY - 1);
		
		HRESULT hr;
		if( (hr = CDxObjects::GetDevice()->CreateIndexBuffer(NumOfIndicesInIndexBuf * sizeof(WORD),
							D3DUSAGE_WRITEONLY, D3DFMT_INDEX16, D3DPOOL_MANAGED,
							&m_pIndexBuf)										) != S_OK)
			return(hr);

		WORD *pIndices = NULL;
		if((hr = m_pIndexBuf->Lock(0, 0, (BYTE**)&pIndices, 0)) != S_OK)
			return(hr);


		// Fill in IndBuf
		int		x, y;
		int		nCurIndex = 0;
		for(y=0; y < (nNumVertsY - 1); ++y)
		{
			for(x=0; x < nNumVertsX; ++x)
			{
				pIndices[nCurIndex] = (WORD)(x + (y * nNumVertsX));
				++nCurIndex;
				pIndices[nCurIndex] = (WORD)(x + ((y+1) * nNumVertsX));
				++nCurIndex;
			}
			pIndices[nCurIndex] = pIndices[nCurIndex - 1];
			++nCurIndex;
			pIndices[nCurIndex] = (WORD)((y + 1) * nNumVertsX);
			++nCurIndex;
		}
		m_nNumPrims = (((nNumVertsX - 1) * 2 + 4) *
			(nNumVertsY - 1)) - 4;

		// Unlock IndBuf
		m_pIndexBuf->Unlock();
	}
	return S_OK;
}

//-----------------------------------------------------------------------------
