//-----------------------------------------------------------------------------
// File: gamepad.h		v1.01
//
// Desc: GAMEPAD InputDevice shit
//
// Copyright (c) Huirippu. All rights reserved.
//-----------------------------------------------------------------------------
#ifndef GAMEPAD_H
#define GAMEPAD_H



#define	NUM_GAMEPADS	4

//-----------------------------------------------------------------------------
// Name: class CGamePad
// Desc: structure for holding Game pad data
//-----------------------------------------------------------------------------
class CGamePad : public XINPUT_GAMEPAD
{
public:
	CGamePad();
	~CGamePad();

	HRESULT		Initialise(DWORD dwSlot);
	void		Remove();
	void		Read();

public:
	// The following members are inherited from XINPUT_GAMEPAD:
	//    WORD    wButtons;
	//    BYTE    bAnalogButtons[8];
	//    SHORT   sThumbLX;
	//    SHORT   sThumbLY;
	//    SHORT   sThumbRX;
	//    SHORT   sThumbRY;


    FLOAT      m_fX1;
    FLOAT      m_fY1;
    FLOAT      m_fX2;
    FLOAT      m_fY2;


	WORD       m_wPressedButtons;
	BOOL       m_bPressedAnalogButtons[8];

	// Rumble properties
//	XINPUT_RUMBLE   Rumble;
//	XINPUT_FEEDBACK Feedback;

	// Flags for whether game pad was just inserted or removed
//	BOOL       bInserted;
//	BOOL       bRemoved;


private:
	HANDLE								m_hDevice;
	XINPUT_STATE						m_InputState;

	static XINPUT_POLLING_PARAMETERS	m_PollingParams;
	// State of buttons tracked since last poll
	WORD		m_wLastButtons;
	BOOL		m_bLastAnalogButtons[8];
};

class CGamePads
{
public:
	CGamePads();
	~CGamePads();

	HRESULT		Initialise();
	void		ReadDevices();

public:
	CGamePad	m_GamePads[NUM_GAMEPADS];

private:
	XINPUT_POLLING_PARAMETERS		m_PollingParameters;

	void	UpdateDeviceList();
};

extern CGamePads g_GamePads;



#endif // GAMEPAD_H
