// Title.h: interface for the CTitle class.
//
//////////////////////////////////////////////////////////////////////
#pragma once


class CTitle
{
public:
	CTitle();
	virtual ~CTitle();

	HRESULT	InitDeviceObjects();
	void	DeleteDeviceObjects();
	HRESULT	RestoreDeviceObjects();
	void	InvalidateDeviceObjects();

	void	Render() const;

private:
	LPDIRECT3DTEXTURE8			m_pTexture;

	LPDIRECT3DVERTEXBUFFER8		m_pVB;
	struct CUSTOMVERTEX {
		D3DXVECTOR4 position;
		float		tu, tv;
	};
	DWORD		m_dwFVF;
	enum { NUM_PRIMS = 2, NUM_VERTS = 6 };

	bool		m_bRender;
};

