//#include <d3dx9.h>
//#define DIRECTINPUT_VERSION 0x0800
//#include <dinput.h>
//#include "DXUtil.h"
#include <xtl.h>

#include <stdio.h>

#include "HeightMap.h"


#include ".\Ship.h"

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

CShip::CShip()
{
	// Constant ship parameters...
	m_fTurnSpeed		= 0.3f;//0.02f;
	m_fHorizSpeed		= 0.15f;//0.1f;			// 0.002f;

	m_fVertAcceleration	= 0.0025f;		// 0.0001f;
	m_fGravAcceleration = 0.000625f;		// 0.000025f;
	//m_fVertMaxSpeed		=  2.0f;		// 0.04f;
	m_fVertMaxSpeed		= 1.0f;
	m_fTerminalVelocity = -0.1f;		// -0.004f;

	m_fMaxAltitude		=  0.75f;

	//m_fThrustFuelCost	= 0.0025f;
	m_fThrustFuelCost	= 0.0006f;

	m_fCrashFuelCost		= 0.2f;//0.09f;
	m_fCrashBounce			= 0.9f;//1.2f;
	m_fMaxVelocityPostCrash = 0.15f;
	m_fMinVelocityPostCrash	= 0.1f;


	m_fFuel				= 1.0f;

	m_fVertSpeed		= -0.001f;

	m_vecPos			= D3DXVECTOR3(0.0f, 0.2f, 0.5f);
	m_fBearing			= 1.0f;
	m_fLandHeight		= 0.0f;

	m_bTurnLeft			= false;
	m_bTurnRight		= false;

	m_nCrashImmunityFrames = 0;
}

//-----------------------------------------------------------------------------

CShip::~CShip(void)
{
}

//-----------------------------------------------------------------------------

void CShip::SetPosition(const D3DXVECTOR3 &vecPos)
{
	m_vecPos = vecPos;
}

//-----------------------------------------------------------------------------

const D3DXVECTOR3& CShip::GetPosition() const
{
	return(m_vecPos);
}

//-----------------------------------------------------------------------------

float CShip::GetBearing() const
{
	return(m_fBearing);
}

//-----------------------------------------------------------------------------

float CShip::GetAltitude() const
{
	return(m_vecPos.y);
}

//-----------------------------------------------------------------------------

float CShip::GetLandHeight() const
{
	return(m_fLandHeight);
}

//-----------------------------------------------------------------------------

float CShip::GetFuel() const
{
	return(m_fFuel);
}

//-----------------------------------------------------------------------------

void CShip::FuelBonus(float fFuel)
{
	m_fFuel += fFuel;
	if(m_fFuel > 1.0f)
		m_fFuel = 1.0f;
}

//-----------------------------------------------------------------------------

void CShip::TurnLeft()
{
	m_bTurnLeft = true;
}

//-----------------------------------------------------------------------------

void CShip::TurnRight()
{
	m_bTurnRight = true;
}

//-----------------------------------------------------------------------------

void CShip::Thrust()
{
	if(m_fFuel > 0.0f)
	{
		m_fVertSpeed += m_fVertAcceleration;
		if(m_fVertSpeed > m_fVertMaxSpeed)
			m_fVertSpeed = m_fVertMaxSpeed;

		m_fFuel -= m_fThrustFuelCost;
	}
}

//-----------------------------------------------------------------------------

void CShip::MoveHorizontal(float fTime)
{
	if(m_bTurnLeft)
	{
		m_fBearing -= m_fTurnSpeed * fTime;
		m_bTurnLeft = false;
	}
	else if(m_bTurnRight)
	{
		m_fBearing += m_fTurnSpeed * fTime;
		m_bTurnRight = false;
	}


	m_vecPos.x = m_vecPos.x + ((float)sin(m_fBearing) * m_fHorizSpeed * fTime);
	m_vecPos.z = m_vecPos.z + ((float)cos(m_fBearing) * m_fHorizSpeed * fTime);


	Limit(m_vecPos.x, m_vecPos.z);
}

//-----------------------------------------------------------------------------
/*
 * bool MoveVertical(const CHeightMap &HeightMap, float fTime, bool bDemo)
 *
 * returns true if ship grounded & out of fuel
 *
 * updates position, checks for crash
 */
bool CShip::MoveVertical(const CHeightMap &HeightMap, float fTime, bool bDemo)
{
	bool bRetVal = false;

	float fNoseX = m_vecPos.x + 0.046f * (float)sin(m_fBearing);
	float fNoseZ = m_vecPos.z + 0.046f * (float)cos(m_fBearing);
	Limit(fNoseX, fNoseZ);
	m_fLandHeight = HeightMap.GetData(fNoseZ, fNoseX);

	if(bDemo)
	{
		m_vecPos.y = m_fLandHeight + 0.1f;
	}
	else
	{
		m_fVertSpeed -= m_fGravAcceleration;
		if(m_fVertSpeed < m_fTerminalVelocity)
			m_fVertSpeed = m_fTerminalVelocity;

		m_vecPos.y = m_vecPos.y + m_fVertSpeed * fTime;


		if(m_nCrashImmunityFrames)
			--m_nCrashImmunityFrames;

		// Check for collision...
		if(Crashed(HeightMap))
		{
			if(!m_nCrashImmunityFrames)
			{
				m_nCrashImmunityFrames = 160;
				m_fFuel -= m_fCrashFuelCost;
			}
			if(m_fFuel > 0.0f)			// bounce ship
			{
				m_fVertSpeed = (float)fabs(m_fVertSpeed) * m_fCrashBounce;
				if(m_fVertSpeed > m_fMaxVelocityPostCrash)
					m_fVertSpeed = m_fMaxVelocityPostCrash;
				else if(m_fVertSpeed < m_fMinVelocityPostCrash)
					m_fVertSpeed = m_fMinVelocityPostCrash;
			}
			else						// ground ship, return true
			{
				m_fVertSpeed = 0.0f;
				bRetVal = true;
			}
		}
		else if(m_vecPos.y > m_fMaxAltitude)
		{
			m_vecPos.y = m_fMaxAltitude;
			m_fVertSpeed = 0.0f;
		}
	}
	return(bRetVal);
}

//-----------------------------------------------------------------------------

bool CShip::Crashed(const CHeightMap& HeightMap)
{
	float fSinPlus90 = (float)sin(m_fBearing + D3DX_PI * 0.5f);
	float fCosPlus90 = (float)cos(m_fBearing + D3DX_PI * 0.5f);

	float fRightWingX = m_vecPos.x + 0.046f * fSinPlus90;
	float fRightWingZ = m_vecPos.z + 0.046f * fCosPlus90;
	Limit(fRightWingX, fRightWingZ);
	float fLeftWingX = m_vecPos.x - 0.046f * fSinPlus90;
	float fLeftWingZ = m_vecPos.z - 0.046f * fCosPlus90;
	Limit(fLeftWingX, fLeftWingZ);

	float fTailX = m_vecPos.x - 0.046f * (float)sin(m_fBearing);
	float fTailZ = m_vecPos.z - 0.046f * (float)cos(m_fBearing);
	Limit(fTailX, fTailZ);


	float fRightWingLandHeight = HeightMap.GetData(fRightWingZ, fRightWingX);
	float fLeftWingLandHeight = HeightMap.GetData(fLeftWingZ, fLeftWingX);
	float fTailLandHeight = HeightMap.GetData(fTailZ, fTailX);


	bool bCrashed = false;
	if(m_vecPos.y < fRightWingLandHeight)
		bCrashed = true;
	else if(m_vecPos.y < fLeftWingLandHeight)
		bCrashed = true;
	else if(m_vecPos.y < m_fLandHeight)
		bCrashed = true;
	else if(m_vecPos.y < fTailLandHeight)
		bCrashed = true;

	return(bCrashed);
}

//-----------------------------------------------------------------------------

void CShip::Limit(float &f1, float &f2)
{
	if(f1 >= 1.0f)
		f1 -= 1.0f;
	else if(f1 < 0.0f)
		f1 += 1.0f;

	if(f2 >= 1.0f)
		f2 -= 1.0f;
	else if(f2 < 0.0f)
		f2 += 1.0f;
}

//-----------------------------------------------------------------------------
