// FuelGuage.h: interface for the CFuelGuage class.
//
//////////////////////////////////////////////////////////////////////

#pragma once

class CFuelGuage
{
public:
	CFuelGuage();
	virtual ~CFuelGuage();

	HRESULT	InitDeviceObjects();
	void	DeleteDeviceObjects();
	HRESULT	RestoreDeviceObjects();
	void	InvalidateDeviceObjects();

	void	Render() const;
	void	FrameMove(float fFuel);

private:
	static LPDIRECT3DTEXTURE8			m_pTexture;

	struct CUSTOMVERTEX {
		D3DXVECTOR4 position;       // vertex position
		float		tu, tv;
	};
	DWORD	m_dwFVF;
	LPDIRECT3DVERTEXBUFFER8		m_pVB;

	enum { NUM_PRIMS = 4, NUM_VERTS = 12 };

	bool	m_bRender;


	HRESULT CreateSimpleVertexBuffer();
	void	AssignWindowGeom();


	// Constant Pixel offsets...
	int		m_nLeftPixelsWords;
	int		m_nRightPixelsWords;
	int		m_nHeightPixelsWords;

	int		m_nVertGapPixels;

	int		m_nLeftPixelsFuel;
	int		m_nRightPixelsFuel;

	// Variable Pixel offsets...
	int		m_nBottomPixelsWords;
	int		m_nTopPixelsWords;
	int		m_nBottomPixelsFuel;
	int		m_nTopPixelsFuel;


	// Constant texture coords...
	float	m_fTopTexCoordWords;
	float	m_fBottomTexCoordWords;
	float	m_fRightTexCoordWords;
	float	m_fLeftTexCoordWords;

	float	m_fTopTexCoordFuel;
	float	m_fBottomTexCoordFuel;
	float	m_fRightTexCoordFuel;
	float	m_fLeftTexCoordFuel;
};
