
#ifndef _CAMERA_H
#define _CAMERA_H

#include <xtl.h>

class CCamera
{
private:
	IDirect3DDevice8* m_pD3DDevice;


	  bool m_bMovedSinceLastUpdate;   // tracks whether the camera has moved since it was
                                      // last updated
      D3DXVECTOR3 m_vPosition;
      D3DXVECTOR3 m_vFacing;
      D3DXVECTOR3 m_vUp;
      D3DXVECTOR3 m_vRight;

      // floats to keep track of how far we've rotated since the last update which
      // can then be used by UpdateDevice() to recalculate the new orientation vectors
      float m_fRotAboutUp;
      float m_fRotAboutRight;
      float m_fRotAboutFacing;

      D3DXMATRIX m_matView;


public:
	// This is used to set our VIEW in ->SetTransform(D3DTS_VIEW,&m_matWorld)
	D3DXMATRIX m_matWorld;
	D3DXMATRIX m_matTranslation;
	D3DXMATRIX m_matRotation;

	// Camera's position in 3D world.
	float m_PosX, m_PosY, m_PosZ;

	// The point in 3D space where looking at.
	float m_RotX, m_RotY, m_RotZ;

	// Called once for the creation.
	void Create( IDirect3DDevice8** pDevice );

	void CreateFirstPerson();
	HRESULT FirstPersonUpdate();

	void Release();

	void Setup2dCamera();
	void Setup3dCamera();

	// Called if we want to move our camera around.
	void Move   (float x, float y, float z);
	void MoveRel(float x, float y, float z);

	void Rotate   (float x, float y, float z);
	void RotateRel(float x, float y, float z);
	void UpdateCamera(); //Used internally


	////////////////////////////
	//  1st person functions //
	///////////////////////////

	void MoveForward();
	void MoveBackward();
	
	void MoveRight();
	void MoveLeft();
	
	void MoveUp();
	void MoveDown();

	void RotateRight();
	void RotateLeft();

};


#endif // _CAMERA_H





