#include "text.h"


void CText::Create(IDirect3DDevice8** pDevice, LPCWSTR fontPath, int type)
{
	m_pd3dDevice = *pDevice;
	m_pd3dDevice->GetBackBuffer(-1,D3DBACKBUFFER_TYPE_MONO,&g_pFrontBuffer);
	DWORD dwFontCacheSize = 16 * 1024;
	if(type == FONT_BMP )
	  XFONT_OpenBitmapFont( fontPath, dwFontCacheSize, &m_pBitmapFont );
	else if(type == FONT_TTF )
	  XFONT_OpenTrueTypeFont(fontPath, dwFontCacheSize, &m_pBitmapFont);
}

void CText::DisplayText(WCHAR string[200], float xpos, float ypos, int r, int g, int b)
{
	WCHAR szbuff[200] = {0};
	wsprintfW(szbuff, L"%s", string);

	m_pBitmapFont->SetTextColor(D3DCOLOR_XRGB(r,g,b));
	m_pBitmapFont->TextOut( g_pFrontBuffer, szbuff, -1, (long)xpos, (long)ypos );
}

void CText::SetHeight(int size)
{
	m_pBitmapFont->SetTextHeight(size);
}

void CText::Release()
{
    m_pBitmapFont->Release();
	g_pFrontBuffer->Release();
}