#ifndef _XLOADER_H_
#define _XLOADER_H_
 
#include <xtl.h>
#include <string.h>
#include "xfile.h"
 
 
class CXLoader
{
public:
      CXLoader();
      void Create(IDirect3DDevice8** pD3DDevice, char *szFilename, char *TexturePath);
      void Render(int size);
      void cam();
	  void scale(int size);

	  void MoveX(float x);
	  void MoveY(float y);
	  void Move(float x, float y, float z);
	  void MoveRel(float x, float y, float z);
	  float GetXpos();
	  float GetYpos();
	  float GetZpos();
 
	  void Rotate(float x_rot, float y_rot, float z_rot);
	  void RotateRel(float x_rot, float y_rot, float z_rot);
	  float GetXrot();
	  float GetYrot();
	  float GetZrot();
 
      void Release();
protected:
      LPD3DXMESH              m_pMesh;           // Our mesh object in sysmem
      D3DMATERIAL8*           m_pMeshMaterials;
      LPDIRECT3DTEXTURE8*     m_pMeshTextures;
      DWORD                   m_dwNumMaterials;
 
	  D3DXMATRIX			  m_matRot;
	  D3DXMATRIX			  m_matPos;
	  D3DXMATRIX			  m_matWorld;
	  D3DXMATRIX			  m_scale3;
	  D3DXMATRIX			  m_scale2;
	  D3DXMATRIX			  m_scale1;
	  D3DXMATRIX			  m_scale0;
 
D3DXMATRIX out;
	  float m_x, m_y ,m_z;
	  float m_xRot, m_yRot, m_zRot;
	  IDirect3DDevice8*       m_pD3DDevice;
};
 
#endif