#ifndef EDITOR_H
#define EDITOR_H
#include "SDL.h"

struct Tile;

typedef struct Grid{
    char *name;
    char *tune;
    
    int start_x, start_y;

    int width, height;
    int num_tiles;

    int jumps_allowed;

    struct Tile *tilemap;
} Grid;

typedef struct Bomb2{
    int grid_x;
    int grid_y;
    Sprite *sprite;
    struct Bomb2 *next, *prev;
} Bomb2;

enum{ SELECTOR_GRID,
      SELECTOR_TILES,
      SELECTOR_VOID,
      SELECTOR_BOMB,
      SELECTOR_BUTTONS
} SelectorStates;

void editorGridNew(int width, int height);
void editorGridDelete();
void editorGridRedraw();

void editorRedrawTileSelector();
void editorRedrawButtons();

int editorHandleEvents();
void editorMoveSelector(SDL_MouseMotionEvent *motion);
void editorMousePress(SDL_MouseButtonEvent *button);
void editorPlaceTile(int x, int y, int type);
int editorLoadLevel(char *name);
void editorReshuffleBombs();
void editorMouseRelease(int button);
#endif
