
.globl mmx_memcpy

.text

.align 16

mmx_memcpy: 

    pushl %ebp
    movl %esp,%ebp

    pushal

    movl 8(%ebp),%edi     # destination
    movl 12(%ebp),%esi    # source
    movl 16(%ebp),%ecx    # bytes

    movl %ecx,%eax
    shrl $6,%ecx
    movl %ecx,%ebx
    shll $6,%ebx
    subl %ebx,%eax

.align 16

    mmx_memcpy.loop: 

        movq (%esi),%mm0
        movq 8(%esi),%mm1
        movq 16(%esi),%mm2
        movq 24(%esi),%mm3
        movq 32(%esi),%mm4
        movq 40(%esi),%mm5
        movq 48(%esi),%mm6
        movq 56(%esi),%mm7
        movq %mm0,(%edi)
        movq %mm1,8(%edi)
        movq %mm2,16(%edi)
        movq %mm3,24(%edi)
        movq %mm4,32(%edi)
        movq %mm5,40(%edi)
        movq %mm6,48(%edi)
        movq %mm7,56(%edi)
        addl $8*8,%esi
        addl $8*8,%edi
        decl %ecx
        jnz mmx_memcpy.loop

    movl %eax,%ecx
    rep
    movsb

    emms

    popal

    popl %ebp
    ret


